#include <os2.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "Defines.h"
#include "Structures.h"
#include "SupportFunctions.h"

PFUNCRETURN ParseSectValues(PUCHAR range, PULONG begin, PULONG end)
{
    static FUNCRETURN fr;
    PFUNCRETURN pfr;
    UCHAR currFunc[]="ParseSectValues";

    memset(&fr, 0, sizeof(fr));

    if (strchr(range, '-')==NULL)
        {
        pfr=GetValue(range, begin);
        if (!pfr->success)
            {
            fr.success=FALSE;
            strcpy(fr.errorFunc, pfr->errorFunc);
            strcpy(fr.errorHome, pfr->errorHome);
            fr.errorCode=0;
            return &fr;
            }
        *end=*begin;
        }
    else
        {
        UCHAR sbuf[256];
        strcpy(sbuf, strchr(range, '-'));
        RightJustify(sbuf, strlen(sbuf)-1);
        pfr=GetValue(sbuf, end);
        if (!pfr->success)
            {
            fr.success=FALSE;
            strcpy(fr.errorFunc, pfr->errorFunc);
            strcpy(fr.errorHome, pfr->errorHome);
            fr.errorCode=0;
            return &fr;
            }
        strrev(range);
        sbuf[0]=0x00;
        strcpy(sbuf, strchr(range, '-'));
        RightJustify(sbuf, strlen(sbuf)-1);
        strrev(sbuf);
        pfr=GetValue(sbuf, begin);
        if (!pfr->success)
            {
            fr.success=FALSE;
            strcpy(fr.errorFunc, pfr->errorFunc);
            strcpy(fr.errorHome, pfr->errorHome);
            fr.errorCode=0;
            return &fr;
            }
        if (*begin>*end)
            {
            fr.success=FALSE;
            strcpy(fr.errorFunc, "endbeforebegin");
            strcpy(fr.errorHome, currFunc);
            fr.errorCode=0;
            return &fr;
            }
        }

    fr.success=TRUE;
    return &fr;
}

PFUNCRETURN GetValue(PUCHAR vstring, PULONG num)
{
    static FUNCRETURN fr;
    UCHAR currFunc[]="GetValue";

    memset(&fr, 0, sizeof(fr));

    if (!strcmp(vstring, "0"))
        {
        *num=0;
        }
    else if (!stricmp(vstring, "SUPER"))
        {
        *num=SUPERLOC;
        }
    else if (!stricmp(vstring, "SPARE"))
        {
        *num=SPARELOC;
        }
    else if (!stricmp(vstring, "BOOT"))
        {
        *num=0;
        }
    else
        {
        *num=(ULONG)atol(vstring);
        if (num==0)
            {
            fr.success=FALSE;
            strcpy(fr.errorFunc, vstring);
            strcpy(fr.errorHome, currFunc);
            fr.errorCode=0;
            return &fr;
            }
        }

    fr.success=TRUE;
    return &fr;
}

PUCHAR fCodel(double number)
{
    UCHAR numString[33], scrap[10];
    static UCHAR rString[30];

    memset(numString, 0, sizeof(numString));

    sprintf(numString, "%.0f", number);
    strrev(numString);

    memset(rString, 0, sizeof(rString));

    while (strlen(numString)>3)
        {
        strcat(rString, StrLeft(numString, 3, scrap));
        strcat(rString, ",");
        RightJustify(numString, strlen(numString)-3);
        }

    strcat(rString, numString);
    strrev(rString);

    return rString;
}

PUCHAR iCodel(ULONG number)
{
    UCHAR numString[33], scrap[10];
    static UCHAR rString[13];

    memset(numString, 0, sizeof(numString));

    sprintf(numString, "%u", number);
    strrev(numString);

    memset(rString, 0, sizeof(rString));

    while (strlen(numString)>3)
        {
        strcat(rString, StrLeft(numString, 3, scrap));
        strcat(rString, ",");
        RightJustify(numString, strlen(numString)-3);
        }

    strcat(rString, numString);
    strrev(rString);

    return rString;
}

PUCHAR StrLeft(PUCHAR theString, ULONG length, PUCHAR rString)
{
    memset(rString, 0, length+1);

    strncpy(rString, theString, length);

    return rString;
}

PUCHAR RightJustify(PUCHAR theString, ULONG newLength)
{
    ULONG i, slen, begin;

    slen=strlen(theString);
    begin=slen-newLength;

    for (i=begin; i<slen; i++)
        {
        theString[i-begin]=theString[i];
        }
    theString[newLength]=0x00;

    return theString;
}

PUCHAR BitString(UCHAR bstring)
{
    BYTEBITFIELD bf;
    static UCHAR rstring[17];
    LONG i;

    memcpy(&bf, &bstring, 1);
    memset(rstring, 0, sizeof(rstring));

    rstring[0]='0'+bf.bit7;
    rstring[1]=' ';
    rstring[2]='0'+bf.bit6;
    rstring[3]=' ';
    rstring[4]='0'+bf.bit5;
    rstring[5]=' ';
    rstring[6]='0'+bf.bit4;
    rstring[7]=' ';
    rstring[8]='0'+bf.bit3;
    rstring[9]=' ';
    rstring[10]='0'+bf.bit2;
    rstring[11]=' ';
    rstring[12]='0'+bf.bit1;
    rstring[13]=' ';
    rstring[14]='0'+bf.bit0;
    rstring[15]=' ';

    return rstring;
}
