/*** ThirdEye REXX Interface API Usage Example ***/
/*** (c) 2001 Andrei A. Porodko             ******/
/*                                                                         */
/* this REXX cmdfile downloads all available pictures from the camera to   */
/* the harddisk, if they are new or modified (different size, optional     */
/* different date/time)                                                    */
/*                                                                         */
/*  F. Beythien     2001-10-25   fbeythien@gmx.de                          */
/*                                                                         */
/*To customize, modify  the lines  with                                    */
/*                                 <----- to be changed                    */
/*                                       as comment                        */
pgmvers="V 2.5 2001-11-19 18.55"                         /* current Version*/

Signal On SYNTAX                                        /* trap REXX errors*/
Signal On NOVALUE                                          /* trap bad vars*/
Signal On HALT                                                /* trap ctl-C*/

/***************************************************************************/
/*  Init environment                                                       */
/***************************************************************************/
Call Initos

Signal Firsttime   /* Delete this line when customized <----- to be changed*/

/***************************************************************************/
/*  Location of ThirdEye Registration Key dataset                          */
/*  assign nullstring for demoversion                                      */
/***************************************************************************/
thirdkey=""                     /* This is for running with the demoversion*/
thirdkey="E:\coolpix9\thirdeye\thirdeye.key"        /* <----- to be changed*/

/***************************************************************************/
/*  here goes our message output                                           */
/***************************************************************************/
logdat="E:\coolpix9\thirdeye\mycamx.log"            /* <----- to be changed*/

/***************************************************************************/
/*  Here are the pictures stored                                           */
/***************************************************************************/
picdir="E:\coolpix9\thirdeye\rexxpic2\"             /* <----- to be changed*/

/***************************************************************************/
/*  The following directory should be different from 'picdir'              */
/*  It contains filenames which are ignored for download                   */
/*  i.e. even if these files are not in picdir but available in the camera */
/*  they will not be downloaded.                                           */
/*  only the filename is compared ( no size/date/time)                     */
/***************************************************************************/
igndir="E:\coolpix9\pics\"                          /* <----- to be changed*/

/***************************************************************************/
/*  If the 3eyerexx.dll supports picture timestamp i.e. creation date/time */
/*  of the picture, set the following to "YES"                             */
/*  for NIKON coolpix 990 it is not (yet) supported                        */
/***************************************************************************/
picdatetime ="NO"    /* Picture has creation timestamp <----- to be changed*/

port = "COM1"                          /* Used comport <----- to be changed*/
baud = 115200                             /* Baud rate <----- to be changed*/
camera = "Olympus"                /* Camera / Protocol <----- to be changed*/

/* Don't modify anything below or you better know what your are doing.     */
/* Don't modify anything below or you better know what your are doing.     */
/* Don't modify anything below or you better know what your are doing.     */
dlcount=0

tab="09"x

If Right(picdir,1)<>"\" Then picdir=picdir"\"            /* must end with \*/
picdir=Translate(Strip(picdir))                     /* convert to UPPERCASE*/
pospicname=Length(picdir)+1

If Right(igndir,1)<>"\" Then igndir=igndir"\"            /* must end with \*/
igndir=Translate(Strip(igndir))                     /* convert to UPPERCASE*/
posignname=Length(igndir)+1

/*** camx REXX Function Return Code Definitions ************/
ret_ok               =  0
ret_not_enough_mem   = -1
ret_insuff_params    = -2
ret_not_connected    = -3
ret_not_loaded       = -4
ret_cant_get_picture = -5
ret_cant_del_picture = -6
ret_cant_get_number  = -7
ret_cant_get_camname = -8
ret_cant_take_pic    = -9

Call Logger 2,1,0,os invoke sourcefn xx 'ThirdEye REXX Interface' pgmvers
Call Logger 2,0,0,'(c) 2001 Andrei A. Porodko modified by Frank Beythien'

Call Logger 2,0,0,langproc langlvl rday rmon ryear
Call Logger 0,0,1,'Starting' Date() 'at' Time()

Call Logger 2,0,0,'Registering all Functions for further usage'
Call Rxfuncadd 'camxInit', '3eyeRexx', 'camxInit'

/***************************************************************************/
/*  Trap invalid registration key                                          */
/***************************************************************************/

Signal On SYNTAX name notregistered
Call Camxinit thirdkey                          /* try to init 3eyeREXX.dll*/
Signal On SYNTAX                        /* restore 'normal' Syntax checking*/

Call Logger 2,0,0,camxgetversion()                      /* output Version*/

Call Logger 2,1,0,'Connecting to' camera 'on' port 'with' baud 'baud'

rc = camxconnect(port,baud,camera)
If  rc \== ret_ok Then Do
  Call Logger 2,0,0,'Err: Connection to Camera Failure, code =' rc
  Call Logger 1,0,0,'     Check the Connection or Parameters.'
  Call Camxquit
  Exit 99
End

Call Logger 2,1,1,'Getting Various Information from Camera'
Call Logger 2,0,0,'Camera name  =' camxgetcameraname()
framesavail = camxframestaken()    /* save availabe picture count for later*/
Call Logger 2,0,0,'Frames taken =' Format(framesavail,3),
  '<-- available for download'
Call Logger 2,0,0,'Frames left  =' Format(camxframesleft(),3),
  '<-- available for taking pictures'

/***************************************************************************/
/*  Get info about pictures in picdir                                      */
/***************************************************************************/
rc=sysfiletree(picdir"*.jpg","pics","FT")
If rc<>0 Then pics.0=0

/***************************************************************************/
/*  reformat the info for easier compare                                   */
/***************************************************************************/
Do k=1 To pics.0

  If k=1 Then Say pics.1

/***************************************************************************/
/* handle blanks in filename don't rely on fixed offset for filename start */
/***************************************************************************/
  fnpos=Pos(picdir,pics.k)
  work=Strip(Substr(pics.k,fnpos))
  work=Substr(work,pospicname)
  picname.k=Translate(work)
  picsize.k=Strip(Word(pics.k,2))
  picdate.k="20"Strip(Word(pics.k,1))         /* date/time 20YY/MM/DD/hh/mm*/

  /*************************************************************************/
  /*  Handle 19xx case                                                     */
  /*************************************************************************/
  If Substr(picdate.k,3,2)>"79" Then  Do
    picdate.k=Overlay("19",picdate.k,1)
  End

  /*************************************************************************/
  /*  Dateformat is now YYYY/MM/DD/hh/mm                                   */
  /*************************************************************************/

End

/***************************************************************************/
/*  Show all stored picture data                                           */
/***************************************************************************/

Call Logger 2,0,0,"stored picture count:" pics.0 "in directory:" picdir
sizem=Length(pics.0)

Do m=1 To pics.0
  Call Logger 2,0,(m=pics.0),"stored picture" Format(m,sizem)":",
    picname.m Format(picsize.m,12) "   " picdate.m
End


/***************************************************************************/
/*  Get info about files    in igndir                                      */
/***************************************************************************/
rc=sysfiletree(igndir"*.jpg","igns","FT")
If rc<>0 Then igns.0=0

/***************************************************************************/
/*  reformat the info for easier compare                                   */
/***************************************************************************/
Do k=1 To igns.0

  If k=1 Then Say igns.1

/***************************************************************************/
/* handle blanks in filename don't rely on fixed offset for filename start */
/***************************************************************************/
  fnpos=Pos(igndir,igns.k)
  work=Strip(Substr(igns.k,fnpos))
  work=Substr(work,posignname)
  ignname.k=Translate(work)
End

/***************************************************************************/
/*  Show all files to be ignored                                           */
/***************************************************************************/

Call Logger 2,1,0,"stored ignore file count:" igns.0 "in directory:" igndir
sizem=Length(igns.0)

Do k=1 To igns.0
  Call Logger 2,0,(k=igns.0),"ignore picture" Format(k,sizem)":" ignname.k
End

/***************************************************************************/
/*  for all available pictures                                             */
/***************************************************************************/
Do k = 1 To framesavail
  cpicname=Translate(camxgetpicturename(k))

  /*************************************************************************/
  /*  compare with ignore list                                             */
  /*************************************************************************/

  Do m=1 To igns.0
    If  cpicname=ignname.m Then Do
      /***********************************************************************/
      /*  We are to ignore this picture                                      */
      /***********************************************************************/
      Call Logger 2,0,0,"Picture is on ignore list:" cpicname
      Iterate k                                  /* try next camera picture*/
    End
  End
  cpicsize=camxgetpicturesize(k,0)
  cpicdate=camxgetpicturedate(k)          /* Dateformat YYYY/MM/DD/hh/mm/ss*/
  cpicdate2=Left(cpicdate,16)             /* Dateformat YYYY/MM/DD/hh/mm   */

  /*************************************************************************/
  /*  Compare with all stored pictures                                     */
  /*************************************************************************/
  Do m=1 To pics.0
    If  cpicname=picname.m Then Do

      /***********************************************************************/
      /*  We already have a picture with same name                           */
      /***********************************************************************/
      Call Logger 2,1,0,"Picture with same name exists:"
      Call Logger 2,0,0,"stored picture data:",
        picname.m Format(picsize.m,12) "   " picdate.m
      Call Logger 2,0,0,"camera picture data:",
        cpicname Format(cpicsize,12) "   " cpicdate2

      If cpicsize=picsize.m Then Do
        Call Logger 2,0,0," ... and same size."

        /*******************************************************************/
        /*  If the "real" creation timestamp cannot be retrieved from the  */
        /*  camera (coolpix 990 does not (yet) support this)               */
        /*  treat picture as equal (skip download)                         */
        /*******************************************************************/
        If picdatetime="NO" Then Iterate k       /* try next camera picture*/
        If cpicdate2=picdate.m Then Do
          Call Logger 2,0,0," ... and same date."
        End
        Else Do
          If cpicdate2 > picdate.m Then Do
            Call Logger 2,0,0," ... but older date:" cpicdate2
          End
          Else Do
            Call Logger 2,0,0," ... but newer date:" cpicdate2
          End
          Leave m                                    /* go get the picture*/
        End
      End
      Else Do
        Call Logger 2,0,0," ... but different size:" cpicsize
        Leave m                                      /* go get the picture*/
      End
    End
  End

  name = picdir||cpicname
  dlcount=dlcount+1
  Call Logger 1,1,0,'download' dlcount '('cpicsize 'Bytes) as --->' name
  start=Time("E")
  gp = camxgetpicture(k,name,0)
  dur=Format(Time("E")-start,,0)
  Call Logger 2,0,0,"camxGetPicture rc="gp " " cpicsize "Bytes duration" dur,
    "seconds (" Format(cpicsize/dur/1024,,0) "KB/sec) for" cpicname
  If gp=ret_ok Then Do
    gp=camxsetfiledate(name,cpicdate)
    Call Logger 2,0,0, "camxSetfiledate rc="gp
  End
End

/***************************************************************************/
/*  We are done                                                            */
/***************************************************************************/

Call Cleanup
Call Logger 2,0,1,'Ending' Date() 'at' Time()
Exit 0

/***************************************************************************/
/*  CTL-C handler                                                          */
/***************************************************************************/
HALT:
Call Logger 2,1,0,"CTL-C detected, aborting..."
Call Cleanup
Exit 3


/***************************************************************************/
/*  Subroutines                                                            */
/***************************************************************************/

/***************************************************************************/
/*  Disconnect from camera                                                 */
/***************************************************************************/

CLEANUP:
Call Camxdisconnect
Call Camxquit
Return

/***************************************************************************/
/*  Error message if camxInit call fails                                   */
/***************************************************************************/
NOTREGISTERED:
Call Logger 2,1,1,"Error in call to camxInit. Invalid Key dataset?"
Exit 5


/***************************************************************************/
/*  determine                NT / OS/2  + REXX version                     */
/***************************************************************************/
INITOS:
Parse Source os invoke sourcefn xx

Parse version langproc langlvl rday rmon ryear

If os="OS/2" Then Do
  nt=0
  os2=1
  umgebung="OS2ENVIRONMENT"
  cmdext="cmd"
  bskz="O"
End
Else Do
  nt=1
  os2=0
  umgebung="ENVIRONMENT"
  cmdext="rex"
  bskz="N"

  /*************************************************************************/
  /* Call Rxfuncadd 'w32loadfuncs', 'w32util', 'w32loadfuncs'              */
  /* Call W32loadfuncs                                                     */
  /*************************************************************************/

End

/***************************************************************************/
/*  Load rexxutils                                                         */
/***************************************************************************/

rc=rxfuncadd( "sysloadfuncs","rexxutil","sysloadfuncs")
Call Sysloadfuncs

Return

/***************************************************************************/
/*  Error handling                                                         */
/***************************************************************************/
NOVALUE:
Drop rc
SYNTAX:
ERROR:
Signal Off NOVALUE
Signal Off SYNTAX
Signal Off ERROR
If Datatype(rc,"W") Then Do                     /* check RC & set a message*/
  If (rc<100) & (rc>-1)
    Then mmm="Rexx error" rc ":" Errortext(rc)
    Else mmm="Bad return code" rc Condition("D")
  If Datatype(dlcount,"W") Then Do
    If (dlcount=7) & (rc=40) Then Do
      mmz="The Demo Version of 3eyeREXX is limited to downloading 6 pictures."
      Say mmz
      Call Lineout logdat,mmz
      mmz="Maybe that is the reason for the following error message."
      Say mmz
      Call Lineout logdat,mmz
    End
  End
End
Else mmm="Uninitialized variable:" Condition("D")

Parse Source . . program                           /* find the program name*/
mmz=program||"("||sigl||"):"|| mmm || " Programm error"
Say mmz

errfile=Substr(program,1,Lastpos(".",program))"err"    /* make errfile name*/
Call Sysfiledelete errfile                   /* delete errfile if it exists*/
Call Lineout errfile, mmz                                  /* write errfile*/
Call Stream errfile, "C", "Close"                          /* close errfile*/
Call Lineout logdat, mmz
Call Lineout logdat

Call Cleanup                                      /* disconnect from camera*/

/*If os2 Then 'x' program '/err' sigl  */
/*Trace '?i'*/
Nop
Exit 99



/***************************************************************************/
/*  Upro Logger   option,         before,      after,         message      */
/*                0 only log           empty lines                         */
/*                1 only say                                               */
/*                2 say + log                                              */
/*                                                                         */
/***************************************************************************/
LOGGER: Procedure Expose logdat
Parse Arg opt, vor, nach, text

/*  check params                                                           */
If text="" Then Return
If vor<"0" Then vor=0;Else If vor>"9" Then vor=1
If nach<"0" Then nach=0;Else If nach>"9" Then nach=1

/*  with say                                                               */
If opt>"0" Then Do
  Do k=1 To vor;Say;End
  Say text
  Do k=1 To nach;Say;End
End

/*  with log dataset                                                       */
If opt<>"1" Then Do
  Do k=1 To vor;Call Lineout logdat,"";End
  Call Lineout logdat,text
  Do k=1 To nach;Call Lineout logdat,"";End
End
Call Stream logdat,"C","Close"
Return

FIRSTTIME:
zigl=sigl

Say
Say "Please edit" sourcefn "and change line" zigl "and following"

Do k=zigl
  zeil=Strip(Sourceline(k))
  If zeil="" Then Iterate k
  If Pos("/* Don't modify a",zeil)>0 Then Leave k
  Say zeil
End
Say
Say "Please edit" sourcefn "and change lines" zigl "to" k-1 "for customization."
Return 99
/***************************************************************************/
/*  Change history: partial                                                */
/*  v 2.3                                                                  */
/*      messages txt changed                                               */
/*      timer for DL                                                       */
/*  v 2.4                                                                  */
/*      Date/time compare optional                                         */
/*  v 2.5                                                                  */
/*      ignore list for pictures not to DL, even if available              */
/*      program documentation (comments)                                   */
/*      Better Errormsg trying to DL more than 6 pics with demoversion     */
/*      Force customization                                                */
/***************************************************************************/

