/* starurl_cmd.m4,v 1.5 1999-12-13 23:55:16-05 rl Exp */


/*************************************************************************
 *                                                                       *
 * starurl_cmd.m4 -> starurl.cmd                                         *
 * 1999-12-12, Rolf Lochbuehler                                          *
 *                                                                       *
 *************************************************************************/


call rxFuncAdd 'sysLoadFuncs', 'rexxUtil', 'SysLoadFuncs'
call sysLoadFuncs

PROGRAM = 'StarUrl'


parse arg args
uArgs = translate( args )

if (0 < wordPos('-H',uArgs)) | (0 < wordPos('/H ',uArgs)) then
  do
  say ''
  say PROGRAM' 1.5, Rolf Lochbuehler <rolf@together.net>'
  say 'Purpose:'
  say '  Convert URL objects from OS/2 format to StarOffice format, or vice versa'
  say 'Syntax:'
  say '  starurl [/h] [/nodel] [/toos2] [InDir [OutDir]]'
  say 'Arguments:'
  say '  /h        Print this help screen, then exit'
  say '  /toos2    Convert StarOffice URLs to OS/2 URLs'
  say '              [default: OS/2 to StarOffice]'
  say '  /nodel    Create new URLs, but leave existing URLs untouched'
  say '              [default: overwrite existing URL objects]'
  say '  InDir     Root directory of URL folder tree to convert'
  say '              [default, only if no OutDir specified: .]'
  say '  OutDir    Root directory of converted URL folder tree'
  say '              [default: "URLs n" (n being some number to make name unique)]'
  say 'Note:'
  say '  Enclose directory names with double quotes if they contain spaces'
  say 'Example:'
  say '  starurl . "..\StarOffice URLs"'
  exit 1
  end

i = wordpos( '/TOOS2', uArgs )
if 0 = i then
  i = wordpos( '-TOOS2', uArgs )
if 0 = i then
  toOs2 = 0
else
  toOs2 = 1
n = i + 1

i = wordpos( '/NODEL', uArgs )
if 0 = i then
  i = wordpos( '-NODEL', uArgs )
if 0 = i then
  noDel = 0
else
  do
  noDel = 1
  n = max( n, i + 1 )
  end

if subword(args,n) = '' then
  do
  inDir = directory()
  outDir = filespec('drive',inDir) || filespec('path',inDir) || sysTempFileName( 'URLs ??' )
  end
else
  do
  if left(subword(args,n,1),1) = '"' then
    do
    if right(args,1) = '"' then parse var args . '"' inDir '"' . '"' outDir '"'
    else                        parse var args . '"' inDir '"'       outDir
    end
  else
    do
    i = wordIndex( args, n )
    if right(args,1) = '"' then parse var args . =(i) inDir '"' outDir '"'
    else                        parse var args . =(i) inDir     outDir
    end
  end
if '' = outDir then
  outDir = filespec('drive',inDir) || filespec('path',inDir) || sysTempFileName( 'URLs ??' )
inDir = strip( inDir )
outDir = strip( outDir )

inDir = normalize( inDir )
outDir = normalize( outDir )

str = 'Convert URLs in "'inDir'" (in'
if toOs2 then str = str' StarOffice'
else          str = str' OS/2'
str = str' format) to URLs in "'outDir'" (in'
if toOs2 then str = str' OS/2'
else          str = str' StarOffice'
str = str' format)? [Y|n]'
say str
pull answer
if 'N' = answer then
  do
  say 'Aborted'
  exit 1
  end

callDir = directory()

if inDir <> directory(inDir) then
  do
  say '*Error* Cannot find directory' inDir
  exit 1
  end

if outDir <> directory(outDir) then
  call sysMkDir outDir

numDirs = 0
numUrls = 0

call charOut , 'In progress...'

if toOs2 then
  call soToOs2 inDir, outDir
else
  call os2ToSo inDir, outDir

call directory callDir

say 'done'
if numUrls > 1 then
  if numDirs > 1 then say 'Converted 'numUrls' URLs in 'numDirs' directories'
  else                say 'Converted 'numUrls' URLs in 'numDirs' directory'
else
  if numDirs > 1 then say 'Converted 'numUrls' URL in 'numDirs' directories'
  else                say 'Converted 'numUrls' URL in 'numDirs' directory'

exit 0


/*************************************************************************
 *                                                                       *
 * os2ToSo()                                                             *
 * Recursive procedure to convert OS/2 URLs to StarOffice URLs           *
 *                                                                       *
 *************************************************************************/
os2ToSo: procedure expose noDel numDirs numUrls

  parse arg inDir, outDir

  call charOut , '.'

  call directory inDir

  numDirs = numDirs + 1


  /* URLs in this directory */

  call sysFileTree '*', 'inFile', 'fo'
  if inFile.0 > 0 then
    do i = 1 to inFile.0

      numUrls = numUrls + 1

      call sysGetEa inFile.i, '.LONGNAME', 'dummy'
      null = '00'x
      parse var dummy . (null) inFileLong (null)

      call stream inFile.i, 'command', 'open read'
      inUrl = lineIn( inFile.i )
      call stream inFile.i, 'command', 'close'

      outFile = outDir'\' || filespec('name',inFile.i) || '.url'

      if (\ noDel) | ('' = stream(outFile,'command','query exists')) then
        do
        call stream outFile, 'command', 'open write'
        call lineOut outFile, '[InternetShortcut]'
        call lineOut outFile, 'URL='inUrl
        call lineOut outFile, 'Title='inFileLong
        call lineOut outFile, 'Target=Browser'
        call lineOut outFile, 'Frame='
        call stream outFile, 'command', 'close'
        end

    end


  /* Subdirectories with more URLs */

  call sysFileTree '*', 'inSubDir', 'do'
  if inSubDir.0 > 0 then
    do k = 1 to inSubDir.0

      outSubDir = outDir'\' || filespec('name',inSubDir.k)

      call sysGetEa inSubDir.k, '.LONGNAME', 'inSubDirLong'

      if outSubDir <> directory(outSubDir) then
        do
        call sysMkDir outSubDir
        call sysPutEa outSubDir, '.LONGNAME', inSubDirLong
        end

      call os2ToSo inSubDir.k, outSubDir

    end


  call directory '..'

  return
  

/*************************************************************************
 *                                                                       *
 * soToOs2()                                                             *
 * Recursive procedure to convert StarOffice URLs to OS/2 URLs           *
 *                                                                       *
 *************************************************************************/
soToOs2: procedure expose noDel numDirs numUrls

  parse arg inDir, outDir

  call charOut , '.'

  call directory inDir

  numDirs = numDirs + 1

  /* URLs in this directory */

  call sysFileTree '*', 'inFile', 'fo'
  if inFile.0 > 0 then
    do i = 1 to inFile.0

      numUrls = numUrls + 1

      parse var inFile.i dummy '.url'
      outFileName = fileSpec( 'name', dummy )
      outFile = outDir'\'outFileName

      call stream inFile.i, 'command', 'open read'
      do while lines(inFile.i)
        line = lineIn( inFile.i )
        select 
          when 1 = pos('Title=',line) then
            parse var line 'Title=' outFileLong
          when 1 = pos('URL=',line) then
            parse var line 'URL=' inUrl
          otherwise
            nop
        end
      end
      call stream inFile.i, 'command', 'close'

      outFileLong = 'FDFF'x || d2c(length(outFileLong)) || '00'x || outFileLong || '00'x

      if (\ noDel) | ('' = stream(outFile,'command','query exists')) then
        do
        call sysCreateObject 'WPUrl', outFileName, outDir, , 'replace'
        call sysPutEa outFile, '.LONGNAME', outFileLong
        call stream outFile, 'command', 'open write'
        call lineOut outFile, inUrl
        call stream outFile, 'command', 'close'
        end

    end


  /* Subdirectories with more URLs */

  call sysFileTree '*', 'inSubDir', 'do'
  if inSubDir.0 > 0 then
    do i = 1 to inSubDir.0

      outSubDirName = filespec( 'name', inSubDir.i )
      outSubDir = outDir'\' || outSubDirName

      call sysGetEa inSubDir.i, '.LONGNAME', 'inSubDirLong'

      if outSubDir <> directory(outSubDir) then
        do
        call sysCreateObject 'WPUrlFolder', outSubDirName, outDir
        call sysPutEa outSubDir, '.LONGNAME', inSubDirLong
        end

      call soToOs2 inSubDir.i, outSubDir

    end


  call directory '..'

  return
  

/*************************************************************************
 *                                                                       *
 * normalize()                                                           *
 * Complete directory name, substitute ellipses, etc.                    *
 *                                                                       *
 *************************************************************************/
normalize: procedure

  parse arg d

  d = strip( d, 'b' )
  d = strip( d, 'b', '"' )

  if d = '' then
    dn = directory()
  
  /* '.' */
  else if d = '.' then
    dn = directory()
  
  /* '..' */
  else if d = '..' then
    do
    curDir = directory()
    call directory '..'
    dn = directory()
    call directory curDir
    end
  
  /* '\any\dir\name' */
  else if subStr(d,1,1) = '\' then
    do
    parse value directory() with drive ':\' .
    dn = drive':'d
    end
  
  /* 'any\dir\name' */
  else if pos(':',d) = 0 then
    do
    temp = directory() 
    if lastPos('\',temp) <> length(temp) then
      temp = temp || '\'
    dn = temp || d
    end

  else
    dn = d

  return dn


