.TH PSTOEDIT 1
.SH NAME 
pstoedit \- a converter from Postscript(TM) and PDF to editable Objects.
.SH SYNOPSIS
.B pstoedit
[
.B -help
] [
.B -bo
] [
.B -dt
] [
.B -dis
] [
.B -merge
] [
.B -flat number 
] [
.B -s number (for tgif only)
] [
.B -nomaptoisolatin1
] [
.B -nq
] [
.B -rn1xn2
] [
.B -f format
] [
.I input file
[
.I output file
]
]

.SH DESCRIPTION
pstoedit converts Postscript(TM) and PDF files to a simple vector graphic
format, that can be edited or imported into various drawing packages. 
To get a list of supported output formats type pstoedit -help.

Pstoedit works by redefining the two basic painting operators of
(TM)Postscript, stroke and show.
Other drawing operators, e.g., image are not supported.
After redefining these operators, the Postscript or PDF file that needs to
be converted is processed by a PostScript interpreter, e.g., GhostScript (gs). 
So you need to have a PostScript interpreter installed in order to use this 
program. If you want to process PDF files directly, the PostScript interpreter
must provide this feature, as does GhostScript.
The output that is written by the interpreter due to the redefinition of
the drawing operators is a sort of flat PostScript file which only
contains simple operations like  moveto lineto, show, .... 
You can look at this file using the -f debug option.

This output is read by the backend part in pstoedit and triggers the
drawing functions in the selected backend.

To implement a new backend you can start from drvsampl.cc and drvsampl.h.
See also drvbase.h and drvfuncs.h for an explanation of the methods 
that need to be implemented for a new backend.

.PP
.SH OPTIONS
.TP 0.6i
.B -dt
Text is drawn as polygons. This might produce a large output file.
You might want to use this options for example if the PostScript file 
contains rotated text and the backend does not support this, e.g., tgif.
.TP 0.6i
.B -merge
Some backend support the representation of filled polygons with edges that
are in a different color than the fill color. Since PostScript does not
support this, drawing programs typically generate two objects (the outline and
the filled polygon) into the PostScript output. pstoedit is able to recombine these,
if they follow each other directly and you specified -merge.
.TP 0.6i
.B -dis
Open a display during processing by GhostScript. Some files only work 
correctly this way.
.TP 0.6i
.B -s factor
scale by a factor (for tgif only).
.TP 0.6i
.B -f format
target output format. Currently tgif, mif, fig (for xfig), cgm, 
met (OS/2 only), wmf (Windows only), pdf, gnuplot, dxf, lwo, rib,
rpl, java, dump, debug, and ps are recognized.
.TP 0.6i
.B -flat number 
If the backend does not support curves in the way PostScript does, all
curves are approximated by lines. Using the the -flat option one can
control this approximation. This parameter is directly converted to a
PostScript setflat command.
.TP 0.6i
.B -rn1xn2
This argument is passed directly to GhostScript. This causes 
the resolution to be changed to (n1,n2). This has an effect only if -diplay is set.
Otherwise the resolution is 72dpi.
.TP 0.6i
.B -nq
Normally Ghostscript stops after processing the pstoedit input file. For debugging
it can be useful to avoid this. In this case you have to type 'quit' to the GS> prompt.
.TP 0.6i
.B -nomaptoisolatin1
Normally pstoedit maps all character codes to the ones defined by the ISO-Latin1 encoding. 
If you specify -nomaptoisolatin1 then the encoding from the input PostScript is passed
unchanged to the output. 
.TP 0.6i
.B -bo 
You can run a backend only (without the PostScript interpreter frontend)
by first running pstoedit -f dump infile dumpfile and then
running pstoedit -f format -bo dumpfile outfile.
.TP 0.6i
.I input file
input file. 
.TP 0.6i
.I output file
output file. If no output file is given as argument, pstoedit writes the
result to standard output.

If neither an input nor an output file is given as argument, pstoedit works 
as filter reading from standard input and writing to standard output.
.SH RUNNING ON OS/2
When running pstoedit on OS/2 you need to call it via the script ps2edit.cmd.
.SH BACKEND SPECIFIC OPTIONS
pstoedit allows to pass individual options to a backend driver. This is done
by appending all options to the format specifier after the -f option. 
The format specifier and the options must be separated by a :. If more than
one option needs to be passed to the backend, the whole argument to -f
must be enclosed within ".

Currently the met and the wmf driver are the only drivers accepting 
specific options.

The wmf driver supports two backend specific options. 
'v' turns on a verbose mode and 'e' tells pstoedit to generate an 
enhanced metafile instead of a normal metafile. 
pstoedit does not yet generate placeable metafiles.
This will be added in one of the next releases.

.SH ENVIRONMENT VARIABLES
A default PostScript interpreter that shall be called by pstoedit is 
specified at compile time. You can overwrite this default by setting
the environment variable GS to the name of a suitable PostScript 
interpreter.

For getting some verbose output you can set the environment variable
PSTOEDITVERBOSE to 1.

.SH AUTHOR
Wolfgang Glunz, Wolfgang.Glunz@mchp.siemens.de

.SH ACKNOWLEDGEMENTS
.TP 0.2i
.B *
Klaus Steinberger <Klaus.Steinberger@physik.uni-muenchen.de> who wrote the initial version of this man page.
.TP 0.2i
.B *
David B. Rosen <rosen@murmur> for some ideas and some PostScript code from his ps2aplot program.
.TP 0.2i
.B *
Ian MacPhedran <Ian_MacPhedran@engr.USask.CA> for the xfig backend.
.TP 0.2i
.B *
Carsten Hammer <chammer@hermes.hrz.uni-bielefeld.de> for the gnuplot and the intial dxf backend.
.TP 0.2i
.B *
Christoph Jaeschke <jaeschke@imbe05.imbe.uni-bremen.de> for the OS/2 metafile backend.
.TP 0.2i
.B *
Jens Weber <wr@lzh1.lzh.de> for the Windows metafile (WMF) backend and a GUI.
.TP 0.2i
.B *
G. Edward Johnson <lorax@nist.gov> <URL:http://speckle.ncsl.nist.gov/~lorax/> for the CGM draw library used in the CGM backend.
.TP 0.2i
.B *
Gerhard Kircher <kircher@edvz.tuwien.ac.at> for some bug fixes.
.TP 0.2i
.B *
Bill Cheng <william@cs.columbia.edu> <URL:http://www.cs.columbia.edu/~william>
for his help with the tgif format and some changes to tgif to make the backend
easier to implement.
.TP 0.2i
.B *
Reini Urban <rurban@sbox.tu-graz.ac.at>  <URL:http://xarch.tu-graz.ac.at/autocad/>
for his inputs regarding the extended DXF backend.
.TP 0.2i
.B *
Glenn M. Lewis <glewis@c2.net>  <URL:http://www.c2.net/~glewis/>
for the RenderMan (RIB), Real3D (RPL), and LightWave 3D (LWO) backends.
.TP 0.2i
.B *
Piet van Oostrum <piet@cs.ruu.nl> for several bug fixes.
.TP 0.2i
.B *
Lutz Vieweg <lkv@mania.robin.de> for several bug reports and suggestions for improvements.
.TP 0.2i
.B *
Derek B. Noonburg <derekn@vw.ece.cmu.edu> and Rainer Dorsch
<rd@berlepsch.wohnheim.uni-ulm.de>
for taking care of the linux specific problem core dump problem 
and providing the workaround for it.
