/**
*** This will convert an HPPCL datastream into a file that can be uploaded
*** into a VBA MVS file.  This allows mainframe documentation to be created
*** on a PC using the word processor of choice.  That can then be uploaded
*** to the host.
***
*** This code supports only underscore, normal and boldface Courier 10 point.
*** An attempt to do any other highlighting will produce an error message.
***
**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dcfvba.h"

/**
***  Define global variables
**/

int      line_length = MAXLINE; /* Max length of a line */
FILE     *pcl_file;             /* Input file */
FILE     *vba_file;             /* Output file */
STRING   line = "";             /* Buffer for holding a line */
char     current[2];            /* Buffer for next input character */
long     row = 1;               /* Input row (or line number) */
int      underscore = 0;        /* Is underscore on? */
int      italics = 0;           /* Is italics on? */
int      bold = 0;              /* Is bold on? */
int      column = 0;            /* Input column */
int      lmargin = 0;           /* Left margin */
int      rmargin = 255;         /* Right margin */
int      actual_vpos = 1;       /* Actual line number on the output page */
int      logical_vpos = 1;      /* Theoretical line number on output page */
double   pitch = 10.0;          /* Pitch of the font */
double   lpi = 6.0;             /* Lines per inch */

/**
*** +-----------------------------------------------------------------------+
*** |                               Mainline                                |
*** +-----------------------------------------------------------------------+
**/

int main(int argc,char *argv[])
   {

   /* Print banner */

   printf("DCFVBA Version 1.0  Copyright (c) 1990  Gary Murphy\n\n");

   parse_command_line(argc,argv);

   /* Write out the initial DCF commands */

   fputs(".df bold OS RPT 3 TYPE(BOLD OVERSTRUCK)\n",vba_file);
   fputs(".tr ! 40\n",vba_file);

   next_char();
   while(!feof(pcl_file))
      {
      if (*current == '')
         {
         *current = 'o';
         normal_char();
         }
      else
      if (*current == ESCAPE)
         translate_pcl();
      else
      if (*current == LINEFEED)
         new_line();
      else
      if (*current == CARRIAGE_RETURN)
         new_line();
      else
      if (*current == FORMFEED)
         new_page();
      else
         normal_char();
      next_char();
      } /* while */

   /* Flush the buffers */

   new_line();
   return(0);
   }
