/**
***  This is a part of the PCL2VBA project.   This set of functions handle
***  the output of the converted datastreams.
**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dcfvba.h"

/* -------------------------------------------------------------------------- */

void new_page(void)
   {
   new_line();
   fputs(".pa",vba_file);
   logical_vpos = 1;
   actual_vpos = 1;
   return;
   }

/* -------------------------------------------------------------------------- */

void clear_line(void)
   {
   *line = '\0';

   /* Pad the new output string to the length of the left margin */

   strpad(lmargin);
   return;
   }

/* -------------------------------------------------------------------------- */

void put_line(void)
   {
   char *pchar;

   /* If the only thing on the line is the concatination (.ct) command, then */
   /* don't bother to print it out.                                          */

   if (!strcmp(line,".ct "))
      return;

   /* Point to the end of the line and replace all trailing blanks w/ '!'. */

   pchar = strchr(line,'\0');
   pchar--;

   while(*pchar == ' ')
      *pchar-- = '!';

   fputs(line,vba_file);
   fputc('\n',vba_file);
   return;
   }

/* -------------------------------------------------------------------------- */


void new_line(void)
   {
   char *last_char;


   put_line();

   /* If there are trailing blanks in the line just printed out, then       */
   /* concatinate the subsequent line.                                      */

   last_char = strchr(line,'\0');
   last_char--;
   if (*last_char == '!')
      strcpy(line,".ct ");
   else
      clear_line();

   /* Reset row and column indicators */

   row++;
   column = 0;
   logical_vpos++;
   actual_vpos++;
   return;
   }
