/**
***  This is a part of the PCL2VBA project.   This set of functions handle
***  The command line and the help information.
**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dcfvba.h"

/* -------------------------------------------------------------------------- */

void show_usage()
   {
   printf("Usage:  DCFVBA [options] PCL_file [VBA_file]\n");
   printf("\twhere options are:\n");
   printf("\t\t/L   output line length\n");
   printf("\t\t/?   Show this usage screen.\n\n");
   }

/* -------------------------------------------------------------------------- */

void parse_command_line(int argc, char *argv[])
   {
   int files = 0; /* number of files found on the command line */
   int count;     /* index through the parameters */
   if (argc == 1)
      {
      show_usage();
      exit(0);
      }
   else
      {

      /* Check for options */

      for (count = 1; count < argc; count++)
         {
         if ((*argv[count] == '/') || (*argv[count] == '-'))
            {
            switch (argv[count][1])
               {
               case '?':
                  {
                  show_usage();
                  exit(0);
                  }
               case 'L':
               case 'l':
                  {
                  char   number[10];
                  char   *scanptr;
                  int    i = 0;

                  scanptr = argv[count];
                  scanptr += 2; /* Skip over the "/L" */
                  while (number[i++] != '\0')
                     number[i++] = *scanptr++;
                  if ((line_length = atoi(number)) == 0)
                     error(strcat("Invalid numeric in parameter string: ",number),16);
                  break;
                  }
               default:
                  {
                  printf("Warning: Invalid flag argument \"%s\".\n",&argv[count][1]);
                  break;
                  }
               } /* switch */
            } /* if */
         } /* for */

      /* Check for file names */

      for (count = 1; count < argc; count++)
         {
         if ((*argv[count] != '/') && (*argv[count] != '-'))
            {
            files++;
            switch(files)
               {
               case 1: /* Input file */
                  {
                  if ((pcl_file = fopen(argv[count],"rt")) == NULL)
                     error(strcat("Cannot open input file: ",argv[count]),16);
                  break;
                  }
               case 2: /* Output file */
                  {
                  if ((vba_file = fopen(argv[count],"wt")) == NULL)
                     error(strcat("Cannot open output file: ",argv[count]),16);
                  break;
                  }
               default:
                  {
                  show_usage();
                  error("Invalid number of parameters.",16);
                  } /* default */
               } /* switch */
            } /* if */
         } /* for */

      /* Make sure both files have been opened */

      if (files != 2)
         error("Output file missing",16);

      } /* else */
   return;
   } /* parse_command_line */
