/* RxExtras - test for all functions in RxExtras.DLL */
Address CMD

Parse Arg label
If label <> '' Then Interpret 'CALL 'label

If RxFuncQuery('RxExtra') <> 0 Then
    rcy = RxFuncAdd('RxExtra', 'RxExtras', 'RxExtra')

Call RxExtra "Drop" /* Drop everything */
rcy = RxFuncAdd('RxExtra', 'RxExtras', 'RxExtra')
Say 'Using version 'RxExtra("Load")' of RxExtras'

Say
Say "Testing RxBootDrive and RxRead..."
Call RxRead 'stem.', RxBootDrive()":"'\CONFIG.SYS'
Say "Your Config.Sys file should now appear"
"@PAUSE"
Do i = 1 to stem.0
   Say stem.i
end /* do */
"@PAUSE"


Say
Say "Testing RxBootDrive by itself"
Say 'Your bootdrive is 'RxBootDrive()":"
"@PAUSE"

temp.0 = 5
temp.1 = "This is a test file"
temp.2 = "With this ring, I thee bed"
temp.3 = "The worlds smallest handcuff"
temp.4 = "How to win fiends and affluent people"
temp.5 = "### The last line ###"

Say
Say "Testing RxWrite by writing 5 lines to \TEMP.DAT"
Call RxWrite "temp.", "\temp.dat"
Say "Here is \TEMP.DAT"
"@type \temp.dat"

"@PAUSE"
"@DEL \temp.dat"

Say
Say "Testing RxVolumeLabel"
Say "Label of C is "RxVolumeLabel("C")
"@PAUSE"


Say
Drop stem.
Drop temp.
temp.1 = 1
temp.testing = "Testing is on"
temp.2 = 3
temp.testing.1 = "Life be in it"
Say "Testing RxVarDump - dumping all 'local' variables"
Call RxVarDump 'vars.'

Do i = 1 to vars.0
  Say 'Variable Name:"'vars.i.name'" has the value: "'vars.i.value'"'
End
Drop vars.
"@PAUSE"

Say
Say "Testing RxStemCopy"
Say "Copy all variables from temp. to temp2."
Say "See RxVarDump above for temp. variables"

Call RxStemCopy "temp.", "temp2."

Say "Now we have..."
Call RxVarDump 'vars.'
Do i = 1 to vars.0
  Say 'Variable Name:"'vars.i.name'" has the value: "'vars.i.value'"'
End
Drop vars.
"@PAUSE"

Say
Say "Testing RxSort"
temp.0 = 16
temp.1 = "This is a list"
temp.2 = "a List should be sorted"
temp.3 = "upper and Lowercase"
temp.4 = "$trange"
temp.5 = "#unny"
temp.6 = "@nd unusual"
temp.7 = "12345"
temp.8 = "123456"
temp.9 = "One isthe 9"
temp.10 = "Ten green bottles 10"
temp.11 = "Legs 11"
temp.12 = "And then some 12"
temp.13 = "Hollow weeing 13"
temp.14 = "Only 14"
temp.15 = "15"
temp.16 = "The last line!"
Say
Say "The unsorted list is..."
Say Copies('-', 50)
Do i = 1 to temp.0
    Say temp.i
end /* do */
Say Copies('-', 50)
"@PAUSE"
Say
Say "Sorting in descending order gives..."
Call RxSort 'temp.', 'Descending'

Say Copies('-', 50)
Do i = 1 to temp.0
    Say temp.i
end /* do */
Say Copies('-', 50)
"@PAUSE"
Say
Say "Sorting in ascending order gives..."
Call RxSort 'temp.', 'Asc'
Say Copies('-', 50)
Do i = 1 to temp.0
    Say temp.i
end /* do */
Say Copies('-', 50)
"@PAUSE"

Say
Say "Testing RxSwitchTo"
Say "Switching to the desktop, hit Ctrl-Alt-Shift-O to see developers"
/* RxSwitchTo works by matching as much of the string as you give it
 * to the first session.
 * i.e. Call RxSwitchTo "System C"
 * Will switch to the system clock.
 */
Call RxSwitchTo "Desktop"
If POS("Switch", result) <> 0 Then Do /* probably 2.1 */
  Call RxSwitchTo "OS"
End
"@PAUSE"

Say
Say "Testing RxQuerySwitchListo"
Say "The programs running should now appear."
Call RxQuerySwitchList "temp."
Do i = 1 to temp.0
   Say "Title: "temp.i ", Hwnd: "temp.i.hwnd", Process Id: "temp.i.pid
End /* do */

"@PAUSE"

Say
Say "Testing RxQueryDriveType for Drive C:"
Say RxQueryDriveType("C:")
"@PAUSE"

BD = RxBootDrive()
PathToSearch = BD":\OS2;"BD":\OS2\INSTALL"
Say
Say "Testing RxSearchPath looking for DATABASE.TXT in \OS2 and \OS2\INSTALL"
Say RxSearchPath(PathToSearch, 'DATABASE.TXT')
"@PAUSE"

RxLC:
Say
Say "Testing RxLineCount"
LC = RxLineCount(RxBootDrive()':\CONFIG.SYS')
Say 'There are 'LC' lines in the your CONFIG.SYS file'
"@PAUSE"

Say
Say "Testing RxGetEXEName"
Say "The command line for this program was '"RxGetEXEName()"'"
"@PAUSE"

Say
Say "Testing RxNap"
Say "This program should appear to sleep for half a second"
Call RxNap 500
"@PAUSE"

Say
Say "Testing RxFileExists"
If (RxFileExists(RxBootDrive()":\CONFIG.SYS")) Then
   Say "I found your CONFIG.SYS!"
"@PAUSE"

Say
Say "Testing RxKillProcess"
Say "Please note the following output for processes to kill"
Say "(and remember to convert the process from hex to decimal)"
"@PSTAT /C | MORE"
Call Charout ,"Enter a process id to be killed ?"
Parse Pull id
Say "Kill process returned: "RxKillProcess(id)
"@PAUSE"

Say
Say "Testing RxAddFileHandles"
Say "There are currently "RxAddFileHandles(0)" handles available."
Say "Now adding 25 more. Now "RxAddFileHandles(25)" handles available."
"@PAUSE"

Say
Say "Testing RxSetFileHandles"
Say "There are currently "RxAddFileHandles(0)" handles available"
Say "Now setting this to 100."
Call RxSetFileHandles 100
Say "Now "RxAddFileHandles(0)" handles available."
"@PAUSE"

Say
Say "Testing RxMatchWildCard"
MF = 'MYFILE.cmd'
WC = '*.cmd'
Result = RxMatchWildCard(MF, WC)
If Result = MF Then
   Say '   'MF' matches Wildcard 'WC' (Edited name is:'Result')'
Else
   Say '   'MF' does not match Wildcard 'WC' (Edited name is:'Result')'
MF = 'MYFILE.cmd'
WC = '*.bbb'
Result = RxMatchWildCard(MF, WC)
If Result = MF Then
   Say '   'MF' matches Wildcard 'WC' (Edited name is:'Result')'
Else
   Say '   'MF' does not match Wildcard 'WC' (Edited name is:'Result')'
'@PAUSE'

Say
Say "Testing RxStemSearch"
stem.0 = 5
stem.1 = 'Hi There, hello'
stem.2 = 'Hello'
stem.3 = 'Nope'
stem.4 = 'helicopter'
stem.5 = 'Hell is a lovely planet'

Say "Finding 'hel' case sensitive in a stem, and returning indexes"
Call RxStemSearch 'hel', 'stem.', 'find.', 'CN'
Do i = 1 to find.0
  Say find.i
End
'@PAUSE'

Say
Say 'Testing RxMemAvail'
Say 'There is 'RxMemAvail()/1024||'KB of physical memory free'
'@PAUSE'

Say
Say 'Testing RxSysValues'
Call RxSysValues 'sysvals.'
Say 'There is 'sysvals.totphysmem/1024/1024'MB of memory in your machine'
'@PAUSE'

Say
Say 'Testing RxSetGlobal and RxGetGlobal with single variables'
Say "Setting the global variable 'TEST' to 'The air attack warning sounds like'"
Call RxSetGlobal 'TEST', 'The air attack warning sounds like'
Say 'The text retrieved is:"'RxGetGlobal('TEST')'"'
'@PAUSE'

stem.0 = 3
stem.1 = 'When you hear'
stem.2 = 'the air attack warning'
stem.3 = 'RUN!!!!!'
Say
Say 'Testing RxSetGlobal and RxGetGlobal with stems'
Say 'Setting the global stem "warning" from a local stem'
Call RxSetGlobal 'warning.', 'stem.'
Say 'Getting the Global stem "warning" into the local stem "frankie"'
Call RxGetGlobal 'warning.', 'frankie.'
Say 'The contents of frankie are: '
Do i = 1 to frankie.0
  Say frankie.i
End
'@PAUSE'

Say
Say 'Testing RxQueryCountryInfo'
Call RxQueryCountryInfo 'temp.'
Say 'The currency sign is '||temp.CURRENCY||' in your country'
'@PAUSE'
Say
Say "All testing is now over..."
"@PAUSE"

Call RxExtra "Drop"
