/* REXX: remove OS2CSM comment markup from config.sys */

/* parameter 1: filename */
parse arg name

/* handle help request */
if name=='' | name=='?' | name=='/?' | name = '-?' then
  do
    Say 'Usage: stripcsm x:\config.sys'
    Return 99
  end

/* error, if file does not even exist */
if Stream(name, 'c', 'query exist') == '' then
  do
    Say 'file' name 'does not exist.'
    Return 99
  end

/* read all lines, ignoring 512 byte markup */
r = 0
j = 0
do while lines(name)
   r = r + 1
   ibuf = linein(name)
   jbuf = translate(ibuf)
   if (pos("REM V.K. * OS2CFG *",jbuf)>0) then iterate
   if (pos("REM 512CONF",jbuf)>0) then iterate
   j = j + 1
   lines.j = ibuf
end
Say 'Read' r 'lines,'

/* write back remaining lines */
if (j>0) then do
   call lineout name
   '@call del 'name
   lines.0 = j
   do i = 1 to lines.0
      call lineout name, lines.i
   end
   call lineout name
end
Say 'Wrote' j 'lines.'

/* done, successful */
return 0
