/* Install for RxBMW Backup My Way         */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

dir = directory() || '\'

CALL SysCls
SAY 'Welcome to Backup My Way Installation procedure!'
SAY 'Your files are in directory: '||Dir
SAY 'This procedure will create a Folder and Program objects for Backup My Way'
SAY 'Press "Y" to start Installation, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'Installation aborted.'
END

say 'Creating folder'
call SysCreateObject "WPFolder", "Backup My Way", "<WP_DESKTOP>", "OBJECTID=<RxBMW_FOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO", "Replace"

say 'Creating program objects'
call SysCreateObject "WPProgram", "RxBMW", "<RxBMW_FOLDER>", "EXENAME=Rx.exe;STARTUPDIR=" || dir || ";PARAMETERS=RXBMW.CMD", "R"
call SysCreateObject "WPProgram", "Drives Window", "<RxBMW_FOLDER>", "EXENAME=Rx.exe;STARTUPDIR=" || dir || ";PARAMETERS=RXBMWdrv.CMD", "R"
call SysCreateObject "WPProgram", "RxBMW Help", "<RxBMW_FOLDER>", "EXENAME=View.exe;STARTUPDIR=" || dir || ";PARAMETERS=RXBMW.hlp", "R"
say 'Install complete'
say ' '
say 'Rexx Dialog should now be installed.'
say 'The Installation procedure is in Rxdlg11.zip.'
say ' '
say 'RexxLib should now be installed.'
say 'The installation procedure is in RexxLib.zip.'
say ' '
say ' '
say 'Before using RxBMW for the first time, edit RxBMW.cfg'
say 'and change the file edit and file viewer config entries'
say 'to match your system.'
say ' '

pause
Exit

NoAction:   PROCEDURE

PARSE ARG noinstmsg
SAY ' '
SAY noinstmsg
SAY 'Press any key to exit ...'
ans = SysGetKey('NOECHO')
Exit
