/* rexx - install.cmd - install rlgbisf 6/28/98            */
/* usage: INSTALL x:\install_directory dos_drive os2_drive */

if Stream('rlgBISF.EXE','C','Query Exists') = '' then do
    say 'Please run this program from the same directory as the rlgBISF.EXE file'
    say ''
    say 'Exiting . . .'
    exit
end

parse upper arg install_dir dos_drive os2_drive
parse value install_dir with install_drive ':' install_dir
if install_drive = '' then
    install_drive = 'E'
if install_dir = '' then
    install_dir = '\rlgBISF'
install_drive = LEFT(install_drive,1)
install_dir = STRIP(install_dir)
if RIGHT(install_dir,1) = '\' then
    install_dir = STRIP(install_dir,'T','\')
if install_dir = '' then
    install_dir = '\'
dos_drive = LEFT(dos_drive,1)
os2_drive = LEFT(os2_drive,1)
if dos_drive = '' then
    dos_drive = 'C'
if os2_drive = '' then
    os2_drive = 'E'

say 'rlgBISF v1.0 will be installed in 'install_drive':'install_dir
say ''
say '   DOS  is installed on drive 'dos_drive':'
say '   OS/2 is installed on drive 'os2_drive':'
say ''
say 'Is this correct? (y/N):'
parse upper pull answer
if answer = 'Y' then
    nop
else do
    call usage
    exit
end
/******************************/
/* OK, begin installation     */
/******************************/
Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs
say ''
Call SysMkDir install_drive':'install_dir
rlgBISF_install_dir = install_drive':'install_dir
Program = 'rlgBISF'
File.0  = 10
File.1  = 'BISFhlp.txt'
File.2  = 'FILE_ID.DIZ'
File.3  = 'FILES.LST'
File.4  = 'install.cmd'
File.5  = 'readme.txt'
File.6  = 'register.txt'
File.7  = 'rlgBISF.exe'
File.8  = 'rlgBISF.ico'
File.9  = 'uninstal.cmd'
File.10 = 'vrobjdll.url'
ADDRESS CMD
"@echo off"
say 'Copying files to 'rlgBISF_install_dir
do i = 1 to File.0
    "copy "File.i" "rlgBISF_install_dir
end
ADDRESS
if install_dir = '\' then
    rlgBISF_install_dir = install_drive':'
rlgbisf_ini = rlgBISF_install_dir'\rlgBISF.INI'

/* delete all previous settings for rlgbisf from os2.ini */
/* say 'Adding entry to OS2.INI' */
call SysIni , Program
/* add rlgBISF settings to OS2.INI */
rc = SysIni('USER', Program, 'rlgBISF_install_dir', rlgBISF_install_dir)
if rc \= '' then do
    say 'Error setting installation directory in OS2.INI.   Exiting.'
    exit
end
/* say 'Adding entries to 'rlgbisf_ini */
rc = SysIni(rlgbisf_ini, 'rlgBISF', 'rlgBISF_dos_drive', dos_drive)
if rc \= '' then do
    say 'Error setting dos_drive in 'rlgbisf_ini'.   Exiting.'
    exit
end

rc = SysIni(rlgbisf_ini, 'rlgBISF', 'rlgBISF_os2_drive', os2_drive)
if rc \= '' then do
    say 'Error setting os2_drive in 'rlgbisf_ini'.   Exiting.'
    exit
end

/* Create main folder object */
/* say ''
 * say 'Building Workplace Shell rlgBISF v1.0 Objects...'
 * say ''
 */
/**********************/
/** folder           **/
/**********************/
classname = 'WPFolder'
title     = 'Backup Important^System Files v1.0'
location  = '<WP_DESKTOP>'
objectid  = '<rlgBISF_folder>'
setup     = 'OBJECTID=' || objectid || ';'
rc = SysCreateObject(classname, title, location, setup, 'r')
if rc = 1 then
    nop /*say '  folder object built'*/
else do
    say '  error building folder, rc = 'rc
    exit
end

/**********************/
/** readme.txt       **/
/**********************/
classname = 'WPProgram'
objectid  = '<rlgBISF_readme>'
exename   = 'E.EXE'
title     = 'Readme^First'
location  = '<rlgBISF_folder>'
setup     = 'OBJECTID=' || objectid || ';EXENAME=' || exename ||,
            ';PARAMETERS=' || rlgBISF_install_dir || '\README.TXT' ||,
            ';PROGTYPE=PM;'
rc = SysCreateObject(classname, title, location, setup, 'r')
if rc = 1 then
    nop /*say '  readme object built'*/
else do
    say '  error building readme, rc = 'rc
    exit
end

/**********************/
/** program          **/
/**********************/
classname = 'WPProgram'
objectid  = '<rlgBISF_program>'
exename   = rlgBISF_install_dir || '\RLGBISF.EXE'
iconfile  = rlgBISF_install_dir || '\RLGBISF.ICO'
title     = 'rlgBISF v1.0'
location  = '<rlgBISF_folder>'
setup     = 'OBJECTID=' || objectid || ';EXENAME=' || exename ||,
            ';PROGTYPE=PM;ICONFILE=' || iconfile ||,
            ';STARTUPDIR=' || rlgBISF_install_dir || ';'
rc = SysCreateObject(classname, title, location, setup, 'r')
if rc = 1 then
    nop /*say '  program object built'*/
else do
    say '  error building program, rc = 'rc
    exit
end

/**********************/
/** bisfhlp.txt      **/
/**********************/
classname = 'WPProgram'
objectid  = '<rlgBISF_bisfhlp>'
exename   = 'E.EXE'
title     = 'rlgBISF^Help'
location  = '<rlgBISF_folder>'
setup     = 'OBJECTID=' || objectid || ';EXENAME=' || exename ||,
            ';PARAMETERS=' || rlgBISF_install_dir || '\BISFHLP.TXT' ||,
            ';PROGTYPE=PM;'
rc = SysCreateObject(classname, title, location, setup, 'r')
if rc = 1 then
    nop /*say '  help object built'*/
else do
    say '  error building help, rc = 'rc
    exit
end

/**********************/
/** register.txt     **/
/**********************/
classname = 'WPProgram'
objectid  = '<rlgBISF_register>'
exename   = 'E.EXE'
title     = 'Registration^Form'
location  = '<rlgBISF_folder>'
setup     = 'OBJECTID=' || objectid || ';EXENAME=' || exename ||,
            ';PARAMETERS=' || rlgBISF_install_dir || '\REGISTER.TXT' ||,
            ';PROGTYPE=PM;'
rc = SysCreateObject(classname, title, location, setup, 'r')
if rc = 1 then
    nop /*say '  registration form object built'*/
else do
    say '  error building registration form, rc = 'rc
    exit
end

/**********************/
/** vrobjdll.url     **/
/**********************/
classname = 'WPProgram'
objectid  = '<rlgBISF_vrobjdll>'
exename   = 'E.EXE'
title     = 'URL to download^VROBJ.DLL'
location  = '<rlgBISF_folder>'
setup     = 'OBJECTID=' || objectid || ';EXENAME=' || exename ||,
            ';PARAMETERS=' || rlgBISF_install_dir || '\VROBJDLL.URL' ||,
            ';PROGTYPE=PM;'
rc = SysCreateObject(classname, title, location, setup, 'r')
if rc = 1 then
    nop /*say '  vrobjdll object built'*/
else do
    say '  error building vrobjdll, rc = 'rc
    exit
end

/**********************/
/** shadow program   **/
/** onto the desktop **/
/**********************/
classname = 'WPShadow'
objectid  = '<rlgBISF_shadow_pgm>'
shadowid  = '<rlgBISF_program>'
title     = 'Backup Important^System Files'
location  = '<WP_DESKTOP>'
setup     = 'SHADOWID=' || shadowid || ';OBJECTID=' || objectid || ';'
rc = SysCreateObject(classname, title, location, setup, 'r')
if rc = 1 then
    nop /*say '  desktop shadow object built'*/
else do
    say '  error building desktop shadow, rc = 'rc
    exit
end
say 'rlgBISF v1.0 has been installed.'
return

usage:
    /* usage: INSTALL x:\install_directory dos_drive os2_drive */
    say ''
    say 'This program installs the various files and objects needed to run rlgBISF v1.0.'
    say ''
    say 'Usage:    install [target_drive:\target_dir] [dos_drive] [os2_drive]'
    say ''
    say 'Example:  install X:\rlgBISF Y Z'
    say ''
    say '  where X:\rlgBISF is the installation drive and directory,'
    say '        Y          is the drive where DOS/Windows is installed,'
    say '        Z          is the drive where OS/2 is installed.'
return
