/* $Id: nntpcl.c 1.2 1995/01/05 13:19:45 cthuang Exp $
 *
 * NNTP client routines
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <utils.h>
#include "nntp.h"
#include "socket.h"

/* #define DEBUG */

/* Open connection to NNTP server.
 * Return socket handle.
 */
int
nntpConnect (void)
{
    char *server;
    struct servent *sp;
    char buf[BUFSIZ];
    int response;
    int socket;

    if(!(server = (char *)getentry("newsserver")))
	server = getenv("NEWSSERVER");
    if (server == NULL) {
	fprintf(stderr,
	    "Set the NEWSSERVER environment variable or config file keyword to the news host.\n");
	exit(1);
    }

    if ((sp = getservbyname("nntp", "tcp")) == NULL) {
	fprintf(stderr, "nntp/tcp: Unknown service.\n");
	return -1;
    }

#ifdef DEBUG
    socket = 110;
#else
    socket = Socket(server, ntohs(sp->s_port));
#endif
    if (socket < 0) {
	fprintf(stderr,
	    "Couldn't connect to %s news server, try again later.\n",
	    server);
	return -1;
    }

    if (SockGets(socket, buf, sizeof(buf)) == 0) {
	response = atoi(buf);
	switch (response) {
	case OK_NOPOST:
	    printf("This machine does not have permission to post articles.\n");
	    break;

	case OK_CANPOST:
	    break;

	case ERR_ACCESS:
	    printf("This machine does not have permission to use the news server.\n");
	    return -1;

	default:
	    printf("Unexpected response code %d from %s news server\n",
		    response, server);
	    return -1;
	}
    }

    /* This is for INN */
    SockPuts(socket, "mode reader");
    SockGets(socket, buf, sizeof(buf));

    return socket;
}

/* Select newsgroup to read from
 * Return TRUE if successful.
 */
int
nntpGroup (int socket, const char *ngname, int *pLo, int *pHi)
{
    char buf[BUFSIZ];
    int count;

    SockPrintf(socket, "GROUP %s\r\n", ngname);
    if (SockGets(socket, buf, sizeof(buf)) != 0) {
	return 0;
    }

    if (buf[0] == CHAR_OK) {
	sscanf(buf+4, "%d %d %d", &count, pLo, pHi);
    } else {
	fprintf(stderr, "%s: %s\n", buf, ngname);
    }
    return buf[0] == CHAR_OK;
}

/* Get article from server.
 * Return TRUE if successful.
 */
int
nntpArticle (int socket, const char *cmd, int artnum, FILE *outf)
{
    char buf[BUFSIZ];
    char *bufp;

    SockPrintf(socket, "%s %d\r\n", cmd, artnum);
    if (SockGets(socket, buf, sizeof(buf)) < 0) {
	return 0;
    }

    if (buf[0] == CHAR_FATAL) {	/* Fatal error */
	fprintf(stderr, "%s\n", buf);
	exit(1);
    }

    if (buf[0] != CHAR_OK) {		/* and get it's reaction */
	return 0;
    }

    while (SockGets(socket, buf, sizeof(buf)) == 0) {
	bufp = buf;
	if (buf[0] == '.') {
	    ++bufp;
	    if (buf[1] == '\0')
		break;
	}

	fputs(bufp, outf);
	fputc('\n', outf);
    }

    return 1;
}

/* Close NNTP connection. */

void
nntpClose (int socket)
{
    SockPuts(socket, "QUIT");
    soclose(socket);
}
