
/**
***	This file is part of the source to QQLink, a FTS-9 reply linker for
*** use with the Squish(tm) mail processor.
*** Copyright (c) 1993 Josh Parsons. All rights reserved, however:
***
***	       1) You are permitted to freely distribute this source,
***           provided you do not remove this copyright notice, and
***           provided you do not charge a fee, for the service of
***           distributing this material, over and above the value
***           of disks, phone tolls, etc. incurred in such distribution.
***        2) You are permitted to use executables produced from this
***           source in the manner described in QQLink.DOC, which should
***           accompany this file.
***        3) You are permitted to use this source in your own programs,
***           provided that your derivative work carries an
***           acknowledgement that portions of its source are derived
***           from QQLink, by Josh Parsons.
***
***        NB: This source carries no warrantee, implicit or explicit
***            of fitness for any particular task.
**/


#define MAX_XMSG 192
//#define MAX_XMSG 32
#define MAX_MSGS 1000

typedef long MSGID;

struct QQF {  // The actual layout of a .QQL file
  byte sig,method;
  word topid;
  ulong high;
  MSGID id[MAX_MSGS];
  ulong uid[MAX_MSGS];
  };

typedef struct { // One muthahumper of a structure (62682 bytes)
	word file;
	MSG * area;
	ulong oldhigh;
	XMSG xmbuf[MAX_XMSG];
	ulong xmnum[MAX_XMSG];
	byte xmflg[MAX_XMSG];
  struct QQF f;
  struct QQF f2;
	} QQDAT;

#define LINK_LAST 0
#define LINK_FTS9 1
#define LINK_SUBJ 2
#define LINK_COM1 3
#define LINK_COM2 4

#define QQL2_SIG 'Q'

extern int trunc_qq;

QQDAT *open_qq(const char *path,MSG *area,int is_squish,int method);
int link_qq(QQDAT *qq,MSGH *msg,long uid,int clean);
void close_qq(QQDAT *qq);
int percent_qq(QQDAT *qq,long msgnum);
