
/**
***  This file is part of the source to QQLink, a FTS-9 reply linker for
*** use with the Squish(tm) mail processor.
*** Copyright (c) 1993 Josh Parsons. All rights reserved, however:
***
***         1) You are permitted to freely distribute this source,
***           provided you do not remove this copyright notice, and
***           provided you do not charge a fee, for the service of
***           distributing this material, over and above the value
***           of disks, phone tolls, etc. incurred in such distribution.
***        2) You are permitted to use executables produced from this
***           source in the manner described in QQLink.DOC, which should
***           accompany this file.
***        3) You are permitted to use this source in your own programs,
***           provided that your derivative work carries an
***           acknowledgement that portions of its source are derived
***           from QQLink, by Josh Parsons.
***
***        NB: This source carries no warrantee, implicit or explicit
***            of fitness for any particular task.
**/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "config.h"

#define PARCMP(x,y) strnicmp(x,y,strlen(y))
#define PARGET(x,y) ((x)+strlen(y))

static int flgseen[CFG_maxargs];
char *flgget(int argc,char **argv,const char *flg) {
  int i;
  char *ret=NULL;
  if(flg[strlen(flg)-1]==':'||*flg=='-') {
    for(i=0;i<argc;i++) if(!PARCMP(argv[i],flg)) {
      flgseen[i]++;
      ret=PARGET(argv[i],flg);
      };
    }
  else
    for(i=0;i<argc;i++) if(!stricmp(argv[i],flg)) {
      flgseen[i]++;
      ret=argv[i];
      };
  return ret;
  };
void flgclr(void) {
  int i;
  for(i=0;i<CFG_maxargs;i++) flgseen[i]=0;
  };
int flgchk(int argc,char **argv) {
  int ret=0,i;
  for(i=0;i<argc;i++) if(flgseen[i]==0)
    ret|=CFG_error("Unrecognised flag \"%s\".",argv[i]);
  return ret;
  };

char *squishcfg_fname="Squish.CFG";
char *areasbbs_fname=NULL;
char *echolog_fname=NULL;
void add_area(char *tag,char *path,int is_sq,int is_net);

extern char link_passthru;

int do_squish_cfg(int argc,char **argv,int flgc,char **flgv) {
  if(argc<1) return 0; // should never happen, but anyway...
  flgclr();
  if(!stricmp(*argv,"EchoArea")) {
    if(argc<3)
      return CFG_error("Wrong number of arguments to %s.",*argv);
    if(!flgget(flgc,flgv,"-0")||link_passthru)
      add_area(argv[1],argv[2],flgget(flgc,flgv,"-$")!=NULL,0);
    }
  else if(!stricmp(*argv,"NetArea")) {
    if(argc<3) return CFG_error("Wrong number of arguments to %s.",*argv);
    if(!flgget(flgc,flgv,"-0")||link_passthru)
      add_area(argv[1],argv[2],flgget(flgc,flgv,"-$")!=NULL,1);
    }
  else if(!stricmp(*argv,"AreasBBS")) {
    if(argc!=2) return CFG_error("Wrong number of arguments to %s.",*argv);
    areasbbs_fname=strupr(strdup(argv[1]));
    };
  return 0;
  };

void add_area(char *tag,char *path,int is_sq,int is_net);

int parse_adotb(const char *fn) {
  static char buf[256];
  char *path,*tag;
  int lines=0;
  FILE *fin=fopen(fn,"r");
  if(fin==NULL) return -1;
  while(!feof(fin)) {
    char *s;
    int sq=0,cmnt=0;
    memset(buf,0,256);
    fgets(buf,255,fin);
    s=strchr(buf,'\n');
    if(s) *s=0;
    s=buf;
    while(s) {
      if(isspace(*s)) ;
      else if(*s=='#') ;
      else if(*s=='$') sq=1;
      else if(*s==';') cmnt=1;
      else break;
      s++;
      };
    if(cmnt) continue;

    path=s;
    while(s&&!isspace(*s)) s++;
    *(s++)=0;

    while(s&&isspace(*s)) s++;
    tag=s;
    while(s&&!isspace(*s)) s++;
    *(s++)=0;

    if(*tag&&*path) {
      // Avoid origin/sysop line
      if(lines++) add_area(tag,path,sq,0);
      };
    };
  fclose(fin);
  return 0;
  };

void q_config(void) {
  if(CFG_parse(squishcfg_fname,do_squish_cfg)==CFGERR_syntax) {
    printf("\n\nError(s) %s config file %s\n","parsing",squishcfg_fname);
    exit(10);
    };
  if(areasbbs_fname&&parse_adotb(areasbbs_fname)) {
    printf("\n\nError(s) %s config file %s\n","reading",areasbbs_fname);
    exit(10);
    };
  };

