/***************************************************************************/
/*                                                                         */
/* REXX TIC processor using MaxFile/PM's REXX extensions.                  */
/* Copyright (C) 1995 by Craig Morrison, All Rights Reserved.              */
/*                                                                         */
/* This REXX script only processes inbound TICs, it does not have downlink */
/* capabilities. What you have here is a good start, so go for it! :-)     */
/*                                                                         */
/* PLEASE, PLEASE look through this file and see how it works BEFORE you   */
/* blindly run it. As it is written you specify an area for all your "bad" */
/* TIC distributions to go into. You may not want this behaviour. This is  */
/* a REXX script so you can change this.                                   */
/*                                                                         */
/* The TIC `Replaces' verb isn't supported. That can be an exercise for    */
/* the student. :-)                                                        */
/*                                                                         */
/* The configuration file format is very simple. It consists of a file     */
/* with each line formatted like so:                                       */
/*                                                                         */
/*      <tick_area_tag> <your_area_tag> <from_node> <password>             */
/*                                                                         */
/* See the example MAXTIC.CFG included in the archive.                     */
/*                                                                         */
/***************************************************************************/
'@echo off'

Signal On Syntax Name ErrorHandler
Signal On Halt Name ErrorHandler

/* Define some constants we will use later */
BadFileArea = '0'
InboundPath = 'D:\Binkley\Inbound\'
ConfigFile = 'E:\BCOS2\MaxFile\MaxTic.Cfg'
LogFile = 'E:\BCOS2\MaxFile\MaxTic.Log'
Verbs = 'AREA CRC DESC FILE FROM PW'

Call LineOut LogFile, Date('N')' 'Time('N')' MaxTic - Begin'

/* Load up the RexxUtil Library */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Get a list of all the file areas we have */
Call MPM_QueryAreaList 'FileAreas'

/* Make sure the Bad File Area exists so we can toss to there */
BadAreaIdx = FindFileArea(BadFileArea)
if BadAreaIdx = 0 Then
    Signal NoBadArea

/* Check for the configuration file and bail out if it doesn't exist */
If Stream(ConfigFile, 'c', 'query exists')='' Then
    Signal NoConfig

/* Read in and parse configuration file into the Cfg stem */
i = 1
Cfg.0 = 0
Do Until Lines(ConfigFile)=0
    cfgLine = LineIn(ConfigFile)
    Parse Upper Var cfgLine Cfg.i.tictag,
                            Cfg.i.ourtag,
                            Cfg.i.from,
                            Cfg.i.pwd,
                            extra
    Cfg.0 = i
    i = i + 1
End
Call Stream ConfigFile, 'c', 'close'

/* Gather TIC file names into the ticFiles stem */
Call SysFileTree InboundPath'*.TIC', 'ticFiles', 'FO'

/* If no TIC files are present bail out */
If ticFiles.0 = 0 Then
    Signal NoFiles

/* Process each TIC file */
Do i = 1 To ticFiles.0
    Say 'Processing 'ticFiles.i'. . .'
    tArea = ''
    tCRC = ''
    tDesc = ''
    tFile = ''
    tFrom = ''
    tPWD = ''
    Do Until Lines(ticFiles.i)=0
        tLine = LineIn(ticFiles.i)
        Parse Var tLine tVerb tExtra
        verbNo = WordPos(Translate(tVerb), Verbs)
        Select
            When verbNo = 1 Then Do
                Parse Upper Var tExtra tArea junk
                End
            When verbNo = 2 Then Do
                Parse Upper Var tExtra tCRC junk
                tCRC = Right(tCRC, 8, '0')      /* mod by cam, 01-24-95 */
                End
            When verbNo = 3 Then Do
                Parse Var tExtra tDesc
                End
            When verbNo = 4 Then Do
                Parse Var tExtra tFile junk
                End
            When verbNo = 5 Then Do
                Parse Var tExtra tFrom junk
                End
            When verbNo = 6 Then Do
                Parse Upper Var tExtra tPWD junk
                End
            Otherwise
                Nop
        End
    End
    Call Stream ticFiles.i, 'c', 'close'

    If Stream(InboundPath||tFile, 'c', 'query exists')='' Then Do
        Call LineOut LogFile,,
            Date('N')' 'Time('N')' 'tFile' does not exist'
        badTIC = MakeBadTicName(ticFiles.i)
        Call LineOut LogFile,,
            Date('N')' 'Time('N')' Check inbound for 'badTIC
        dosCmd = 'REN 'ticFiles.i' 'badTIC' >nul'
        dosCmd
        Iterate
    End

    /* Find the index of the TIC area tag in our configuration stem */
    cfgIdx = 0
    Do j = 1 To Cfg.0
        If Cfg.j.tictag = tArea Then Do
            cfgIdx = j
            Leave
        End
    End

    if cfgIdx = 0 Then Do
        Call MPM_SetFDUFlag FileAreas.BadAreaIdx.area
        Call TossFile InboundPath||tFile,,
                      FileAreas.BadAreaIdx.path||tFile,,
                      FileAreas.BadAreaIdx.fbbs,,
                      tFile' Bad TIC - 'tDesc
        Call LineOut LogFile,,
            Date('N')' 'Time('N')' Unknown TIC area 'tArea
        badTIC = MakeBadTicName(ticFiles.i)
        Call LineOut LogFile,,
            Date('N')' 'Time('N')' Check inbound for 'badTIC
        dosCmd = 'REN 'ticFiles.i' 'badTIC' >nul'
        dosCmd
        Iterate
    End

    /* NOTE: this is a BOGUS loop, I did this because it is easier */
    /* to use Leave instead of an obfuscated set of If-Then-Else's */
    /* Purists will argue this isn't structured REXX, that's their */
    /* problem. It works fine the way it is.                       */

    Do Forever
        AreaIdx = FindFileArea(Cfg.cfgIdx.ourtag)
        if AreaIdx = 0 Then Do
            Call MPM_SetFDUFlag FileAreas.BadAreaIdx.area
            Call TossFile InboundPath||tFile,,
                          FileAreas.BadAreaIdx.path||tFile,,
                          FileAreas.BadAreaIdx.fbbs,,
                          tFile' Bad TIC - 'tDesc
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Area tag 'Cfg.cfgIdx.ourtag' bogus'
            badTIC = MakeBadTicName(ticFiles.i)
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Check inbound for 'badTIC
            dosCmd = 'REN 'ticFiles.i' 'badTIC' >nul'
            dosCmd
            Leave
        End

        If tFrom<>Cfg.cfgIdx.from Then Do
            Call MPM_SetFDUFlag FileAreas.BadAreaIdx.area
            Call TossFile InboundPath||tFile,,
                          FileAreas.BadAreaIdx.path||tFile,,
                          FileAreas.BadAreaIdx.fbbs,,
                          tFile' Bad TIC - 'tDesc
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' TIC from unknown origin 'tFile
            badTIC = MakeBadTicName(ticFiles.i)
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Check inbound for 'badTIC
            dosCmd = 'REN 'ticFiles.i' 'badTIC' >nul'
            dosCmd
            Leave
        End

        If tPWD<>Cfg.cfgIdx.pwd Then Do
            Call MPM_SetFDUFlag FileAreas.BadAreaIdx.area
            Call TossFile InboundPath||tFile,,
                          FileAreas.BadAreaIdx.path||tFile,,
                          FileAreas.BadAreaIdx.fbbs,,
                          tFile' Bad TIC - 'tDesc
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Bad TIC Password for 'tFile
            badTIC = MakeBadTicName(ticFiles.i)
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Check inbound for 'badTIC
            dosCmd = 'REN 'ticFiles.i' 'badTIC' >nul'
            dosCmd
            Leave
        End

        ticCRC = MPM_Crc32(InboundPath||tFile)
        if (tCRC <> '' & ticCRC <> tCRC) Then Do
            Call MPM_SetFDUFlag FileAreas.BadAreaIdx.area
            Call TossFile InboundPath||tFile,,
                          FileAreas.BadAreaIdx.path||tFile,,
                          FileAreas.BadAreaIdx.fbbs,,
                          tFile' Bad TIC - 'tDesc
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Bad TIC CRC for 'tFile
            badTIC = MakeBadTicName(ticFiles.i)
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Check inbound for 'badTIC
            dosCmd = 'REN 'ticFiles.i' 'badTIC' >nul'
            dosCmd
            Leave
        End

        /* If we get here, the file is okay and should be sent to */
        /* its proper file area.                                  */
        Call TossFile InboundPath||tFile,,
                      FileAreas.AreaIdx.path||tFile,,
                      FileAreas.AreaIdx.fbbs,,
                      tFile' 'tDesc

        if Stream(FileAreas.AreaIdx.path||tFile, 'c', 'query exists')<>'' then
            Call MPM_SetFDUFlag FileAreas.AreaIdx.area

        dosCmd = 'DEL 'ticFiles.i' >nul'
        dosCmd
        If rc<>0 Then
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Error deleting 'ticFiles.i
        Leave
    End
End

/* Get outta Dodge */
ByeBye:
Call LineOut LogFile, Date('N')' 'Time('N')' MaxTic - END'
Call Stream LogFile, 'c', 'close'
Exit

/* Move file from the inbound to its destination and update the FILES.BBS */
TossFile:

    Parse Arg fromFile, toFile, filesBBS, ticDescription

    tossError = 0
    dosCmd = 'COPY 'fromFile' 'toFile' >nul'
    dosCmd
    If rc<>0 Then Do
        Call LineOut LogFile,,
            Date('N')' 'Time('N')' Error copying 'fromFile' to 'toFile
        tossError = 1
    End
    Else Do
        Call LineOut LogFile,,
            Date('N')' 'Time('N')' 'fromFile' copied to 'toFile
        Call LineOut filesBBS, ticDescription
        Call Stream filesBBS, 'c', 'close'
        Call LineOut LogFile, Date('N')' 'Time('N')' 'filesBBS' updated'
        dosCmd = 'DEL 'fromFile' >nul'
        dosCmd
        If rc<>0 Then Do
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' Error deleting 'fromFile
            tossError = 2
        End
        If tossError = 0 Then
            Call LineOut LogFile,,
                Date('N')' 'Time('N')' 'fromFile' deleted after copy'
    End

Return tossError

/* Search through FileAreas looking for a file area tag (name) */
FindFileArea:

    Parse Arg atag

    itag = 0
    Do ii = 1 to FileAreas.0
        If FileAreas.ii.area = atag Then Do
            itag = ii
            Leave
        End
    End

Return itag

/* Take *.TIC, make it *.BAD and return the base filename */
MakeBadTicName:

    Parse Arg inTIC

    ppos = LastPos('.', inTIC)
    If ppos = 0 Then
        ppos = Length(inTIC)
    Else
        ppos = ppos - 1

    /* mod by cam, 01-24-95 */
    BadTicName = Translate(FileSpec("name", Left(inTIC, ppos)'.BAD'))

Return BadTicName

/* No files to process */
NoFiles:
    Call LineOut LogFile, Date('N')' 'Time('N')' No TIC files to process'
    Signal ByeBye

/* Bitch about not having a configuration file */
NoConfig:
    Call LineOut LogFile, Date('N')' 'Time('N')' No configuration file'
    Signal ByeBye

/* Bitch about not having a valid BadFileArea */
NoBadArea:
    Call LineOut LogFile, Date('N')' 'Time('N')' Area 'BadFileArea' invalid'
    Signal ByeBye

ErrorHandler:
    RexxError = rc
    Call MPM_MsgBox('REXX Error ('RexxError')', 'MaxTic - Error Handler')
    Call LineOut LogFile, Date('N')' 'Time('N')' REXX Error ('RexxError')'
    Signal ByeBye
