/* Test MPM_AnnounceFiles(..)                                              */
/*                                                                         */
/* This example shows how to define ALL the fields for a file announcement */
/* Please note that by using MPM_QueryFileList(..) you can generate the    */
/* the stem needed to create a file announcement. All you have to do after */
/* calling that function is filter out the files you don't want, then fill */
/* in the message information before calling MPM_AnnounceFiles(..).        */

files.0 = 1
files.1.path = 'D:\bcos2\maxfile\'
files.1.file = 'mpm1_20.zip'
files.1.desc = 'MaxFile/PM 1.20, A FILES.BBS Manager for Presentation Manager'

/* Path to the message area, REQUIRED                                      */
files.msgpath  = 'D:\Max\Msg\Public'

/* Mail tosser/packer information, optional                                */
files.msgproc  = 'd:\squish\sq386p -cd:\squish\squish.cfg squash link -fWORKCHAT'

/* Message area type: SQUISH, MSG or MSGECHO. REQUIRED                     */
files.msgtype  = 'SQUISH'

/* Message flag: HOLD, NORMAL or CRASH. REQUIRED                           */
files.msgflag  = 'NORMAL'

/* Who to address the message to, defaults to 'All' if not defined         */
files.to       = 'Elliott Goodman'

/* The fidonet address for who the message is addressed to                 */
/* All four elements are REQUIRED, defaults to *.fromaddr if not defined   */
files.toaddr   = '1:102/1319.0'

/* Who the message is from, REQUIRED                                       */
files.from     = 'Craig Morrison'

/* Fidonet address of who the message is from, REQUIRED                    */
files.fromaddr = '1:201/60.0'

/* Optional header text for the message                                    */
files.header   = 'Check this out:'

/* Optional footer text for the message                                    */
files.footer   = "Slick ain't it?"

/* Optional subject line, defaults to 'File Announcement' if not defined   */
files.subject  = 'REXX MPM_AnnounceFiles(..) Test'

/* Optional origin information, if not defined, no origin line is created  */
files.origin   = 'Workplace Connection * (317) 742-2680'

/* The call itself, returns 'ERROR' if something goes wrong                */
retval = MPM_AnnounceFiles('files')

rc = MPM_MsgBox(retval, 'MPM_AnnounceFiles Result')
