/* REXX * Read a named pipe as provided by Binkley or Maximus */

/*
            Dennis Peterson *
         OS/2 Northwest BBS *
  dpeterso@os2nw.ces.wa.com *
                1:343/179.0 *
               Bellevue, WA *
             (206) 562-7212 *
              June 28, 1994 *
    With much borrowed code *
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Signal on HALT name cleanup

/* 
   Usage: rxsnoop pipename mode

   eg: rxsnoop \pipe\binkley binkley

   modes are binkley and maximus

   default pipename: \pipe\binkley
   default mode: binkley
*/

parse arg pipe_name pipe_type
if pipe_name = "" then
   pipe_name = '\pipe\binkley'

if pipe_type = ""
   then pipe_type = "binkley"

parse value stream(pipe_name, 'C', 'OPEN READ') with PipeState ':' OS2RC
if OS2RC = 231 then call SysWaitNamedPipe pipe_name, -1

call SysCls

do forever
   pipe_state = SysWaitNamedPipe(pipe_name, 2)
   select

      when pipe_state = 0 then do
         parse value stream(pipe_name, 'C', 'OPEN READ') with PipeState ':' OS2RC
         if OS2RC = 231 then call SysWaitNamedPipe pipe_name, -1
      end

      when pipe_state = 3 then do
         say "waiting for a pipe connection"
         do while pipe_state = 3
            pipe_state = SysWaitNamedPipe(pipe_name, 2)
            call syssleep 1
         end
         say
      end

      when pipe_state = 121 then do
         if pipe_type = "binkley" then
            current_line = charin(pipe_name,, 80)
         else
            current_line = linein(pipe_name)
         if current_line <> "" then say current_line
      end

      otherwise do
         call syssleep 1
      end
   end
end

cleanup:
exit
