/* OS/2 REXX */
/* Copyright (C)1996 by Holger.Veit@gmd.de */
/* This utility checks whether you have set up your XFree86/OS2 correctly
 */
'@echo off'
ADDRESS CMD
CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

/* This is an ugly hack. Does anyone know how to get the boot drive from Rexx? */
PARSE ARG bootdrv
IF bootdrv ='' THEN DO
	SAY "Call this script with the letter of the boot drive, e.g."
	SAY "   CHECKINSTALL C:"
	EXIT 1
END
IF POS(':',bootdrv)=0 THEN bootdrv=bootdrv':'

env = 'OS2ENVIRONMENT'
errcnt = 0
runxconfig = 0

x11root = VALUE('X11ROOT',,env)
CALL envexchk '001','X11ROOT','c:'
CALL direxchk '002','X11ROOT'
CALL direxchk1 '003',x11root'/XFree86/bin','X11ROOT'
CALL direxchk1 '004',x11root'/XFree86/lib','X11ROOT'
CALL direxchk1 '005',x11root'/XFree86/lib/X11','X11ROOT'
CALL fwdslchk '006','X11ROOT'
CALL hpfschk '007','X11ROOT'

CALL envexchk '010','HOME','c:\home\x11user'
CALL direxchk '011','HOME'
CALL backslchk '012','HOME'
CALL hpfschk '013','HOME'

etc = VALUE('ETC',,env)
CALL envexchk '020','ETC','c:\tcpip\etc'
CALL direxchk '021','ETC'
CALL backslchk '022','ETC'
CALL filexchk '023',etc'\hosts','ETC'

tmp = VALUE('TMP',,env)
CALL envexchk '030','TMP','f:\tcpip\tmp'
CALL direxchk '031','TMP'
CALL backslchk '032','TMP'
CALL trailchk '033','TMP'
CALL hpfschk '034','TMP'

hostname = VALUE('HOSTNAME',,env)
CALL envexchk '040','HOSTNAME','myhost'
CALL envexchk '041','USER','user123'
CALL envexchk '042','LOGNAME','user123'
user = VALUE('USER',,env)
logname = VALUE('LOGNAME',,env)
CALL userchk1 '043',user,logname

termcap = VALUE('TERMCAP',,env)
CALL envexchk '050','TERMCAP','d:/emx/etc/termcap.x11'
CALL filexchk '051',termcap,'TERMCAP'
CALL fwdslchk '052','TERMCAP'
term = VALUE('TERM',,env)
CALL envexchk '053','TERM','ansi'
CALL termcapchk1 termcap,term	/* 054,055 */

xserver = VALUE('XSERVER',,env)
CALL envexchk '060','XSERVER','D:/XFree86/bin/XF86_SVGA.EXE'
CALL filexchk '061',xserver,'XSERVER'
CALL fwdslchk '062','XSERVER'

CALL envexchk '070','DISPLAY','myhost:0.0'
CALL dispchk	/* 071,072,073 */

CALL hostchk /* 080,081 */
CALL pathchk '082','xf86config.exe',x11root'\XFree86\bin'
CALL libpathchk '083','xaw.dll',x11root'\XFree86\lib'
CALL localchk /* 084,085 */

CALL manpathchk /* 090,091 */
CALL xconfigchk /* 092 */
CALL emxchk /* 093,094,095,096 */
CALL xf86supchk /* 097,098,099 */

SAY ""
SAY ""
IF errcnt=0 THEN DO
	CALL BEEP 440,250
	SAY "***CHECK: Your system seems to be setup correctly for XFree86/OS2"
	CALL xconfig
END 
ELSE DO
	CALL BEEP 440,250
	SAY "***CHECK: There were "errcnt" error(s) detected. Please correct them"
	SAY "   before attempting to run XFree86/OS2."
	IF runxconfig=1 THEN DO
		SAY ""
		SAY "***CHECK: xf86config won't be run, because errors were found."
	END
END

EXIT 0

/* helper functions */

notexists_file: PROCEDURE
	ARG file
	IF file='' THEN RETURN 0
	RETURN STREAM(file,'C','QUERY EXISTS') = ''

notexists_dir: PROCEDURE
	ARG dir
	direc = TRANSLATE(dir,'\','/')
	'DIR "'direc'" >NUL 2>&1'
	IF RC = 0 THEN RETURN 0
	RETURN 1

notbackslash: PROCEDURE
	ARG path
	IF POS('/',path) = 0 THEN RETURN 0
	RETURN 1

notfwdslash: PROCEDURE
	ARG path
	IF POS('\',path) = 0 THEN RETURN 0
	RETURN 1

backslchk: PROCEDURE EXPOSE env errcnt
	ARG err,var
	envvar = VALUE(var,,env)
	IF envvar='' THEN RETURN
	IF notbackslash(envvar) THEN DO
		SAY "***XFERR"err": The "envvar" directory (derived from variable "var")"
		SAY "   must have backslashes as a directory separator."
		SAY "   Please correct this."
		errcnt = errcnt+1
	END
	RETURN

fwdslchk: PROCEDURE EXPOSE env errcnt
	ARG err,var
	envvar = VALUE(var,,env)
	IF envvar='' THEN RETURN
	IF notfwdslash(envvar) THEN DO
		SAY "***XFERR"err": The "envvar" directory (derived from variable "var")"
		SAY "   must have forward slashes as a directory separator."
		SAY "   Please correct this."
		errcnt = errcnt+1
	END
	RETURN

direxchk: PROCEDURE EXPOSE env errcnt
	ARG err,var
	envvar = VALUE(var,,env)
	if notexists_dir(envvar) THEN DO
		SAY "***XFERR"err": The directory specified in the variable "var" does not exist"
		SAY "   Please create it or specify another directory in the variable"
		errcnt = errcnt+1
	END
	RETURN

direxchk1: PROCEDURE EXPOSE env errcnt
	ARG err,dir,var
	if notexists_dir(dir) THEN DO
		SAY "***XFERR"err": The directory "dir" (derived from variable "var")"
		SAY "   does not exist."
		SAY "   Your XFree86 installation seems to be incomplete."
		errcnt = errcnt+1
	END
	RETURN

envexchk: PROCEDURE EXPOSE env errcnt
	ARG err,var,val
	envvar = VALUE(var,,env)
	IF envvar='' THEN DO
		SAY "***XFERR"err": The environment variable "var" is not set."
		SAY "   Please set it in CONFIG.SYS, for example:"
		SAY "       SET "var"="val
		errcnt = errcnt+1
	END
	RETURN

filexchk: PROCEDURE EXPOSE env errcnt
	ARG err,file,var
	if notexists_file(file) THEN DO
		SAY "***XFERR"err": The file "file" (derived from variable "var")"
		SAY "   does not exist. Please create one."
		errcnt = errcnt+1
	END
	RETURN

filexchk1: PROCEDURE EXPOSE env errcnt
	ARG err,file
	file1 = WORD(TRANSLATE(file,' ','/'),1)
	if notexists_file(file1) THEN DO
		SAY "***XFERR"err": The file "file1" (derived from DEVICE section)"
		SAY "   does not exist. You must install it."
		errcnt = errcnt+1
	END
	RETURN

nothpfs: PROCEDURE
	ARG dir
	testfile = TRANSLATE(dir,'\','/')
	IF LENGTH(testfile) \= LASTPOS('\',testfile) THEN testfile=testfile||'\'
	testfile = testfile||'very.long.file.name'
	CALL LINEOUT testfile,'test',1
	CALL LINEOUT testfile
	rc = SysFileDelete(testfile)
	IF rc = 0 THEN RETURN 0
	RETURN 1

hpfschk: PROCEDURE EXPOSE env errcnt
	ARG err,var
	envvar = VALUE(var,,env)
	if nothpfs(envvar) THEN DO
		SAY "***XFERR"err": The directory "envvar" (derived from variable "var")"
		SAY "   must reside on a file system which understands long file names"
		SAY "   (e.g. HPFS, NFS, Linux-ext2) because some software relies on this."
		SAY "   Please move this directory."
		errcnt = errcnt+1
	END
	RETURN

userchk1: PROCEDURE EXPOSE errcnt
	ARG err,usr,log
	IF usr \= log THEN DO
		SAY "***XFERR"err": The variables USER and LOGNAME must be present and"
		SAY "   match. It will cause problems if they are different or missing."
		SAY "   Please correct this."
		errcnt = errcnt+1
	END
	RETURN

searchstring: PROCEDURE
	ARG file,str
	rc = SysFileSearch(str,file,'res.')
	IF (rc \= 0) | (res.0>0) THEN RETURN 1
	RETURN 0

termcapchk1: PROCEDURE EXPOSE errcnt x11root
	ARG file,str
	found = searchstring(file,'xterm')
	if found=0 THEN DO
		SAY "***XFERR054: The termcap file specified in TERMCAP does not"
		SAY "   contain an entry for 'xterm'. It is possibly outdated. Please"
		SAY "   use the file "x11root"/XFree86/lib/X11/etc/emx.termcap.x11 instead."
		errcnt = errcnt+1
	END
	if str \= '' THEN DO
		found = searchstring(file,str)
		if found=0 THEN DO
			SAY "***XFERR055: The termcap file specified in TERMCAP does not"
			SAY "   contain an entry for the value "str" specified in the TERM variable."
			SAY "   Please set TERM to a correct value."
			errcnt = errcnt+1
		END
	END
	RETURN

dispchk: PROCEDURE EXPOSE env errcnt hostname
	display = VALUE('DISPLAY',,env)
	IF hostname \= '' & (POS(hostname,display)=0) THEN DO
		SAY "***XFWARN071: The DISPLAY variable contains a different value"
		SAY "   than the HOSTNAME variable. This is okay provided you want"
		SAY "   OS/2 X clients to be displayed elsewhere. Otherwise, please"
		SAY "   correct this."
	END
	IF POS(':',display) = 0 THEN DO
		SAY "***XFERR072: The DISPLAY variable does not contain a colon ':' which"
		SAY "   is not correct. Please correct this. A valid DISPLAY variable looks like:"
		SAY "       SET DISPLAY=myhost:0.0"
		errcnt = errcnt+1
	END
	IF POS(':7',display) > 0 THEN DO
		SAY "***XFERR073: The DISPLAY variable uses the standard connection"
		SAY "   LBX (low bandwidth X). This is not supported by the current X servers."
		SAY "   Use another connection type."
		errcnt = errcnt+1
	END
	RETURN

hostchk: PROCEDURE EXPOSE env errcnt hostname etc
	use_hosts_first = VALUE('USE_HOSTS_FIRST',,env)
	IF use_hosts_first = '' THEN DO
		SAY "***XFWARN080: You have not set the USE_HOSTS_FIRST variable."
		SAY "   Unless you are permanently connected to an ethernet network"
		SAY "   and have direct access to a DNS nameserver, it is recommended"
		SAY "   to have the line SET USE_HOSTS_FIRST=1 in your CONFIG.SYS file."
	END

	IF hostname = '' THEN RETURN
	found = searchstring(hostname,etc'\hosts')
	IF found = 0 THEN DO
		SAY "***XFERR081: There is no entry for the HOSTNAME in the HOSTS file."
		SAY "   (in"etc"\hosts). Please add a line like the following to this file:"
		SAY "	    192.10.10.1 "hostname
	END
	RETURN

pathchk: PROCEDURE EXPOSE errcnt
	ARG err,file,dir
	found = SysSearchPath('PATH',file)
	IF found = '' THEN DO
		SAY "***XFERR"err": You must set the directory "dir" in"
		SAY "   your PATH entry in CONFIG.SYS. Please correct this."
		errcnt = errcnt+1
	END
	RETURN

libpathchk: PROCEDURE EXPOSE errcnt bootdrv
	ARG err,file,dir
	CALL SysFileSearch 'LIBPATH',bootdrv'\config.sys','res.'
	IF res.0 \= 1 THEN RETURN
	libpath = TRANSLATE(res.1,'  ','=;')
	found = 0
	DO i=1 TO WORDS(libpath)
		IF \(notexists_file(WORD(libpath,i)'\'file)) THEN DO
			found = 1
			LEAVE
		END
	END
	if found = 0 THEN DO
		SAY "***XFERR"err": You must set the directory "dir" in"
		SAY "   your LIBPATH entry in CONFIG.SYS. Please correct this."
		errcnt = errcnt+1
	END
	RETURN


localchk: PROCEDURE EXPOSE errcnt hostname bootdrv etc
	IF hostname \= 'localhost' THEN RETURN
	config = bootdrv'\config.sys'
	CALL SysFileSearch 'ifconfig',config,'res.'
	found = 0
	IF DATATYPE(res.0,N) = 1 THEN DO
		DO i = 0 TO res.0
			IF (POS('lo',res.i)>0) & (POS('127.0.0.1',res.i)>0) THEN DO
				found = 1
				LEAVE
			END
		END
	END
	IF (found = 0) | (res.0 = 0) THEN DO
		SAY "***XFERR084: If your hostname is 'localhost', you must setup"
		SAY "   the LOOPBACK network connection. This is done by adding the"
		SAY "   following line to CONFIG.SYS:"
		SAY "       RUN=<tcpippath>\ifconfig lo 127.0.0.1 up"
		errcnt = errcnt+1
	END
	CALL SysFileSearch 'localhost',etc'\hosts','res1.'
	IF (res1.0 \= 1) | (POS('127.0.0.1',res1.1)=0) THEN DO
		SAY "***XFERR085: If your hostname is 'localhost', it must have the"
		SAY "   standard internet number 127.0.0.1 in "etc"\hosts. Please"
		SAY "   correct this."
		errcnt = errcnt+1
	END
	RETURN

testpath: PROCEDURE EXPOSE env errcnt
	ARG err,var,prog
	path = TRANSLATE(VALUE(var,,env),' ',';')
	DO i=1 TO WORDS(path)
		IF notexists_dir(WORD(path,i)) THEN DO
			SAY "***XFERR"err": In your "var" variable, the component "WORD(path,i)
			SAY "   does not point to a valid directory. Please correct"
			SAY "   the "var" variable, or '"prog"' might get confused."
			errcnt = errcnt+1
		END
	END
	RETURN

manpathchk: PROCEDURE EXPOSE env errcnt x11root
	manpath = VALUE('MANPATH',,env)
	IF manpath='' THEN DO
		SAY "***XFWARN090: You don't have a MANPATH statement set. This is"
		SAY "   no problem, but will disable the start of 'xman' in xinitrc.cmd"
		SAY "   If you installed the man pages, you might want to add a MANPATH"
		SAY "   to CONFIG.SYS like:"
		SAY "       SET MANPATH="x11root"/XFree86/man"
	END
	ELSE DO
		CALL testpath '091','MANPATH','xman'
	END
	RETURN

xconfigchk: PROCEDURE EXPOSE runxconfig x11root
	IF notexists_file(x11root'/XFree86/lib/X11/XConfig') THEN DO
		SAY ""
		SAY "***XFWARN092: You don't have an XConfig file yet. Do you want to"
		SAY "   run the xf86config utility after this script (Y/N)?"
		PULL yesno
		IF (yesno='Y') | (yesno='YES') THEN runxconfig=1
	END
	RETURN

revision: PROCEDURE
	ARG pathname
	CALL RxFuncAdd emx_revision, pathname, emx_revision
	SIGNAL ON SYNTAX NAME ERROR
	rev = emx_revision()
	SIGNAL OFF SYNTAX
	CALL RxFuncDrop emx_revision
	RETURN rev

emxchk: PROCEDURE EXPOSE env errcnt x11root
	IF \(notexists_file(x11root'/XFree86/bin/imake.exe')) THEN DO
		incpath = VALUE('C_INCLUDE_PATH',,env)
		lbrpath = VALUE('LIBRARY_PATH',,env)
		IF (lbrpath='') | (incpath='') THEN DO
			SAY "***XFERR093: You have installed the programmer's kit, but have"
			SAY "   not set up the EMX development system completely."
			SAY "   Besides other EMX variables, the X11 programmer's kit needs"
			SAY "   a correct setup of the variables C_INCLUDE_PATH and LIBRARY_PATH."
			SAY "   Please fix this, or imake won't work correctly."
			errcnt = errcnt+1
		END
		ELSE DO
			CALL testpath '094','C_INCLUDE_PATH','imake'
			CALL testpath '095','LIBRARY_PATH','imake'
		END
	END
	found = SysSearchPath('PATH','EMXREV.CMD')
	IF found \= '' THEN DO
		IF revision('EMX') < 42 THEN DO
			SAY "***XFERR096: There is an EMX.DLL in your LIBPATH, which is"
			SAY "   older than the required EMX09B FIX 4 patch level."
			SAY "   Please remove it and ensure you have the latest"
			SAY "   version, or XFree86/OS2 won't run."
			errcnt = errcnt+1
		END
		
	END
	RETURN

xconfig: PROCEDURE EXPOSE runxconfig
	IF runxconfig=1 THEN DO
		SAY "***CHECK: Now calling xf86config..."
		CALL SysCls
		'xf86config'
		CALL SysCls
		CALL BEEP 440,250
		SAY ""
		SAY "***CHECK checkinstall finished!"
	END
	RETURN

xf86supchk: PROCEDURE EXPOSE errcnt bootdrv x11root
	CALL SysFileSearch 'XF86SUP.SYS',bootdrv'\config.sys','res.'
	IF res.0 < 1 THEN DO
		SAY "***XFERR097: You must have the XF86SUP.SYS device driver"
		SAY "   installed in your CONFIG.SYS file, i.e. a line like:"
		SAY "      DEVICE="x11root"\XFree86\lib\xf86sup.sys"
		errcnt = errcnt+1
	END
	PARSE VAR res.1 WITH "DEVICE=" drv
	CALL filexchk1 '098',drv
	CALL SysFileSearch 'FASTIO.SYS',bootdrv'\config.sys','res.'
	IF res.0=1 THEN DO
		SAY "***XFERR099: You have the FASTIO.SYS device driver installed in your"
		SAY "   CONFIG.SYS file. This driver is superseeded by the driver"
		SAY "   XF86SUP.SYS. Please remove the obsolete FASTIO.SYS driver."
		SAY "   XFree86/OS2 won't work with it installed."
		errcnt = errcnt+1
	END
	RETURN

trailchk: PROCEDURE EXPOSE errcnt env
	ARG err,var
	envvar = TRANSLATE(VALUE(var,,env),'\','/')
	IF LASTPOS('\',envvar) = LENGTH(envvar) THEN DO
		SAY "***XFERR"err": The TMP directory is declared with a trailing backslash."
		SAY "   There is a problem in XFree86 which prevents proper work"
		SAY "   with it. Please remove the trailing backslash."
		errcnt = errcnt+1
	END
	RETURN
