/* Installation of tools (zip, arj, etc.)                               */
/* Place in this directory any exe, cmd, bat, dll, hlp or inf files     */
/* you may want to install. The exe, cmd and bat files will be copied   */
/* to the directory \os2, the dll's to \os2\dll, the hlp files to       */
/* \os2\help and the inf files to \os2\books during add-on installation */
/* Created: 11.15.2002                                                  */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* exit if package does not exist */
call sysfiletree inst_dir'\*', 'tmp.', 'FO'
if tmp.0 < 2 then exit 9

/* copy files */
call install_files 'exe os2'
call install_files 'cmd os2'
call install_files 'bat os2'
call install_files 'dll os2\dll'
call install_files 'hlp os2\help'
call install_files 'inf os2\book'

exit

/* uninstall mode */
uninstall:

	/* delete files */
	call install_files 'exe os2 d'
	call install_files 'cmd os2 d'
	call install_files 'bat os2 d'
	call install_files 'dll os2\dll d'
	call install_files 'hlp os2\help d'
	call install_files 'inf os2\book d'

return

/* install/uninstall files */
install_files: 

	parse arg ext tdir mode
	call sysfiletree inst_dir'\*.'ext, 'tmp.', 'FO'
	do i=1 to tmp.0
		if translate(filespec('name', tmp.i)) = 'ADDONINS.CMD' then iterate
		if mode = 'd' then 'del 'target'\'tdir'\'filespec('name', tmp.i)' >> 'product_log' 2>>&1'
		else 'copy 'tmp.i target'\'tdir'\.  >> 'product_log' 2>>&1'
	end

return
