/* Amouse.wpi installation file                                    */
/* Place the Amouse WPI package here under the name amouse.wpi     */
/* Optionally, you can also place the XCenter widgets here under   */
/* the name xamou.zip.                                             */
/* 17.01.2005: Created                                             */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* do nothing if package does not exist */
if stream(inst_dir'\amouse.wpi', 'c', 'query exists') = '' then exit 9

/* run warpin */
cdir = directory()
rc   = directory(get_ini_key(warpin path))
'WarpIN.Exe 'inst_dir'\amouse.wpi'
rc = directory(cdir)

/* install widgets */
xcp = get_ini_key(XWorkplace XFolderPath)
xcp = substr(xcp, 1, length(xcp)-1)'\plugins\xcenter'
'@unzip -o 'inst_dir'\xamou.zip *.dll -d 'xcp' >> 'product_log' 2>>&1'
'@unzip -o 'inst_dir'\xamou.zip *.hlp -d 'xcp' >> 'product_log' 2>>&1'

exit

uninstall:

	cdir = directory()
	rc   = directory(get_ini_key(warpin path))
	'WarpIN.Exe'
	rc = directory(cdir)

return

/* get apps key value from OS2.INI */
get_ini_key: procedure

	parse upper arg apps key

	call rxfuncadd sysini, rexxutil, sysini
	call SysIni 'USER', 'All:', 'Apps.'
	do i = 1 to Apps.0	
		if translate(apps.i) = apps then do
			call SysIni 'USER', Apps.i, 'All:', 'Keys'
 	   	do j=1 to Keys.0
 	   		if translate(Keys.j) = key then do
					val = SysIni('USER', Apps.i, Keys.j)
					return val
				end
    	end
  	end
	end

return ''

