/* XWP installation file                             */
/* Place the XWP package here under the name xwp.exe */
/* 05.25.2002: added support for uninstallation      */
/* 07.13.2002: aligned with xwp 0.9.19               */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* exit if package does not exist */
if stream(inst_dir'\xwp.exe', 'c', 'query exists') = '' then exit 9

/* set installation environment */
rc = value("WARPIN_DISPLAYPAGES"     , "NO"       , "OS2ENVIRONMENT")
rc = value("WARPIN_INSTALLACTION"    , "ADDREMOVE", "OS2ENVIRONMENT")
rc = value("WARPIN_SELECTPACKAGE1"   , "INSTALL"  , "OS2ENVIRONMENT")
rc = value("WARPIN_TARGETPATH1"      , product_drv"\"product_path, "OS2ENVIRONMENT")
rc = value("WARPIN_SELECTPACKAGE2"   , "INSTALL"  , "OS2ENVIRONMENT")
rc = value("WARPIN_TARGETPATH2"      , product_drv"\"product_path, "OS2ENVIRONMENT")
rc = value("WARPIN_UPDATECONFIGSYS"  , "NO"       , "OS2ENVIRONMENT")
rc = value("WARPIN_INSTALLWPSCLASSES", "YES"      , "OS2ENVIRONMENT")
rc = value("WARPIN_CREATEWPSOBJECTS" , "YES"      , "OS2ENVIRONMENT")
rc = value("WARPIN_IFSAMEDATE"       , "OVERWRITE", "OS2ENVIRONMENT")
rc = value("WARPIN_IFEXISTINGOLDER"  , "OVERWRITE", "OS2ENVIRONMENT")
rc = value("WARPIN_IFEXISTINGNEWER"  , "OVERWRITE", "OS2ENVIRONMENT")

/* run install */
cdir = directory()
rc   = directory(get_ini_key(warpin path))
'WarpIN.Exe 'inst_dir'\xwp.exe'
rc = directory(cdir)

exit


/* get apps key value from OS2.INI */
get_ini_key: procedure

	parse upper arg apps key

	call rxfuncadd sysini, rexxutil, sysini
	call SysIni 'USER', 'All:', 'Apps.'
	do i = 1 to Apps.0	
		if translate(apps.i) = apps then do
			call SysIni 'USER', Apps.i, 'All:', 'Keys'
 	   	do j=1 to Keys.0
 	   		if translate(Keys.j) = key then do
					val = SysIni('USER', Apps.i, Keys.j)
					return val
				end
    	end
  	end
	end

return ''

uninstall:

	/* run warpin to uninstall */
	cdir = directory()
	rc   = directory(get_ini_key(warpin path))
	'WarpIN.Exe'
	rc = directory(cdir)	

	/* del remaining files */
	call deldir product_drv'\'product_path

return

DelDir: procedure

	parse upper arg Directory
	DirSpec = Directory'\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
		'@del "'Files.i'"'
	end

	/* delete directory */
	'@rmdir "'Directory'"'

return

