/* Installation of Mozilla 1.x for OS/2                                 */
/* Created: 07.08.2002                                                  */
/*                                                                      */
/* Place the Mozilla distribution zip under the name mozilla.zip, or    */
/* place the Mozilla distribution exe under the name mozilla.exe here   */
/* If you use Mozilla 1.5 or higher, you also need to place libc04      */
/* here (http://download.innotek.de/gccos2/runtime/libc04.zip). You may */
/* also place the Innotek font engine under the name ft2lib.zip here.   */
/*                                                                      */
/* 07.13.2002: fixed problem with changing back to previous dir         */
/* 12.07.2002: added support for exe installation                       */
/* 08.17.2003: added object creation for zip version                    */
/* 08.19.2003: added \mozilla to icon creation path                     */
/* 08.22.2003: improved plugin installation and uninstallation          */
/* 10.21.2003: added support for Mozilla 1.5 (GCC version)              */
/* 11.02.2003: added support for Innotek font engine                    */
/* 11.23.2003: font engine installation did not work                    */
/* 12.03.2003: switched echo back on after fontlib install              */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")
product_version   = value("PRODUCT_VERSION"  , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

if stream(inst_dir'\mozilla.zip', 'c', 'query exists') = '' & stream(inst_dir'\mozilla.exe', 'c', 'query exists') = '' then exit 9

if stream(inst_dir'\mozilla.zip', 'c', 'query exists') <> '' then do

	/* unzip mozilla files */
	dest_dir = product_drv'\'product_path
	'unzip -o 'inst_dir'\mozilla.zip -d 'dest_dir' >> 'product_log' 2>>&1'

	/* unzip GCC dll's */
	if stream(inst_dir'\libc04.zip', 'c', 'query exists') <> '' then do
		'unzip -jCo 'inst_dir'\libc04.zip *.dll  -d 'target'\os2\dll\. >> 'product_log' 2>>&1'
	end

	/* install font engine */
	if stream(inst_dir'\ft2lib.zip', 'c', 'query exists') <> '' then do
		'mkdir 'target'\temp\ft2lib'
		'unzip -jCo 'inst_dir'\ft2lib.zip -d 'target'\temp\ft2lib\. >> 'product_log' 2>>&1'
		cdir = directory()
		call directory target'\temp\ft2lib'
		'call install.cmd 'dest_dir'\mozilla >> 'product_log' 2>>&1'
		call directory cdir
		call deldir target'\temp\ft2lib'
		'@echo on'
	end

	/* create objects */
	dir = dest_dir || '\mozilla'
	call SysCreateObject 'WPFolder', 'Mozilla','<WP_DESKTOP>','OBJECTID=<MOZILLAFLDR>;'||'ALWAYSSORT=YES;','Update'
	call SysCreateObject 'WPProgram','Mozilla','<MOZILLAFLDR>','EXENAME='||dir||'\MOZILLA.EXE;'||'STARTUPDIR='||dir||';'||'OBJECTID=<MOZILLAEXE>','Update'
	call SysCreateObject 'WPProgram','Mozilla^Profile Manager','<MOZILLAFLDR>','EXENAME='||dir||'\MOZILLA.EXE;'||'PARAMETERS=-ProfileManager;'||'STARTUPDIR='||dir||';'||'OBJECTID=<MOZILLAPROFMANAGER>','Update'
	call SysCreateObject 'WPProgram','Mozilla^Mail and News','<MOZILLAFLDR>','EXENAME='||dir||'\MOZILLA.EXE;'||'PARAMETERS=-mail;'||'STARTUPDIR='||dir||';'||'OBJECTID=<MOZILLAMAIL>','Update'
	call SysCreateObject 'WPProgram','Mozilla^Chat','<MOZILLAFLDR>','EXENAME='||dir||'\MOZILLA.EXE;'||'PARAMETERS=-chat;'||'STARTUPDIR='||dir||';'||'OBJECTID=<MOZILLACHAT>','Update'
	call SysCreateObject 'WPProgram','Mozilla^Composer','<MOZILLAFLDR>','EXENAME='||dir||'\MOZILLA.EXE;'||'PARAMETERS=-edit;'||'STARTUPDIR='||dir||';'||'OBJECTID=<MOZILLACOMPOSER>','Update'
	call SysCreateObject 'WPProgram','Mozilla^Address Book','<MOZILLAFLDR>','EXENAME='||dir||'\MOZILLA.EXE;'||'PARAMETERS=-addressbook;'||'STARTUPDIR='||dir||';'||'OBJECTID=<MOZILLAADDRESSBOOK>','Update'
	call SysCreateObject 'WPProgram','Mozilla^JavaScript^Console','<MOZILLAFLDR>','EXENAME='||dir||'\MOZILLA.EXE;'||'PARAMETERS=-jsconsole;'||'STARTUPDIR='||dir||';'||'OBJECTID=<MOZILLAJAVASCRIPTCONSOLE>','Update'
	call SysCreateShadow dir'\README.TXT','<MOZILLAFLDR>'
	call SysCreateShadow dir'\LICENSE',   '<MOZILLAFLDR>'

	/* store things in ini */
	call SysIni 'USER', 'Mozilla 'product_version' (en)', 'Install Directory',    dest_dir'\Mozilla'
	call SysIni 'USER', 'Mozilla 'product_version' (en)', 'Uninstall Log Folder', dest_dir'\Mozilla\Uninstall'
	call SysIni 'USER', 'Mozilla 'product_version' (en)', 'Plugins',              dest_dir'\Mozilla\Plugins'
	call SysIni 'USER', 'Mozilla 'product_version' (en)', 'Components',           dest_dir'\Mozilla\Components'
	call SysIni 'USER', 'Mozilla 'product_version' (en)', 'PathToExe',            dest_dir'\Mozilla\Mozilla.exe'

end
else do
	
	/* start installer */
	inst_dir'\mozilla.exe'	

end

/* install java plug-in */
dest_dir = find_key('USER Mozilla Install Directory')
plugins  = find_key('USER Mozilla Plugins')
call SysFileTree target'\mzplugin.exe', 'tmp.', 'FSO'
if tmp.0 > 0 then do
	'@echo Found Java 1.3 plug-in in directory: 'tmp.1' >> 'product_log
	mozdir = substr(tmp.1, 1, lastpos('\', tmp.1)-1)
	cdir = directory(mozdir)
	tmp.1' -o >> 'product_log' 2>>&1'
	'echo JAVA131MZFiles.Selection=1 > mzuser.rsp'
	'echo JAVA131MZFiles.MZDRV='dest_dir' >> mzuser.rsp'
	cmd_file = 'insmzplg.cmd'
	l = linein(cmd_file)
	call lineout cmd_file
	parse var l w1 w2 w3 w4 rest
	w4 = '/s:'mozdir
	w3 = '/b:'target
	'echo 'w1 w2 w3 w4 rest' > 'cmd_file
	'call 'cmd_file ' >> 'product_log' 2>>&1'
	'copy npoji6.dll 'plugins'\. >> 'product_log' 2>>&1'
	call directory cdir
end

exit 0

/* uninstall mode */
uninstall:

	/* destroy objects */
	call RxFuncAdd 'SysDestroyObject', 'RexxUtil', 'SysDestroyObject'
	call SysDestroyObject "<MOZILLAFLDR>"

	/* delete files */
	dest_dir = find_key('USER Mozilla Install Directory')
	call deldir dest_dir 
	'@rmdir 'dest_dir' >> 'product_log' 2>>&1'

	/* clean ini */
	call SysIni 'USER', 'Mozilla 'product_version' (en)', 'DELETE:'

return

/* find out value key belonging to app stored in ini */
find_key: procedure

	parse arg ini app key
	call rxfuncadd sysini, rexxutil, sysini
	call SysIni ini, 'All:', 'Apps.'
	if Result \= 'ERROR:' then
		do i = 1 to Apps.0
			If left(apps.i,7) = app then do 
				call SysIni ini, Apps.i, 'All:', 'Keys'
				if Result \= 'ERROR:' then
					do j=1 to Keys.0
						if Keys.j = key then do
							val = SysIni(ini, Apps.i, Keys.j)
							return val
						end
					end
			end
		end

return ''

/* del directory */
DelDir: procedure

	parse upper arg Directory
	DirSpec = Directory'\*'

	/* delete subdirectories */
	call RxFuncAdd SysFileTree, RexxUtil, SysFileTree
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
		'@call 'source'\updcd\bin\unlock.exe "'Files.i'" >nul 2>>&1'
		'@del "'Files.i'"'
	end

	/* delete directory */
	'@rmdir "'Directory'"'

return
