/* Install script for UDF file system. Place the following files in this */
/* directory: UDF.IFS, UUDF.DLL (should match your language)             */
/* If the build level of OS2CDROM.DMD included in the OS/2 or DD fixpak  */
/* you have incorporated is lower than 10.035 you also need to place an  */
/* updated OS2CDROM.DMD here. If you incorporated Device Driver Fixpak 2 */
/* this file is not needed (the fixpak file has version 10.040).         */
/* Last changed on 03.22.2001                                            */
/* 05.20.2002: added support for uninstallation                          */

/* get command line parameters */
parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* exit if package does not exist */
if stream(inst_dir'\UDF.IFS', 'c', 'query exists') = '' then exit 9

/* copy files but do not overwrite them if they are already there */
if stream(target'\OS2\BOOT\UDF.IFS', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\UDF.IFS 'target'\OS2\BOOT\. >> 'product_log
end
if stream(target'\os2\dll\UUDF.DLL', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\UUDF.DLL 'target'\os2\dll\. >> 'product_log
end

/* update os2cdrom.dmd only if we have a newer one */
if stream(inst_dir'\os2cdrom.dmd', 'c', 'query exists') <> '' then do
	if build(inst_dir'\os2cdrom.dmd') > build(target'\OS2\BOOT\os2cdrom.dmd') then do
		'copy 'inst_dir'\os2cdrom.dmd 'target'\os2\boot\. >> 'product_log
	end
end

/* scan config.sys */
cfgfile = target'\config.sys'
gevonden = 0
do while lines(cfgfile)
	l = linein(cfgfile)
	if pos('UDF.IFS', translate(l)) > 0 then do
		gevonden = 1
		leave
	end
end
rc = lineout(cfgfile)

/* update config.sys */
if gevonden = 0 then do
	'echo REM UpdCD >> 'cfgfile
	'echo IFS='target'\OS2\BOOT\UDF.IFS >> 'cfgfile
end

exit

/* returns build levl input file */
build: procedure 

	parse arg file
	tmp = 'buildlvl.$t$'
	'@bldlevel 'file' > 'tmp' 2>>&1'
	do while lines(tmp)
		l=linein(tmp)
		parse var l rev num
		if translate(rev) = 'REVISION:' then leave
	end
	rc=lineout(tmp)
	'@del 'tmp
	num = space(num)
	if datatype(num) <> 'NUM' then num = 0

return num

uninstall:

	/* update config.sys */
	found. = 0
	cfgfile = target'\config.sys'
	q = 1
	do while lines(cfgfile)
		l.q = linein(cfgfile)
		q=q+1
	end
	call lineout cfgfile
	l.0=q-1
	'copy 'cfgfile target'\os2\install\config.udf >> 'product_log 
	'del 'cfgfile' >> 'product_log 
	do q=1 to l.0
		if pos('\OS2\BOOT\UDF.IFS', translate(l.q)) > 0 then iterate
		call lineout cfgfile, l.q
	end
	call lineout cfgfile

	/* delete files */
	'del 'target'\os2\boot\UDF.IFS >> 'product_log
	'del 'target'\os2\dll\UUDF.DLL >> 'product_log

return
