/* Install Warp Update Kit on OS/2, last modified on 07.11.2003 */

'@mode 80,25 >nul'
'@ansi on >NUL'
say '1B'x || '[36;44m'
say '1B'x || '[1m'

call load_rexxutil
call load_language 'ENG NOSAVE'
call load_language 'DEFAULT'
call check_rexx
call start_up
call check_installed_components
call display_main_menu

exit

/* main menu */
display_main_menu:

	option_used = 0
	updcd_installed = 0
	key = ''
	do while (key <> 0)
	'@cls'
		say ''
		say '  *-------------------------------------------------------------------------*'
		say '  |'center(msg.0005,73)'|'
		say '  |=========================================================================|'
		say '  |                                                                         |'
		say '  |'center('> = 'msg.0007', * = 'msg.0008,73)'|'
		say '  |                                                                         |'
		say '  |   0 - 'left(msg.0009, 50)'                |'
		say '  |                                                                         |'
		say '  | 'flag1'1 - 'left(msg.0010, 50)'                |'
		say '  | 'flag2'2 - 'left(msg.0011, 50)'                |'
		say '  | 'flag3'3 - 'left(msg.0012, 50)'                |'
		say '  | 'flag4'4 - 'left(msg.0013, 50)'                |'
		say '  | 'flag5'5 - 'left(msg.0014, 50)'                |'
		say '  | 'flag6'6 - 'left(msg.0015, 50)'                |'
		say '  |                                                                         |'
		say '  | 'flag7'7 - 'left(msg.0016, 50)'                |'
		say '  |                                                                         |'
		say '  *-------------------------------------------------------------------------*'
		say

		key = ''
		do while ((key < 0) | (key > 7))
			key = SysGetKey('NOECHO')	
		end

		select
			when (key = 1) then call install_updcd
			when (key = 2) then call install_vfdisk
			when (key = 3) then call install_aspi
			when (key = 4) then call install_emx
			when (key = 5) then call install_dani
			when (key = 6) then call install_cdrecord
			when (key = 7) then call install_needed
			otherwise nop;
		end

	end

	/* inform */
	if updcd_installed = 1 | option_used = 1 then do
		say
		say ' 'msg.0031
		say ' 'log
	end
	if option_used = 1 then do
		say
		say ' 'substr(msg.0032, 1, 75)
		say ' 'substr(msg.0033, 1, 75)
		say ' 'substr(msg.0034, 1, 75)
	end
	if updcd_installed = 1 then do
		say
		say ' 'substr(msg.0035, 1, 75)
		say ' 'substr(msg.0036, 1, 75)
		say ' 'substr(msg.0037, 1, 75)
		say ' 'substr(msg.0038, 1, 75)
		say ' 'substr(msg.0039, 1, 75)
	end
	if updcd_installed = 1 | option_used = 1 then do
		say
		'@pause'
	end

return

/* check installed components */
check_installed_components:
	
	say 
	say ' 'substr(msg.0006, 1, 75)

	/* load config.sys */
	i=1
	found_svdisk=0
	found_vfdisk=0
	found_aspirt=0
	found_os2asp=0
	found_daniid=0
	found_danifl=0
	found_fat32f=0
	found_reserv=0
	do while lines(config)
		l.i=linein(config)
		if pos('SVDISK.SYS',    translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_svdisk=1
		if pos('VFDISK.SYS',    translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_vfdisk=1
		if pos('ASPIROUT.SYS',  translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_aspirt=1
		if pos('OS2ASPI.DMD',   translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_os2asp=1
		if pos('DANIS506.ADD',  translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_daniid=1
		if pos('DANIATAPI.FLT', translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_danifl=1
		if pos('DANIATAP.FLT',  translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_danifl=1
		if pos('FAT32.IFS',     translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_fat32f=1
		if pos('RESERVEDRIVELETTER=', translate(l.i)) > 0 then found_reserv=1
		i=i+1
	end
	call lineout config
	l.0=i-1

	/* check updcd */
	instdir = SysIni(, 'UPDCD', 'PATH')
	if stream(instdir'\updcd.cfg', 'c', 'query exists') = '' then flag1 = '> '
	version = SysIni(, 'UPDCD', 'VERS')
	if datatype(version) <> 'NUM' then flag1 = '> '

	/* check vdisk */
	if found_svdisk = 0 & found_vfdisk = 0 then flag2 = '> '

	/* check aspi */
	if found_aspirt = 0 then flag3 = '> '

	/* check emx */
	trace off
	'@call emxrev >nul 2>>&1'
	trace on
	if rc <> 0 then do
		flag4 = '> '
		found_emxrt = 0
	end
	else found_emxrt = 1

	/* check dani */
	if found_daniid = 0 | found_danifl = 0 then flag5 = '> '

	/* check RSJ */
	if find_rsjdir() <> '' then found_rsj = 1
	else found_rsj = 0

	/* check cdrecord */
	found_cdrec2 = 0
	if found_rsj = 0 then do
		cdrecdir = find_file('mkisofs.exe Q')
		if cdrecdir <> '' then
			if stream(cdrecdir'\cdrecord.exe', 'c', 'query exists') <> '' then found_cdrec2 = 1
			else do
				cdrecdir = find_file('cdrecord.exe Q')
				if cdrecdir <> '' & stream(cdrecdir'\mkisofs.exe', 'c', 'query exists') <> '' then found_cdrec2 = 1
			end 
	end
	if found_cdrec2 = 0 & found_rsj = 0 then flag6 = '> '

return

/*******************/
/* start things up */
/*******************/
start_up: 

	logfile = 'install.log'
	hdir    = strip(directory(), 'T', '\')
	flag1 	= '  '
	flag2 	= '  '
	flag3 	= '  '
	flag4 	= '  '
	flag5 	= '  '
	flag6 	= '  '
	flag7 	= '  '
	say
	say ' 'msg.0087
	say ' 'msg.0088
	say
	say ' 'msg.0091
	say
	say ' 'msg.0089
	'@pause >nul'

	/* empty rexx queue */
	say
	say ' Cleaning up, please wait...'
  do while queued() > 0
   l = linein('queue:')
  end

	/* get language */
	call sysfiletree hdir'\updcd\nls\message.*', 'tmp.', 'FO'
	if tmp.0 = 0 then do
		say ' Fatal error, no language files were found. Aborting...'
		exit 7
	end
	'@cls'
	say
	say ' 'msg.0090
	say 
	say ' 'msg.0092
	say 
	languages = ''
	do i=1 to tmp.0
		tmp.i = translate(filespec('name',tmp.i))
		tmp.i = substr(tmp.i, lastpos('.', tmp.i)+1)
		say ' 'i'. 'tmp.i
		languages = languages' 'tmp.i
	end
	response = 0
	do while response < 1 | response > tmp.0 | datatype(response) <> 'NUM'
		say
		say ' 'msg.0093
		pull response
	end
	lang = tmp.response

	/* load message file */
	call load_language lang

	/* install or uninstall */
	'@cls'
	say
	say ' 'msg.0095
	say 
	say ' 1. 'msg.0096
	say ' 2. 'msg.0097
	response = 0
	do while response < 1 | response > 2
		say
		say ' 'msg.0098
		pull response
	end
	if response = 2 then do
		updcd_dir = SysIni('USER', 'UPDCD', 'PATH')
		if updcd_dir = 'ERROR:' then do
			say ' 'msg.0099
			pull updcd_dir
		end
		say
		say ' 'msg.0100' 'updcd_dir
		say ' 'msg.0089
		say
		'@pause >nul'
		if stream(updcd_dir'\uninstal.cmd', 'c', 'query exists') <> '' then '@call 'updcd_dir'\uninstal.cmd Q'
		say
		say ' 'msg.0148' 'updcd_dir
		call deldir updcd_dir
		say ' 'msg.0079
		exit
	end

	/* backup config.sys */
	bdrive = bootdrive()
	say
	say ' 'msg.0004' 'bdrive'\Config.Sys -> 'bdrive'\Config.Wuk...'
	config = bdrive'\Config.Sys'
	'@copy 'config bdrive'\Config.Wuk >nul'

return

/*****************/
/* load rexxutil */
/*****************/
load_rexxutil:

	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs

return

/********************/
/* return bootdrive */
/********************/
BootDrive: procedure

	/* first try rlanutil */
	Call RxFuncDrop 'GetBootDrive'
	Call RxFuncAdd 'GetBootDrive', 'RLANUTIL', 'GetBootDrive'
	signal on syntax name BootDrive2
	bdrv = GetBootDrive()
	signal off syntax

return bdrv

BootDrive2:

	/* try path method */
	alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
	record = value('PATH',,'OS2ENVIRONMENT')
	record = translate(record)
	os2_pos = pos(':\OS2\SYSTEM',record)
	if (os2_pos=0) then bootdrive='A'
	else do
            bootdrive_pos = os2_pos - 1
            bootdrive = substr(record,bootdrive_pos,1)
	end
	if  (verify(bootdrive,alphabet) <> 0) then return 'A:' /* presume A */

return bootdrive||':'

/*****************/
/* install updcd */
/*****************/
install_updcd:

	parse arg option

	/* select language */
	'@cls'
	say
	say ' 'msg.0094
	say
	say ' 'msg.0092
	say
	tmp.1 = 'ENG'
	tmp.2 = 'DEU'
	tmp.3 = 'HUN'
	tmp.4 = 'BRA'
	tmp.0 = 4
	languages = ''
	do i=1 to tmp.0
		say ' 'i'. 'tmp.i
		languages = languages' 'tmp.i
	end
	response = 0
	do while response < 1 | response > tmp.0 | datatype(response) <> 'NUM'
		say
		say ' 'msg.0093
		pull response
	end
	lang = tmp.response
	p = wordpos(lang, languages)
	languages = subword(languages, 1, p-1)' 'subword(languages, p+1)

	/* select */
	call select_components

	/* inform */
	'@cls'
	say
	say ' 'substr(msg.0040, 1, 75)
	say ' 'substr(msg.0041, 1, 75)
	say ' 'substr(msg.0042, 1, 75)
	say ' 'substr(msg.0043, 1, 75)
	say ' '
	pull instdir
	instdir = strip(instdir, 'T', '\')

	'@dir 'instdir'\* >nul 2>>&1'
	if rc <> 0 then do
		if option <> 'Q' then do
			say
			say ' 'instdir' 'msg.0044
		end
		if option = 'Q' | (GetKeyYN(k) = 'Y') then do
			rc = CreateDirectoryTree(instdir)
			if rc <> 0 then do
				say
				say ' 'msg.0045' 'instdir
				call Hit_Key
				return
			end
		end
		else do
			call Hit_Key
			return
		end
	end
	else do
		if instdir <> '' then do
			if option <> 'Q' then do
				say
				say ' 'instdir' 'msg.0046
			end
			if option <> 'Q' & (GetKeyYN(k) = 'N') then do
				call Hit_Key
				return
			end
			else do
				cfgfile = instdir'\updcd.cfg'
				l.0 = 0
				if stream(cfgfile, 'c', 'query exists') <> '' then do
					i=1
					do while lines(cfgfile)
						l.i=linein(cfgfile)
						i=i+1
					end
					l.0=i-1
					call lineout cfgfile
				end
				call deldir instdir
				'@mkdir 'instdir' >nul 2>>&1'
				if l.0 > 0 then do
					do i=1 to l.0
						call lineout cfgfile, l.i
					end
					call lineout cfgfile
				end
			end
		end
		else do
			say
			say ' 'msg.0022
			call Hit_Key
			return
		end
	end
	/* need to know drive */
	cdir = chdir()
	instdir = chdir(instdir)
	call chdir cdir
	drive = substr(instdir, 1, 2)
	if drive = '' then do
		say ' 'msg.0112
		exit 1
	end

	/* check free space */
	parse value SysDriveInfo(drive) with . free .
	if free = '' then do
		say
		say ' 'msg.0047' 'drive
		call Hit_Key
		return
	end
	if free < 734003200 then do
		say
		say ' 'msg.0048' 'trunc(free/(1024*1024))
		say ' 'substr(msg.0049, 1, 75)
		say ' 'substr(msg.0050, 1, 75)
		if option = 'Q' then option = 'X'
		if (GetKeyYN(k) = 'N') then do
			call Hit_Key
			return
		end
		if option = 'X' then option = 'Q'
	end

	/* do it */
	log = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then do
		'@echo just testing... > 'log
		if stream(log, 'c', 'query exists') = '' then log = 'nul'
		else '@del 'log
	end
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	'@echo Selected language: 'lang' >> 'log' 2>>nul'
	'@echo Selected OS/2 version: 'ver' >> 'log' 2>>nul'
	'@echo Selected fixes: >> 'log' 2>>nul'
	do i=1 to fixes.0
		'@echo 'fixes.i' >> 'log' 2>>nul'
	end
	'@echo Selected updates: >> 'log' 2>>nul'
	do i=1 to updates.0
		'@echo 'updates.i' >> 'log' 2>>nul'
	end
	'@echo Selected addons:  >> 'log' 2>>nul'
	do i=1 to addons.0
		'@echo 'addons.i' >> 'log' 2>>nul'
	end
	'@echo Selected locals: >> 'log' 2>>nul'
	do i=1 to found.0
		'@echo 'found.i' >> 'log' 2>>nul'
	end

	/* set ini */
	call SysIni , 'UPDCD', 'PATH', instdir
	call SysIni , 'UPDCD', 'VERS', '200'
	select 
		when ver = 'WP3' then os2ver = 'Warp 3'
		when ver = 'WP4' then os2ver = 'Warp 4'
		when ver = 'WSB' then os2ver = 'WSeB'
		when ver = 'MCP' then os2ver = 'MCP/ACP'
		when ver = 'ACP' then os2ver = 'MCP/ACP'
		when ver = 'ECS' then os2ver = 'eCS'
	end
	call SysIni , 'UPDCD', 'OS2VER', os2ver

	/* copy files */
	say
	say ' 'msg.0051
	'@echo Starting installation on drive 'drive' >> 'log
	'@echo Date/Time: 'date() time()' >> 'log
	'@echo Free disk space: 'free' bytes >> 'log
	'@mkdir 'instdir'\fixes >nul 2>>&1'
	'@mkdir 'instdir'\updates >nul 2>>&1'
	'@mkdir 'instdir'\addons >nul 2>>&1'
	rcode = 0
	say ' 'msg.0052
	rcode = 0
	do i=1 to fixes.0
		parse var fixes.i . path1 path2
		path1 = substr(path1, 1, pos('/', path1)-1)
		path2 = translate(path2, '\', '/')
		path3 = ''
		if path1 = 'RMJV118' | path1 = 'RUJV118' | path1 = 'SAJV118' | path1 = 'TOJV118' then path3 = 'JAVA118'
		if path3 <> '' then '@mkdir 'instdir'\fixes\'path3' >nul 2>>&1'
		else '@mkdir 'instdir'\fixes\'path1' >nul 2>>&1'
		'@'hdir'\updcd\bin\unzip -Co 'hdir'\data\wukdata.zip 'path2||path1'/* -d 'instdir'\fixes >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc
		if path3 <> '' then rc = move_files(instdir'\fixes\'path2||path1' 'instdir'\fixes\'path3)
		else rc = move_files(instdir'\fixes\'path2||path1' 'instdir'\fixes\'path1)
		if rc <> 0 then rcode = rc
		path2 = substr(path2, 1, pos('\', path2)-1)
		call deldir instdir'\fixes\'path2
	end
	say ' 'msg.0053
	do i=1 to updates.0
		parse var updates.i . path1 path2
		path1 = substr(path1, 1, pos('/', path1)-1)
		path2 = translate(path2, '\', '/')
		path3 = ''
		if path1 = 'RMJV118' | path1 = 'RUJV118' | path1 = 'SWJV118' | path1 = 'TOJV118' then path3 = 'JAVA118'
		if path3 <> '' then '@mkdir 'instdir'\updates\'path3' >nul 2>>&1'
		else '@mkdir 'instdir'\updates\'path1' >nul 2>>&1'
		'@'hdir'\updcd\bin\unzip -Co 'hdir'\data\wukdata.zip 'path2||path1'/* -d 'instdir'\updates >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc
		if path3 <> '' then rc = move_files(instdir'\updates\'path2||path1' 'instdir'\updates\'path3)
		else rc = move_files(instdir'\updates\'path2||path1' 'instdir'\updates\'path1)
		if rc <> 0 then rcode = rc
		path2 = substr(path2, 1, pos('\', path2)-1)
		call deldir instdir'\updates\'path2
	end
	say ' 'msg.0054
	do i=1 to addons.0
		parse var addons.i . path1 path2
		path1 = substr(path1, 1, pos('/', path1)-1)
		path2 = translate(path2, '\', '/')
		'@mkdir 'instdir'\addons\'path1' >nul 2>>&1'
		'@'hdir'\updcd\bin\unzip -Co 'hdir'\data\wukdata.zip 'path2||path1'/* -d 'instdir'\addons >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc
		rc = move_files(instdir'\addons\'path2||path1' 'instdir'\addons\'path1)
		if rc <> 0 then rcode = rc
		path2 = substr(path2, 1, pos('\', path2)-1)
		call deldir instdir'\addons\'path2
	end
	say ' 'msg.0111
	do i=1 to found.0
		parse var found.i path2 . pname . path1
		'@mkdir 'instdir'\'path2'\'pname' >nul 2>>&1'
		'@xcopy 'path1'\* 'instdir'\'path2'\'pname'\. /H/O/T/S/R/V/E >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc
	end
	'@xcopy updcd\* 'instdir'\. /H/O/T/S/R/V/E >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	/* check */
	if check_result() = 0 then do

		/* remove RO attribute */
		call SysFileTree instdir||'\*', 'tmp.', 'BSO',,'**---'

		/* creating objects */
		say
		say ' 'msg.0055
		'@echo Creating objects >> 'log
		cdir = chdir()
		call chdir instdir
		'@call install.cmd QUIET'
		call chdir cdir

		/* update flag */
		flag1 = '* '
		if option <> 'Q' then call Hit_Key
		updcd_installed = 1

	end

return

/******************/
/* install vfdisk */
/******************/
install_vfdisk:

	parse arg option

	/* check */
	if found_vfdisk = 1 then do
		say
		say ' 'msg.0056
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* check */
	if found_svdisk = 1 then do
		say
		say ' 'msg.0057
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	say
	say ' 'msg.0058
	'@echo Installing VFDISK >> 'log
	rcode = 0
	'@copy 'hdir'\tools\vfdisk\vfdisk.sys 'bdrive'\os2\boot\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy 'hdir'\tools\vfdisk\vfctrl.exe 'bdrive'\os2\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy 'hdir'\tools\vfdisk\vfctrlpm.exe 'bdrive'\os2\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy 'hdir'\tools\vfdisk\vfctrlpm.hlp 'bdrive'\os2\help\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc

	/* check */
	if check_result() = 0 then do

		/* handle ini and config */
		call SysIni , 'UPDCD', 'VDISK', 'VFDISK'
		if found_vfdisk = 0 & rcode = 0 then '@echo DEVICE='bdrive'\os2\boot\VFDISK.SYS 4 >> 'bdrive'\config.sys'

		/* inform */
		if found_fat32f = 1 & rcode = 0 then do
			say
			say ' 'msg.0059
			say ' 'msg.0060
			call Hit_Key 'C'
		end
		if found_reserv = 1 & rcode = 0 then do
			say
			say ' 'msg.0061
			say ' 'msg.0062
			say ' 'msg.0063
			call Hit_Key 'C'
		end

	end

	/* update flag */
	if rcode = 0 then do
			flag2 = '* '
			option_used = 1
			if option <> 'Q' then call Hit_Key
	end

return

/****************/
/* install aspi */
/****************/
install_aspi:

	parse arg option

	/* check */
	if found_aspirt = 1 then do
		say
		say ' 'msg.0064
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	rcode = 0
	say
	say ' 'msg.0065
	'@echo Installing ASPI >> 'log
	'@'hdir'\updcd\bin\unzip -Cjo 'hdir'\data\wukdata.zip ADD/16_ASPRT/ASPIROUT.SYS -d 'bdrive'\os2\boot >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@'hdir'\updcd\bin\unzip -Cjo 'hdir'\data\wukdata.zip ADD/16_ASPRT/ASPIROUT.TXT -d 'bdrive'\os2\help >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc

	/* check */
	if check_result() = 0 then do

		/* handle config */
		if found_os2asp = 0 & rcode = 0 then '@echo BASEDEV=OS2ASPI.DMD /ALL >> 'bdrive'\config.sys'
		if found_aspirt = 0 & rcode = 0 then '@echo DEVICE='bdrive'\OS2\BOOT\ASPIROUT.SYS >> 'bdrive'\config.sys'

	end

	/* update flag */
	if rcode = 0 then do
		flag3 = '* '
		if option <> 'Q' then call Hit_Key
		option_used = 1
	end

return

/***************/
/* install emx */
/***************/
install_emx:

	parse arg option

	/* check */
	if found_emxrt = 1 then do
		say
		say ' 'msg.0066
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	rcode = 0
	say
	say ' 'msg.0067
	'@echo Installing EMX >> 'log

	/* unzip */
	'@'hdir'\updcd\bin\unzip -jCo 'hdir'\data\wukdata.zip ADD/60_EMXRT/emxrt.zip -d 'bdrive'\ >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@'hdir'\updcd\bin\unzip -Co 'bdrive'\emxrt.zip -d 'bdrive'\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy 'bdrive'\emx\etc\termcap.dat 'VALUE('ETC', ,'OS2ENVIRONMENT')'\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@del 'bdrive'\emxrt.zip >> 'log' 2>>&1'

	/* change lines config */
	i=1
	cfgfile = bdrive'\config.sys'
	do while lines(cfgfile)
		l.i = linein(cfgfile)
		i=i+1
	end
	call lineout cfgfile
	'@del 'cfgfile' >nul 2>>&1'
	if rc <> 0 then rcode = rc
	l.0 = i-1
	do q=1 to l.0
		if substr(translate(l.q), 1, 8) = 'SET PATH' & pos('EMX\BIN', translate(l.q)) = 0 then do
			lpos = length(l.q)
			if substr(l.q, lpos) = ';' then l.q = l.q || bdrive'\EMX\BIN;'
			else l.q = l.q || ';' || bdrive'\EMX\BIN;'
			call lineout cfgfile, l.q
		end
		else if substr(translate(l.q), 1, 7) = 'LIBPATH' & pos('EMX\DLL', translate(l.q)) = 0 then do
			lpos = length(l.q)
			if substr(l.q, lpos) = ';' then l.q = l.q || bdrive'\EMX\DLL;'
			else l.q = l.q || ';' || bdrive'\EMX\DLL;'
			call lineout cfgfile, l.q
		end
		else call lineout cfgfile, l.q
	end
	call lineout cfgfile

	/* check */
	call check_result

	/* update flag */
	if rcode = 0 then do
		flag4 = '* '
		if option <> 'Q' then call Hit_Key
		option_used = 1
	end

return

/****************/
/* install dani */
/****************/
install_dani:

	parse arg option

	/* check */
	reinstall = 0
	if found_daniid = 1 then do
		say
		say ' 'msg.0068
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
		else reinstall = 1
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	if found_daniid = 0 | reinstall = 1 then do
		rcode = 0
		say
		say ' 'msg.0069
		'@echo Installing DANI IDE >> 'log
		'@'hdir'\updcd\bin\unzip -Cjo 'hdir'\data\wukdata.zip ADD/21_DNIDE/DaniS506.ADD -d 'bdrive'\os2\boot >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc
		'@'hdir'\updcd\bin\unzip -Cjo 'hdir'\data\wukdata.zip ADD/21_DNIDE/DaniS506.DOC -d 'bdrive'\os2\help >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc

		/* check */
		if check_result('C') = 0 then do

			/* handle config */
			if rcode = 0 then do
				i=1
				found = 0
				do while lines(config)
					l.i=linein(config)
					if pos('IBM1S506.ADD', translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then do
						l.i='BASEDEV=DANIS506.ADD'
						found = 1
					end
					i=i+1
				end
				call lineout config
				l.0=i-1
				if found = 0 & found_daniid = 0 then '@echo BASEDEV=DANIS506.ADD >> 'config
				else do
					'@del 'config
					do i=1 to l.0
						call lineout config, l.i
					end
					call lineout config
				end
			end

			/* update flag */
			flag5 = '* '
			option_used = 1

		end

	end

	/* check */
	reinstall = 0
	if found_danifl = 1 then do
		say
		say ' 'msg.0070
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
		else reinstall = 1
	end

	/* do it */
	if found_danifl = 0 | reinstall = 1 then do
		rcode = 0
		'@echo Installing DANI FLT >> 'log
		'@'hdir'\updcd\bin\unzip -Cjo 'hdir'\data\wukdata.zip ADD/20_DNFLT/DaniATAP.FLT -d 'bdrive'\os2\boot >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc
		'@'hdir'\updcd\bin\unzip -Cjo 'hdir'\data\wukdata.zip ADD/20_DNFLT/DaniATAP.DOC -d 'bdrive'\os2\help >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc

		/* check */
		if check_result('C') = 0 then do

			/* handle config */
			if rcode = 0 then do
				found = 0
				do i=1 to l.0
					if (pos('IBMIDECD.FLT', translate(l.i)) > 0 | pos('IBMATAPI.FLT', translate(l.i)) > 0) & word(translate(l.i), 1) <> 'REM' then do
						l.i='BASEDEV=DANIATAP.FLT'
						found = 1
						leave
					end
				end
				if found = 0 & found_danifl = 0 then '@echo BASEDEV=DANIATAP.FLT >> 'config
				else do
					'@del 'config
					do i=1 to l.0
						call lineout config, l.i
					end
					call lineout config
				end

				/* update flag */
				flag5 = '* '
				option_used = 1
			end

		end

	end

	if option <> 'Q' & rcode = 0 then call Hit_Key

return

/********************/
/* install cdrecord */
/********************/
install_cdrecord:

	parse arg option

	/* check */
	if found_cdrec2 = 1 then do
		say
		say ' 'msg.0071
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* check */
	if found_rsj = 1 then do
		say
		say ' 'msg.0072
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	rcode = 0
	say
	say ' 'msg.0073
	'@echo Installing CDRecord >> 'log
	'@mkdir 'bdrive'\cdrec2 >nul 2>>&1'
	'@'hdir'\updcd\bin\unzip -Co 'hdir'\data\wukdata.zip ADD/63_CDREC/*  -d 'bdrive'\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
  rc = move_files(bdrive'\add\63_cdrec 'bdrive'\cdrec2')
	if rc <> 0 then rcode = rc
	call deldir bdrive'\add'
	call create_icons "CDRecord/2 <WP_DESKTOP> <CDREC2> "bdrive"\cdrec2"
	'@del 'bdrive'\cdrec2\test.cmd >nul 2>>&1'
	call create_test_program bdrive"\cdrec2\test.cmd"
	call SysCreateObject 'WPProgram', 'Command Prompt', '<CDREC2>', 'EXENAME=CMD.EXE;PARAMETERS=/K "MODE CO80,102";STARTUPDIR='bdrive'\cdrec2;', 'R'
	call SysCreateObject "WPProgram", "Test Installation ^ (start here)", "<CDREC2>", "EXENAME="bdrive"\cdrec2\test.cmd", "R"

	/* check */
	if check_result() = 0 then do

		/* handle config */
		if rcode = 0 then do
			i=1
			found = 0
			do while lines(config)
				l.i=linein(config)
				if pos('SET PATH=', translate(l.i)) > 0 & pos('\CDREC2', translate(l.i)) = 0 then do
					lpos = length(l.i)
					if substr(l.i, lpos) = ';' then l.i = l.i || bdrive'\cdrec2;'
					else l.i = l.i || ';' || bdrive'\cdrec2;'
					found = 1
				end
				i=i+1
			end
			call lineout config
			l.0=i-1
			if found = 1 then do
				'@del 'config' >nul 2>>&1'
				do i=1 to l.0
					call lineout config, l.i
				end
				call lineout config
			end
		end

	end
	
	/* update flag */
	if rcode = 0 then do
		flag6 = '* '
		if option <> 'Q' then call Hit_Key
		option_used = 1
	end

return

/******************/
/* install needed */
/******************/
install_needed:

	if flag2 = '> ' then call install_vfdisk 'Q'
	if flag3 = '> ' then call install_aspi 'Q'
	if flag4 = '> ' then call install_emx 'Q'
	if flag5 = '> ' then call install_dani 'Q'
	if flag6 = '> ' then call install_cdrecord 'Q'
	if flag1 = '> ' then call install_updcd 'Q'

	/* update flag */
	flag7 = '* '
	call Hit_Key

return

/**********************/
/* check rexx version */
/**********************/
check_rexx:

	Parse Version . Level .
	If Level > 4.00 Then do
		say
		say ' 'msg.0074
		say ' 'msg.0075
		exit 8
	end

return

/*************************************************************/
/* chdir: drive and path aware directory() replacement       */
/*        returns the current dir without trailing backslash */
/*************************************************************/
chdir: procedure

	parse upper arg dr                /* get target dir        */

	if length(dr) > 1 then dr = strip(dr, 'T', '\')
	cdir = directory()                /* get current dir       */
	if substr(dr, 2, 1) = ':' then do /* absolute path         */
		drive = substr(dr, 1, 2)
		rc = directory(drive)           /* change to drive       */
		if substr(rc, 1, 2) <> drive then 
			return strip(directory(cdir), 'T', '\')
		rc = directory('\')             /* change to root        */
		rc = directory(substr(dr, 3))   /* change to path        */
		if strip(rc, 'T', '\') <> dr then 
			return strip(directory(cdir), 'T', '\')
	end
	else do
		return strip(directory(dr), 'T', '\')  /* relative path  */
	end

return strip(directory(), 'T', '\') /* return current dir    */

/***********************************/
/* A simple Y/N keypress procedure */
/***********************************/
GetKeyYN: procedure expose option

	if option = 'Q' then return 'X'
	do while ((key1 <> 'Y') & (key1 <> 'N'))
		key1 = SysGetKey('NOECHO')
		parse upper var key1 key1
	end
	say

return key1

/***********/
/* hit key */
/***********/
Hit_Key: procedure expose msg.

	parse arg option

	if (option = 'C') then prompt = 'continue.'
	else prompt = 'return to the menu.'

	say ' 'msg.0076' 'prompt
	call SysGetKey 'NOECHO'

return

/****************/
/* check result */
/****************/
check_result: 

	parse arg opt
	say
	if rcode <> 0 then do
		say ' 'msg.0077
		say ' 'msg.0078' 'log
		call Hit_Key opt
		return 1
	end
	else say ' 'msg.0079

return rcode

/**********************************************************/
/* Find out if user has RSJ cdwriter system installed 		  */
/* do this by checking the class list for CDWRITER class 	*/
/**********************************************************/
find_rsjdir: procedure

	rsjdir = ''
	call SysQueryClassList 'junk.'
	i = 1
	do i=1 to junk.0
  	tmp = translate(word(junk.i, 1))
  	if (tmp = 'CDWRITER') then do /* We found the rsj CDWRITER class */
			tmp = word(junk.i, 2)
			rsjdir = substr(tmp, 1, lastpos('\', tmp )-1)
	   	leave
		end
	end

return rsjdir

/*************/
/* find file */
/*************/
find_file: procedure

	parse upper arg file_to_find option
	if option <> 'Q' then call lineout , ' 'msg.0080' 'file_to_find||'. '
	find. = ''

	/* find in path */
	if option <> 'Q' then call lineout , msg.0081
	find.1 = SysSearchPath('PATH', file_to_find)

	parse value SysCurPos() with row col
	if find.1 = '' then do
		/* find on drives */
		drives = SysDriveMap('C:', 'LOCAL')
		if option <> 'Q' then call charout , msg.0082
		insertSpot = col + length(msg.0082) 
		do while length(drives) > 0
			parse var drives drv drives
			if option <> 'Q' then do
 			 	call SysCurPos row, insertSpot
				call charout , drv
			end
			rc = sysdriveinfo(drv)
			if rc <> '' then do
				call sysfiletree drv'\'file_to_find, 'find.', 'FSO'
				if find.0 > 0 then leave
			end
		end
	end

	if find.1 = '' & option <> 'Q' then do
		say ' 'msg.0083
		say ' 'msg.0084' 'file_to_find
	End 
	Else Do
		if find.1 <> '' then find.1 = substr(find.1, 1, lastpos('\', find.1)-1)
		if option <> 'Q' then do
			call SysCurPos row, col
			call charout , left('', 18 )  /* erase the text first */
			call SysCurPos row, col
			call charout , msg.0085
			say find.1
		end
	End

return find.1

/*************************/
/* create cdrecord icons */
/*************************/
create_icons: procedure expose log

	parse arg title pid fid path
	call lineout log, "Creating objects: "title pid fid path
	call lineout log
	call SysCreateObject "WPFolder", title, pid, "OBJECTID="fid";ICONVIEW=FLOWED,NORMAL;", "R"
	call sysfiletree path'\*', 'file.'
	do i=1 to file.0
		parse var file.i . . size attrib sdir rest
		/* create folder */
		if size = 0 & substr(attrib, 2, 1) = 'D' then do
			title = filespec('name', sdir)
			subfid = "<CDREC2_"title">"
			call create_icons title fid subfid sdir
		end
		/* create icon */
		else do
			title = filespec('name', sdir)
			ext = translate(substr(title, lastpos('.', title)+1))
			if ext = 'EXE' then do
				found=0
				do while lines(sdir)
					l=linein(sdir)
					if pos('emx.exe', l) > 0 then do
						found=1
						leave;
					end
				end
				call lineout sdir
				if found=1 then call SysCreateObject 'WPProgram', title, fid, 'EXENAME=CMD.EXE;PARAMETERS=/K "MODE CO80,102 & 'sdir'";STARTUPDIR='filespec('drive', sdir)||filespec('path', sdir)';NOAUTOCLOSE=YES', 'R'
				else call SysCreateObject 'WPProgram', title, fid, 'EXENAME='sdir';STARTUPDIR='filespec('drive', sdir)||filespec('path', sdir), 'R'
			end
			else if ext = 'BAT' | ext = 'CMD' then 
				call SysCreateObject 'WPProgram', title, fid, 'EXENAME=CMD.EXE;PARAMETERS=/K "MODE CO80,102 & 'sdir'";STARTUPDIR='filespec('drive', sdir)||filespec('path', sdir)';NOAUTOCLOSE=YES', 'R'
			else if ext = 'HTM' | ext = 'HTML' then
				call SysCreateObject "WPUrl", title, fid, "NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=file:///"translate(translate(sdir,"|",":"), "/", "\")";", "R"
			else
				call SysCreateObject "WPProgram", title, fid, "EXENAME=e.exe;PARAMETERS="sdir";", "R"
		end
	end

return

/*******************************/
/* create cdrecord testprogram */
/*******************************/
create_test_program: procedure expose bdrive
	
	parse arg outfile

	line.1 = "/* Check CDRecord installation */"
	line.2 = " "
	line.3 = "'@cls'"
	line.4 = "f='temp.cdr'"
	line.5 = "say"
	line.6 = "say 'This program will check the installation of CDRecord/2.'"
	line.7 = "say"
	line.8 = "say 'Running command: "bdrive"\cdrec2\cdrecord.exe -scanbus'"
	line.9 = "'@"bdrive"\cdrec2\cdrecord.exe -scanbus > 'f"
	line.10 = "l=linein(f)"
	line.11 = "if length(l) = 0 then do"
	line.12 = "	say 'Cannot run cdrecord.exe, check if EMX installed!'"
	line.13 = "	pause"
	line.14 = "	exit 1"
	line.15 = "end"
	line.16 = "parse var l w1 w2 ."
	line.17 = "say 'Detected CDRecord/2 version: 'w2"
	line.18 = " "
	line.19 = "say"
	line.20 = "say 'Detected SCSI devices:'"
	line.21 = "l=linein(f)"
	line.22 = "do while lines(f)"
	line.23 = "	l=linein(f)"
	line.24 = "	if pos('*', l) = 0 & pos('scsibus', l) = 0 then say l"
	line.25 = "end"
	line.26 = "call lineout f"
	line.27 = "'@del 'f"
	line.28 = " "
	line.29 = "say"
	line.30 = "say 'Please enter the SCSI ID of the device you want to use with CDRecord/2'"
	line.31 = "say 'and press ENTER. If you do not see your device check if you load the'"
	line.32 = "say 'appropriate SCSI driver in your config.sys. Check if ASPI router is'"
	line.33 = "say 'installed. If you use an IDE device check if DANI ATAPI and DANI IDE'"
	line.34 = "say 'are installed. Example SCSI ID response: 0,1,0'"
	line.35 = "response = ''"
	line.36 = "do while length(response) <> 5"
	line.37 = "	pull response"
	line.38 = "	if length(response) <> 5 then say 'Invalide response, try again!'"
	line.39 = "end"
	line.40 = " "
	line.41 = "say"
	line.42 = "say 'Creating sample command files...'"
	line.43 = "call rxfuncadd syscreateobject, rexxutil, syscreateobject"
	line.44 = " "
	line.45 = "f = 'image.cmd'"
	line.46 = "'@del 'f' >nul 2>>&1'"
	line.47 = "call lineout f, '/* create image file */'"
	line.48 = "call lineout f, ' '"
	line.49 = "call lineout f, ""'@cls'"""
	line.50 = "call lineout f, ""say"""
	line.51 = "call lineout f, ""say 'This program will create an ISO image on your hard disk.'"""
	line.52 = "call lineout f, ""say 'Specify a directory which should be imaged.'"""
	line.53 = "call lineout f, ""say 'Example: d:\burn'"""
	line.54 = "call lineout f, ""say"""
	line.55 = "call lineout f, ""pull directory"""
	line.56 = "call lineout f, ' '"
	line.57 = "call lineout f, ""rawfile = filespec('name', directory)'.raw'"""
	line.58 = "call lineout f, ""'@""directory()""\mkisofs -l -L -R -o 'rawfile directory"""
	line.59 = "call lineout f, ""say 'Image file 'rawfile' created with return code 'rc"""
	line.60 = "call lineout f, "" """
	line.61 = "call lineout f, ""exit"""
	line.62 = "call lineout f"
	line.63 = " "
	line.64 = "f = 'burn.cmd'"
	line.65 = "'@del 'f' >nul 2>>&1'"
	line.66 = "call lineout f, '/* burn CD */'"
	line.67 = "call lineout f, ' '"
	line.68 = "call lineout f, ""'@cls'"""
	line.69 = "call lineout f, ""say"""
	line.70 = "call lineout f, ""say 'This program will burn a CD from an ISO image on your hard disk.'"""
	line.71 = "call lineout f, ""say 'Specify the image file which should be used.'"""
	line.72 = "call lineout f, ""say 'Example: d:\burn\cd.raw'"""
	line.73 = "call lineout f, ""say"""
	line.74 = "call lineout f, ""pull rawfile"""
	line.75 = "call lineout f, ' '"
	line.76 = "call lineout f, ""device = '""response""'"""
	line.77 = "call lineout f, ""speed = '2'"""
	line.78 = "call lineout f, ""say """
	line.79 = "call lineout f, ""say 'Burning CD using image file 'rawfile' on device 'device' with 'speed' speed.'"""
	line.80 = "call lineout f, ""'@""directory()""\cdrecord dev='device' speed='speed' -v -eject -pad -data 'rawfile"""
	line.81 = "call lineout f, ""say 'The CD-ROM has been created with return code 'rc"""
	line.82 = "call lineout f, ' '"
	line.83 = "call lineout f, ""exit"""
	line.84 = "call lineout f"
	line.85 = " "
	line.86 = "call SysCreateObject 'WPProgram', 'Burn CD-ROM (step 2)', '<CDREC2>', 'EXENAME='directory()'\burn.cmd;NOAUTOCLOSE=YES', 'R'"
	line.87 = "call SysCreateObject 'WPProgram', 'Create image (step 1)', '<CDREC2>', 'EXENAME='directory()'\image.cmd;NOAUTOCLOSE=YES', 'R'"
	line.88 = "say 'Done! Press ENTER to exit.'"
	line.89 = "pull response"
	line.90 = " "
	line.91 = "exit"
	line.92 = " "

	do i=1 to 92
		call lineout outfile, line.i
	end

return

/**************************************************/
/* delete directory structure including all files */
/* skip ea data.sf and root directory (e.g. c:)   */
/**************************************************/
DelDir: procedure expose msg.

	parse upper arg Directory
	DirSpec = Directory'\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
		if pos('EA DATA. SF', Files.i) = 0 then do
			'@del "'Files.i'" >nul 2>>&1'
			if rc <> 0 then say ' 'msg.0086': @del 'Files.i' rc='rc
		end
 end

	/* delete directory */
	cdir1 = translate(chdir())
	cdir2 = translate(chdir(Directory))
	call chdir '\'
	cdir1 = chdir(cdir1)
	if pos(Directory, cdir2) > 0 & cdir2 <> cdir1 & substr(Directory, 2) <> ':' then do
		'@rmdir "'Directory'" >nul 2>>&1'
		if rc <> 0 then say ' 'msg.0086': @rmdir 'Directory' rc='rc
	end

return

/******************/
/* display addons */
/******************/
display_addons: procedure expose hdir msg.
	
	parse arg anum1 adir1 . anum2 adir2 .
	if adir2 = '' then adir2 = '***'
	f = hdir'\updcd\newinst\addons.cfg'
	adesc. = msg.0025
	avers. = '?.?'
	do while lines(f)
		l=linein(f)
		parse upper var l prname . prdesc
		if prname = substr(adir1, 1, 8) then do
			l = linein(f)
			parse var l . . adesc.1
			l = linein(f)
			parse var l . . avers.1
		end
		if prname = substr(adir2, 1, 8) then do
			l = linein(f)
			parse var l . . adesc.2
			l = linein(f)
			parse var l . . avers.2
		end
	end
	call lineout f
	if adir2 = '***' then 
		say " "anum1" "substr(strip(adesc.1,,"'")" "strip(avers.1,,"'"), 1, 34)
	else
		say " "anum1" "substr(strip(adesc.1,,"'")" "strip(avers.1,,"'"), 1, 34)" "anum2" "substr(strip(adesc.2,,"'")" "strip(avers.2,,"'"), 1, 34)

return

/**************************/
/* get product selections */
/**************************/
get_selected_products: procedure expose msg. addons. fixes. updates.

		parse upper arg type
		select 
			when type = 'ADDONS' then selection.0 = addons.0
			when type = 'FIXES' then selection.0 = fixes.0
			when type = 'UPDATES' then selection.0 = updates.0
			when type = 'FOUND' then selection.0 = found.0
			otherwise selection.0 = 0
		end
		pull response
		if (type <> 'ADDONS' & type <> 'FOUND') & length(response) = 0 then do
				say ' 'msg.0022
				return 'ERROR'
		end
		tmp_response = response
		do while length(response) > 0
			parse var response selection response
			if ((datatype(selection) <> 'NUM') | (selection < 1) | (selection > selection.0)) then do
				say ' 'msg.0022
				return 'ERROR'
			end
		end

return tmp_response

/*******************************************************/
/* move files from sdir to tdir and preserve structure */
/*******************************************************/
move_files: procedure

	parse arg sdir tdir
	rcode = 0
	'@copy 'sdir'\* 'tdir'\. >nul 2>>&1'
	if rc > 1 then rcode = rc
	call SysFileTree sdir'\*', 'tmp.', 'DOS'
	do i=1 to tmp.0
		temp_dir = substr(tmp.i, length(sdir)+1)
		'@mkdir 'tdir||temp_dir' >nul 2>>&1'
		'@copy 'sdir||temp_dir'\* 'tdir||temp_dir'\. >nul 2>>&1'
		if rc > 1 then rcode = rc
	end
	if rcode = 1 then rcode = 0

return rcode

/**********************************/
/* select components to integrate */
/**********************************/
select_components:

	/* get OS/2 version */
	'@cls'
	say
	say ' 'substr(msg.0001, 1, 75)
	say 
	say ' 'substr(msg.0002, 1, 75)
	say 
	tmp.0 = 5
	tmp.1 = 'Warp 3'
	tmp.2 = 'Warp 4'
	tmp.3 = 'WSeB'
	tmp.4 = 'MCP 1/2 'msg.0110
	tmp.5 = 'ACP 1/2 'msg.0110
	tmp.6 = 'eCS 1.0 'msg.0110
	do i=1 to tmp.0
		say ' 'i'. 'tmp.i
	end
	response = 0
	do while response < 1 | response > tmp.0 | datatype(response) <> 'NUM'
		say
		say ' 'substr(msg.0003, 1, 75)
		pull response
	end
	versions = 'WP3 WP4 WSB MCP ACP ECS'
	select
		when response = 1 then ver = 'WP3'
		when response = 2 then ver = 'WP4'
		when response = 3 then ver = 'WSB'
		when response = 4 then ver = 'MCP'
		when response = 5 then ver = 'ACP'
		when response = 6 then ver = 'ECS'
		otherwise do
			say ' Fatal error, exiting...'
			exit 6
		end
	end
	p = wordpos(ver, versions)
	versions = subword(versions, 1, p-1)' 'subword(versions, p+1)

	/* find products on CD */
	say 
	say ' 'substr(msg.0017' 'ver' ('lang')', 1, 75)
	say ' 'msg.0103
	'@RXQUEUE /CLEAR'
	'@'hdir'\updcd\bin\unzip -Z 'hdir'\data\wukdata.zip | RXQUEUE'
	i = 1
	do while queued() > 0
   l = linein('queue:')
			parse upper var l fattrib . . . . . . . fpath
			if fattrib = 'DRWX---' then do
				languages_backup = languages
				do while words(languages) > 0
					parse upper var languages w languages
					if pos(w'/', fpath) > 0 then languages = ''
					else if words(languages) = 0 then do
							versions_backup = versions
							do while words(versions) > 0 
								parse upper var versions v versions
								if pos(v'/', fpath) > 0 then versions = ''
								else if words(versions) = 0 then do
									instdir.i = fpath
									i=i+1
								end
							end
							versions = versions_backup
					end
				end
				languages = languages_backup
			end
	end
	instdir.0=i-1

	/* filter list */
	j=1
	do i=1 to instdir.0
		if instdir.i = 'ADD/' | instdir.i = 'FIX/' | instdir.i = 'UPD/' then iterate
		if instdir.i = lang | instdir.i = lang'/ADD/' | instdir.i = lang'/FIX/' | instdir.i = lang'/UPD/' then iterate
		if instdir.i = ver | instdir.i = ver'/ADD/' | instdir.i = ver'/FIX/' | instdir.i = ver'/UPD/' then iterate
		if instdir.i = lang'/'ver | instdir.i = lang'/'ver'/ADD/' | instdir.i = lang'/'ver'/UPD/' | instdir.i = lang'/'ver'/FIX/' then iterate
		if substr(instdir.i, 1, 4) = 'ADD/' | substr(instdir.i, 1, 8) = lang'/ADD/' | substr(instdir.i, 1, 12) = lang'/'ver'/ADD/' | substr(instdir.i, 1, 8) = ver'/ADD/' then do
			insttype.j = 'ADDONS'
			instdir.j  = substr(instdir.i, pos('ADD/', instdir.i)+4)
			instpath.j = substr(instdir.i, 1, pos('ADD/', instdir.i)+3)
			j=j+1
		end
		if substr(instdir.i, 1, 4) = 'FIX/' | substr(instdir.i, 1, 8) = lang'/FIX/' | substr(instdir.i, 1, 12) = lang'/'ver'/FIX/' | substr(instdir.i, 1, 8) = ver'/FIX/' then do
			insttype.j = 'FIXES'
			instdir.j  = substr(instdir.i, pos('FIX/', instdir.i)+4)
			instpath.j = substr(instdir.i, 1, pos('FIX/', instdir.i)+3)
			j=j+1
		end
		if substr(instdir.i, 1, 4) = 'UPD/' | substr(instdir.i, 1, 8) = lang'/UPD/' | substr(instdir.i, 1, 12) = lang'/'ver'/UPD/' | substr(instdir.i, 1, 8) = ver'/UPD/' then do
			insttype.j = 'UPDATES'
			instdir.j  = substr(instdir.i, pos('UPD/', instdir.i)+4)
			instpath.j = substr(instdir.i, 1, pos('UPD/', instdir.i)+3)
			j=j+1
		end
	end
	instdir.0 = j-1
	j=1
	previous_instdir = '***'
	do i=1 to instdir.0
		if pos(previous_instdir, instdir.i) = 0 then do
			instdir.j  = instdir.i
			insttype.j = insttype.i
			instpath.j = instpath.i
			previous_instdir = instdir.i
			j=j+1
		end
	end
	instdir.0 = j-1

	/* display addons */
	say
	j=1
	do i=1 to instdir.0
		if insttype.i = 'ADDONS' then do
			if length(j) = 1 then
				addons.j = '0'j': 'instdir.i' 'instpath.i
			else
				addons.j = j': 'instdir.i' 'instpath.i
			j=j+1
		end
	end
	addons.0 = j-1
	say ' 'msg.0018' 'addons.0
	say ' 'msg.0019
	if GetKeyYN(k) = 'Y' then do
		selected_addons = 'ERROR'
		do while selected_addons = 'ERROR'
			'@cls'
			say
			do i=1 to addons.0 by 2
				j=i+1
				call display_addons addons.i' 'addons.j
			end
			say
			say ' 'msg.0020
			say ' 'msg.0021
			call get_selected_products 'ADDONS'
			selected_addons = result
			if selected_addons <> 'ERROR' & selected_addons <> '' then do
				j=1
				do while length(selected_addons) > 0
					parse var selected_addons i selected_addons
					addons.j = addons.i
					j=j+1
				end
				addons.0 = j-1
			end
		end
	end

	/* display fixes */
	'@cls'
	say
	say ' 'substr(msg.0023, 1, 75)
	say
	j=1
	do i=1 to instdir.0
		if insttype.i = 'FIXES' then do
			if length(j) = 1 then
				fixes.j = '0'j': 'instdir.i' 'instpath.i
			else
				fixes.j = j': 'instdir.i' 'instpath.i
			j=j+1
		end
	end
	fixes.0 = j-1
	do i=1 to fixes.0
		select
			when substr(fixes.i,5,2) = 'XR' & (substr(fixes.i,8,1) = 'W' | substr(fixes.i,8,1) = 'M' | substr(fixes.i,8,1) = 'E' | substr(fixes.i,8,1) = 'C') then description_fixes.i = 'Base OS/2 Fixpak'
			when substr(fixes.i,5,2) = 'XR' & substr(fixes.i,8,1) = 'D' then description_fixes.i = 'Device Driver Fixpak'
			when substr(fixes.i,5,2) = 'NW' then description_fixes.i = 'Netware Requester Fixpak'
			when substr(fixes.i,5,2) = 'UN' then description_fixes.i = 'TCP/IP Fixpak'
			when substr(fixes.i,5,2) = 'IP' then description_fixes.i = 'Lan Server/Peer Fixpak'
			when substr(fixes.i,5,2) = 'WR' then description_fixes.i = 'MPTS Fixpak'
			when substr(fixes.i,5,2) = 'PR' then description_fixes.i = 'Printer Fixpak'
			when substr(fixes.i,5,2) = 'RU' then description_fixes.i = 'JAVA Run-Time Fixpak'
			when substr(fixes.i,5,2) = 'TO' then description_fixes.i = 'JAVA Toolkit Fixpak'
			when substr(fixes.i,5,2) = 'SA' then description_fixes.i = 'JAVA Samples Fixpak'
			when substr(fixes.i,5,2) = 'RM' then description_fixes.i = 'JAVA RMI-IIOP Toolkit Fixpak'
			otherwise description_fixes.i = msg.0025
		end
		/* filter */
		if (ver = 'WSB' | ver = 'ACP' | ver = 'MCP' | ver = 'ECS') & (pos('UN_0980', fixes.i) > 0 | pos('UN_2001', fixes.i) > 0) then iterate 
		if (ver = 'ACP' | ver = 'MCP') & pos('8621', fixes.i) > 0 then iterate 
		/* select defaults */
		if pos('W042', fixes.i) > 0 | pos('W043', fixes.i) > 0 | pos('UN_2001', fixes.i) > 0 | pos('TOJV', fixes.i) > 0 | pos('SAJV', fixes.i) > 0 | pos('RMJV', fixes.i) > 0 | pos('8532', fixes.i) > 0 then say '   'i': 'description_fixes.i' ('substr(fixes.i, 5, 7)')' 
		else if (ver = 'ACP' | ver = 'MCP') & (pos('D002', fixes.i) > 0 | pos('RUJV118', fixes.i) > 0) then say '   'i': 'description_fixes.i' ('substr(fixes.i, 5, 7)')' 
		else say ' * 'i': 'description_fixes.i' ('substr(fixes.i, 5, 7)')'
	end
	say
	say ' 'substr(msg.0024, 1, 75)
	if GetKeyYN(k) = 'Y' then do
		say ' 'msg.0026
		say ' 'msg.0027
		selected_fixes = 'ERROR'
		do while selected_fixes = 'ERROR'
			call get_selected_products 'FIXES'
			selected_fixes = result
		end
	end
	else do
		selected_fixes = ''
		do i=1 to fixes.0
			/* filter */
			if (ver = 'WSB' | ver = 'ACP' | ver = 'MCP' | ver = 'ECS') & (pos('UN_0980', fixes.i) > 0 | pos('UN_2001', fixes.i) > 0) then iterate 
			if (ver = 'ACP' | ver = 'MCP') & (pos('8621', fixes.i) > 0 | pos('D002', fixes.i) > 0 | pos('RUJV118', fixes.i) > 0) then iterate 
			if pos('W042', fixes.i) > 0 | pos('W043', fixes.i) > 0 | pos('8532', fixes.i) > 0 | pos('UN_2001', fixes.i) > 0 | pos('TOJV', fixes.i) > 0 | pos('SAJV', fixes.i) > 0 | pos('RMJV', fixes.i) > 0 then iterate
			selected_fixes = selected_fixes' 'i
		end
	end
	j=1
	do while length(selected_fixes) > 0
		parse var selected_fixes i selected_fixes
		fixes.j = fixes.i
		j=j+1
	end
	fixes.0 = j-1

	/* display updates */
	'@cls'
	say
	say ' 'substr(msg.0028, 1, 75)
	say
	j=1
	do i=1 to instdir.0
		if insttype.i = 'UPDATES' then do
			if length(j) = 1 then
				updates.j = '0'j': 'instdir.i' 'instpath.i
			else
				updates.j = j': 'instdir.i' 'instpath.i
			j=j+1
		end
	end
	updates.0 = j-1
	do i=1 to updates.0
		select
			when substr(updates.i,5,2) = 'XR' & substr(updates.i,9,3) = '461' then description_updates.i = 'Netscape Update'
			when substr(updates.i,5,2) = 'XR' & substr(updates.i,9,3) <> '461' then description_updates.i = 'Feature Installer Update'
			when substr(updates.i,5,2) = 'UN' then description_updates.i = 'TCP/IP Update'
			when substr(updates.i,5,2) = 'WR' then description_updates.i = 'MPTS Update'
			when substr(updates.i,5,2) = 'PM' then description_updates.i = 'PMFAX Update'
			when substr(updates.i,5,2) = 'RU' then description_updates.i = 'JAVA Run-Time Update'
			when substr(updates.i,5,2) = 'TO' then description_updates.i = 'JAVA Toolkit and Samples Update'
			when substr(updates.i,5,2) = 'SW' then description_updates.i = 'JAVA Swing Run-Time and Toolkit Update'
			when substr(updates.i,5,2) = 'RM' then description_updates.i = 'JAVA RMI-IIOP Toolkit Update'
			otherwise description_updates.i = msg.0025
		end
		/* filter */
		if (ver = 'WSB' | ver = 'ACP' | ver = 'MCP' | ver = 'ECS') & (pos('3100', updates.i) > 0 | pos('8610', updates.i) > 0) then iterate 
		/* select defaults */
		if pos('TOJV', updates.i) > 0 | pos('SWJV', updates.i) > 0 | pos('RMJV', updates.i) > 0 then say '   'i': 'description_updates.i' ('substr(updates.i, 5, 7)')' 
		else if (ver = 'ACP' | ver = 'MCP') & pos('RUJV118', updates.i) > 0 then say '   'i': 'description_updates.i' ('substr(updates.i, 5, 7)')' 
		else say ' * 'i': 'description_updates.i' ('substr(updates.i, 5, 7)')'
	end
	say
	say ' 'msg.0029
	if GetKeyYN(k) = 'Y' then do
		say ' 'msg.0030
		say ' 'msg.0027
		selected_updates = 'ERROR'
		do while selected_updates = 'ERROR'
			call get_selected_products 'UPDATES'
			selected_updates = result
		end
	end
	else do
		selected_updates = ''
		do i=1 to updates.0
		/* filter */
		if (ver = 'WSB' | ver = 'ACP' | ver = 'MCP' | ver = 'ECS') & (pos('3100', updates.i) > 0 | pos('8610', updates.i) > 0) then iterate 
		if (ver = 'ACP' | ver = 'MCP') & pos('RUJV118', updates.i) > 0 then iterate
		if pos('TOJV', updates.i) > 0 | pos('SWJV', updates.i) > 0 | pos('RMJV', updates.i) > 0 then iterate 
		selected_updates = selected_updates' 'i
		end
	end
	j=1
	do while length(selected_updates) > 0
		parse var selected_updates i selected_updates
		updates.j = updates.i
		j=j+1
	end
	updates.0 = j-1

	/* find local products */
	'@cls'
	found.0=0
	response = 'N'
	if ver <> 'ACP' & ver <> 'MCP' then do
		say
		say ' 'msg.0101
		response = GetKeyYN(k)
	end
	if ver = 'ACP' | ver = 'MCP' | response = 'Y' then do
		say
		say ' 'msg.0102
		say ' 'msg.0103
		say
		l.0=0
		map = sysdrivemap('C:', 'LOCAL')
		do while map <> ''
			parse var map drive map
			say ' 'msg.0104' 'drive
			rc = sysdriveinfo(drive)
			if rc <> '' then do
				call get_fixpaks ver' 'drive
				call get_updates ver' 'drive
			end
		end
		tmpfile = bdrive'\os2\found.upc'
		'@del 'tmpfile' >nul 2>>&1'
		'@echo 'msg.0105' >> 'tmpfile
		'@echo+ >> 'tmpfile 
		found.0 = l.0-3
		do i=1 to found.0
			'@echo 'found.i' >> 'tmpfile
		end
		'@start "'msg.0106'" /f e.exe 'tmpfile' >nul 2>>&1'
		say
		say ' 'msg.0107
		say ' 'msg.0108
		say ' 'msg.0109
		say
		selected_found = 'ERROR'
		do while selected_found = 'ERROR'
			call get_selected_products 'FOUND'
			selected_found = result
		end
		if selected_found <> 'ERROR' then do
			j=1
			do while length(selected_found) > 0
				parse var selected_found i selected_found
				found.j = kind.i' 'found.i
				j=j+1
			end
			found.0 = j-1
		end
	end

return

/*********************/
/* load message file */
/*********************/
load_language: procedure expose msg.

	/* get parameters */
	parse upper arg language opt
	if language  = 'DEFAULT' then do
		language = SysIni(, 'UPDCD', 'LANG')
		if language = 'ERROR:' then language = 'ENG'
	end

	/* clear */
	'@cls'
	say
	
	/* check */
	lfile = strip(directory(), 'T', '\')||'\updcd\nls\message.'language
	if stream(lfile, 'c', 'query exists') = '' then do
		say ' Fatal error: cannot find language file: 'lfile
		say ' Did you run this script from the root directory of the CD-ROM?' 
		say ' Aborting...'
		exit 7
	end

	/* load */
	do while lines(lfile)
		l = linein(lfile)
		interpret l
	end
	call lineout lfile

	/* set ini */
	if opt <> 'NOSAVE' then call SysIni , 'UPDCD', 'LANG', language

return

/* get fixpaks */
get_fixpaks: 

		parse arg os2_version drive
    if os2_version = 'WP4' then os2_version = 'WARP4'
    if os2_version = 'WP3' then os2_version = 'WARP3'
    if os2_version = 'WSB' then os2_version = 'WSEB'
    if os2_version = 'MCP' then os2_version = 'CP'
    if os2_version = 'ACP' then os2_version = 'CP'
    go4it = 'updcd\lib\general.rlb'
    if stream(go4it, 'c', 'query exists') = '' then do
			say ' Fatal error, cannot find updcd\lib\general.rlb!'
			return
		end
		else do
			lg = bdrive'\os2\updcdltg.cmd'
	    call sysfiledelete lg
	    read = 0
	    call lineout lg, '/* rexx */'
	    call lineout lg, 'fixes="'drive'"'
	    call lineout lg, 'call find_fixpaks fixes "'os2_version' WUK"'
	    call lineout lg, 'exit'
	    do while lines(go4it)
				l = linein(go4it)
	      if pos('find_fixpaks:', l) > 0 then read = 1
	      if read = 1 & pos('return', l) > 0 then do
	      	call lineout lg, 'return'
	        read = 0
	        leave
	     	end
				if read = 1 then call lineout lg, l
			end
	    call lineout go4it
	    call lineout lg
			'@rxqueue /clear'
	    cmd=lg' 2>NUL | rxqueue 2>NUL'
	    '@'cmd
	
  	  i=l.0+1
			j=l.0+1
	    do while queued() <> 0
	    	l.i = linein("QUEUE:")
				parse var l.i num.j type.j dir.j
				num.j  = space(num.j)
				type.j = space(type.j)
				dir.j  = space(dir.j)
				kind.j = 'FIXES'
				found=0
				do k=1 to j-1
					if dir.j = dir.k then do 
						found = 1
						leave k
					end
				end
				if found = 0 then do 
					if j > 3 then do
						x = j-3
						found.x = x'.' num.j type.j dir.j
						kind.x = kind.j
					end
					j=j+1
				 end
	      i=i+1
  	  end
    	i.0 = i-1
    	call sysfiledelete lg
    	l.0 = j-1
	end

return

/* get updates */
get_updates: 

		parse arg os2_version drive
    if os2_version = 'WP4' then os2_version = 'WARP4'
    if os2_version = 'WP3' then os2_version = 'WARP3'
    if os2_version = 'WSB' then os2_version = 'WSEB'
    if os2_version = 'MCP' then os2_version = 'CP'
    if os2_version = 'ACP' then os2_version = 'CP'
    go4it = 'updcd\lib\general.rlb'
    if stream(go4it, 'c', 'query exists') = '' then do
			say ' Fatal error, cannot find updcd\lib\general.rlb!'
			return
		end
    else do
        lg = bdrive'\os2\updcdltg.cmd'
        call sysfiledelete lg
        read = 0
        call lineout lg, '/* rexx */'
        call lineout lg, 'updates="'drive'"'
        call lineout lg, 'call find_updates updates "'os2_version' WUK"'
        call lineout lg, 'exit'
        do while lines(go4it)
            l = linein(go4it)
            if pos('find_updates:', l) > 0 then read = 1
            if read = 1 & pos('return', l) > 0 then do
                call lineout lg, 'return'
                read = 0
                leave
            end
            if read = 1 then do
                call lineout lg, l
            end
        end
        call lineout go4it
        call lineout lg, 'exit'
        call lineout lg

  			'@rxqueue /clear'
        cmd=lg' 2>NUL | rxqueue 2>NUL'
        '@'cmd

  	  ii=i
			jj=j
	    do while queued() <> 0
	    	l.ii = linein("QUEUE:")
				parse var l.ii num.jj type.jj dir.jj
				num.jj  = space(num.jj)
				type.jj = space(type.jj)
				dir.jj  = space(dir.jj)
				kind.jj = 'UPDATES'
				found=0
				do kk=1 to jj-1
					if dir.jj = dir.kk then do 
						found = 1
						leave kk
					end
				end
				if found = 0 then do 
					if jj > 3 then do
						x = jj-3
						found.x = x'.' num.jj type.jj dir.jj
						kind.x = kind.jj
					end
					jj=jj+1
				 end
	      ii=ii+1
  	  end
    	ii.0 = ii-1
    	call sysfiledelete lg
    	l.0 = jj-1
    end

return

/* create directory tree */
CreateDirectoryTree: PROCEDURE

	parse arg dirToCreate
	dirToCreate = strip(dirToCreate, 'T', '\')
	tmp =  dirToCreate
	d2 = ''
	do while pos('\', tmp) > 0
		parse value tmp with d1 '\' tmp
		if substr(d1, 2, 1) = ':' then do
			d2 = d1
		end
		else do
			if substr(dirToCreate, 1, 1) = '\' then d2 = '\'d1 
			else if d2 = '' then d2 = d1
			else d2 = d2'\'d1
			if d2 <> '\' then '@mkdir 'd2' >nul 2>>&1'
		end
	end
 	'@mkdir 'd2'\'tmp' >nul 2>>&1'

return rc
