/* Install Warp Update Kit on OS/2, last modified on 06.08.2003 */

call check_rexx
call start_up
call load_rexxutil
call check_installed_components
call display_main_menu

exit

/* main menu */
display_main_menu:

	option_used = 0
	updcd_installed = 0
	key = ''
	do while (key <> 0)
	'@cls'
		say ''
		say '  *-------------------------------------------------------------------------*'
		say '  |                    Install UpdCD and the required tools                 |'
		say '  |=========================================================================|'
		say '  |                                                                         |'
		say '  |   > = Installation recommended, * = Installation done                   |'
		say '  |                                                                         |'
		say '  |   0 - Quit                                                              |'
		say '  |                                                                         |'
		say '  | 'flag1'1 - Install UpdCD                                                     |'
		say '  | 'flag2'2 - Install Virtual Floppy Disk (VFDISK)                              |'
		say '  | 'flag3'3 - Install ASPI Router                                               |'
		say '  | 'flag4'4 - Install EMX Run-Time Engine                                       |'
		say '  | 'flag5'5 - Install DANI IDE and/or FLT Drivers                               |'
		say '  | 'flag6'6 - Install CDRecord/2                                                |'
		say '  |                                                                         |'
		say '  | 'flag7'7 - Install everything I need, do not ask stupid questions            |'
		say '  |                                                                         |'
		say '  *-------------------------------------------------------------------------*'
		say

		key = ''
		do while ((key < 0) | (key > 7))
			key = SysGetKey('NOECHO')	
		end

		select
			when (key = 1) then call install_updcd
			when (key = 2) then call install_vfdisk
			when (key = 3) then call install_aspi
			when (key = 4) then call install_emx
			when (key = 5) then call install_dani
			when (key = 6) then call install_cdrecord
			when (key = 7) then call install_needed
			otherwise nop;
		end

	end

	/* inform */
	if updcd_installed = 1 | option_used = 1 then do
		say
		say '  Installation completed. Please see 'log' for details.'
	end
	if option_used = 1 then do
		say
		say '  Some of the installation options may have modified your Config.Sys.'
		say '  Please restart your computer before you use UpdCD to be sure that the'
		say '  changes have been correctly activated.'
	end
	if updcd_installed = 1 then do
		say
		say '  Do not forget to adjust the drive letter of the virtual floppy, the SCSI'
		say '  ID used by CDRecord/2 and the location of the original Warp 4 CD before'
		say '  you start the build process. If you have installed CDRecord/2 run Test'
		say '  Installation to test and finalize the installation after the reboot. It'
		say '  will also help you to find out the SCSI ID of your burner.'
	end
	if updcd_installed = 1 | option_used = 1 then do
		say
		'@pause'
	end

return

/* check installed components */
check_installed_components:
	
	say 
	say ' Checking installed software, please wait!'

	/* load config.sys */
	i=1
	found_svdisk=0
	found_vfdisk=0
	found_aspirt=0
	found_os2asp=0
	found_daniid=0
	found_danifl=0
	found_fat32f=0
	found_reserv=0
	do while lines(config)
		l.i=linein(config)
		if pos('SVDISK.SYS',    translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_svdisk=1
		if pos('VFDISK.SYS',    translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_vfdisk=1
		if pos('ASPIROUT.SYS',  translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_aspirt=1
		if pos('OS2ASPI.DMD',   translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_os2asp=1
		if pos('DANIS506.ADD',  translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_daniid=1
		if pos('DANIATAPI.FLT', translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_danifl=1
		if pos('DANIATAP.FLT',  translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_danifl=1
		if pos('FAT32.IFS',     translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then found_fat32f=1
		if pos('RESERVEDRIVELETTER=', translate(l.i)) > 0 then found_reserv=1
		i=i+1
	end
	call lineout config
	l.0=i-1

	/* check updcd */
	instdir = SysIni(, 'UPDCD', 'PATH')
	if stream(instdir'\updcd.cfg', 'c', 'query exists') = '' then flag1 = '> '
	version = SysIni(, 'UPDCD', 'VERS')
	if datatype(version) <> 'NUM' then flag1 = '> '

	/* check vdisk */
	if found_svdisk = 0 & found_vfdisk = 0 then flag2 = '> '

	/* check aspi */
	if found_aspirt = 0 then flag3 = '> '

	/* check emx */
	trace off
	'@call emxrev >nul 2>>&1'
	trace on
	if rc <> 0 then do
		flag4 = '> '
		found_emxrt = 0
	end
	else found_emxrt = 1

	/* check dani */
	if found_daniid = 0 | found_danifl = 0 then flag5 = '> '

	/* check RSJ */
	if find_rsjdir() <> '' then found_rsj = 1
	else found_rsj = 0

	/* check cdrecord */
	found_cdrec2 = 0
	if found_rsj = 0 then do
		cdrecdir = find_file('mkisofs.exe Q')
		if cdrecdir <> '' then
			if stream(cdrecdir'\cdrecord.exe', 'c', 'query exists') <> '' then found_cdrec2 = 1
			else do
				cdrecdir = find_file('cdrecord.exe Q')
				if cdrecdir <> '' & stream(cdrecdir'\mkisofs.exe', 'c', 'query exists') <> '' then found_cdrec2 = 1
			end 
	end
	if found_cdrec2 = 0 & found_rsj = 0 then flag6 = '> '

return

/* start things up */
start_up: 

	logfile = 'install.log'
	hdir    = strip(directory(), 'T', '\')
	flag1 	= '  '
	flag2 	= '  '
	flag3 	= '  '
	flag4 	= '  '
	flag5 	= '  '
	flag6 	= '  '
	flag7 	= '  '
	'@mode 80,25 >nul'
	'@ansi on >NUL'
	say '1B'x || '[36;44m'
	say '1B'x || '[1m'
	'@cls'
	say
	say ' This program will install the Warp Update Kit on your computer. Press '
	say ' ENTER to continue or CTRL-C to abort.'
	'@pause >nul'

	/* backup config.sys */
	bdrive = bootdrive()
	say
	say ' Backing up 'bdrive'\Config.Sys to 'bdrive'\Config.Wuk...'
	config = bdrive'\Config.Sys'
	'@copy 'config bdrive'\Config.Wuk >nul'

return

/*****************/
/* load rexxutil */
/*****************/
load_rexxutil:

	if RxFuncQuery('SysLoadFuncs') then do
		call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
		call SysLoadFuncs
	end

return

/********************/
/* return bootdrive */
/********************/
BootDrive: procedure

	/* first try rlanutil */
	Call RxFuncDrop 'GetBootDrive'
	Call RxFuncAdd 'GetBootDrive', 'RLANUTIL', 'GetBootDrive'
	signal on syntax name BootDrive2
	bdrv = GetBootDrive()
	signal off syntax

return bdrv

BootDrive2:

	/* try path method */
	alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
	record = value('PATH',,'OS2ENVIRONMENT')
	record = translate(record)
	os2_pos = pos(':\OS2;',record)
	if (os2_pos=0) then bootdrive='A'
	else do
            bootdrive_pos = os2_pos - 1
            bootdrive = substr(record,bootdrive_pos,1)
	end
	if  (verify(bootdrive,alphabet) <> 0) then return 'A:' /* presume A */

return bootdrive||':'

/*****************/
/* install updcd */
/*****************/
install_updcd:

	parse arg option

	/* inform */
	say '  Enter the drive and path where you want to install the Warp Update Kit.'
	say '  The installation drive needs to have at least 700MB of free space. If you'
	say '  plan to put the ISO image used to burn the new installation CD on this'
	say '  drive, more than 1GB free space is needed. Example response: c:\updcd'
	say ' '
	pull instdir
	instdir = strip(instdir, 'T', '\')

	'@dir 'instdir'\* >nul 2>>&1'
	if rc <> 0 then do
		if option <> 'Q' then do
			say
			say '  'instdir 'does not exist. Create? (Y/N)'
		end
		if option = 'Q' | (GetKeyYN(k) = 'Y') then do
			'@mkdir 'instdir' >nul 2>>&1'
			if rc <> 0 then do
				say
				say '  Cannot create 'instdir
				call Hit_Key
				return
			end
		end
		else do
			call Hit_Key
			return
		end
	end
	else do
		if instdir <> '' then do
			if option <> 'Q' then do
				say
				say '  'instdir' already exists. Overwrite? (Y/N)'
			end
			if option <> 'Q' & (GetKeyYN(k) = 'N') then do
				call Hit_Key
				return
			end
			else do
				cfgfile = instdir'\updcd.cfg'
				l.0 = 0
				if stream(cfgfile, 'c', 'query exists') <> '' then do
					i=1
					do while lines(cfgfile)
						l.i=linein(cfgfile)
						i=i+1
					end
					l.0=i-1
					call lineout cfgfile
				end
				call deldir instdir
				'@mkdir 'instdir' >nul 2>>&1'
				if l.0 > 0 then do
					do i=1 to l.0
						call lineout cfgfile, l.i
					end
					call lineout cfgfile
				end
			end
		end
		else do
			say
			say '  Please give a valide response!'
			call Hit_Key
			return
		end
	end
	/* need to know drive */
	cdir = chdir()
	instdir = chdir(instdir)
	call chdir cdir
	drive = substr(instdir, 1, 2)

	/* check free space */
	parse value SysDriveInfo(drive) with . free .
	if free = '' then do
		say
		say ' Invalid drive 'drive
		call Hit_Key
		return
	end
	if free < 734003200 then do
		say
		say '  Drive 'drive' has less than 700MB ('trunc(free/(1024*1024))'MB) of free space.'
		say '  Do you want to continue? (Y/N)'
		if option = 'Q' then option = 'X'
		if (GetKeyYN(k) = 'N') then do
			call Hit_Key
			return
		end
		if option = 'X' then option = 'Q'
	end

	/* do it */
	log = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then do
		'@echo just testing... > 'log
		if stream(log, 'c', 'query exists') = '' then log = 'nul'
		else '@del 'log
	end
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	call SysIni , 'UPDCD', 'PATH', instdir
	call SysIni , 'UPDCD', 'VERS', '200'
	say
	say '  Creating directories...'
	'@echo Starting installation on drive 'drive' > 'log
	'@echo Date/Time: 'date() time()' >> 'log
	'@echo Free disk space: 'free' bytes >> 'log
	'@mkdir 'instdir'\fixes >nul 2>>&1'
	'@mkdir 'instdir'\updates >nul 2>>&1'
	'@mkdir 'instdir'\addons >nul 2>>&1'
	rcode = 0
	say '  Copying fixes...'
	'@xcopy fixes\* 'instdir'\fixes /H/O/T/S/R/V/E  >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	if stream(instdir'\fixes\jv118fix\toolkit.exe', 'c', 'query exists') <> '' then do
		'@updcd\bin\unzip 'instdir'\fixes\jv118fix\toolkit.exe -d 'instdir'\fixes\jv118fix >> 'log' 2>>&1'
		call SysFileTree instdir||'\fixes\jv118fix\toolkit.exe', fcd.full., 'BSO',,'**---'
		if rc = 0 then '@del 'instdir'\fixes\jv118fix\toolkit.exe >> 'log' 2>>&1'
	end
	if stream(instdir'\fixes\jv118fix\samples.exe', 'c', 'query exists') <> '' then do
		'@updcd\bin\unzip 'instdir'\fixes\jv118fix\samples.exe -d 'instdir'\fixes\jv118fix >> 'log' 2>>&1'
		call SysFileTree instdir||'\fixes\jv118fix\samples.exe', fcd.full., 'BSO',,'**---'
		if rc = 0 then '@del 'instdir'\fixes\jv118fix\samples.exe >> 'log' 2>>&1'
	end
	if stream(instdir'\fixes\jv118fix\rmiiop.exe', 'c', 'query exists') <> '' then do
		'@updcd\bin\unzip 'instdir'\fixes\jv118fix\rmiiop.exe -d 'instdir'\fixes\jv118fix >> 'log' 2>>&1'
		call SysFileTree instdir||'\fixes\jv118fix\rmiiop.exe', fcd.full., 'BSO',,'**---'
		if rc = 0 then '@del 'instdir'\fixes\jv118fix\rmiiop.exe >> 'log' 2>>&1'
	end
	if stream(instdir'\fixes\jv118fix\unzip.exe', 'c', 'query exists') <> '' then do
		call SysFileTree instdir||'\fixes\jv118fix\unzip.exe', fcd.full., 'BSO',,'**---'
		if rc = 0 then '@del 'instdir'\fixes\jv118fix\unzip.exe >> 'log' 2>>&1'
	end
	say '  Copying updates...'
	'@xcopy updates\* 'instdir'\updates /H/O/T/S/R/V/E >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	say '  Copying addons...'
	'@xcopy addons\* 'instdir'\addons /H/O/T/S/R/V/E >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@xcopy updcd\* 'instdir'\. /H/O/T/S/R/V/E >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc

	/* check */
	if check_result() = 0 then do

		/* remove RO attribute */
		call SysFileTree instdir||'\*', fcd.full., 'BSO',,'**---'

		/* creating objects */
		say
		say '  Creating UpdCD objects...'
		'@echo Creating objects >> 'log
		cdir = chdir()
		call chdir instdir
		'@call install.cmd QUIET'
		call chdir cdir

		/* update flag */
		flag1 = '* '
		if option <> 'Q' then call Hit_Key
		updcd_installed = 1

	end

return

/******************/
/* install vfdisk */
/******************/
install_vfdisk:

	parse arg option

	/* check */
	if found_vfdisk = 1 then do
		say
		say '  VFDISK seems to be installed. Do you want to reinstall? (Y/N)'
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* check */
	if found_svdisk = 1 then do
		say
		say '  SVDISK seems to be installed. Do you want to install VFDISK? (Y/N)'
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	say
	say '  Installing VFDISK, please stand by...'
	'@echo Installing VFDISK >> 'log
	rcode = 0
	'@copy 'hdir'\tools\vfdisk\vfdisk.sys 'bdrive'\os2\boot\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy 'hdir'\tools\vfdisk\vfctrl.exe 'bdrive'\os2\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy 'hdir'\tools\vfdisk\vfctrlpm.exe 'bdrive'\os2\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy 'hdir'\tools\vfdisk\vfctrlpm.hlp 'bdrive'\os2\help\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc

	/* check */
	if check_result() = 0 then do

		/* handle ini and config */
		call SysIni , 'UPDCD', 'VDISK', 'VFDISK'
		if found_vfdisk = 0 & rcode = 0 then '@echo DEVICE='bdrive'\os2\boot\VFDISK.SYS 4 >> 'bdrive'\config.sys'

		/* inform */
		if found_fat32f = 1 & rcode = 0 then do
			say
			say '  It seems that you have FAT32 support installed. If VFDISK.SYS does not'
			say '  load correctly rem out the FAT32.IFS driver and reboot your computer.'
			call Hit_Key 'C'
		end
		if found_reserv = 1 & rcode = 0 then do
			say
			say '  It seems that you have reserved a drive letter using the RESERVEDRIVELETTER'
			say '  option in your Config.Sys. If VFDISK.SYS does not load correctly check if '
			say '  there is a free drive letter for VFDISK to reserve.'
			call Hit_Key 'C'
		end

	end

	/* update flag */
	if rcode = 0 then do
			flag2 = '* '
			option_used = 1
			if option <> 'Q' then call Hit_Key
	end

return

/****************/
/* install aspi */
/****************/
install_aspi:

	parse arg option

	/* check */
	if found_aspirt = 1 then do
		say
		say '  ASPI ROUTER seems to be installed. Do you want to reinstall? (Y/N)'
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	rcode = 0
	say
	say '  Installing ASPI ROUTER, please stand by...'
	'@echo Installing ASPI >> 'log
	'@copy 'hdir'\addons\16_ASPRT\ASPIROUT.SYS 'bdrive'\os2\boot\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy 'hdir'\addons\16_ASPRT\ASPIROUT.TXT 'bdrive'\os2\help\. >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc

	/* check */
	if check_result() = 0 then do

		/* handle config */
		if found_os2asp = 0 & rcode = 0 then '@echo BASEDEV=OS2ASPI.DMD /ALL >> 'bdrive'\config.sys'
		if found_aspirt = 0 & rcode = 0 then '@echo DEVICE='bdrive'\OS2\BOOT\ASPIROUT.SYS >> 'bdrive'\config.sys'

	end

	/* update flag */
	if rcode = 0 then do
		flag3 = '* '
		if option <> 'Q' then call Hit_Key
		option_used = 1
	end

return

/***************/
/* install emx */
/***************/
install_emx:

	parse arg option

	/* check */
	if found_emxrt = 1 then do
		say
		say '  EMX run-time seems to be installed. Do you want to reinstall? (Y/N)'
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	rcode = 0
	say
	say '  Installing EMX run-time, please stand by...'
	'@echo Installing EMX >> 'log
	'@xcopy 'hdir'\addons\60_EMXRT\emx\bin\*  'bdrive'\OS2\.      /H/T/O/R >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@xcopy 'hdir'\addons\60_EMXRT\emx\dll\*  'bdrive'\OS2\DLL\.  /H/T/O/R >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@xcopy 'hdir'\addons\60_EMXRT\emx\book\* 'bdrive'\OS2\BOOK\. /H/T/O/R >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@xcopy 'hdir'\addons\60_EMXRT\emx\doc\*  'bdrive'\OS2\HELP\. /H/T/O/R >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	'@copy  'hdir'\addons\60_EMXRT\emx\etc\termcap.dat  'VALUE('ETC', ,'OS2ENVIRONMENT')'\.  >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc

	/* check */
	call check_result

	/* update flag */
	if rcode = 0 then do
		flag4 = '* '
		if option <> 'Q' then call Hit_Key
		option_used = 1
	end

return

/****************/
/* install dani */
/****************/
install_dani:

	parse arg option

	/* check */
	reinstall = 0
	if found_daniid = 1 then do
		say
		say '  DANI IDE driver seems to be installed. Do you want to reinstall? (Y/N)'
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
		else reinstall = 1
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	if found_daniid = 0 | reinstall = 1 then do
		rcode = 0
		say
		say '  Installing DANI IDE driver, please stand by...'
		'@echo Installing DANI IDE >> 'log
		'@copy 'hdir'\addons\21_DNIDE\DaniS506.ADD 'bdrive'\os2\boot\. >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc
		'@copy 'hdir'\addons\21_DNIDE\DaniS506.DOC 'bdrive'\os2\help\. >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc

		/* check */
		if check_result('C') = 0 then do

			/* handle config */
			if rcode = 0 then do
				i=1
				found = 0
				do while lines(config)
					l.i=linein(config)
					if pos('IBM1S506.ADD', translate(l.i)) > 0 & word(translate(l.i), 1) <> 'REM' then do
						l.i='BASEDEV=DANIS506.ADD'
						found = 1
					end
					i=i+1
				end
				call lineout config
				l.0=i-1
				if found = 0 & found_daniid = 0 then '@echo BASEDEV=DANIS506.ADD >> 'config
				else do
					'@del 'config
					do i=1 to l.0
						call lineout config, l.i
					end
					call lineout config
				end
			end

			/* update flag */
			flag5 = '* '
			option_used = 1

		end

	end

	/* check */
	reinstall = 0
	if found_danifl = 1 then do
		say
		say '  DANI FLT driver seems to be installed. Do you want to reinstall? (Y/N)'
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
		else reinstall = 1
	end

	/* do it */
	if found_danifl = 0 | reinstall = 1 then do
		rcode = 0
		'@echo Installing DANI FLT >> 'log
		'@copy 'hdir'\addons\20_DNFLT\DaniATAP.FLT 'bdrive'\os2\boot\. >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc
		'@copy 'hdir'\addons\20_DNFLT\DaniATAP.DOC 'bdrive'\os2\help\. >> 'log' 2>>&1'
		if rc <> 0 then rcode = rc

		/* check */
		if check_result('C') = 0 then do

			/* handle config */
			if rcode = 0 then do
				found = 0
				do i=1 to l.0
					if (pos('IBMIDECD.FLT', translate(l.i)) > 0 | pos('IBMATAPI.FLT', translate(l.i)) > 0) & word(translate(l.i), 1) <> 'REM' then do
						l.i='BASEDEV=DANIATAP.FLT'
						found = 1
						leave
					end
				end
				if found = 0 & found_danifl = 0 then '@echo BASEDEV=DANIATAP.FLT >> 'config
				else do
					'@del 'config
					do i=1 to l.0
						call lineout config, l.i
					end
					call lineout config
				end

				/* update flag */
				flag5 = '* '
				option_used = 1
			end

		end

	end

	if option <> 'Q' & rcode = 0 then call Hit_Key

return

/********************/
/* install cdrecord */
/********************/
install_cdrecord:

	parse arg option

	/* check */
	if found_cdrec2 = 1 then do
		say
		say '  CDRecord/2 seems to be installed. Do you want to reinstall? (Y/N)'
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* check */
	if found_rsj = 1 then do
		say
		say '  RSJ seems to be installed. Do you want to install CDrecord/2? (Y/N)'
		if (GetKeyYN(k) = 'N') then do
			if option <> 'Q' then call Hit_Key
			return
		end
	end

	/* do it */
	instdir = SysIni(, 'UPDCD', 'PATH')
	log     = instdir'\'logfile
	if stream(log, 'c', 'query exists') = '' then log = 'nul'
	'@echo Start logging 'date() time()': >> 'log' 2>>nul'
	rcode = 0
	say
	say '  Installing CDRecord/2, please stand by...'
	'@echo Installing CDRecord >> 'log
	'@mkdir 'bdrive'\cdrec2 >> 'log' 2>>&1'
	'@xcopy 'hdir'\addons\63_CDREC\* 'bdrive'\cdrec2\. /E/V/S/H/O/T/R >> 'log' 2>>&1'
	if rc <> 0 then rcode = rc
	call create_icons "CDRecord/2 <WP_DESKTOP> <CDREC2> "bdrive"\cdrec2"
	'@del 'bdrive'\cdrec2\test.cmd >> 'log' 2>>&1'
	call create_test_program bdrive"\cdrec2\test.cmd"
	call SysCreateObject 'WPProgram', 'Command Prompt', '<CDREC2>', 'EXENAME=CMD.EXE;PARAMETERS=/K "MODE CO80,102";STARTUPDIR='bdrive'\cdrec2;', 'R'
	call SysCreateObject "WPProgram", "Test Installation ^ (start here)", "<CDREC2>", "EXENAME="bdrive"\cdrec2\test.cmd", "R"

	/* check */
	if check_result() = 0 then do

		/* handle config */
		if rcode = 0 then do
			i=1
			found = 0
			do while lines(config)
				l.i=linein(config)
				if pos('SET PATH=', translate(l.i)) > 0 & pos('\CDREC2', translate(l.i)) = 0 then do
					lpos = length(l.i)
					if substr(l.i, lpos) = ';' then l.i = l.i || bdrive'\cdrec2;'
					else l.i = l.i || ';' || bdrive'\cdrec2;'
					found = 1
				end
				i=i+1
			end
			call lineout config
			l.0=i-1
			if found = 1 then do
				'@del 'config
				do i=1 to l.0
					call lineout config, l.i
				end
				call lineout config
			end
		end

	end
	
	/* update flag */
	if rcode = 0 then do
		flag6 = '* '
		if option <> 'Q' then call Hit_Key
		option_used = 1
	end

return

/******************/
/* install needed */
/******************/
install_needed:

	if flag1 = '> ' then call install_updcd 'Q'
	if flag2 = '> ' then call install_vfdisk 'Q'
	if flag3 = '> ' then call install_aspi 'Q'
	if flag4 = '> ' then call install_emx 'Q'
	if flag5 = '> ' then call install_dani 'Q'
	if flag6 = '> ' then call install_cdrecord 'Q'

	/* update flag */
	flag7 = '* '
	call Hit_Key

return

/**********************/
/* check rexx version */
/**********************/
check_rexx:

	Parse Version . Level .
	If Level > 4.00 Then do
		say
		say 'ObjectREXX detected. UpdCD does not support it at this time. Please'
		say 'swith to classic REXX using SWITCHRX.CMD and run this script again.'
		exit 8
	end

return

/*************************************************************/
/* chdir: drive and path aware directory() replacement       */
/*        returns the current dir without trailing backslash */
/*************************************************************/
chdir: procedure

	parse upper arg dr                /* get target dir        */

	if length(dr) > 1 then dr = strip(dr, 'T', '\')
	cdir = directory()                /* get current dir       */
	if substr(dr, 2, 1) = ':' then do /* absolute path         */
		drive = substr(dr, 1, 2)
		rc = directory(drive)           /* change to drive       */
		if substr(rc, 1, 2) <> drive then 
			return strip(directory(cdir), 'T', '\')
		rc = directory('\')             /* change to root        */
		rc = directory(substr(dr, 3))   /* change to path        */
		if strip(rc, 'T', '\') <> dr then 
			return strip(directory(cdir), 'T', '\')
	end
	else do
		return strip(directory(dr), 'T', '\')  /* relative path  */
	end

return strip(directory(), 'T', '\') /* return current dir    */

/***********************************/
/* A simple Y/N keypress procedure */
/***********************************/
GetKeyYN: procedure expose option

	if option = 'Q' then return 'X'
	do while ((key1 <> 'Y') & (key1 <> 'N'))
		key1 = SysGetKey('NOECHO')
		parse upper var key1 key1
	end
	say

return key1

/***********/
/* hit key */
/***********/
Hit_Key: procedure

	parse arg option

	if (option = 'C') then prompt = 'continue.'
	else prompt = 'return to the menu.'

	say '  Hit any Key to 'prompt
	call SysGetKey 'NOECHO'

return

/****************/
/* check result */
/****************/
check_result: 

	parse arg opt
	say
	if rcode <> 0 then do
		say '  One or more errors were detected during installation.'
		say '  Please see the 'log' file for more information.'
		call Hit_Key opt
		return 1
	end
	else say '  Completed'.

return rcode

/**********************************************************/
/* Find out if user has RSJ cdwriter system installed 		  */
/* do this by checking the class list for CDWRITER class 	*/
/**********************************************************/
find_rsjdir: procedure

	rsjdir = ''
	call SysQueryClassList 'junk.'
	i = 1
	do i=1 to junk.0
  tmp = translate(word(junk.i, 1))
  if (tmp = 'CDWRITER') then do /* We found the rsj CDWRITER class */
			tmp = word(junk.i, 2)
			rsjdir = substr(tmp, 1, lastpos('\', tmp )-1)
   leave
		end
	end

return rsjdir

/*************/
/* find file */
/*************/
find_file: procedure

	parse upper arg file_to_find option
	if option <> 'Q' then call lineout , 'Locating 'file_to_find||'. '
	find. = ''

	/* find in path */
	if option <> 'Q' then call lineout , 'Searching PATH...'
	find.1 = SysSearchPath('PATH', file_to_find)

	parse value SysCurPos() with row col
	if find.1 = '' then do
		/* find on drives */
		drives = SysDriveMap('C:', 'LOCAL')
		if option <> 'Q' then call charout , 'Searching drive'
		insertSpot = col + 16 /* that's the length of 'Searching drive' + 1 */
		do while length(drives) > 0
			parse var drives drv drives
			if option <> 'Q' then do
 			 	call SysCurPos row, insertSpot
				call charout , drv
			end
			rc = sysdriveinfo(drv)
			if rc <> '' then do
				call sysfiletree drv'\'file_to_find, 'find.', 'FSO'
				if find.0 > 0 then leave
			end
		end
	end

	if find.1 = '' & option <> 'Q' then do
		say 'Failed!'
		say 'Could not find file 'file_to_find' on this system.'
	End 
	Else Do
		if find.1 <> '' then find.1 = substr(find.1, 1, lastpos('\', find.1)-1)
		if option <> 'Q' then do
			call SysCurPos row, col
			call charout , left('', 18 )  /* erase the text first */
			call SysCurPos row, col
			call charout , 'Found! - '
			say find.1
		end
	End

return find.1

/*************************/
/* create cdrecord icons */
/*************************/
create_icons: procedure expose log

	parse arg title pid fid path
	call lineout log, "Creating objects: "title pid fid path
	call lineout log
	call SysCreateObject "WPFolder", title, pid, "OBJECTID="fid";ICONVIEW=FLOWED,NORMAL;", "R"
	call sysfiletree path'\*', 'file.'
	do i=1 to file.0
		parse var file.i . . size attrib sdir rest
		/* create folder */
		if size = 0 & substr(attrib, 2, 1) = 'D' then do
			title = filespec('name', sdir)
			subfid = "<CDREC2_"title">"
			call create_icons title fid subfid sdir
		end
		/* create icon */
		else do
			title = filespec('name', sdir)
			ext = translate(substr(title, lastpos('.', title)+1))
			if ext = 'EXE' then do
				found=0
				do while lines(sdir)
					l=linein(sdir)
					if pos('emx.exe', l) > 0 then do
						found=1
						leave;
					end
				end
				call lineout sdir
				if found=1 then call SysCreateObject 'WPProgram', title, fid, 'EXENAME=CMD.EXE;PARAMETERS=/K "MODE CO80,102 & 'sdir'";STARTUPDIR='filespec('drive', sdir)||filespec('path', sdir)';NOAUTOCLOSE=YES', 'R'
				else call SysCreateObject 'WPProgram', title, fid, 'EXENAME='sdir';STARTUPDIR='filespec('drive', sdir)||filespec('path', sdir), 'R'
			end
			else if ext = 'BAT' | ext = 'CMD' then 
				call SysCreateObject 'WPProgram', title, fid, 'EXENAME=CMD.EXE;PARAMETERS=/K "MODE CO80,102 & 'sdir'";STARTUPDIR='filespec('drive', sdir)||filespec('path', sdir)';NOAUTOCLOSE=YES', 'R'
			else if ext = 'HTM' | ext = 'HTML' then
				call SysCreateObject "WPUrl", title, fid, "NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=file:///"translate(translate(sdir,"|",":"), "/", "\")";", "R"
			else
				call SysCreateObject "WPProgram", title, fid, "EXENAME=e.exe;PARAMETERS="sdir";", "R"
		end
	end

return

/*******************************/
/* create cdrecord testprogram */
/*******************************/
create_test_program: procedure expose bdrive
	
	parse arg outfile

	line.1 = "/* Check CDRecord installation */"
	line.2 = " "
	line.3 = "'@cls'"
	line.4 = "f='temp.cdr'"
	line.5 = "say"
	line.6 = "say 'This program will check the installation of CDRecord/2.'"
	line.7 = "say"
	line.8 = "say 'Running command: "bdrive"\cdrec2\cdrecord.exe -scanbus'"
	line.9 = "'@"bdrive"\cdrec2\cdrecord.exe -scanbus > 'f"
	line.10 = "l=linein(f)"
	line.11 = "if length(l) = 0 then do"
	line.12 = "	say 'Cannot run cdrecord.exe, check if EMX installed!'"
	line.13 = "	pause"
	line.14 = "	exit 1"
	line.15 = "end"
	line.16 = "parse var l w1 w2 ."
	line.17 = "say 'Detected CDRecord/2 version: 'w2"
	line.18 = " "
	line.19 = "say"
	line.20 = "say 'Detected SCSI devices:'"
	line.21 = "l=linein(f)"
	line.22 = "do while lines(f)"
	line.23 = "	l=linein(f)"
	line.24 = "	if pos('*', l) = 0 & pos('scsibus', l) = 0 then say l"
	line.25 = "end"
	line.26 = "call lineout f"
	line.27 = "'@del 'f"
	line.28 = " "
	line.29 = "say"
	line.30 = "say 'Please enter the SCSI ID of the device you want to use with CDRecord/2'"
	line.31 = "say 'and press ENTER. If you do not see your device check if you load the'"
	line.32 = "say 'appropriate SCSI driver in your config.sys. Check if ASPI router is'"
	line.33 = "say 'installed. If you use an IDE device check if DANI ATAPI and DANI IDE'"
	line.34 = "say 'are installed. Example SCSI ID response: 0,1,0'"
	line.35 = "response = ''"
	line.36 = "do while length(response) <> 5"
	line.37 = "	pull response"
	line.38 = "	if length(response) <> 5 then say 'Invalide response, try again!'"
	line.39 = "end"
	line.40 = " "
	line.41 = "say"
	line.42 = "say 'Creating sample command files...'"
	line.43 = "call rxfuncadd syscreateobject, rexxutil, syscreateobject"
	line.44 = " "
	line.45 = "f = 'image.cmd'"
	line.46 = "'@del 'f' >nul 2>>&1'"
	line.47 = "call lineout f, '/* create image file */'"
	line.48 = "call lineout f, ' '"
	line.49 = "call lineout f, ""'@cls'"""
	line.50 = "call lineout f, ""say"""
	line.51 = "call lineout f, ""say 'This program will create an ISO image on your hard disk.'"""
	line.52 = "call lineout f, ""say 'Specify a directory which should be imaged.'"""
	line.53 = "call lineout f, ""say 'Example: d:\burn'"""
	line.54 = "call lineout f, ""say"""
	line.55 = "call lineout f, ""pull directory"""
	line.56 = "call lineout f, ' '"
	line.57 = "call lineout f, ""rawfile = filespec('name', directory)'.raw'"""
	line.58 = "call lineout f, ""'@""directory()""\mkisofs -l -L -R -o 'rawfile directory"""
	line.59 = "call lineout f, ""say 'Image file 'rawfile' created with return code 'rc"""
	line.60 = "call lineout f, "" """
	line.61 = "call lineout f, ""exit"""
	line.62 = "call lineout f"
	line.63 = " "
	line.64 = "f = 'burn.cmd'"
	line.65 = "'@del 'f' >nul 2>>&1'"
	line.66 = "call lineout f, '/* burn CD */'"
	line.67 = "call lineout f, ' '"
	line.68 = "call lineout f, ""'@cls'"""
	line.69 = "call lineout f, ""say"""
	line.70 = "call lineout f, ""say 'This program will burn a CD from an ISO image on your hard disk.'"""
	line.71 = "call lineout f, ""say 'Specify the image file which should be used.'"""
	line.72 = "call lineout f, ""say 'Example: d:\burn\cd.raw'"""
	line.73 = "call lineout f, ""say"""
	line.74 = "call lineout f, ""pull rawfile"""
	line.75 = "call lineout f, ' '"
	line.76 = "call lineout f, ""device = '""response""'"""
	line.77 = "call lineout f, ""speed = '2'"""
	line.78 = "call lineout f, ""say """
	line.79 = "call lineout f, ""say 'Burning CD using image file 'rawfile' on device 'device' with 'speed' speed.'"""
	line.80 = "call lineout f, ""'@""directory()""\cdrecord dev='device' speed='speed' -v -eject -pad -data 'rawfile"""
	line.81 = "call lineout f, ""say 'The CD-ROM has been created with return code 'rc"""
	line.82 = "call lineout f, ' '"
	line.83 = "call lineout f, ""exit"""
	line.84 = "call lineout f"
	line.85 = " "
	line.86 = "call SysCreateObject 'WPProgram', 'Burn CD-ROM (step 2)', '<CDREC2>', 'EXENAME='directory()'\burn.cmd;NOAUTOCLOSE=YES', 'R'"
	line.87 = "call SysCreateObject 'WPProgram', 'Create image (step 1)', '<CDREC2>', 'EXENAME='directory()'\image.cmd;NOAUTOCLOSE=YES', 'R'"
	line.88 = "say 'Done! Press ENTER to exit.'"
	line.89 = "pull response"
	line.90 = " "
	line.91 = "exit"
	line.92 = " "

	do i=1 to 92
		call lineout outfile, line.i
	end

return

/**************************************************/
/* delete directory structure including all files */
/* skip ea data.sf and root directory (e.g. c:)   */
/**************************************************/
DelDir: procedure

	parse upper arg Directory
	DirSpec = Directory'\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
		if pos('EA DATA. SF', Files.i) = 0 then do
			'@del "'Files.i'"'
			if rc <> 0 then say 'Error: @del 'Files.i' rc='rc
		end
 end

	/* delete directory */
	cdir1 = translate(chdir())
	cdir2 = translate(chdir(Directory))
	call chdir '\'
	cdir1 = chdir(cdir1)
	if pos(Directory, cdir2) > 0 & cdir2 <> cdir1 & substr(Directory, 2) <> ':' then do
		'@rmdir "'Directory'"'
		if rc <> 0 then say 'Error: @rmdir 'Directory' rc='rc
	end

return
