/********************************************************copyrite.xmc***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This module is "Restricted Materials of IBM":                     */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1991.                        */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/********************************************************copyrite.xmc***/
/*
 *     This product contains:
 *              "Restricted Materials of IBM"
 *              (c) Copyright IBM Corp. 1987
 *              All Rights Reserved
 *              Licensed Materials-Property of IBM
 *
 *     See Copyright Instructions, G120-2083
 *
 * $Header:   T:/tcp12vcs/pgmgkit/src/tcphdr32/include/rpc/xdr.h_v   1.2   24 Feb 1993 18:03:00   MCGARVEY  $
 *
 * $Log:   T:/tcp12vcs/pgmgkit/src/tcphdr32/include/rpc/xdr.h_v  $
 * 
 *    Rev 1.2   24 Feb 1993 18:03:00   MCGARVEY
 * fixes for 3/93 CSD
 *
 *    Rev 1.0   22 Dec 1988 13:56:26   Philip Shafer/2
 * Initial revision.
 *
 * @(#)xdr.h    1.1 87/11/04 3.9 RPCSRC
 *
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 *
 *      @(#)xdr.h 1.19 87/04/22 SMI
 *
 * xdr.h, External Data Representation Serialization Routines.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 *
 * XDR provides a conventional way for converting between C data
 * types and an external bit-string representation.  Library supplied
 * routines provide for the conversion on built-in C data types.  These
 * routines and utility routines defined here are used to help implement
 * a type encode/decode routine for each user-defined type.
 *
 * Each data type provides a single procedure which takes two arguments:
 *
 *      bool_t
 *      xdrproc(xdrs, argresp)
 *              XDR *xdrs;
 *              <type> *argresp;
 *
 * xdrs is an instance of a XDR handle, to which or from which the data
 * type is to be converted.  argresp is a pointer to the structure to be
 * converted.  The XDR handle contains an operation field which indicates
 * which of the operations (ENCODE, DECODE * or FREE) is to be performed.
 *
 * XDR_DECODE may allocate space if the pointer argresp is null.  This
 * data can be freed with the XDR_FREE operation.
 *
 * We write only one procedure per data type to make it easy
 * to keep the encode and decode procedures for a data type consistent.
 * In many cases the same code performs all operations on a user defined type,
 * because all the hard work is done in the component type routines.
 * decode as a series of calls on the nested data types.
 */
#ifndef RPC_XDR_H
#define RPC_XDR_H
#ifndef __32BIT__
#define _Packed
#define _Seg16
#define _Far16
#define _Cdecl
#endif


/*
 * Xdr operations.  XDR_ENCODE causes the type to be encoded into the
 * stream.  XDR_DECODE causes the type to be extracted from the stream.
 * XDR_FREE can be used to release the space allocated by an XDR_DECODE
 * request.
 */
enum xdr_op {
        XDR_ENCODE=0,
        XDR_DECODE=1,
        XDR_FREE=2
#ifdef __32BIT__
        , XDR_DUMMY=32767
#endif
};

/*
 * This is the number of bytes per unit of external data.
 */
#define BYTES_PER_XDR_UNIT      (4)
#define RNDUP(x)  ((((x) + BYTES_PER_XDR_UNIT - 1) / BYTES_PER_XDR_UNIT) \
                    * BYTES_PER_XDR_UNIT)

/*
 * A xdrproc_t exists for each data type which is to be encoded or decoded.
 *
 * The second argument to the xdrproc_t is a pointer to an opaque pointer.
 * The opaque pointer generally points to a structure of the data type
 * to be decoded.  If this pointer is 0, then the type routines should
 * allocate dynamic storage of the appropriate size and return it.
 * bool_t       (*xdrproc_t)(XDR *, caddr_t *);
 */

/*
 * The XDR handle.
 * Contains operation which is being applied to the stream,
 * an operations vector for the paticular implementation (e.g. see xdr_mem.c),
 * and two private fields for the use of the particular impelementation.
 */
typedef _Packed struct _XDR {
        enum xdr_op     x_op;           /* operation; fast additional param */
        struct xdr_ops {
                bool_t  (* _Seg16 _Far16 _Cdecl x_getlong)(_Packed struct _XDR * _Seg16,void * _Seg16); /* get a long from underlying stream */
                bool_t  (* _Seg16 _Far16 _Cdecl x_putlong)(_Packed struct _XDR * _Seg16,void * _Seg16); /* put a long to " */
                bool_t  (* _Seg16 _Far16 _Cdecl x_getbytes)(_Packed struct _XDR * _Seg16,void * _Seg16,short);/* get some bytes from " */
                bool_t  (* _Seg16 _Far16 _Cdecl x_putbytes)(_Packed struct _XDR * _Seg16,void * _Seg16,short);/* put some bytes to " */
                u_int   (* _Seg16 _Far16 _Cdecl x_getpostn)(_Packed struct _XDR * _Seg16);/* returns bytes off from beginning */
                bool_t  (* _Seg16 _Far16 _Cdecl x_setpostn)(_Packed struct _XDR * _Seg16,unsigned short);/* lets you reposition the stream */
                long * _Seg16 (* _Seg16 _Far16 _Cdecl x_inline)(_Packed struct _XDR * _Seg16,short);  /* buf quick ptr to buffered data */
                void    (* _Seg16 _Far16 _Cdecl x_destroy)(_Packed struct _XDR * _Seg16,short); /* free privates of this xdr_stream */
        } * _Seg16 x_ops;
        char * _Seg16   x_public;       /* users' data */
        char * _Seg16   x_private;      /* pointer to private data */
        char * _Seg16   x_base;         /* private used for position info */
        short           x_handy;        /* extra private word */
} XDR;

#ifdef __32BIT__
#pragma checkout(suspend)
#endif
typedef bool_t (* _Seg16 _Far16 _Cdecl xdrproc_t)();
#ifdef __32BIT__
#pragma checkout(resume)
#endif
/*
 * Operations defined on a XDR handle
 *
 * XDR          *xdrs;
 * long         *longp;
 * caddr_t       addr;
 * u_int         len;
 * u_int         pos;
 */
#define XDR_GETLONG(xdrs, longp)                        \
        (*(xdrs)->x_ops->x_getlong)(xdrs, longp)
#define xdr_getlong(xdrs, longp)                        \
        (*(xdrs)->x_ops->x_getlong)(xdrs, longp)

#define XDR_PUTLONG(xdrs, longp)                        \
        (*(xdrs)->x_ops->x_putlong)(xdrs, longp)
#define xdr_putlong(xdrs, longp)                        \
        (*(xdrs)->x_ops->x_putlong)(xdrs, longp)

#define XDR_GETBYTES(xdrs, addr, len)                   \
        (*(xdrs)->x_ops->x_getbytes)(xdrs, addr, len)
#define xdr_getbytes(xdrs, addr, len)                   \
        (*(xdrs)->x_ops->x_getbytes)(xdrs, addr, len)

#define XDR_PUTBYTES(xdrs, addr, len)                   \
        (*(xdrs)->x_ops->x_putbytes)(xdrs, addr, len)
#define xdr_putbytes(xdrs, addr, len)                   \
        (*(xdrs)->x_ops->x_putbytes)(xdrs, addr, len)

#define XDR_GETPOS(xdrs)                                \
        (*(xdrs)->x_ops->x_getpostn)(xdrs)
#define xdr_getpos(xdrs)                                \
        (*(xdrs)->x_ops->x_getpostn)(xdrs)

#define XDR_SETPOS(xdrs, pos)                           \
        (*(xdrs)->x_ops->x_setpostn)(xdrs, pos)
#define xdr_setpos(xdrs, pos)                           \
        (*(xdrs)->x_ops->x_setpostn)(xdrs, pos)

#define XDR_INLINE(xdrs, len)                           \
        (*(xdrs)->x_ops->x_inline)(xdrs, len)
#define xdr_inline(xdrs, len)                           \
        (*(xdrs)->x_ops->x_inline)(xdrs, len)

#define XDR_DESTROY(xdrs)                               \
        if ((xdrs)->x_ops->x_destroy)                   \
                (*(xdrs)->x_ops->x_destroy)(xdrs)
#define xdr_destroy(xdrs)                               \
        if ((xdrs)->x_ops->x_destroy)                   \
                (*(xdrs)->x_ops->x_destroy)(xdrs)

/*
 * Support struct for discriminated unions.
 * You create an array of xdrdiscrim structures, terminated with
 * a entry with a null procedure pointer.  The xdr_union routine gets
 * the discriminant value and then searches the array of structures
 * for a matching value.  If a match is found the associated xdr routine
 * is called to handle that part of the union.  If there is
 * no match, then a default routine may be called.
 * If there is no match and no default routine it is an error.
 */
#define NULL_xdrproc_t ((xdrproc_t)0)
_Packed struct xdr_discrim {
        short   value;
        xdrproc_t proc;
};

/*
 * In-line routines for fast encode/decode of primitve data types.
 * Caveat emptor: these use single memory cycles to get the
 * data from the underlying buffer, and will fail to operate
 * properly if the data is not aligned.  The standard way to use these
 * is to say:
 *      if ((buf = XDR_INLINE(xdrs, count)) == NULL)
 *              return (FALSE);
 *      <<< macro calls >>>
 * where ``count'' is the number of bytes of data occupied
 * by the primitive data types.
 *
 * N.B. and frozen for all time: each data type here uses 4 bytes
 * of external representation.
 */
#define IXDR_GET_LONG(buf)              ((long)ntohl((u_long)*(buf)++))
#define IXDR_PUT_LONG(buf, v)           (*(buf)++ = (long)htonl((u_long)v))

#define IXDR_GET_BOOL(buf)              ((bool_t)IXDR_GET_LONG(buf))
#define IXDR_GET_ENUM(buf, t)           ((t)IXDR_GET_LONG(buf))
#define IXDR_GET_U_LONG(buf)            ((u_long)IXDR_GET_LONG(buf))
#define IXDR_GET_SHORT(buf)             ((short)IXDR_GET_LONG(buf))
#define IXDR_GET_U_SHORT(buf)           ((u_short)IXDR_GET_LONG(buf))

#define IXDR_PUT_BOOL(buf, v)           IXDR_PUT_LONG((buf), ((long)(v)))
#define IXDR_PUT_ENUM(buf, v)           IXDR_PUT_LONG((buf), ((long)(v)))
#define IXDR_PUT_U_LONG(buf, v)         IXDR_PUT_LONG((buf), ((long)(v)))
#define IXDR_PUT_SHORT(buf, v)          IXDR_PUT_LONG((buf), ((long)(v)))
#define IXDR_PUT_U_SHORT(buf, v)        IXDR_PUT_LONG((buf), ((long)(v)))

/*
 * These are the "generic" xdr routines.
 */
#if 0
extern bool_t   xdr_void();
extern bool_t   xdr_int();
extern bool_t   xdr_u_int();
extern bool_t   xdr_long();
extern bool_t   xdr_u_long();
extern bool_t   xdr_short();
extern bool_t   xdr_u_short();
extern bool_t   xdr_bool();
extern bool_t   xdr_enum();
extern bool_t   xdr_array();
extern bool_t   xdr_bytes();
extern bool_t   xdr_opaque();
extern bool_t   xdr_string();
extern bool_t   xdr_union();
extern bool_t   xdr_char();
extern bool_t   xdr_u_char();
extern bool_t   xdr_vector();
extern bool_t   xdr_float();
extern bool_t   xdr_double();
extern bool_t   xdr_reference();
extern bool_t   xdr_pointer();
extern bool_t   xdr_wrapstring();
#endif

/*
 * Common opaque bytes objects used by many rpc protocols;
 * declared here due to commonality.
 */
#define MAX_NETOBJ_SZ 1024
_Packed struct netobj {
        u_short n_len;
        char    * _Seg16 n_bytes;
};
typedef _Packed struct netobj netobj;

/*
 * These are the public routines for the various implementations of
 * xdr streams.
 */
#ifdef __32BIT__
#pragma linkage(xdr_accepted_reply,far16 cdecl)
#pragma linkage(xdr_array,far16 cdecl)
#pragma linkage(xdr_bool,far16 cdecl)
#pragma linkage(xdr_bytes,far16 cdecl)
#pragma linkage(xdr_callhdr,far16 cdecl)
#pragma linkage(xdr_callmsg,far16 cdecl)
#pragma linkage(xdr_char,far16 cdecl)
#pragma linkage(xdr_deskey,far16 cdecl)
#pragma linkage(xdr_double,far16 cdecl)
#pragma linkage(xdr_enum,far16 cdecl)
#pragma linkage(xdr_float,far16 cdecl)
#pragma linkage(xdr_free,far16 cdecl)
#pragma linkage(xdr_int,far16 cdecl)
#pragma linkage(xdr_long,far16 cdecl)
#pragma linkage(xdr_netobj,far16 cdecl)
#pragma linkage(xdr_opaque,far16 cdecl)
#pragma linkage(xdr_opaque_auth,far16 cdecl)
#pragma linkage(xdr_pointer,far16 cdecl)
#pragma linkage(xdr_reference,far16 cdecl)
#pragma linkage(xdr_rejected_reply,far16 cdecl)
#pragma linkage(xdr_replymsg,far16 cdecl)
#pragma linkage(xdr_short,far16 cdecl)
#pragma linkage(xdr_string,far16 cdecl)
#pragma linkage(xdr_u_char,far16 cdecl)
#pragma linkage(xdr_u_int,far16 cdecl)
#pragma linkage(xdr_u_long,far16 cdecl)
#pragma linkage(xdr_u_short,far16 cdecl)
#pragma linkage(xdr_union,far16 cdecl)
#pragma linkage(xdr_vector,far16 cdecl)
#pragma linkage(xdr_void,far16 cdecl)
#pragma linkage(xdr_wrapstring,far16 cdecl)
#pragma linkage(xdrmem_create,far16 cdecl)
#pragma linkage(xdrrec_create,far16 cdecl)
#pragma linkage(xdrrec_endofrecord,far16 cdecl)
#pragma linkage(xdrrec_eof,far16 cdecl)
#pragma linkage(xdrrec_skiprecord,far16 cdecl)
#pragma linkage(xdrstdio_create,far16 cdecl)
#endif
bool_t   xdr_accepted_reply(XDR * , void * );
bool_t   xdr_array(XDR * , char *  * , u_short * , u_short, u_short, xdrproc_t);
bool_t   xdr_bool(XDR * , short * );
bool_t   xdr_bytes(XDR * , char * *, u_short * , u_long);
bool_t   xdr_callhdr( XDR * , void * );
bool_t   xdr_callmsg(XDR * , void * );
bool_t   xdr_char( XDR * , char * );
bool_t   xdr_deskey(XDR * , void * );
bool_t   xdr_double(XDR * , double * );
bool_t   xdr_enum(XDR * ,void * );
bool_t   xdr_float(  XDR * , float * );
bool_t   xdr_int( XDR * , short * );
bool_t   xdr_long(XDR * , long * );
bool_t   xdr_netobj( XDR * , _Packed struct netobj * );
bool_t   xdr_opaque(XDR * , void * , u_long);
bool_t   xdr_opaque_auth(XDR * , void * );
bool_t   xdr_pointer(XDR * , char * * , u_short, xdrproc_t);
bool_t   xdr_reference(XDR * , void *  * , u_short, xdrproc_t);
bool_t   xdr_rejected_reply(XDR * , void * );
bool_t   xdr_replymsg(XDR * , void * );
bool_t   xdr_short(XDR * , short * );
bool_t   xdr_string(XDR * ,char * * , u_long);
bool_t   xdr_u_char( XDR * , u_char * );
bool_t   xdr_u_int( XDR * , u_short * );
bool_t   xdr_u_long(XDR * ,u_long * );
bool_t   xdr_u_short(XDR * , u_short * );
bool_t   xdr_union(XDR * , enum_t * , char * , _Packed struct xdr_discrim * , xdrproc_t);
bool_t   xdr_vector(XDR * , char * , u_short, u_short, xdrproc_t);
bool_t   xdr_void(void);
bool_t   xdr_wrapstring( XDR * , char * * );
bool_t   xdrrec_endofrecord( XDR * , bool_t);
bool_t   xdrrec_eof( XDR * );
bool_t   xdrrec_skiprecord( XDR * );
void     xdrmem_create(XDR *,void *,u_short,enum xdr_op);          /* XDR using memory buffers */
void     xdrstdio_create(XDR *,void *,enum xdr_op);        /* XDR using stdio library */
void   xdr_free( xdrproc_t , void * );
void   xdrrec_create(XDR * , u_short,u_short, char * , short (*  )(void *,short,short), short (*  )(void *,void *,short));
#ifdef __32BIT__
#pragma checkout(suspend)
short _Far16 _Cdecl registerrpc(unsigned long, unsigned long, unsigned long,
  void * _Seg16 (* _Seg16 _Far16 _Cdecl myproc)(),
  xdrproc_t,
  xdrproc_t);
#pragma checkout(resume)
#else
short _Far16 _Cdecl registerrpc();
#endif
#endif /* RPC_XDR_H */
