/********************************************************copyrite.xmc***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This module is "Restricted Materials of IBM":                     */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1991.                        */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/********************************************************copyrite.xmc***/
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*      @(#)svc.h 1.1 86/02/03 SMI      *

/*
 * svc.h, Server-side remote procedure call interface.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */
#ifndef INCL_RPC_SVC_H
#define INCL_RPC_SVC_H
#ifndef __32BIT__
#define _Packed
#define _Seg16
#define _Far16
#define _Cdecl
#endif

/*
 * This interface must manage two items concerning remote procedure calling:
 *
 * 1) An arbitrary number of transport connections upon which rpc requests
 * are received.  The two most notable transports are TCP and UDP;  they are
 * created and registered by routines in svc_tcp.c and svc_udp.c, respectively;
 * they in turn call xprt_register and xprt_unregister.
 *
 * 2) An arbitrary number of locally registered services.  Services are
 * described by the following four data: program number, version number,
 * "service dispatch" function, a transport handle, and a boolean that
 * indicates whether or not the exported program should be registered with a
 * local binder service;  if true the program's number and version and the
 * port number from the transport handle are registered with the binder.
 * These data are registered with the rpc svc system via svc_register.
 *
 * A service's dispatch function is called whenever an rpc request comes in
 * on a transport.  The request's program and version numbers must match
 * those of the registered service.  The dispatch function is passed two
 * parameters, struct svc_req * and SVCXPRT *, defined below.
 */

enum xprt_stat {
        XPRT_DIED,
        XPRT_MOREREQS,
        XPRT_IDLE
#ifdef __32BIT__
        , XPRT_DUMMY=32767
#endif
};

/*
 * Server side transport handle
 */
typedef _Packed struct {
        short           xp_sock;
        u_short         xp_port;         /* associated port number */
        struct xp_ops {
            bool_t      (* _Seg16 _Far16 _Cdecl xp_recv)(void * _Seg16,void * _Seg16);    /* receive incomming requests */
            enum xprt_stat (* _Seg16 _Far16 _Cdecl xp_stat)(void * _Seg16); /* get transport status */
            bool_t      (* _Seg16 _Far16 _Cdecl xp_getargs)(void * _Seg16,xdrproc_t,void * _Seg16); /* get arguments */
            bool_t      (* _Seg16 _Far16 _Cdecl xp_reply)(void * _Seg16,void * _Seg16);   /* send reply */
            bool_t      (* _Seg16 _Far16 _Cdecl xp_freeargs)(void * _Seg16,xdrproc_t,void * _Seg16);/* free mem allocated for args */
            void        (* _Seg16 _Far16 _Cdecl xp_destroy)(void * _Seg16); /* destroy this struct */
        } * _Seg16 xp_ops;
        short           xp_addrlen;      /* length of remote address */
        struct sockaddr_in xp_raddr;     /* remote address */
        _Packed struct opaque_auth xp_verf;      /* raw response verifier */
        char * _Seg16   xp_p1;           /* private */
        char * _Seg16   xp_p2;           /* private */
} SVCXPRT;

/*
 *  Approved way of getting address of caller
 */
#define svc_getcaller(x) (&(x)->xp_raddr)

/*
 * Operations defined on an SVCXPRT handle
 *
 * SVCXPRT              *xprt;
 * struct rpc_msg       *msg;
 * xdrproc_t             xargs;
 * caddr_t               argsp;
 */
#define SVC_RECV(xprt, msg)                             \
        (*(xprt)->xp_ops->xp_recv)((xprt), (msg))
#define svc_recv(xprt, msg)                             \
        (*(xprt)->xp_ops->xp_recv)((xprt), (msg))

#define SVC_STAT(xprt)                                  \
        (*(xprt)->xp_ops->xp_stat)(xprt)
#define svc_stat(xprt)                                  \
        (*(xprt)->xp_ops->xp_stat)(xprt)

#define SVC_GETARGS(xprt, xargs, argsp)                 \
        (*(xprt)->xp_ops->xp_getargs)((xprt), (xargs), (argsp))
#define svc_getargs(xprt, xargs, argsp)                 \
        (*(xprt)->xp_ops->xp_getargs)((xprt), (xargs), (argsp))

#define SVC_REPLY(xprt, msg)                            \
        (*(xprt)->xp_ops->xp_reply) ((xprt), (msg))
#define svc_reply(xprt, msg)                            \
        (*(xprt)->xp_ops->xp_reply) ((xprt), (msg))

#define SVC_FREEARGS(xprt, xargs, argsp)                \
        (*(xprt)->xp_ops->xp_freeargs)((xprt), (xargs), (argsp))
#define svc_freeargs(xprt, xargs, argsp)                \
        (*(xprt)->xp_ops->xp_freeargs)((xprt), (xargs), (argsp))

#define SVC_DESTROY(xprt)                               \
        (*(xprt)->xp_ops->xp_destroy)(xprt)
#define svc_destroy(xprt)                               \
        (*(xprt)->xp_ops->xp_destroy)(xprt)


/*
 * Service request
 */
_Packed struct svc_req {
        u_long          rq_prog;        /* service program number */
        u_long          rq_vers;        /* service protocol version */
        u_long          rq_proc;        /* the desired procedure */
        _Packed struct opaque_auth rq_cred;     /* raw creds from the wire */
        char * _Seg16   rq_clntcred;    /* read only cooked cred */
        SVCXPRT * _Seg16 rq_xprt;               /* associated transport */
};


/*
 * Service registration
 *
 * svc_register(xprt, prog, vers, dispatch, protocol)
 *      SVCXPRT *xprt;
 *      u_long prog;
 *      u_long vers;
 *      void (*dispatch)();
 *      int protocol;  /* like TCP or UDP, zero means do not register
 */
extern bool_t   _Far16 _Cdecl svc_register(SVCXPRT * _Seg16,u_long,u_long,
  void (* _Seg16 _Far16 _Cdecl)(_Packed struct svc_req * _Seg16, SVCXPRT * _Seg16),
  short);

/*
 * Service un-registration
 *
 * svc_unregister(prog, vers)
 *      u_long prog;
 *      u_long vers;
 */
extern void  _Far16 _Cdecl   svc_unregister(u_long,u_long);

/*
 * Transport registration.
 *
 * xprt_register(xprt)
 *      SVCXPRT *xprt;
 */
extern void _Far16 _Cdecl    xprt_register(SVCXPRT * _Seg16);

/*
 * Transport un-register
 *
 * xprt_unregister(xprt)
 *      SVCXPRT *xprt;
 */
extern void _Far16 _Cdecl    xprt_unregister(SVCXPRT * _Seg16);


/*
 * When the service routine is called, it must first check to see if it
 * knows about the procedure;  if not, it should call svcerr_noproc
 * and return.  If so, it should deserialize its arguments via
 * SVC_GETARGS (defined above).  If the deserialization does not work,
 * svcerr_decode should be called followed by a return.  Successful
 * decoding of the arguments should be followed the execution of the
 * procedure's code and a call to svc_sendreply.
 *
 * Also, if the service refuses to execute the procedure due to too-
 * weak authentication parameters, svcerr_weakauth should be called.
 * Note: do not confuse access-control failure with weak authentication!
 *
 * NB: In pure implementations of rpc, the caller always waits for a reply
 * msg.  This message is sent when svc_sendreply is called.
 * Therefore pure service implementations should always call
 * svc_sendreply even if the function logically returns void;  use
 * xdr.h - xdr_void for the xdr routine.  HOWEVER, tcp based rpc allows
 * for the abuse of pure rpc via batched calling or pipelining.  In the
 * case of a batched call, svc_sendreply should NOT be called since
 * this would send a return message, which is what batching tries to avoid.
 * It is the service/protocol writer's responsibility to know which calls are
 * batched and which are not.  Warning: responding to batch calls may
 * deadlock the caller and server processes!
 */

extern bool_t _Far16 _Cdecl svc_sendreply(SVCXPRT * _Seg16,xdrproc_t,void * _Seg16);
extern void _Far16 _Cdecl svcerr_decode(SVCXPRT * _Seg16);
extern void _Far16 _Cdecl svcerr_weakauth(SVCXPRT * _Seg16);
extern void _Far16 _Cdecl svcerr_noproc(SVCXPRT * _Seg16);
extern void _Far16 _Cdecl svcerr_auth(SVCXPRT * _Seg16,enum auth_stat);
extern void _Far16 _Cdecl svcerr_noprog(SVCXPRT * _Seg16);
extern void _Far16 _Cdecl svcerr_progvers(SVCXPRT * _Seg16,u_long,u_long);
extern void _Far16 _Cdecl svcerr_systemerr(SVCXPRT * _Seg16);

/*
 * Lowest level dispatching -OR- who owns this process anyway.
 * Somebody has to wait for incoming requests and then call the correct
 * service routine.  The routine svc_run does infinite waiting; i.e.,
 * svc_run never returns.
 * Since another (co-existant) package may wish to selectively wait for
 * incoming calls or other events outside of the rpc architecture, the
 * routine svc_getreq is provided.  It must be passed readfds, the
 * "in-place" results of a select system call (see select, section 2).
 */

/* dynamic; must be inspected before each call to select */
extern short svc_fds;

/*
 * a small program implemented by the svc_rpc implementation itself;
 * also see clnt.h for protocol numbers.
 */
extern void _Far16 _Cdecl rpctest_service(void);
/* argument may not be void, but this is not implemented at present
   in TCPIP for OS/2 10-13-92 */

extern void _Far16 _Cdecl svc_getreq(short * _Seg16,short);
extern void _Far16 _Cdecl svc_run(void);       /* never returns */

/*
 * Socket to use on svcxxx_create call to get default socket
 */
#define RPC_ANYSOCK     -1

/*
 * These are the existing service side transport implementations
 */

/*
 * Memory based rpc for testing and timing.
 */
extern SVCXPRT * _Seg16 _Far16 _Cdecl svcraw_create(void);

/*
 * Udp based rpc.
 */
extern SVCXPRT * _Seg16 _Far16 _Cdecl svcudp_create(short);
extern SVCXPRT * _Seg16 _Far16 _Cdecl svcudp_bufcreate(short,unsigned short,unsigned short);

/*
 * Tcp based rpc.
 */
extern SVCXPRT * _Seg16 _Far16 _Cdecl svctcp_create(short,u_short,u_short);

extern short * _Seg16 svc_socks;
extern short noregistered;
#endif
