/* CASSKEL 2.0               */

/* This is the LAN CID Utility skeleton command file.  This command file     */
/* illustrates the installation of OS/2 and an application.                  */

/* Specifically, this command file installs OS/2 2.1 and LS 4.0.             */

/*---------------------------------------------------*/
/*         DO NOT MODIFY THE NEXT EIGHT LINES        */
/*---------------------------------------------------*/

parse ARG client logfile additional

QUEUE_REBOOT = 0
CALL_AGAIN = 0

Call AddDLLFunctions

x.0.instprog = ''
x.0.rspdir   = ''
x.0.statevar = 'CAS_STATE'
x.0.default  = ''


/*---------------------------------------------------*/
/*             MODIFICATIONS START HERE              */
/*---------------------------------------------------*/


/*****************************************************/
/*                 SRVATTCH SECTION                  */
/*****************************************************/

/* 'SRVATTCH z: \\SERVER1\ALIAS' */                             /* Additional SRVATTCHs can be placed here*/

/* 'SRVATTCH y: SERVER2'         */                             /* They can be placed before specific     */
                                                                /* RunInstall statements too if you only  */
                                                                /* want to attach to a special server     */
                                                                /* right before a specific install.       */

/*****************************************************/
/*                 VARIABLES SECTION                 */
/*****************************************************/

/*---------------------------------------------------*/
/*         DO NOT REMOVE THE NEXT FIVE LINES         */
/*              (They may be modified)               */
/*---------------------------------------------------*/

bootdrive = 'c:'                                                /* Boot Drive                             */
configsys = bootdrive || '\CONFIG.SYS'                          /* Fully qualified path to CONFIG.SYS     */
maintdir  = bootdrive || '\SERVICE'                             /* Maintenance directory, refrenced by    */
                                                                /*   SEMAINT, SEINST, and LAPS.           */
exepath   = 'X:\EXE\V210'                                       /* Path to executable directory on server */
dllpath   = 'X:\DLL\V210'                                       /* Paths to the DLL directories on server */

/*---------------------------------------------------*/
/* The next four lines are included to make it       */
/* easier to change the version of OS/2 2.x that is  */
/* to be installed.                                  */
/*                                                   */
/* These variables are referenced in the product     */
/* data sections for SEINST and SEMAINT.             */
/*---------------------------------------------------*/

os2dir  = 'OS2V21'                                              /* Name of OS/2 2.1 directories         */
os2img  = 'X:\IMG\' || os2dir                                   /* - product image directory            */
os2rsp  = 'X:\RSP\' || os2dir                                   /* - response file directory            */
os2log  = 'X:\LOG\' || os2dir                                   /* - log file directory                 */


/*****************************************************/
/*               PRODUCT DATA SECTION                */
/*****************************************************/

x.seinst = 1                                                    /* structure index                      */
x.1.name='OS/2 2.1'                                             /* product name                         */
x.1.statevar = 'CAS_' || x.1.name                               /* state variable name                  */
x.1.instprog = exepath || '\seinst                     ',       /* fully qualified install program name */
               ' /b:' || bootdrive || '                ',       /* - bootdrive                          */
               ' /s:' || os2img || '                   ',       /* - source directory                   */
               ' /t:' || maintdir || '                 ',       /* - service directory                  */
               '/l1:' || os2log || '\' || client || '.log ',    /* - log file                           */
               ' /r:'                                           /* - response file flag (auto selection)*/
x.1.rspdir   = os2rsp                                           /* response file directory              */
x.1.default  = 'default.rsp'                                    /* default response file name           */

x.semaint = 2                                                   /* structure index                      */
x.2.name='OS/2 2.1 Maintenance'                                 /* product name                         */
x.2.statevar = 'CAS_' || x.2.name                               /* state variable name                  */
x.2.instprog = exepath || '\semaint                    ',       /* fully qualified install program name */
                ' /s:' || os2img || '                  ',       /* - source directory                   */
                ' /t:' || maintdir || '                ',       /* - target directory                   */
                ' /b:' || bootdrive || '               ',       /* - target boot drive (not necessarily current) */
                '/l1:' || os2log || '\' || client || '.log'     /* - log file                           */
x.2.rspdir   = ''                                               /* no auto selection                    */
x.2.default  = ''

x.laps_prep = 3                                                 /* structure index                      */
x.3.name='LAPS Maintnenace'                                     /* product name                         */
x.3.statevar = 'CAS_' || x.3.name                               /* state variable name                  */
x.3.instprog = 'x:\img\laps\mpts                      ',        /* fully qualified install program name */
                ' /e:prep                             ',        /* - prep installation                  */
                ' /s:x:\img\laps                      ',        /* - source directory                   */
                ' /t:' || maintdir || '               ',        /* - target directory                   */
                '/tu:' || bootdrive || '              ',        /* - location of config.sys             */
                '/l1:x:\log\laps\' || client || '.log ',        /* - log file                           */
                ' /r:x:\rsp\laps\lapsrsp.rsp'                   /* - response file                      */
x.3.rspdir   = ''                                               /* no auto selection                    */
x.3.default  = ''

x.laps = 4                                                      /* structure index                      */
x.4.name='LAPS'                                                 /* product name                         */
x.4.statevar = 'CAS_' || x.4.name                               /* state variable name                  */
x.4.instprog = 'x:\img\laps\mpts                     ',         /* fully qualified install program name */
               ' /e:maint                            ',         /* - maintenance installation           */
               ' /s:x:\img\laps                      ',         /* - source directory                   */
               ' /t:' || bootdrive || '\             ',         /* - target directory                   */
               '/l1:x:\log\laps\' || client || '.log ',         /* - log file                           */
               ' /r:'                                           /* - response file flag (auto selection)*/
x.4.rspdir   = 'x:\rsp\laps'                                    /* response file directory              */
x.4.default  = 'lapsrsp.rsp'                                    /* default response file name           */

x.laninstr = 5                                                  /* structure index                      */
x.5.name='LAN Services 4.0'                                     /* product name                         */
x.5.statevar = 'CAS_' || x.5.name                               /* state variable name                  */
x.5.instprog = 'x:\img\ls40\laninstr',                          /* fully qualified install program name */
               ' /req',                                         /* - install a requester                */
               ' /l1:x:\log\ls40\' || client || '.L1',          /* - error log file                     */
               ' /l2:x:\log\ls40\' || client || '.L2',          /* - history log file                   */
               ' /g:x:\rsp\ls40',                               /* - include file directory             */
               ' /r:'                                           /* - response file flag (auto selection)*/
x.5.rspdir   = 'x:\rsp\ls40'                                    /* response file directory              */
x.5.default  = 'req.rsp'                                        /* default response file name           */

x.thinifs = 6                                                   /* structure index                      */
x.6.name='SRVIFS Requester'                                     /* product name                         */
x.6.statevar = ''                                               /* state variable name                  */
x.6.instprog = 'x:\img\srvifs\thinifs                   ',      /* fully qualified install program name */
               '  /s:x:\img\srvifs                      ',      /* - source directory                   */
               '  /t:' || bootdrive || '\srvifsrq       ',      /* - target directory                   */
               ' /tu:' || bootdrive || '\               ',      /* - config.sys location                */
               ' /l1:x:\log\srvifs\' || client || '.log ',      /* - log file                           */
               ' /req:*                                 ',      /* - random requester name              */
               ' /srv:server1                           ',      /* - server name                        */
               ' /d:x'                                          /* - remote drive identifier            */
x.6.rspdir   = ''                                               /* no auto selection                    */
x.6.default  = ''

x.ifsdel = 7                                                    /* structure index                      */
x.7.name='SRVIFS Delete'                                        /* product name                         */
x.7.statevar = ''                                               /* state variable name                  */
x.7.instprog = 'x:\img\srvifs\ifsdel             ',             /* fully qualified install program name */
               ' /t:' || bootdrive || '\srvifsrq ',             /* - target directory                   */
               '/tu:' || bootdrive                              /* - config.sys location                */
x.7.rspdir   = ''                                               /* no auto selection                    */
x.7.default  = ''

x.casinstl = 8                                                  /* structure index                               */
x.8.name='LAN CID Utility'                                      /* product name                                  */
x.8.statevar = ''                                               /* state variable name                           */
x.8.instprog = 'x:\img\lcu\casinstl                 ',          /* fully qualified install program name          */
               ' /cmd:x:\client                      ',         /* - location of .cmd files (passed to casagent) */
               ' /tu:' || bootdrive || '             ',         /* - config.sys location (boot drive)            */
               ' /pl:' || dllpath || '               ',         /* - string to add to libpath                    */
               ' /pa:x:\img\lcu                      ',         /* - workstation's path to LCU code on server    */
               ' /l1:x:\log\lcu\' || client || '.log ',         /* - CASINSTL log file                           */
               ' /l2:x:\log\lcu\SRVIFS_REQ.log       ',         /* - CASAGENT log file                           */
               ' /req:' || client || '               '          /* - LCU client name                             */
x.8.rspdir   = ''                                               /* no auto selection                             */
x.8.default  = ''

x.casdelet = 9                                                  /* structure index                      */
x.9.name='LAN CID Utility Delete'                               /* product name                         */
x.9.statevar = ''                                               /* state variable name                  */
x.9.instprog = 'x:\img\lcu\casdelet   ',                        /* fully qualified install program name */
                '/pl:' || dllpath || ' ',                       /* - string to delete from libpath      */
                '/tu:' || bootdrive                             /* - config.sys location (boot drive)   */
x.9.rspdir   = ''                                               /* no auto selection                    */
x.9.default  = ''

/*---------------------------------------------------*/
/*         NUMBER OF PROGRAMS SET UP IN THE          */
/*               PRODUCT DATA SECTION                */
/*---------------------------------------------------*/

NUM_INSTALL_PROGS = 9


/*---------------------------------------------------*/
/*       DO NOT MODIFY OR REMOVE THE NEXT LINE       */
/*---------------------------------------------------*/

OVERALL_STATE = GetEnvironmentVars()


/*****************************************************/
/*                  INSTALL SECTION                  */
/*****************************************************/

Do Forever
  Select
    when OVERALL_STATE = 0 then do
      if BootDriveIsDiskette()   == YES    then iterate         /* Check if booted from diskette*/
                                                                /*  if it was, then goto state 1*/
      if RunInstall(x.semaint)   == BAD_RC then exit            /* Install maintenance system   */
      if RunInstall(x.laps_prep) == BAD_RC then exit            /* Install LAPS prep system     */
      if RunInstall(x.thinifs)   == BAD_RC then exit            /* Install SRVIFS requester     */
      if RunInstall(x.casinstl)  == BAD_RC then exit            /* Install LCU                  */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 1 then do
      if RunInstall(x.seinst)   == BAD_RC then exit             /* Install operating system     */
      if RunInstall(x.laps)     == BAD_RC then exit             /* Install LAPS                 */
      if RunInstall(x.thinifs)  == BAD_RC then exit             /* Install SRVIFS requester     */
      if RunInstall(x.casinstl) == BAD_RC then exit             /* Install LCU                  */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 2 then do
      if RunInstall(x.laninstr) == BAD_RC then exit             /* Install LS                   */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 3 then do
      if RunInstall(x.ifsdel)   == BAD_RC then exit             /* Delete SRVIFS requester      */
      if RunInstall(x.casdelet) == BAD_RC then exit             /* Delete LCU                   */
      Call Reboot                                               /* Reboot                       */
    end
  end
end
exit


/*************************************************************/
/*         DO NOT MODIFY ANY CODE BELOW THIS LINE !!!        */
/*************************************************************/

RunInstall: procedure expose x. queue_reboot call_again configsys logfile client OVERALL_STATE
  parse arg index, new_state, other
  install = SetEnvironmentVar(x.index.statevar)
  if install == YES then do
    state = value('REMOTE_INSTALL_STATE',,'OS2ENVIRONMENT')     /* check   REMOTE_INSTALL_STATE */
    if state <> 0 then
      rc2 = LogMessage(75, x.index.name, state, logfile)        /* log an install starting msg  */
    else
      rc2 = LogMessage(72, x.index.name, '', logfile)           /* log an install starting msg  */

    install_prog = 'CMD /C ' || strip(x.index.instprog)         /* build the command string     */

                                                /* If automatic responst file selection was     */
                                                /* indicated, then get the response file name   */
                                                /* and append it to the command string.         */
    if x.index.default <> '' then do
      response_file = DetermineResponseFile(x.index.rspdir, client,
                                            , x.index.default, x.index.name,
                                            , logfile)
      if response_file == '' then exit
      install_prog = install_prog || response_file
    end

    install_prog                                                /* Execute the install program  */

    state = value(x.index.statevar,,'OS2ENVIRONMENT')           /* Get the current install state*/
                                                                /* for this install program from*/
                                                                /* the environment.             */

                                                /* Check the return code and set the global     */
                                                /* variables accordingly.                       */

    parse value ProcessReturnCode(rc, state, QUEUE_REBOOT, CALL_AGAIN, logfile),
           with rc ',' state ',' QUEUE_REBOOT ',' CALL_AGAIN

    rc2 = value(x.index.statevar, state, 'OS2ENVIRONMENT')      /* Set the new install state for*/
                                                                /* this install program.        */

                                                /* Put the install state into the CONFIG.SYS,   */
                                                /* if this action was unsuccessful, then exit.  */

    if PutStateVar(x.index.statevar, state, configsys, logfile) <> 0 then exit

    if rc == GOOD_RC then do
      if pos('\SEMAINT', translate(install_prog)) <> 0 then     /* If the install program was   */
        Call PreserveStartupCmd(install_prog)                   /* SEMAINT, then make sure      */
                                                                /* STARTUP.CMD won't be copied  */
                                                                /* over when SEINST runs.       */

      rc2 = LogMessage(70, x.index.name, '', logfile)           /* log an install successful msg*/
      return GOOD_RC                                            /* return a good return code    */
    end

    else do
      rc2 = LogMessage(71, x.index.name, '', logfile)           /* log an install failed msg    */
      if (new_state <> '') then                                 /* If a new state was requested,*/
                                                                /* then set OVERALL_STATE to the*/
        rc2 = SetState(new_state, 'RunInstall', 2)              /* new state.                   */

      return BAD_RC                                             /* return a bad return code     */
    end
  end
  return GOOD_RC


/*************************************************************/
PreserveStartupCmd: procedure

  parse upper arg string, other

  if pos('/T:', string) <> 0 then                               /* Determine if there is a      */
    findvalue = '/T:'                                           /* target parameter.  If there  */
  else                                                          /* is none, return.             */
    if pos('-T:',string) <> 0 then
      findvalue = '-T:'
    else
      return 0

  remain = substr(string, pos(findvalue, string) + 3)           /* Get the value of the target  */
                                                                /* parameter.                   */
  blank = pos(' ', remain)

  if (blank <> 0) then
    param = substr(remain, 1, blank-1)
  else
    param = remain
                                                /* Erase startup.lcu in the target directory,  */
                                                /* then rename startup.s13 to startup.lcu      */

  'if exist ' param || '\startup.lcu erase  ' param || '\startup.lcu'
  'if exist ' param || '\startup.s13 rename ' param || '\startup.s13 *.lcu'

  return 0

/*************************************************************/
GetEnvironmentVars: procedure expose X. NUM_INSTALL_PROGS


  OVERALL_STATE = value(x.0.statevar,,'OS2ENVIRONMENT')         /* Get the overall install state */
                                                                /* from the environment.         */

  if OVERALL_STATE == '' then do                                /* If the overall install state  */
    OVERALL_STATE = 0                                           /* has not been set yet, reset   */
    do I=0 to NUM_INSTALL_PROGS by 1                            /* all the state vars to 0.      */
      if x.I.statevar <> '' then
        rc = value(x.I.statevar,'0','OS2ENVIRONMENT')
    end
  end

  return OVERALL_STATE


/*************************************************************/
SetEnvironmentVar: procedure
  parse arg env_string, other
  if env_string == '' then do                                   /* If the install program has   */
                                                                /* no state variable, then ...  */

    rc = value('REMOTE_INSTALL_STATE','0','OS2ENVIRONMENT')     /* Set the REMOTE_INSTALL_STATE */
                                                                /* to 0 so that the program     */
                                                                /* being run can know that is   */
                                                                /* being run in an unattended   */
                                                                /* environment.                 */

    return YES                                                  /* return install=yes           */

  end

  state = value(env_string,,'OS2ENVIRONMENT')                   /* Otherwise, get the value of  */
                                                                /* the state variable from the  */
                                                                /* environment.                 */

  if state <> '' then do                                        /* If the state variable exists */

    rc = value('REMOTE_INSTALL_STATE',state,'OS2ENVIRONMENT')   /* Set the REMOTE_INSTALL_STATE */
                                                                /* environment variable to the  */
                                                                /* value of the state variable. */

    return YES                                                  /* return install=yes           */
  end
  else                                                          /* Otherwise,                   */
    return NO                                                   /* return install=no            */


/*************************************************************/
BootDriveIsDiskette:

  if IsBootDriveRemovable() == 1 then do                        /* If the drive booted from is  */
                                                                /* a diskette drive, then set   */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from the hardfile.           */
    return 'NO'

/*************************************************************/
BootDriveIsFixedDisk:

  if IsBootDriveRemovable() == 0 then do                        /* If the drive booted from is  */
                                                                /* a fixed disk, then set       */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from a diskette.             */
    return 'NO'

/*************************************************************/
SetState:
  parse arg new_state, proc_name, param_num, other

    if datatype(new_state, number) <> 1 then do                 /* If the new state requested is*/
                                                                /* not numeric, then log an     */
      if proc_name <> '' then                                   /* error.                       */
        LogMessage(63, proc_name, param_num, logfile)
      else
        LogMessage(63, 'SetState', 1, logfile)

      exit
    end

    OVERALL_STATE = new_state                                   /* Set the OVERALL_STATE to the */
                                                                /* new state requested.         */

    rc = value(x.0.statevar, new_state, 'OS2ENVIRONMENT')       /* Save the OVERALL_STATE in the*/
                                                                /* environment.                 */
    return 'NO_ERROR'


/*************************************************************/
SaveStates:

  do I=0 to NUM_INSTALL_PROGS by 1            /* Put the install states into the CONFIG.SYS,  */
    if x.I.statevar <> '' then                /* if this action was unsuccessful, then exit.  */

      if PutStateVar(x.I.statevar, value(x.I.statevar,,'OS2ENVIRONMENT'),
                     , configsys, logfile) <> 0 then exit
  end

  return

/*************************************************************/
RebootAndGotoState:
  parse arg new_state, other

  rc2 = SetState(new_state, 'RebootAndGotoState', 1)           /* Set the state to go to in    */
                                                               /* OVERALL_STATE.               */

  Call SaveStates                                              /* Save the environment vars    */

  Call Reboot                                                  /* Reboot the machine           */

  return


/*************************************************************/
CheckBoot:
  if QUEUE_REBOOT <> 0 then do                                  /* If a reboot has been queued  */
                                                                /* by an install program ...    */

    if CALL_AGAIN == 0 then                                     /* If no install programs want  */
                                                                /* to be recalled ...           */

      rc = SetState(OVERALL_STATE+1)                            /* Increment the overall state  */
                                                                /* variable.                    */

    Call SaveStates                                             /* Save the environment vars    */

    Call Reboot                                                 /* Reboot the machine           */

  end

  else                                                          /* Otherwise, increment the     */
    rc = SetState(OVERALL_STATE+1)                              /* state variable and go on.    */

  return


/*************************************************************/
Reboot:
  bootdrive

  rc = value('OS2_SHELL', bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')
  rc = value('COMSPEC',   bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')

  'cls'
  rc = AskRemoveDiskIfFloppy()

  pathlen = length(exepath)                                     /* Get length of exepath        */
  posslash = lastpos("\",strip(exepath))                        /* Determine the last occurcnce */
                                                                /*   of '\' in exepath          */

  if posslash = pathlen then                                    /* If '\' is the last character */

    cmdline = exepath || 'SETBOOT /IBD:' || bootdrive           /* Then append 'SETBOOT'        */

  else

    cmdline = exepath || '\SETBOOT /IBD:' || bootdrive          /* Else append '\SETBOOT'       */

  LogMessage(74, '', '', logfile)                               /* Log a message indicating     */
                                                                /* reboot.                      */
  cmdline

  LogMessage(73, 'SETBOOT', '', logfile)                        /* If the code gets to here, the*/
                                                                /* reboot failed.  Log a message*/
  exit                                                          /* and exit.                    */

  return


/*************************************************************/
AddDLLFunctions:
  Call RxFuncAdd 'ProcessReturnCode',     'CASAGENT', 'PROCESSRETURNCODE'
  Call RxFuncAdd 'DetermineResponseFile', 'CASAGENT', 'DETERMINERESPONSEFILE'
  Call RxFuncAdd 'PutStateVar',           'CASAGENT', 'PUTSTATEVAR'
  Call RxFuncAdd 'LogMessage',            'CASAGENT', 'GETANDLOGMESSAGE'
  Call RxFuncAdd 'AskRemoveDiskIfFloppy', 'CASAGENT', 'ASKREMOVEDISKIFFLOPPY'
  Call RxFuncAdd 'IsBootDriveRemovable',  'CASAGENT', 'ISBOOTDRIVEREMOVABLE'
  Call RxFuncAdd 'GetOS2Version',         'CASAGENT', 'GETOS2VERSION'
  Call RxFuncAdd 'SetCIDType',            'CASAGENT', 'SETCIDTYPE'

  return
