/*****************************************************************************/
/* Lotus 1-2-3 For OS/2 sample macro command.                                */
/*                                                                           */
/* {REXXRV "REXXADD.CMD",range,value}                                        */
/*                                                                           */
/* Adds 'value' to each of the cells in 'range'.                             */
/*                                                                           */
/* {REXXRV "REXXADD.CMD logFileName",range,value}                            */
/*                                                                           */
/* Writes any TRACE or SAY output to a log file named 'logFileName'.         */
/*                                                                           */
/* Copyright (c) 1991 Lotus Development Corporation.  This code is supplied  */
/* on an 'as is' basis as an example only.  This code has only received      */
/* informal testing by Lotus.  Permission is granted  to copy and modify     */
/* this code to your heart's content.  No warrenties expressed or implied.   */
/* Remember, your mileage may vary.  Let us know if you find support of REXX */
/* by 1-2-3 useful.                                                          */
/*****************************************************************************/

PARSE ARG range, value
IF range = "RANGE1" THEN DO                          /* first arg is a range */
   PARSE VAR range1.0 elements sheets columns rows      /* get size of range */
   i = 1
   DO sheet = 1 TO sheets             /* loop through the cells of the range */
      DO column = 1 TO columns
         DO row = 1 TO rows
            /* Compute the new value for the cell, dividing by one to remove */
            /* the decimal point if it is unneeded.                          */
            newValue = (range1.i + value) / 1
            CALL Set123Cell "RANGE1", sheet, column, row, "NUMBER", newValue
            i = i + 1
            END
         END
      END
   END
ELSE                                             /* this should never happen */
   CALL Display123Error "First argument to REXXADD.CMD is not a range."
RETURN
