/*
 * Decompiled with CFR 0.152.
 */
package com.os2.comm;

import com.os2.comm.OS2SerialNative;
import java.io.IOException;
import java.io.InputStream;

class OS2SerialInputStream
extends InputStream {
    OS2SerialNative port;
    byte[] buff;

    public OS2SerialInputStream(OS2SerialNative oS2SerialNative) {
        this.port = oS2SerialNative;
        this.buff = new byte[4];
    }

    public int read() throws IOException {
        int n = this.port.spreadArray(this.buff, 0, 1);
        if (n < 0) {
            throw new IOException("Could not read from serial port");
        }
        if (n == 0) {
            return -1;
        }
        int n2 = this.buff[0];
        if (n2 < 0) {
            n2 = 256 + n2;
            return n2;
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.port.spreadArray(byArray, 0, Math.min(byArray.length, this.port.readthreshold));
        if (n < 0) {
            throw new IOException("Could not read from serial port");
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length > n + n2) {
            throw new IOException("Length too long or buffer too small");
        }
        int n3 = this.port.spreadArray(byArray, n, Math.min(n2, this.port.readthreshold));
        if (n3 < 0) {
            throw new IOException("Could not read from serial port");
        }
        return n3;
    }

    public int available() throws IOException {
        int n = this.port.spavailable();
        if (n < 0) {
            throw new IOException("Could not query available bytes");
        }
        return n;
    }
}

