; transgen.asm - Software Screen to Screen BitBlt Acceleration GRADD filter, release 0.0.1
;   Copyright (c) 2001 Takayuki 'January June' Suwa

  .386
  .387

CODE32  segment  para use32 public 'CODE'
CODE32  ends
DATA32  segment  para use32 public 'DATA'
DATA32  ends
CONST32_RO  segment  para use32 public 'CONST'
CONST32_RO  ends
BSS32  segment  para use32 public 'BSS'
BSS32  ends
DGROUP  group  BSS32, DATA32
  assume  cs:FLAT, ds:FLAT, ss:FLAT, es:FLAT, fs:nothing, gs:nothing

  extrn  adTransferBuffer:qword

CODE32  segment

; extern VOID _System TransferBlock_Generic(PBYTE pbDst,
;                                           PBYTE pbSrc,
;                                           ULONG ulXBytes,
;                                           ULONG ulExtY,
;                                           LONG lAdditiveY);
  public  TransferBlock_Generic
  org  0
TransferBlock_Generic  proc  near
ARGLIST  struc
pbDst       dd  ?  ; (PBYTE)
pbSrc       dd  ?  ; (PBYTE)
ulXBytes    dd  ?  ; (ULONG)
ulExtY      dd  ?  ; (ULONG)
lAdditiveY  dd  ?  ; (LONG)
ARGLIST  ends
VARLIST  struc
VARLIST  ends
  enter size VARLIST, 0
ARG  equ  ARGLIST[ebp+8]
VAR  equ  VARLIST[ebp-size VARLIST]
  push  ebx
  push  esi
  push  edi

  mov  ebx, ARG.pbDst
  mov  esi, ARG.pbSrc
  mov  edi, ARG.ulExtY
BLBL0:
  mov  eax, ebx
  mov  edx, esi
  mov  ecx, ARG.ulXBytes
  call  TransferScanline_Generic
  add  ebx, ARG.lAdditiveY
  add  esi, ARG.lAdditiveY
  dec  edi
  jne  short BLBL0

  pop  edi
  pop  esi
  pop  ebx
  leave
  ret
TransferBlock_Generic  endp

; static VOID _Optlink TransferScanline_Generic(PBYTE pbDst,   /* eax */
;                                               PBYTE pbSrc,   /* edx */
;                                               ULONG ulBytes  /* ecx */);
  org  30h
TransferScanline_Generic  proc  near
  push  ebx
  push  esi
  push  edi

  lea  ebx, [ecx+edx+7]
  mov  esi, not 7
  and  esi, edx
  sub  ebx, esi
  shr  ebx, 3

  mov  edi, offset FLAT:adTransferBuffer
BLBL0:
  fild  qword ptr [esi]
  add  esi, 8
  fistp  qword ptr [edi]
  add  edi, 8
  dec  ebx
  jnz  short BLBL0

  mov  esi, 7
  and  esi, edx
  mov  edx, 7
  add  esi, offset FLAT:adTransferBuffer
  and  edx, ecx
  shr  ecx, 3
  test  ecx, ecx
  jz  short BLBL2
BLBL1:
  mov  ebx, [esi]
  mov  edi, [esi+4]
  add  esi, 8
  mov  [eax], ebx
  mov  [eax+4], edi
  add  eax, 8
  dec  ecx
  jz  short BLBL2
  mov  ebx, [esi]
  mov  edi, [esi+4]
  add  esi, 8
  mov  [eax], ebx
  mov  [eax+4], edi
  add  eax, 8
  dec  ecx
  jnz  short BLBL1
BLBL2:
  cmp  edx, 4
  jb  short BLBL3
  mov  ecx, [esi]
  add  esi, 4
  mov  [eax], ecx
  add  eax, 4
  sub  edx, 4
BLBL3:
  cmp  edx, 2
  jb  short BLBL4
  mov  cx, [esi]
  add  esi, 2
  mov  [eax], cx
  add  eax, 2
  sub  edx, 2
BLBL4:
  test  edx, edx
  jz  short BLBL5
  mov  cl, [esi]
  mov  [eax], cl
BLBL5:

  pop  edi
  pop  esi
  pop  ebx
  ret
TransferScanline_Generic  endp

CODE32  ends

  end

