/*
** S3 Video Device Driver Setup
**
** Bernie Thompson Jan 5, 1996
** (c) 1996 S3, Inc.
*/

'@echo off'
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* ERROR CODES */
error = 0
ERR_USAGE    = 1
ERR_CHIP     = 2
ERR_OS2VER   = 3
ERR_UNPACK   = 4

parse arg src trg cid

call getsrc
call gettrg

/* space-seperated S3 chip list -- must match with svgadefs.h */
chips = '801/805 928 911 864 964 868 968 Trio32 Trio64 Trio64V+'
chips = chips 'Aurora64V ViRGE ViRGE/vX Trio64UV+'

log = trg'\os2\install\s3setup.log'
x = linein(src||'BUILD.LVL')
rc = lineout(log, copies('=',60))
rc = lineout(log, x)

w = 60
call SysCls
say ''
say copies('*',w)
say center('S3 Trio64/64V+ display driver installation',w)
say center('Version 2.80.19',w)
say ''
say center('Please read README.TXT first', w)
say center('before installing this package', w)
say ''
say center('Source Path 'src,w)
say center('Target Drive 'trg '['word(trginfo,4)']',w)
say copies('*',w)
say ''

copy src||'portio.dll' trg||'\os2\dll 1>nul 2>&1'

''src||'chipid'
chipid = rc
if chipid = 0 then do
   error = ERR_CHIP
   call saylog 'Error: Unknown (probably non-S3) video hardware'
   signal readme
end

call saylog 'The target video hardware is ['chipid'] S3 'word(chips,chipid)
say ''

x = wordpos(chipid, '8 9 10 11')
if x = 0 then do
   error = ERR_CHIP
   call saylog 'Error: Hardware not supported by this driver package'
   say 'please download a package matching the detected hardware'
   signal readme
end

os2ver = SysOS2Ver() /* returns 2.30 for Warp */

proglist = ''

if (os2ver > 2.30) then do
   call saylog 'Warning: New version of OS/2'
   SAY ''
   SAY 'This s3 display driver package was designed'
   SAY 'for OS/2 Warp version 3.00 and earlier'
   SAY 'There is a possbility these drivers may not'
   SAY 'function with this new version of OS/2'
   SAY 'You may continue with installation or'
   SAY 'quit and download a new, updated version of'
   SAY 'this package'
   call prompt
end

if (os2ver < 2.10) then do
   error = ERR_OS2VER
   call saylog 'Error: Unsupported older OS/2 version'
   signal readme
end

currentdriver = sysini(, 'PM_DISPLAYDRIVERS', 'CURRENTDRIVER')
If \pos('IBMVGA32',currentdriver) then do
   call saylog 'Warning: Not running IBM VGA at install time'
   say "Your system is not currently running IBM's VGA drivers."
   say 'In order to install any new hi-res display driver package'
   say 'safely, the system should be reset to VGA mode.'
   say 'please refer to your IBM OS/2 Warp documentation or'
   say 'readme.txt on this installation diskette for more'
   say 'information.'
   call prompt
end

prefix = 'WIN_RES_S3_'
count  = 20

Do i = 0 to 20
   appkey = prefix||i
   result = sysini(, appkey, 'DELETE:')
End

/*
** We are turning the read-only attributes off in our target
** directories because dspinstl will silently fail to copy
** over read-only files. This has generated bug reports
** repeatedly in the past.
*/
rc = SysFileTree(trg||'\os2\*.*',stem,'S','***+*','***-*')

/*
** These two files are private to videocfg.dll and family.
** They are not valid with a new configuration, and should be deleted
*/
rc = SysFileDelete(trg||'\os2\private.dif')
if rc=0 then call lineout log, 'private.dif deleted'
rc = SysFileDelete(trg||'\os2\video.cfg')
if rc=0 then call lineout log, 'video.cfg deleted'

fspec = SysSearchPath('PATH', 'UNPACK2.EXE')
if fspec = '' then do
   call lineout log, 'adding unpack2 capability to system'
   'copy 'src'unpack.exe 'trg'\os2 1> nul 2>&1'
   'copy 'src'unpack2.exe 'trg'\os2 1> nul 2>&1'
end

file = src||'dspinstl.ex_'
call unpack

file = src||'inscfg32.dl_'
call unpack

if cid <> '' then cid = '/u'

say "Starting OS/2's display install program..."
say ''

dspinstl = trg||'\os2\install\dspinstl.exe'
dspsrc = right( src, 1 )
if dspsrc <> '\' & dspsrc <> '/' then
do
   dspsrc = src
end
else do
   dspsrc = left(src, length(src)-1) /* dspinstl: no trailing slash */
end
dspopt = '/pk:other /sk:none /s:'dspsrc' /t:'trg'\ /pd:'src'prereqs.dsc'
dsplog = '/l:'trg'\os2\install\display.log'
dcmd = dspinstl dspopt dsplog cid
rc = lineout(log, dcmd)
''dcmd

result = sysini(, 'PM_INSTALL', 'WINOS2_LOCATION')
if result <> '' then do
   winpath = space(left(result,length(result)-1),0)

   rc = SysFileTree(winpath||'\*.*',stem,,'***+*','***-*')

   setup='EXENAME='||winpath||'\os2fs.exe;OBJECTID=<S3_FONTSIZE>'

   rc = SysDestroyObject('<S3_FONTSIZE>')
   rc = SysCreateObject("WPProgram", "S3 Windows Font Size", "<WP_CONFIG>",setup)
   If rc
      Then call lineout log,'Font Size Object Created'
      Else call lineout log,'Font Size Object Creation Failed in 'winpath' rc='rc
end

setup ='EXENAME=\OS2\DDC.CMD;OBJECTID=<S3_DDC>;ICONFILE=\OS2\DDC.ICO;'
setup = setup||'NOAUTOCLOSE=YES;MAXIMIZED=YES'

rc = SysDestroyObject('<S3_DDC>')
rc = SysCreateObject("WPProgram", "DDC Display Setup", "<WP_CONFIG>",setup)
If rc
  Then call lineout log, 'DDC setup object created'
  Else call lineout log, 'DDC setup object creation failed rc='

setting = 'WIN_BACKGROUND_INIT=1;'
len = length(setting)
x = SysIni(, 'WINOS2', 'PM_GlobalWindows31Settings')
If (left(x, len) <> setting)then
do
   x = setting||x
   SysIni(, 'WINOS2', 'PM_GlobalWindows31Settings', x)
end

if ((os2ver = 2.10) | (os2ver = 2.11)) then ''src'vcfginst.exe'

'start 'src'product.exe 'src trg cid
signal done

getsrc:
rc = stream(src||'BUILD.LVL', 'c', 'query exists')
if (rc = '') | (src = '') then do
   parse source src
   src = word(src,3)
   src = FileSpec('DRIVE', src) || FileSpec('PATH', src)
end
return

gettrg:
rc = stream(trg||'\OS2\PMSHELL.EXE', 'c', 'query exists')
if (rc = '') | (trg = '') then do
   trg = SysSearchPath('PATH', 'PMSHELL.EXE')
   trg = FileSpec('drive',trg)
end
trginfo = SysDriveInfo(trg)
return

usage:
say 'SETUP.CMD: S3 Display Driver Installation'
say ''
say 'Usage: setup [SOURCE_PATH:] [BOOTDRIVE:] {/u}'
say ''
say 'Use the optional /u parameter for CID installs'
signal readme

saylog:
parse arg msg
   say msg
   rc = lineout(log, msg)
return

prompt:
if cid = '' then
do
   say ''
   SAY 'Do you wish to continue installation? (y or n)'
   key = SysGetKey('NOECHO')
   say ''
   parse upper var key key
   if key <> 'Y' then signal readme
end
return

unpack:
'unpack 'file trg' >> nul'
if rc then do
   error = err_unpack
   call saylog 'Error: unpacking 'file', rc = 'rc
   signal readme
end
return

readme:
say ''
say 'The installation has ended without any modifications to your'
say 'system.  Please reference README.TXT on the installation'
say 'diskette for more information.'
say ''
exit error

done:
if cid = '' then 'exit'
exit error


