/* REXX script */

say '      ͻ'
say '                      Appian ADI/2 install for OS/2                  '
say '                                         '
say '         This program will copy the device driver from the floppy    '
say '         disk to your OS2 directory and modify your CONFIG.SYS.      '
say '             (For more information see the file README.OS2)          '
say '      ͼ'

/*      MPF  12/23/93   */
/*
trace ?r						/* For debugging */
*/
'@echo off'
debug=false

adiver = '100'
ofile = 'TMP.APN'
OldDriver = 'IBM1S506.ADD'
NewDriver = ADI2O || adiver || '.ADD'
NewDev = 'BASEDEV=' || NewDriver

if debug = true then do
	ifile = 'FUBAR.SYS'
	ipath = ':\MIKEF\'
	opath = ':\MIKEF\'
	BackupName = 'FUBAR.APN'
end /* do */

else do
	ifile = 'CONFIG.SYS'
	ipath = ':\'
	opath = ':\'
	BackupName = 'CONFIG.APN'
end /* do */
            
parse source OSName HowCalled WhereFrom		/* Get ARGV[0] */
/*
InstallDrive = substr(strip(WhereFrom), 1, 1)	/* Get drive of install */
*/
/* Get the path component */
temp = reverse(translate(WhereFrom))
InstallPath = reverse(substr(temp, (pos('\', temp))))

bootdrive = GetBootDrive()			/* Get boot drive from env */

/* The AZ in front of a file name stands for ASCIIZ which means */
/*  that it is a full path name of the form: "drive:\path\file" */
AZinfile = bootdrive || ipath || ifile
AZoutfile = bootdrive || opath || ofile
AZBackupFile = bootdrive || ipath || BackupName
/* AZDriverFile = InstallDrive || ipath || NewDriver */
AZDriverFile = InstallPath || NewDriver

arg CmdLineArgs					/* Get command line args */
CmdLineArgs = strip(CmdLineArgs)		/* Strip leading blanks */
if CmdLineArgs <> '' then do
	if (CmdLineArgs = '/U') | (CmdLineArgs = 'U') then do
		say '        WARNING: Currently the uninstall option just'
		say '        copies CONFIG.APN to CONFIG.SYS. Any changes'
		say '        you have made to CONFIG.SYS since you installed'
		say '        the ADI2 driver will be lost.'
		say 'Do you want to uninstall the ADI2 driver? (Y/N)'
		pull answer
		rc = abbrev('YES',strip(answer),1)

		if rc = 0 then do
			say "You chose to Abort"
			exit
		end /* If */

		rc = stream(AZBackupFile, 'c', 'query exists')

		if rc = '' then do
			say AZBackupFile 'does not exist'
			exit
		end /* If */

		say 'COPYING' AZBackupFile 'TO' AZinfile
		copy AZBackupFile AZinfile
		say 'Uninstall complete'
		exit
	end /* If */

	else do
		say 'I do not understand' CmdLineArgs
		exit
	end /* Else */

end /* If */

say 'Do you wish to continue? (Y/N)'
pull answer
rc = abbrev('YES',strip(answer),1)
if rc = 0 then do
	say "You chose to Abort"
	exit
end /* If */

say "Proceeding with the installation"
rc = stream(AZinfile, 'c', 'query exists') /* Returns NUL if doesn't exist */
if rc = '' then do
	say 'INSTALL: Can not find' AZinfile
	signal ErrorExit
end /* If */

/* Make a backup of CONFIG.SYS only if it doesn't already exist. */
rc = stream(AZBackupFile, 'c', 'query exists') /* Returns NUL if doesn't exist*/
if rc = '' then do
	say 'COPYING' AZinfile 'TO' AZBackupFile
	copy AZinfile AZBackupFile		/* Save original file */
end /* If */

rc = stream(AZDriverFile, 'c', 'query exists') /* Returns NUL if doesn't exist*/
if rc = '' then do
	say 'INSTALL: Can not find' AZDriverFile
	signal ErrorExit
end /* If */

say 'COPYING' AZDriverFile 'TO' bootdrive || ':\OS2'
copy AZDriverFile bootdrive || ':\OS2'

rc = stream(AZinfile, c, 'open read')
if  rc <> 'READY:' then do
	say 'INSTALL: Could not open ' infile
	signal ErrorExit
end /* If */

rc = stream(AZoutfile, c, 'open write')
if  rc <> 'READY:' then do
	say 'INSTALL: Could not open ' outfile
	signal ErrorExit
end /* If */

do until lines(AZinfile) = 0			/* Loop until no lines */
						/* remain in file...  */
	buffer = linein(AZinfile)		/* Get a line into buffer */
	buffer2 = translate(buffer)		/* Convert line to upper case */
	if pos('ADI2', buffer2) <> 0		/* Are there ADI statements */
		then iterate			/* don't copy them to outfile */

	if pos(OldDriver, buffer2) = 0		/* Look for current driver */
		then rc = lineout(AZoutfile, buffer) /* No match */
		else				/* Match */
	/* Found the old driver, now see if it is already commented out */
	/* If first word is REM just write the line out */
		if pos('REM', strip(buffer2)) = 1
		then rc = lineout(AZoutfile, buffer)
	/* Otherwise, Add REM statement */
		else rc = lineout(AZoutfile, 'rem ' || buffer)
end  /* Do */

rc = lineout(AZoutfile, NewDev)

rc = stream(AZinfile, c, 'close')
rc = stream(AZoutfile, c, 'close')

del AZinfile
ren AZoutfile ifile
say 'You must Shutdown then ReBoot for the changes to take effect!'
pause

ErrorExit:
exit						/* end the program */

/* Subroutines */

GetBootDrive:			/* Returns boot drive from environment */
env = 'OS2ENVIRONMENT'
temp = value('COMSPEC',,env)
return substr(strip(temp),1,1)

