/* REXX script */
/*      MPF  12/23/93   */
/*
trace ?r						/* For debugging */
*/
/* revised for Cirrus ADIO210.ADD ejc 10/3/95  */
/* revised to support 2.1 and Warp ejc 10/26/95 */
/*         also changed to preserve command line parameters */

'@echo off'

call RxFuncAdd 'SysOS2Ver', 'RexxUtil', 'SysOS2Ver'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
/* get the version of OS2 running.  Warp is 2.30  */
version = SysOS2Ver()

bootdrive = GetBootDrive()			/* Get boot drive from env */

targetdir = bootdrive || ':\OS2'
OSver = 'OS/2 version '|| version
if version = 2.30 then 
    do
         targetdir = bootdrive || ':\OS2\BOOT'
         OSver = 'OS/2 Warp'
    end
if version > 2.30 then 
    do
         targetdir = bootdrive || ':\OS2\BOOT'
         OSver = 'OS/2 trans-Warp (???)'
    end


/* find all of the appropriate drivers in this directory */

    rc = SysFileTree( 'ADI*.ADD',drivers, O )         /* get only the file names */
    NewDriver = drivers.1
    if drivers.0 > 1 then
    do
         do i = 1 to drivers.0
              drivers.i = translate( drivers.i )      /* uppercase it */
              drivers.i = substr( drivers.i, lastpos( '\', drivers.i)+1 )
              /* trim off the leading path */
         end
         
         do i=0 to drivers.0
              if drivers.i > NewDriver then Newdriver = drivers.i
         end
    end




/*adiver = '210'*/
ofile = 'TMP.CIR'
OldDriver = 'IBM1S506.ADD'
/*NewDriver = ADIO || adiver || '.ADD'*/
/* NewDev = 'BASEDEV=' || NewDriver */


say '      ͻ'
say '        Cirrus Logic Device Driver install for OS/2 2.x and Warp     '
say '      Ķ'
say '         This program will copy the device driver from the current   '
say '         disk to your OS/2 directory and modify your CONFIG.SYS.     '
say '                                                                     '
say overlay( OSver, '         Your system is running                                      ', 34 )
say overlay( NewDriver,'         The newest driver found on this disk is:                    ', 52)
/*                say overlay( targetdir,'         The target for your version of OS/2 is:                     ',51) */
say overlay( OSver || ' is: '||targetdir,'         The target directory for                                    ',36)
say '                                                                     '
say '             (For more information see the file README.OS2)          '
say '      ͼ'

   do
	ifile = 'CONFIG.SYS'
	ipath = ':\'
	opath = ':\'
	BackupName = 'CONFIG.CIR'
end /* do */
            
parse source OSName HowCalled WhereFrom		/* Get ARGV[0] */
/*
InstallDrive = substr(strip(WhereFrom), 1, 1)	/* Get drive of install */
*/
/* Get the path component */
temp = reverse(translate(WhereFrom))
InstallPath = reverse(substr(temp, (pos('\', temp))))


/* The AZ in front of a file name stands for ASCIIZ which means */
/*  that it is a full path name of the form: "drive:\path\file" */
AZinfile = bootdrive || ipath || ifile
AZoutfile = bootdrive || opath || ofile
AZBackupFile = bootdrive || ipath || BackupName
/* AZDriverFile = InstallDrive || ipath || NewDriver */
AZDriverFile = InstallPath || NewDriver

arg CmdLineArgs					/* Get command line args */
CmdLineArgs = strip(CmdLineArgs)		/* Strip leading blanks */
if CmdLineArgs <> '' then do
	if (CmdLineArgs = '/U') | (CmdLineArgs = 'U') then do
		say '        WARNING: Currently the uninstall option just'
		say '        copies CONFIG.CIR to CONFIG.SYS. Any changes'
		say '        you have made to CONFIG.SYS since you installed'
		say '        the PD-72xx driver will be lost.'
		say 'Do you want to uninstall the PD-72xx driver? (Y/N)'
		pull answer
		rc = abbrev('YES',strip(answer),1)

		if rc = 0 then do
			say "You chose to Abort"
			exit
		end /* If */

		rc = stream(AZBackupFile, 'c', 'query exists')

		if rc = '' then do
			say AZBackupFile 'does not exist'
			exit
		end /* If */

		say 'COPYING' AZBackupFile 'TO' AZinfile
		copy AZBackupFile AZinfile
		say 'Uninstall complete'
		exit
	end /* If */

	else do
		say 'I do not understand' CmdLineArgs
		exit
	end /* Else */

end /* If */

say 'Do you wish to continue? (Y/N)'
pull answer
rc = abbrev('YES',strip(answer),1)
if rc = 0 then do
	say "You chose to Abort"
	exit
end /* If */

say "Proceeding with the installation"
rc = stream(AZinfile, 'c', 'query exists') /* Returns NUL if doesn't exist */
if rc = '' then do
	say 'INSTALL: Can not find' AZinfile
	signal ErrorExit
end /* If */

/* Make a backup of CONFIG.SYS only if it doesn't already exist. */
rc = stream(AZBackupFile, 'c', 'query exists') /* Returns NUL if doesn't exist*/
if rc = '' then do
	say 'COPYING' AZinfile 'TO' AZBackupFile
	copy AZinfile AZBackupFile		/* Save original file */
end /* If */

rc = stream(AZDriverFile, 'c', 'query exists') /* Returns NUL if doesn't exist*/
if rc = '' then do
	say 'INSTALL: Can not find' AZDriverFile
	signal ErrorExit
end /* If */

/* say 'COPYING' AZDriverFile 'TO' bootdrive || ':\OS2'  */
/* copy AZDriverFile bootdrive || ':\OS2'                */

    say 'COPYING' AZDriverFile 'TO' targetdir
    copy AZDriverFile targetdir

rc = stream(AZinfile, c, 'open read')
if  rc <> 'READY:' then do
	say 'INSTALL: Could not open ' infile
	signal ErrorExit
end /* If */

rc = stream(AZoutfile, c, 'open write')
if  rc <> 'READY:' then do
	say 'INSTALL: Could not open ' outfile
	signal ErrorExit
end /* If */

do until lines(AZinfile) = 0			/* Loop until no lines */
                                       /* remain in file...  */
	buffer = linein(AZinfile)		/* Get a line into buffer */
	buffer2 = translate(buffer)		/* Convert line to upper case */

	if pos('ADI2', buffer2) <> 0		/* Are there old ADI2 statements */
		then iterate			/* don't copy them to outfile */

	if pos('ADIO', buffer2) <> 0		/* Are there old 'new' ADIO statements */
		then iterate			/* don't copy them to outfile */

	if pos(OldDriver, buffer2) = 0		/* Look for current driver */
		then rc = lineout(AZoutfile, buffer) /* No match */
		else				/* Match */

	/* Found the old driver, now see if it is already commented out */
	/* If first word is REM just write the line out */
		if pos('REM', strip(buffer2)) = 1
		then do
                   rc = lineout(AZoutfile, buffer)
                   rc = lineout(AZoutfile, NewDev)
              end /* do */
	/* Otherwise, Add REM statement */
		else do
              rc = lineout(AZoutfile, 'rem ' || buffer)
/* rework the new line to use the old line while replacing the IBM1S506.ADD
   with the current driver name in order to preserve any command line
   parameters that the user may have added    */

/*              rc = lineout(AZoutfile, NewDev)   */
              /* overwrite the IBM1S506.ADD with ADI0xxx.ADD, with
                 blank padding to ensure that we conpletely overwrite 
                 the old driver's name   */
              buffer2 = overlay( NewDriver, buffer, pos( OldDriver, buffer ),length( OldDriver ) )
              rc = lineout(AZoutfile, buffer2)

         end  /* do */

end  /* Do */

/* ejc - move so we put adio right after commented out ibm1s506 */
/* rc = lineout(AZoutfile, NewDev) */

rc = stream(AZinfile, c, 'close')
rc = stream(AZoutfile, c, 'close')

del AZinfile
ren AZoutfile ifile
say 'You must Shutdown then ReBoot for the changes to take effect!'
pause

ErrorExit:
exit						/* end the program */

/* Subroutines */

GetBootDrive:			/* Returns boot drive from environment */
env = 'OS2ENVIRONMENT'
temp = value('COMSPEC',,env)
return substr(strip(temp),1,1)

