/* Modem Installation Script */

/* Rev 1.00  10 Jun 98  David Levin */
/* Rev 1.01  7 July 98 David Levin */
/* 30 August 05 Chuck McKinnis */

/* Load advanced rexx functions */
Call Rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call SysLoadFuncs

/* String Definitions */
companyname = 'Xircom, Inc.'
modfile = 'CBMODEM.OS2'
nicfile = 'CBENDIS.OS2'

/* String Initilizations */
srcdrive = Directory()
srcpath = srcdrive||'\'||modfile
env = 'OS2ENVIRONMENT'
targetdrive = SysBootDrive()
targetpath = targetdrive||'\OS2\BOOT'
targetdevice = 'DEVICE='||targetpath||'\'||modfile
originalconfig = targetdrive||'\CONFIG.SYS'
backupconfig = SysTempFileName(targetdrive||'\CONFIG.???')
currentport = 'AUTO'

/* Main Code */
Say 'Orginal CONFIG.SYS is being saved as' backupconfig||'.'
Address cmd '@copy' originalconfig backupconfig '> nul'
Say 'Checking if the' companyname 'modem driver is currently installed.'
Call SysFileSearch targetdevice,originalconfig,'file.','N'
If file.0 = 0 Then Do
 Say 'The' companyname 'modem driver is not currently installed.'
 Call SysFileSearch '\COM.SYS',originalconfig,'cfile.','N'
 If cfile.0 <> 0 Then c_line = Word(cfile.1,1)
 Else c_line = 9999999
 Call SysFileSearch '\CBENDIS.OS2',originalconfig,'cfile.','N'
 If cfile.0 <> 0 Then n_line = Word(cfile.1,1)
 Else n_line = 999999
 comline = Min(c_line n_line)
End
Else Do
 comline = Word(file.1,1)
 currentport = Subword(file.1,3)
 If Abbrev(currentport,'COM') Then Say 'Com port driver already installed. Using' currentport
 Else Do
  Say 'Com port driver already installed. Using AUTO com port assignment.'
  currentport = 'AUTO'
 End
End
Say
Say 'If you do not wish to use auto com port assignment'
Say 'enter the number of the com port you wish to use [1,2,3,4]'
Say 'or hit Enter to keep the current setting.'
Pull portchoice
If portchoice = '1' Then currentport = 'COM1'
If portchoice = '2' Then currentport = 'COM2'
If portchoice = '3' Then currentport = 'COM3'
If portchoice = '4' Then currentport = 'COM4'
If currentport <> 'AUTO' Then targetdevice = targetdevice currentport
Say 'Copying Driver.'
Address cmd '@copy' srcpath targetpath '> nul'
Say 'Updating CONFIG.SYS.'
t_lines. = ''
t_lines.0 = 0
Call Stream originalconfig,'c','open read'
Do While Lines(originalconfig)
 t_data = Linein(originalconfig)
 If t_data = '' Then t_data = '20'x
 Call SysStemInsert 't_lines.',t_lines.0 + 1,t_data
End
Call Stream originalconfig,'c','close'
If file.0 <> 0 Then t_lines.comline = targetdevice
Else Call SysStemInsert 't_lines.',comline,targetdevice
Call SysFileDelete originalconfig
Call Stream originalconfig,'c','open write'
Do x = 1 To t_lines.0
 If t_lines.x = '20'x Then t_lines.x = ''
 Call Lineout originalconfig,t_lines.x
End
Call Lineout originalconfig,'20'x
Call Stream originalconfig,'c','close'
Say 'Modem driver installation completed.'
Say
Say 'Thank you for choosing' companyname
Return
