
;/*************************************************************************
;*
;* SOURCE FILE NAME = GRAPHIRE.ASM
;*
;**************************************************************************

.xlist
       	include pmode.inc
       	include devsym.inc
       	include devhlp.inc
       	include struc.inc
       	include dddd.inc
       	include devhlpP.inc            ;76711
.list

.286p

;*
;*    External Mouse Module Data References
;*
        SUPPRESS EQU 3

        extrn OLDTABX             : word
        extrn OLDTABY             : word
        extrn OLDTABB             : word
        extrn RELA                : byte
        extrn TABOPT              : byte
;        extrn TABX                : word
;        extrn TABY                : word
;        extrn TABB                : word
;        extrn TABZ                : word
       	extrn XSIZE               : word
       	extrn YSIZE               : word
       	extrn OKPRESS             : word

;        extrn TabProc             : byte
;        extrn TabMsg              : byte
       	extrn MEvent              : byte
       	extrn Disable_8259        : byte
       	extrn Enable_8259         : byte
       	extrn DeviceData          : byte
       	extrn MseDD               : byte

       	extrn First_Port          : word
       	extrn ByteCount           : word
       	extrn DevStatus           : word
       	extrn IntPacketOff        : word

       	extrn Device_Help         : dword

        extrn ENDDATA             : near
       	extrn Disable_Device      : near
       	extrn Enable_Device       : near


CSEG    SEGMENT   WORD  PUBLIC  'CODE'
        ASSUME    CS:CSEG, SS:nothing, ES:nothing, DS:nothing

;*
;*    Module Procs made Public for other Mouse Modules
;*

       	public  Interrupt_Handler


;*******************************************************************
;*
;*  FUNCTION NAME :  Interrupt_Handler
;*  DESCRIPTION   :  Mouse device Interrupt Handler.
;*
;*  RETURN-NORMAL :  Always, carry clear -- our interrupt.
;***********************************************************************

Interrupt_Handler  Proc  Far

       ;*
       ;* issue the EOI and disable the IRQ
       ;*

        call Disable_Device            ; disable the device 1st
        cli
        DevEOI    <DeviceData.IRQ>,Device_Help
        sti

;*
;* Check the read packet first, then check initialization request blocks.
;*
        ReadAsync                       ; read interrupt data
;       DebugMSG TabProc

;*
;* Form data packet
;*
        cmp  al, 80h                 ; first byte ?
        jb   NextByte
        mov  MEvent[0], al           ; save button data
        mov  ByteCount, 1            ; ready for 2nd byte

IntNearExit:
        jmp  IntExit

NextByte:
        cmp  ByteCount, 0            ; if got wrong byte - exit
        je   IntNearExit

        mov  di, ByteCount           ; get byte count for index
        mov  MEvent[di], al          ; save this byte
        inc  ByteCount

        cmp  ByteCount, PACKETSIZE
        jne  IntNearExit

;        DebugMSG TabMsg

;* Process Misc tablet data (Proximity, Stylus flag)
;* Process X
        mov  al, MEvent[0]

        mov  ah, al              ; copy to process misc tablet data
        shr  ah, 5
        mov  TABOPT, ah          ; save misc tablet data (xxxxxxPS)
        mov  dh, ah              ; save misc tablet data to use in pressure part
        test ah, 2               ; in proximity ?
        jnz  InProximity
        xor  cx, cx              ; if no - reset buttons
        jmp  OutProximity

InProximity:
        xor  ah, ah              ; process X-pos
        and  ax, 3
        shl  ax, 14
        mov  bx, ax

        mov  al, MEvent[1]
        xor  ah, ah
        shl  ax, 7

        add  al, MEvent[2]
        adc  ah, 0
        add  ax, bx
        mov  si, ax              ; si - x

;* Process Buttons (below is out Event format in cx)
;            Bit 6             Button 3 usage, without motion
;            Bit 5             Button 3 usage, with motion
;            Bit 4             Button 2 usage, without motion
;            Bit 3             Button 2 usage, with motion
;            Bit 2             Button 1 usage, without motion
;            Bit 1             Button 1 usage, with motion
;            Bit 0             Pure motion was recorded.
        mov  ah, MEvent[3]      ; make buttons event without motion
        mov  al, ah
        mov  dl, ah
        and  dl, 00001000b
        shr  dl, 1
        and  ah, 00010000b
        and  al, 00100000b
        shl  al, 1
        or   al, ah
        or   al, dl
        xor  ah, ah
        mov  cx, ax              ; cx - buttons

;* Process Y
        mov  al, MEvent[3]
        xor  ah, ah
        and  ax, 3
        shl  ax, 14
        mov  bx, ax

        mov  al, Mevent[4]
        xor  ah, ah
        shl  ax, 7

        add  al, MEvent[5]
        adc  ah, 0
        add  ax, bx

        mov  bx, ax              ; bx - y

;* Process Pressure
        test dh, 1
        jz   StepOver2           ; if it's mouse - skip pressure part

        mov  al, MEvent[6]
        and  al, 3Fh
        xor  ah, ah
        shl  ax, 1
        mov  di, ax
        mov  al, MEvent[3]
        and  al, 4
        shr  al, 2
        xor  ah, ah
        add  di, ax
        shl  di, 1
        mov  al, MEvent[0]
        and  al, 4
        shr  al, 1
        xor  ah, ah
        add  di, ax
        mov  al, MEvent[6]
        test al, 40h
        jnz  Stepover
        add  di, 256             ; di - pressure

Stepover:
        cmp  di, OKPRESS         ; is pressure enough ?
        jb   StepOver2
        or   cl, 4

Stepover2:
        mov  ax, si              ; ax - x

;        mov  TABX, ax
;        mov  TABY, bx
;        mov  TABZ, di
;        mov  TABB, cx

;* Suppress pen tremor
        push ax
        push bx

        sub  ax, OLDTABX
        jnc  OverSub1
        neg  ax
OverSub1:
        sub  bx, OLDTABY
        jnc  OverSub2
        neg  bx
OverSub2:

        cmp  ax, SUPPRESS
        ja   WasMovement
        cmp  bx, SUPPRESS
        ja   WasMovement
        jmp  NoMovement

WasMovement:
        shr  cx, 1
        pop  bx
        pop  ax
        mov  OLDTABX, ax
        mov  OLDTABY, bx
        or   cx, cx             ; any buttons to process?
        jnz  ProcessPacket
        inc  cx                 ; set only_movement flag
        jmp  ProcessPacket

NoMovement:
        pop  ax
        pop  ax
        cmp  cx, OLDTABB        ; any button changes?
        je   IntExit            ; if no - exit

OutProximity:
        mov  ax, OLDTABX
        mov  bx, OLDTABY

ProcessPacket:
        mov  OLDTABB, cx
        Process_ABSPacket        ; macro to process int data (cx,ax,bx)

IntExit:
        call Enable_Device              ; make sure to enable the IRQ level
        clc                             ; our interrupt
        ret                             ; return to intr hndlr

Interrupt_Handler  EndP

CSEG     ENDS
         END

