/* This REXX program only needs to be run once, and only if you are
   upgrading from PM Radio 1.02 or earlier.
   It must be run in the directory containing the PM Radio INI file.
*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call fixini 'PMRADIO.INI'
call fixini 'PMRADIOD.INI'
say 'Done!'
exit

fixini:
  arg inifile
  call SysFileTree inifile, 'fname', 'O'
  if fname.0 = 0 then do
    say 'INI file' inifile 'not found'
    return
  end
  call SysIni inifile, 'Event', 'Event_1'
  if result \= 'ERROR:' then do
    call SysIni inifile, 'Events', 'Event_1', result
    call SysIni inifile, 'Event', 'Event_1', 'DELETE:'
    say 'INI file' inifile 'found and upgraded'
  end
  return
