/**
 * dbghlp.c - A debugging helper driver
 *
 * Copyright (c) 2014-2015 David Azarewicz david@88watts.net
 *
 */
#include "Dev16lib.h"
/* Use iprintf so it works for basedevs */
#define CPRINTF iprintf

void StrategyInit(PREQPACKET prp);

#pragma aux StrategyHandler far parm [es bx];
void StrategyHandler(PREQPACKET prp)
{
  prp->usStatus = RPDONE;

  switch (prp->bCommand) {

  case STRATEGY_BASEDEVINIT:
  case STRATEGY_INIT:
    StrategyInit(prp);
    break;

  case STRATEGY_OPEN:
    break;

  case STRATEGY_CLOSE:
    break;

  case STRATEGY_GENIOCTL:
    prp->usStatus = RPDONE;
    break;

  case STRATEGY_DEINSTALL:
    break;

  case STRATEGY_INITCOMPLETE:
    Drv16InitComplete();
    break;

  case STRATEGY_SAVERESTORE:
    break;

  default:
    prp->usStatus = RPDONE | RPERR | RPERR_GENERAL;
    break;
  }
}

#pragma code_seg ("_inittext");
#pragma data_seg ("_initdata","endds");

char cDevName[] = "DBGHLP$";
int g_Verbose = 0;

void StrategyInit(PREQPACKET pPacket)
{
  const char far *pszCmdLine;

  UtSetDriverName(cDevName);

  Drv16Init(pPacket);

  /* Process all the command line parameters. */
  pszCmdLine = pPacket->init_in.szArgs;

  while (pszCmdLine && *pszCmdLine)
  {
    if (*pszCmdLine++ != '/') continue; /* Ignore anything that doesn't start with '/' */
    /* pszCmdLine now points to first char of argument */

    if (ArgCmp(pszCmdLine, "V"))
    {
      pszCmdLine++; /* skip the 'V' */
      g_Verbose = 1;
      continue;
    }
    if (ArgCmp(pszCmdLine, "INT3"))
    {
      pszCmdLine += 4;
      DevInt3();
      continue;
    }
    if (ArgCmp(pszCmdLine, "DELAY="))
    {
      pszCmdLine += 6;
      msleep(strtol(pszCmdLine, &pszCmdLine, 0));
      continue;
    }
    if (ArgCmp(pszCmdLine, "COM="))
    {
      pszCmdLine += 4; /* skip the "COM=" */
      D16g_ComBase = strtol(pszCmdLine, &pszCmdLine, 0);
      if (D16g_ComBase == 1) D16g_ComBase = 0x3f8;
      if (D16g_ComBase == 2) D16g_ComBase = 0x2f8;
      continue;
    }
    if (ArgCmp(pszCmdLine, "BAUD="))
    {
      pszCmdLine += 5; /* skip the "BAUD=" */
      InitComPort(strtol(pszCmdLine, &pszCmdLine, 0));
      continue;
    }
    if (ArgCmp(pszCmdLine, "SAY="))
    {
      static char achMessage[80];

      pszCmdLine +=4;
      pszCmdLine += GetString(pszCmdLine, &achMessage, sizeof(achMessage));
      CPRINTF("%s\n", achMessage);
      continue;
    }
    if (ArgCmp(pszCmdLine, "PUT="))
    {
      static char achMessage[80];

      pszCmdLine +=4;
      pszCmdLine += GetString(pszCmdLine, &achMessage, sizeof(achMessage));
      if (D16g_ComBase) dprintf(0, "%s\n", achMessage);
      continue;
    }
    if (ArgCmp(pszCmdLine, "BEEP"))
    {
      USHORT usFreq = 0;

      pszCmdLine +=4;
      if (*pszCmdLine == '=')
      {
        pszCmdLine++;
        usFreq = strtol(pszCmdLine, &pszCmdLine, 0);
      }
      if (usFreq == 0) usFreq = 900;
      DevHelp_Beep(usFreq, 150);
      msleep(150);
      continue;
    }

    CPRINTF("Unrecognized switch: %Fs\n", pszCmdLine-1);
  }

  pPacket->usStatus = 0x8115; /* RPDONE RPERR_INIT */
  pPacket->init_out.usCodeEnd = 0;
  pPacket->init_out.usDataEnd = 0;
  if (g_Verbose) CPRINTF("Driver %s was run.\n", cDevName);
}
