/*REXX add 1 spciirq line to config.sys, \os2\boot\snoop.lst if needed */
Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs
Call SysCls

Say 'primitive install program for set-pci-irq-driver'
Say 'press q to quit, other key to continue'
reply = SysGetKey('NoEcho')
if Translate(reply)='Q' then Return 0

/* Copy files */

'@copy spciirq.snp' SysBootDrive()||'\os2\boot\'
'@copy spciirq.sym' SysBootDrive()||'\os2\boot\'
'@copy spciirq.sys' SysBootDrive()||'\os2\boot\'

/* insert spciirq.snp into \os2\boot\snoop.lst */

snoop_file=SysBootDrive()||'\os2\boot\snoop.lst'
if Stream(snoop_file, 'C', 'Query Exist') == '' then
  do
    Say 'file' snoop_file 'does not exist.'
    Return 99
  end

i=0
found=0
do while lines(snoop_file)
  i=i+1
  snoop.i = linein(snoop_file)
  found = Abbrev(Translate(snoop.i),'SPCIIRQ.SNP') | found
end

Call Stream snoop_file,'C','Close'

if \found then
  do
    '@del' snoop_file
    Call LineOut snoop_file, 'SPCIIRQ.SNP'
    do j = 1 to i
       Call LineOut snoop_file, snoop.j
    end
    Call Stream snoop_file,'C','Close'
  end
  
/* verify that hardware detection level allows running snoopers */

previous_dat=SysBootDrive()||'\os2\boot\previous.dat'
if Stream(previous_dat, 'C', 'Query Exist')<>'' then

  do while 1
  
    SnoopLevel=CharIn(previous_dat,1,1)
    Call Stream previous_dat, 'C', 'Close'
    SnoopLevel=C2D(SnoopLevel)
    Select 
      when SnoopLevel==0 then Say 'SnoopLevel is currently set to previous hardware (bad)'
      when SnoopLevel==1 then Say 'SnoopLevel is currently set to removed hardware (why?)'
      when SnoopLevel==2 then Say 'SnoopLevel is currently set to added hardware (why?)'
      when SnoopLevel==3 then Say 'SnoopLevel is currently set to complete hardware (good!)'
      when SnoopLevel==4 then Say 'SnoopLevel is currently set to no hardware detection (bad)'
    Otherwise
                              Say 'SnoopLevel is currently set to an unknown level ('SnoopLevel').'
    end
    
    if (SnoopLevel==1) | (SnoopLevel==2) | (SnoopLevel==3) then
      Leave
      
    Say 'That SnoopLevel will prevent spciirq.snp from running, and is not'
    Say 'recommended anyway! Please open the Hardware manager folder,'
    Say 'open its settings notebook first page, then change the detection'
    Say 'level to"Complete Hardware". Press a key when you have done so.'
    ignored_key = SysGetKey('NoEcho')

  end
  
/* Add custom config.sys lines */
Say ''
Say ''
Say 'BIOS mode is what "should" work, and work on any machine, but in many'
Say 'cases errors in the BIOS prevent it from working, usualy with error code'
Say 'of 88 - "set failed". LINK mode will work better in this case, but is'
Say 'hardware depended - see chipset list. Recommended mode is LINK.'
Say 'If it does not work, please ask the author for driver updates.'
Say ''

reply = ask('Please choose B)IOS or L)INK mode.')
reply = SubStr(reply,1,1)
if reply='B' then
  do
    bus      = ask('BUS number, range 0..255 or $00..$ff, usually 0')
    device   = ask('Device number, range 0..31 or $0..$1f')
    function = ask('Function number, range 0..7','most PCI cards use only function 0')
    pin      = ask('Pin, range A..D','add-in cards use Pin A most time, seldomly also B.')
    para = bus device function 'INT'||pin||'#'
  end
else if reply='L' then
  do
    link     = ask('Link number, range 1..255 or $01..$ff, depends on chipset','Example: Intel typically has $60..$63')
    para = 'LINK' link
  end
else
  Return 99

int = ask('Interrupt number, range 1..15 or $1..$f')

'@echo BaseDev=spciirq.sys' para int '>>'||SysBootDrive()||'\config.sys'
Say 'Done.'
Return 0

ask:
  Parse Arg title1, title2
  Say title1
  if title2<>'' then Say title2
  Call CharOut ,'> '
  pull reply
  if reply='' then
    do
      Say 'Canceled.'
      Exit 99
    end
  Return Translate(reply)
