#ifndef __NDFS__H
#define __NDFS__H

#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

    /* this is the file system ID as in DOSQUERYFSINFO */
    #define NDFS_ID              0x21401785UL
    
    #define ND_FSDNAME           "NDFS"

    /* resource common flags */
    #define ND_FLAG_WRITEPROTECT      0x1
    
    /* mount points flags */
    #define MP_FLAG_NORMAL            0x0
    
    /* NdQueryInfo infolevels */
    #define ND_INFO_IFS            0 
    #define ND_INFO_CTL            1 
    
    #pragma pack(1)
    typedef struct _RIDINFO
    {
        ULONG  ulReqCompleted;
        USHORT usReqMax;
        USHORT usReqInProcess;
        USHORT usReqMaxInProcess;
        USHORT usReqRetCnt;
        USHORT usReqCptCnt;
        ULONG  ulFreeHits;
        ULONG  ulCptHits;
        ULONG  ulFreeFaults;
        ULONG  ulCptFaults;
        ULONG  ulFreeScanned;
        ULONG  ulCptScanned;
    } RIDINFO;
    
    typedef struct _IFSINFO
    {
        CHAR    achName[8];
        USHORT  usVerMajor;
        USHORT  usVerMinor;
        RIDINFO ridInfo;
        USHORT  usCpgmConnected;
        USHORT  usCpgmPID;
    } IFSINFO;
    
    typedef struct _CTLINFO
    {
        USHORT  usCpgmConnected;
        USHORT  usCpgmPID;
        ULONG   ulVersion;
    } CTLINFO;
    
    #pragma pack()


    APIRET APIENTRY  NdQueryInfo (ULONG infolevel,
                                  PVOID pBuf,
                                  PULONG pcbBuf);
                                 
    APIRET APIENTRY  NdAttach (PSZ pszDevice,
                               PSZ pszLabel,
                               ULONG cUnit,
                               ULONG cUnitAvail);

    APIRET APIENTRY  NdDetach (PSZ pszDevice);
    
    APIRET APIENTRY  NdSetDriveInfo (PSZ pszDevice,
                                     ULONG cUnit,
                                     ULONG cUnitAvail);
                                     
    APIRET APIENTRY  NdMount (PSZ pszType,
                              ULONG ulFlags,
                              PSZ pszDest, 
                              PSZ pszSrc);

    APIRET APIENTRY  NdUnmount (PSZ pszDest, ULONG ulIndex);

    APIRET APIENTRY  NdIoctl (ULONG ulFunction,
                              PSZ   pszDest, 
                              PVOID pData, 
                              ULONG ulDataLenIn,
                              PULONG pulDataLenOut);
                              
    APIRET APIENTRY NdCreateMountPoint (PSZ pszPath, ULONG ulFlags);
    
    APIRET APIENTRY NdDeleteMountPoint (PSZ pszPath);
    
    APIRET APIENTRY NdKill (void);
    
    APIRET APIENTRY NdLoadPlugin (PSZ pszName);

    APIRET APIENTRY NdFreePlugin (PSZ pszName);

    #define ORD_NDQUERYINFO           1
    #define ORD_NDATTACH              2
    #define ORD_NDDETACH              3
    #define ORD_NDSETDRIVEINFO        4
    #define ORD_NDMOUNT               5
    #define ORD_NDUNMOUNT             6
    #define ORD_NDIOCTL               7
    #define ORD_NDCREATEMOUNTPOINT    8
    #define ORD_NDDELETEMOUNTPOINT    9
    #define ORD_NDKILL               10
    #define ORD_NDLOADPLUGIN         11
    #define ORD_NDFREEPLUGIN         12
    

        /* IOCTL functions */
        #define ND_IOCTL_QUERYMOUNTPOINT        0
        #define ND_IOCTL_QUERYMOUNTINFO         1
        #define ND_IOCTL_REFRESH                2
        #define ND_IOCTL_QUERYMOUNTINFOSHORT    3
        #define ND_IOCTL_QUERYRESOURCEBYINDEX   4
     
        #pragma pack(1)
        typedef struct _ND_PARAM_QUERYRESOURCEBYINDEX
        {
            ULONG ulIndex;
        } ND_PARAM_QUERYRESOURCEBYINDEX;
        typedef ND_PARAM_QUERYRESOURCEBYINDEX *PND_PARAM_QUERYRESOURCEBYINDEX;
        
        typedef struct _ND_DATA_MOUNTINFOSHORT
        {
            USHORT usMountPointsTotal;
            USHORT usResourcesTotal;
            ULONG  cbName;
            CHAR   achName[CCHMAXPATH];
        } ND_DATA_MOUNTINFOSHORT;
        typedef ND_DATA_MOUNTINFOSHORT *PND_DATA_MOUNTINFOSHORT;
        
        typedef struct _ND_DATA_MOUNTINFO        
        {
            USHORT usMountPointsTotal;
            USHORT usMountPointsReturned;
            USHORT usResourcesTotal;
            USHORT usResourcesReturned;
            ULONG  cbName;
            CHAR   achName[1];
        } ND_DATA_MOUNTINFO;
        typedef ND_DATA_MOUNTINFO *PND_DATA_MOUNTINFO;
        
        typedef struct _ND_DATA_MOUNTPOINT
        {
            ULONG  cbName;
            CHAR   achName[1];
        } ND_DATA_MOUNTPOINT;
        typedef ND_DATA_MOUNTPOINT *PND_DATA_MOUNTPOINT;
        
        typedef struct _ND_DATA_MOUNTRESOURCE
        {
            CHAR   achType[8];
            ULONG  ulFlags;
            ULONG  cbData;
            CHAR   achData[1];
        } ND_DATA_MOUNTRESOURCE;
        typedef ND_DATA_MOUNTRESOURCE *PND_DATA_MOUNTRESOURCE;
        #pragma pack()

#endif /* __NDFS__H */
