//
// $Header: D:/32bits/ext2-os2/minifsd/RCS/fs_misc.c,v 9.1 1997/03/15 22:31:04 Willm Exp Willm $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the "Developer Connection Device Driver Kit" version 2.0
#include <dhcalls.h>            // From the "Developer Connection Device Driver Kit" version 2.0
#include <strat2.h>             // From the "Developer Connection Device Driver Kit" version 2.0


#include <string.h>
#include <stdlib.h>                // for atol() ...

#include <fsd.h>
#include <fsh.h>

/***********************************************************************************/
/*** Fichiers inclus locaux                                                      ***/
/***********************************************************************************/
#include <linux/stat.h>

#include <os2/ifsdbg.h>
#include <os2/filefind.h>
// #include <os2/cdfsd.h>
#include <os2/errors.h>

#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */
#include <os2/volume.h>      /* Prototypes des fonctions de volume.c                   */

#include <os2/os2proto.h>
#include <os2/os2misc.h>
#include <os2/vfsapi.h>
#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_fs.h>
#include <linux/e2_proto.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/stat.h>

#include <os2/minifsd.h>

/***********************************************************************************/
/*** Nom et attributs du FSD                                                     ***/
/***********************************************************************************/


char FS_NAME[]             = "ext2";
unsigned long FS_ATTRIBUTE = 0;


/***********************************************************************************/
/*** Errors not in bseerr.h (IFS specific or ext2_os2 specific)                  ***/
/***********************************************************************************/

#define ERROR_VOLUME_NOT_MOUNTED 0xEE00                // IFS specific

/***********************************************************************************/
/*** Some useful defines for FS_OPENCREATE() ...                                 ***/
/***********************************************************************************/

   #define OPEN_ACCESS_MASK               0x0007  /* ---- ---- ---- -111 */
   #define OPEN_ACCESS_EXECUTE            0x0003  /* ---- ---- ---- -100 */

   #define OPEN_SHARE_MASK                0x0070  /* ---- ---- -111 ---- */
   #define OPEN_LOCALITY_MASK             0x0700  /* ---- -111 ---- ---- */
   #define OPEN_ACTION_EXIST_MASK         0x000F  /* ---- ---- ---- 1111 */
   #define OPEN_ACTION_NEW_MASK           0x00F0  /* ---- ---- 1111 ---- */

#define FILE_NONFAT     0x0040                // File is non 8.3 compliant


/***********************************************************************************/
/*** Device helper entry point                                                   ***/
/***********************************************************************************/

extern unsigned long Device_Help;

#define THISFILE FILE_TEST_C

/***********************************************************************************/
/*** Some external data ...                                                      ***/
/***********************************************************************************/


extern unsigned long event;                // To be moved somewhere in a .h file

/***********************************************************************************/
/*** Time zone so that time stamps shown in OS/2 are the same as in Linux        ***/
/***********************************************************************************/

long timezone                  = 0;     // Time zone (second shift from UTC)

/***********************************************************************************/
/*** FS_INIT()                                                                   ***/
/***********************************************************************************/
extern void stage2_ll_rw_block();
extern void (*__ll_rw_block)();

extern void (*wait_on_inode)();
extern void (*lock_inode)();
extern void (*unlock_inode)();

extern void stage2_wait_on_inode(struct inode * inode);
extern void stage2_lock_inode(struct inode * inode);
extern void stage2_unlock_inode(struct inode * inode);

extern void stage2_wake_up(void *wait);
extern void stage2_sleep_on(void *wait);
extern void (*sleep_on)();
extern void (*wake_up)();
extern int (far pascal *system_halt)();

extern void inode_stage1_to_stage2(void);

extern struct super_block *stage2_getvolume(unsigned short hVPB);
extern struct super_block *(*getvolume)(unsigned short);


extern struct file_system_type ext2_fs_type;

_FS_RET _FS_ENTRY FS_INIT(
                          pchar                 szParm,
                          unsigned long         DevHelp,
                          unsigned long _FS_PTR pMiniFSD
                         )
{

    printk("FS_INIT(DevHelp=%lu szParm=%lu pMiniFSD=%lu)", DevHelp, szParm, pMiniFSD);

    //
    // Saves the device helper routine entry point
    //
    Device_Help = DevHelp;

    //
    // Updates system halt entry point
    //
    system_halt = FSH_INTERR;

    //
    // Updates memory allocation entry points
    //
    G_malloc = stage2_G_malloc;
    G_free   = stage2_G_free;

    //
    // Updates ll_rw_block entry points
    //
    __ll_rw_block = stage2_ll_rw_block;

    //
    // Updates inode entry points
    //
    wait_on_inode  = stage2_wait_on_inode;
    lock_inode     = stage2_lock_inode;
    unlock_inode   = stage2_unlock_inode;

    //
    // Updates the sched entry points
    //
    sleep_on = stage2_sleep_on;
    wake_up  = stage2_wake_up;

    //
    // Updates the volume entry points
    //
    getvolume = stage2_getvolume;


    //
    // Stage 1 to stage 2 transition for buffers and inodes.
    //
    inode_stage1_to_stage2();
    buffer_stage1_to_stage2();


    return NO_ERROR;

}


/***********************************************************************************/
/*** FS_CHGFILEPTR()                                                             ***/
/***********************************************************************************/
_FS_RET _FS_ENTRY FS_CHGFILEPTR(
                            struct sffsi _FS_PTR psffsi,
                            union  sffsd _FS_PTR psffsd,
                            long                 offset,
                            unsigned short       type,
                            unsigned short       IOflag
                           )
{
    off_t               newfileptr;

/*
    if (!(p_file = ((_sffsd _FS_PTR)psffsd)->p_file)) {
        kernel_printf("FS_CHGFILEPTR() - p_file = NULL");
        return ERROR_INVALID_PARAMETER;
    }
*/
    switch(type) {
        case CFP_RELBEGIN :
            newfileptr = offset;
            break;

        case CFP_RELCUR :
            newfileptr = psffsi->sfi_position + offset;
            break;

        case CFP_RELEND :
            newfileptr = psffsd->u.f->f_inode->i_size + offset;
            break;

        default :
            return ERROR_INVALID_PARAMETER;
    }

    if (newfileptr < 0) {
        return ERROR_INVALID_PARAMETER;
    }

    psffsd->u.f->f_pos        = newfileptr;
    psffsd->u.f->f_reada      = 0;
    psffsd->u.f->f_version    = ++event;

    psffsi->sfi_position = newfileptr;
    return NO_ERROR;
}


_FS_RET _FS_ENTRY FS_CLOSE(
                       unsigned short          type,
                       unsigned short          IOflag,
                       struct sffsi    _FS_PTR psffsi,
                       union  sffsd    _FS_PTR psffsd
                      )
{
    struct super_block * sb;
    int                  rc;

    printk("FS_CLOSE(ino = %lu, type = %d)",  psffsd->u.f->f_inode->i_ino, type);

    //
    // Gets the superblock from psffsi
    //
    if (!(sb = getvolume(psffsi->sfi_hVPB))) {
       ext2_os2_panic(0, "FS_CLOSE - Unable to retrieve superblock");
    }

/*
    //
    // Gets the file structure from psffsd
    //
    if (!(p_file = ((_sffsd _FS_PTR)psffsd)->p_file)) {
       ext2_os2_panic(0, "FS_CLOSE - p_file = NULL");
    }

*/

    //
    // The doc isn't clear about the role of the 'type' parameter. It seems we must
    // only free the resources (file structure in sffsd) at FS_CL_FORSYS time. Otherwise
    // we'' receive an empty sffsd somewhere else !
    // For other 'type' values, maybe we could do a flush ...
    //
    if (type != FS_CL_FORSYS) {
#ifdef FS_TRACE
        kernel_printf("***** Non final system close **** - sffsi->sfi_type = %d - Type = %d", psffsi->sfi_type, type);
#endif
        return NO_ERROR;
    } /* endif */


    //
    // Closes the file
    //
    if ((rc = vfs_close(psffsd->u.f)) != NO_ERROR) {
        fs_err(FUNC_FS_CLOSE, FUNC_CLOSE, rc, FILE_TEST_C, __LINE__);
        return rc;
    }

    //
    // Clean up of sffsd (safety purposes ...)
    //
    memset(psffsd, 0, sizeof(union sffsd));

    return NO_ERROR;
}





void _FS_ENTRY FS_EXIT(
                       unsigned short uid,
                       unsigned short pid,
                       unsigned short pdb
                      )
{
    printk("FS_EXIT( uid = %u pid = %u pdb = %u )", uid, pid, pdb);
}



_FS_RET _FS_ENTRY FS_IOCTL(
                           struct sffsi   _FS_PTR psffsi,
                           union  sffsd   _FS_PTR psffsd,
                           unsigned short         cat,
                           unsigned short         func,
                           char           _FS_PTR pParm,
                           unsigned short         lenParm,
                           unsigned       _FS_PTR pParmLenInOut,
                           char           _FS_PTR pData,
                           unsigned short         lenData,
                           unsigned       _FS_PTR pDataLenInOut
                          )
{
    int           rc;
    struct vpfsi *pvpfsi;
    union  vpfsd *pvpfsd;

    printk("FS_IOCTL pre-invocation : cat = 0x%0X, func = 0x%0X", cat, func);

    if ((rc = FSH_GETVOLPARM(psffsi->sfi_hVPB, &pvpfsi, &pvpfsd)) == NO_ERROR) {
        if ((rc = FSH_DEVIOCTL(
                               0,
                               pvpfsi->vpi_hDEV,
                               psffsi->sfi_selfsfn, /* sfn */
                               cat,
                               func,
                               pParm,
                               lenParm,
                               pData,
                               lenData
                              )) == NO_ERROR) {
            /*
             * Nothing ...
             */
        } else {
            kernel_printf("FS_IOCTL - FSH_DEVIOCTL returned %d", rc);
        } /* FSH_DEVIOCTL failed */
    } else {
        kernel_printf("FS_IOCTL - FSH_GETVOLPARM returned %d", rc);
    } /* FSH_GETVOLPARM failed */

    if (pDataLenInOut) {
        *pDataLenInOut = lenData;
    }
    if (pParmLenInOut) {
        *pParmLenInOut = lenParm;
    }

    return rc;
}


struct super_block * do_mount(
                              struct vpfsi          *pvpfsi,
                              union  vpfsd          *pvpfsd,
                              unsigned short         hVPB,
                              struct file_system_type *type
                             ) {
    struct super_block *tmp;
    struct super_block *sb;
    DriverCaps *pDCS;
    VolChars   *pVCS;


    sb = get_empty_super();
    pvpfsd->u.sb = sb;

    if ((sb) && (sb->s_magic_internal == SUPER_MAGIC)) {
        sb->sector_size       = pvpfsi->vpi_bsize;
        sb->nb_sectors        = pvpfsi->vpi_totsec;
        sb->s_drive           = pvpfsi->vpi_drive;
        sb->s_unit            = pvpfsi->vpi_unit;
        sb->s_blocksize       = BLOCK_SIZE;
        sb->sectors_per_block = BLOCK_SIZE / sb->sector_size;
        sb->s_dev             = hVPB;
        sb->s_status          = VOL_STATUS_MOUNT_IN_PROGRESS;
        /*
         * Mini FSD always read only
         */
        sb->s_flags           = MS_RDONLY;

    /*
     * Strategy 2 I/O support processing
     */

        if (pvpfsi->vpi_pDCS) {
            pDCS = (DriverCaps *)(pvpfsi->vpi_pDCS);
            if (pvpfsi->vpi_pVCS) {
                pVCS = (VolChars *)(pvpfsi->vpi_pVCS);
                if (pDCS->Strategy2) {
                    kernel_printf("\tStrategy 2 entry point found");
                    if (pVCS) {
                        kernel_printf("\tVolume descriptor        : 0x%04X", pVCS->VolDescriptor);           /* see equates below                    */
                        kernel_printf("\tAverage seek time        : %d",     pVCS->AvgSeekTime);             /* milliseconds, if unknown, FFFFh      */
                        kernel_printf("\tAverage latency time     : %d",     pVCS->AvgLatency);               /* milliseconds, if unknown, FFFFh      */
                        kernel_printf("\tBlocks on smallest track : %d",     pVCS->TrackMinBlocks);          /* blocks on smallest track             */
                        kernel_printf("\tBlocks on largest track  : %d",     pVCS->TrackMaxBlocks);          /* blocks on largest track              */
                        kernel_printf("\tMax scatter-gather list  : %d",     pVCS->MaxSGList);               /* Adapter scatter/gather list limit    */
                    }
                    if ((pVCS) && (pVCS->VolDescriptor & VC_REMOVABLE_MEDIA)) {
                        kernel_printf("\tMedia is removable, not supported for strat 2 yet !");
                    } else {
                        kernel_printf("\tMedia is NOT removable, using strat 2 I/Os");
                        sb->s_strat2 = pDCS->Strategy2;
                    }
                } else {
                    kernel_printf("\tNO strategy 2 entry point found, using standard FSH_DOVOLIO instead");
                }
            }
        }

    if ((type) && (type->read_super)) {
        tmp = type->read_super(sb, 0, 0);
        if (tmp) {
            sb->s_blocks_per_page = (unsigned char)(4096 / sb->s_blocksize);
            sb->s_status          = VOL_STATUS_MOUNTED;
            /*
             * nothing else to do ...
             */
        } else {
            put_super(sb);
            sb = 0;
        }
    } else {
        sb = 0;
    }

    } else {
        sb = 0;
    }

    return sb;
}

extern int check_ext2fs_magic(struct vpfsi *pvpfsi, unsigned short hVPB);


_FS_RET _FS_ENTRY FS_MOUNT(
                           unsigned short         flag,
                           struct vpfsi   _FS_PTR pvpfsi,
                           union  vpfsd   _FS_PTR pvpfsd,
                           unsigned short         hVPB,
                           char           _FS_PTR pBoot
                          )
{
    int rc;
    struct super_block *sb;
    struct super_block *old_sb;
    unsigned short oldhVPB;


    switch(flag) {
        case MOUNT_MOUNT :
             kernel_printf("FS_MOUNT flg = MOUNT_MOUNT hVPB = 0x%04X", hVPB);

            /*
             * We zero out pvpfsd for safety purposes !
             */
            memset(pvpfsd, 0, sizeof(union vpfsd));

            if ((rc = check_ext2fs_magic(pvpfsi, hVPB)) == NO_ERROR) {
                /*
                 * The volume serial number is a CRC checksum of the boot sector
                 */
                pvpfsi->vpi_vid = updcrc((unsigned char *)pBoot, pvpfsi->vpi_bsize);

                /*
                 * The volume label is dummy for the moment ("ext2fs_<drive>")
                 */
                sprintf(pvpfsi->vpi_text, "EXT2FS_%c", pvpfsi->vpi_unit + 'A');


                /*
                 * Is there another instance of the drive ?
                 *     - Yes : update internal volume table and return silently
                 *     - No  : continue the mount process
                 */
                if ((rc = FSH_FINDDUPHVPB(hVPB, &oldhVPB)) == NO_ERROR) {
                    kernel_printf(" \tFSH_FINDDUPHVPB(0x%0X) - Found dup hVPB 0x%0X", hVPB, oldhVPB);

                    old_sb = getvolume(oldhVPB);

                    if ((old_sb) && (old_sb->s_magic_internal == SUPER_MAGIC)) {
                        old_sb->s_status = VOL_STATUS_MOUNTED;
                        rc               = NO_ERROR;
                    } else {
                        kernel_printf("Cannot find old superblock !");
                        rc = ERROR_INVALID_PARAMETER;
                    }


                } else {
                    kernel_printf(" \tFSH_FINDDUPHVPB - NO dup hVPB");
                    /*
                     * This is the first instance of the drive
                     */

                    sb = do_mount(pvpfsi, pvpfsd, hVPB, &ext2_fs_type);

                    if (sb) {
                        kernel_printf("Volume characteristics :");
                        kernel_printf("========================");
                        kernel_printf("\t volume id    : 0x%08X", pvpfsi->vpi_vid);
                        kernel_printf("\t hDEV         : 0x%08X", pvpfsi->vpi_hDEV);
                        kernel_printf("\t sector size  : %u", pvpfsi->vpi_bsize);
                        kernel_printf("\t sector/track : %u", pvpfsi->vpi_trksec);
                        kernel_printf("\t heads        : %u", pvpfsi->vpi_nhead);
                        kernel_printf("\t tot sectors  : %lu", pvpfsi->vpi_totsec);
                        kernel_printf("\t drive (0=A)  : %d", (int)(pvpfsi->vpi_drive));
                        kernel_printf("\t unit code    : %d", (int)(pvpfsi->vpi_unit));
                        kernel_printf("\t volume label : %s", pvpfsi->vpi_text);
                        kernel_printf("\t hVPB         : 0x%08X", hVPB);

                        sb->s_status = VOL_STATUS_MOUNTED;
                        pvpfsd->u.sb = sb;
                        VirtToLin(sb, &(pvpfsd->u.sb_lin));
                        rc = NO_ERROR;
                    } else {
                        rc = ERROR_VOLUME_NOT_MOUNTED;
                    }
                }


            } else {
                kernel_printf("\tbasic superblock validation failed for volume 0x%04X", hVPB);
                rc = ERROR_VOLUME_NOT_MOUNTED;
            }
            break;

        case MOUNT_VOL_REMOVED :
             kernel_printf("FS_MOUNT flg = MOUNT_VOL_REMOVED hVPB = 0x%04X", hVPB);
             return ERROR_NOT_SUPPORTED;

        case MOUNT_RELEASE :
             kernel_printf("FS_MOUNT flg = MOUNT_RELEASE hVPB = 0x%04X", hVPB);
             return ERROR_NOT_SUPPORTED;

        case MOUNT_ACCEPT :
             kernel_printf("FS_MOUNT flg = MOUNT_ACCEPT hVPB = 0x%04X", hVPB);
             return ERROR_NOT_SUPPORTED;

        default :
            kernel_printf("FS_MOUNT() invalid flag %d", flag);
            return ERROR_INVALID_PARAMETER;
    } /* end switch */

    return rc;
}






_FS_RET _FS_ENTRY FS_OPENCREATE(
                                struct cdfsi   _FS_PTR pcdfsi,
                                struct cdfsd   _FS_PTR pcdfsd,
                                char           _FS_PTR pName,
                                unsigned short         iCurDirEnd,
                                struct sffsi   _FS_PTR psffsi,
                                union  sffsd   _FS_PTR psffsd,
                                unsigned long          ulOpenMode,
                                unsigned short         openflag,
                                unsigned short _FS_PTR pAction,
                                unsigned short         attr,
                                char           _FS_PTR pEABuf,
                                unsigned short _FS_PTR pfgenFlag
                               )
{
    int rc;
    struct super_block * sb;
    struct file *p_file;
    UINT32 openmode;
    UINT32 accessmode;
    UINT16 newflag, existflag;
    char component[CCHMAXPATH];

    printk("FS_OPENCREATE(%s)", pName);

    //
    // Gets the superblock from psffsi
    //
    sb = getvolume(psffsi->sfi_hVPB);

#ifdef FS_TRACE
    if (ulOpenMode & OPEN_FLAGS_DASD) {
        printk("OPEN_FLAGS_DASD");
    }


    if (ulOpenMode & OPEN_FLAGS_WRITE_THROUGH) {
        printk("OPEN_FLAGS_WRITE_THROUGH");
    }
    if (ulOpenMode & OPEN_FLAGS_FAIL_ON_ERROR) {
        printk("OPEN_FLAGS_FAIL_ON_ERROR");
    }
    if (ulOpenMode & OPEN_FLAGS_NO_CACHE) {
        printk("OPEN_FLAGS_NO_CACHE");
    }
    if (ulOpenMode & OPEN_FLAGS_NOINHERIT) {
        printk("OPEN_FLAGS_NO_INHERIT");
    }
#endif
    accessmode = ulOpenMode & OPEN_ACCESS_MASK;

    if (accessmode == OPEN_ACCESS_READONLY) {
#ifdef FS_TRACE
        printk("OPEN_ACCESS_READONLY");
#endif
        openmode = OPENMODE_READONLY;
    }

    if (accessmode == OPEN_ACCESS_WRITEONLY) {
#ifdef FS_TRACE
        printk("OPEN_ACCESS_WRITEONLY");
#endif
        openmode = OPENMODE_WRITEONLY;
    }

    if (accessmode == OPEN_ACCESS_READWRITE) {
#ifdef FS_TRACE
        printk("OPEN_ACCESS_READWRITE");
#endif
        openmode = OPENMODE_READWRITE;
    }

#ifdef FS_TRACE
    if (accessmode == OPEN_ACCESS_EXECUTE) {
        printk("OPEN_ACCESS_EXECUTE");
    }
#endif

    newflag = openflag & OPEN_ACTION_NEW_MASK;

#ifdef FS_TRACE
    if (newflag == OPEN_ACTION_FAIL_IF_NEW) {
        printk("OPEN_ACTION_FAIL_IF_NEW");
    }
    if (newflag == OPEN_ACTION_CREATE_IF_NEW) {
        printk("OPEN_ACTION_CREATE_IF_NEW");
    }
#endif

    existflag = openflag & OPEN_ACTION_EXIST_MASK;

#ifdef FS_TRACE
    if (existflag == OPEN_ACTION_OPEN_IF_EXISTS) {
        printk("OPEN_ACTION_OPEN_IF_EXISTS");
    }
    if (existflag == OPEN_ACTION_FAIL_IF_EXISTS) {
        printk("OPEN_ACTION_FAIL_IF_EXISTS");
    }
    if (existflag == OPEN_ACTION_REPLACE_IF_EXISTS) {
        printk("OPEN_ACTION_REPLACE_IF_EXISTS");
    }
#endif

    if ((accessmode == OPEN_ACCESS_READWRITE) ||
        (accessmode == OPEN_ACCESS_WRITEONLY)) {
        return ERROR_NOT_SUPPORTED;
    }

    //
    // Direct access open of the whole device
    //
    if (ulOpenMode & OPEN_FLAGS_DASD) {
        kernel_printf("OPEN_FLAGS_DASD");
        if ((p_file = _open_by_inode(sb, INODE_DASD, openmode)) == 0) {
            kernel_printf("FS_OPENCREATE() - couldn't DASD open %s", pName);
            return ERROR_OPEN_FAILED;
        }
        psffsd->u.f          = p_file;
        VirtToLin(p_file, &(psffsd->u.f_lin));
        psffsi->sfi_tstamp   = ST_SCREAT | ST_PCREAT;
        psffsi->sfi_size     = p_file->f_inode->i_size;
        psffsi->sfi_position = p_file->f_pos;
        date_unix2dos(p_file->f_inode->i_ctime, &(psffsi->sfi_ctime), &(psffsi->sfi_cdate));
        date_unix2dos(p_file->f_inode->i_atime, &(psffsi->sfi_atime), &(psffsi->sfi_adate));
        date_unix2dos(p_file->f_inode->i_mtime, &(psffsi->sfi_mtime), &(psffsi->sfi_mdate));
        return NO_ERROR;

    }

    //
    // Now that we treated the OPEN_FLAGS_DASD special case, lets treat the general case :
    // Try to open the file readonly
    // Success : the file exists
    //     if !S_ISDIR && !S_ISREG => error
    //     if OPEN_ACTION_FAIL_IF_EXISTS set => error
    //     if OPEN_ACTION_OPEN_IF_EXISTS set
    //         <test file attrs>
    //         change the open mode and return OK
    //     if OPEN_ACTION_REPLACE_IF_EXISTS set
    //         OPEN_ACCESS_READONLY or OPEN_ACCESS_EXECUTE set => error
    //         OPEN_ACCESS_READWRITE or OPEN_ACCESS_WRITEONLY set
    //             truncate
    //             change openmode and return
    // Failure : the file does not exist
    //     OPEN_ACCESS_READONLY or OPEN_ACCESS_EXECUTE set => error
    //     OPEN_ACCESS_READWRITE or OPEN_ACCESS_WRITEONLY set
    //         if OPEN_ACTION_CREATE_IF_NEW set
    //             try to create the file
    //             open the file and return
    //         if OPEN_ACTION_FAIL_IF_NEW   set => error

    p_file = _open_by_name(sb, pName, openmode);
    if (p_file) {        // The file exists
        //
        // If it's not a regular file or a directory we cannot open
        //
        if (!S_ISREG(p_file->f_inode->i_mode)) {
            kernel_printf("Can't FS_OPENCREATE - %s is not a regular file", pName);
            if ((rc = vfs_close(p_file)) != NO_ERROR) {
                fs_err(FUNC_FS_OPENCREATE, FUNC_CLOSE, rc, FILE_TEST_C, __LINE__);
                return rc;
            }
            return ERROR_ACCESS_DENIED;
        }
        //
        // if OPEN_ACTION_FAIL_IF_EXISTS set => error
        //
        if (existflag == OPEN_ACTION_FAIL_IF_EXISTS) {
            printk("Can't FS_OPENCREATE() - File exists & OPEN_ACTION_FAIL_IF_EXISTS");
            if ((rc = vfs_close(p_file)) != NO_ERROR) {
                fs_err(FUNC_FS_OPENCREATE, FUNC_CLOSE, rc, FILE_TEST_C, __LINE__);
                return rc;
            }
            return ERROR_FILE_EXISTS;
        }

        //
        // if OPEN_ACTION_OPEN_IF_EXISTS : OK
        //
        if (existflag == OPEN_ACTION_OPEN_IF_EXISTS) {
            printk("\tFile %s OK", pName);
            *pAction        = FILE_EXISTED;
        }

    } else {                // The file doesn't exist
        printk("\tFile %s not found", pName);
        return ERROR_FILE_NOT_FOUND;
    }


    psffsd->u.f = p_file;
    VirtToLin(p_file, &(psffsd->u.f_lin));
    /*
     * Time stamping is done by inode routines - Only propagate value.
     */
    psffsi->sfi_tstamp   |= ST_PREAD;
    psffsi->sfi_size      = p_file->f_inode->i_size;
    psffsi->sfi_position  = p_file->f_pos;


    date_unix2dos(p_file->f_inode->i_ctime, &(psffsi->sfi_ctime), &(psffsi->sfi_cdate));
    date_unix2dos(p_file->f_inode->i_atime, &(psffsi->sfi_atime), &(psffsi->sfi_adate));
    date_unix2dos(p_file->f_inode->i_mtime, &(psffsi->sfi_mtime), &(psffsi->sfi_mdate));

    psffsi->sfi_DOSattr =  (unsigned char)Linux_To_DOS_Attrs(p_file->f_inode, component);
    return NO_ERROR;

}





_FS_RET _FS_ENTRY FS_PROCESSNAME(
                                 pchar pNameBuf
                                )
{
    return NO_ERROR;
}

