/*
 * Copyright 2009 Vasilkin Andrew <digi@os2.snc.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <lqlib.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "debug.h"


VOID _System PipeServThread(ULONG ulParam)
{
  PLQPIPE	pLQPipe = (PLQPIPE)ulParam;
  ULONG		ulRC;
  ULONG		ulActual;
  BOOL		fHaveRecords;
  CHAR		acBuf[1024];

  while( TRUE )
  {
    ulRC = DosConnectNPipe( pLQPipe->hPipe );
    if ( ulRC != NO_ERROR )
    {
      debug( "DosConnectNPipe(), rc=%u", ulRC );
      break;
    }

    if ( pLQPipe->pfnPipeWriteStat == NULL )
    {
      debug( "Stop" );
      break;
    }

    ulRC = DosRead( pLQPipe->hPipe, &acBuf, sizeof(acBuf) - 1, &ulActual );
    if ( ulRC != NO_ERROR )
    {
      debug( "DosRead() #1, rc=%u", ulRC );
    }
    else
    {
      acBuf[ulActual] = '\0';
      debug( "command: <%s>", &acBuf );

      if ( stricmp( &acBuf, PIPE_CMD_STAT ) == 0 )
      {
        fHaveRecords = pLQPipe->pfnPipeWriteStat( pLQPipe->hPipe, &acBuf, FALSE );
      }
      else if ( stricmp( &acBuf, PIPE_CMD_STAT_COMPACT ) == 0 )
      {
        fHaveRecords = pLQPipe->pfnPipeWriteStat( pLQPipe->hPipe, &acBuf, TRUE );
      }
      else
      {
        lqlibPipeWriteMessage( pLQPipe->hPipe, "Unknown command." );
        fHaveRecords = TRUE;
      }

      if ( !fHaveRecords )
        lqlibPipeWriteMessage( pLQPipe->hPipe, "No records exist ." );

      lqlibPipeWriteMessage( pLQPipe->hPipe, PIPE_REPLY_EOF );

      ulRC = DosRead( pLQPipe->hPipe, &acBuf, sizeof(acBuf), &ulActual );
      if ( ulRC != NO_ERROR )
      {
        debug( "DosRead() #2, rc=%u", ulRC );
      }
      else if ( ulActual != 0 )
        debug( "Left some data in pipe." );
    }

    ulRC = DosDisConnectNPipe( pLQPipe->hPipe );
    if ( ulRC != NO_ERROR )
      debug( "DosDisConnectNPipe(), rc=%u", ulRC );
  }

  ulRC = DosDisConnectNPipe( pLQPipe->hPipe );
  if ( ulRC != NO_ERROR )
    debug( "DosDisConnectNPipe() #2, rc=%u", ulRC );
}


extern ULONG lqlibPipeServInit(PLQPIPE pLQPipe, PSZ pszPipeName,
                               PFNPIPEWRITESTAT pfnPipeWriteStat)
{
  ULONG		ulRC;

  ulRC = DosCreateNPipe( pszPipeName, &pLQPipe->hPipe, NP_ACCESS_DUPLEX,
           NP_TYPE_MESSAGE | NP_READMODE_MESSAGE | 1, 4096, 64, 100 );

  if ( ulRC != NO_ERROR )
  {
    debug( "DosCreateNPipe(), rc=%u", ulRC );
    pLQPipe->hPipe = (HPIPE)-1;
  }
  else
  {
    pLQPipe->pfnPipeWriteStat = pfnPipeWriteStat;

    ulRC = DosCreateThread( &pLQPipe->tidPipeServ, &PipeServThread,
             (ULONG)pLQPipe, CREATE_READY | STACK_SPARSE, 16384 );
    if ( ulRC != NO_ERROR )
    {
      debug( "DosCreateThread(), rc=%u", ulRC );

      ulRC = DosClose( pLQPipe->hPipe );

      if ( ulRC != NO_ERROR )
      {
        pLQPipe->hPipe = (HPIPE)-1;
        debug( "DosClose(), rc=%u", ulRC );
      }
    }

    pLQPipe->pszPipeName = strdup( pszPipeName );
  }

  return ulRC;
}

extern VOID lqlibPipeServDone(PLQPIPE pLQPipe)
{
  ULONG		ulRC;
  HPIPE		hPipe;
  ULONG		ulAction;

  if ( pLQPipe->hPipe != (HPIPE)-1 )
  {
    pLQPipe->pfnPipeWriteStat = NULL;

    ulRC = DosOpen( pLQPipe->pszPipeName, &hPipe, &ulAction,
                    0, FILE_NORMAL, OPEN_ACTION_OPEN_IF_EXISTS,
                    OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, NULL );
    if ( ulRC != NO_ERROR )
    {
      debug( "DosOpen(), rc=%u", ulRC );
    }
    else
      ulRC = DosClose( hPipe );
      if ( ulRC != NO_ERROR )
        debug( "DosClose() #1, rc=%u", ulRC );

    DosWaitThread( &pLQPipe->tidPipeServ, DCWW_WAIT );

    ulRC = DosClose( pLQPipe->hPipe );
    if ( ulRC != NO_ERROR )
      debug( "DosClose() #2, rc=%u", ulRC );

    pLQPipe->hPipe = (HPIPE)-1;
  }

  free( pLQPipe->pszPipeName );
}

ULONG lqlibPipeWriteMessage(HPIPE hPipe, PSZ pszMessage)
{
  ULONG		ulRC;
  ULONG		ulActual;

  ulRC = DosWrite( hPipe, pszMessage, strlen( pszMessage ), &ulActual );
  if ( ulRC != NO_ERROR )
    debug( "DosWrite(), rc=%u", ulRC );

  return ulRC;
}


extern ULONG lqlibEASetLLong(PSZ pszPath, PSZ pszEAName, LLONG llData)
{
  ULONG		ulFEA2ListSize;
  ULONG		ulEANameLen = strlen( pszEAName );
  EAOP2		eaopWrite;
  ULONG		ulRC;

  ulFEA2ListSize = sizeof(FEA2LIST) + ulEANameLen + 1 + sizeof(LLONG);

//  eaopWrite.fpFEA2List = alloca( ulFEA2ListSize );
  ulRC = DosAllocMem( (PVOID *)&eaopWrite.fpFEA2List, ulFEA2ListSize, fALLOC );
  if ( ulRC != NO_ERROR )
  {
    debug( "DosAllocMem() #1, rc = %u", ulRC );
    return ulRC;
  }

  eaopWrite.fpGEA2List = NULL;
  eaopWrite.fpFEA2List->cbList = ulFEA2ListSize;

  eaopWrite.fpFEA2List->list[0].oNextEntryOffset	= 0;
  eaopWrite.fpFEA2List->list[0].fEA			= 0;
  eaopWrite.fpFEA2List->list[0].cbName			= ulEANameLen;
  eaopWrite.fpFEA2List->list[0].cbValue			= sizeof(LLONG);

  strcpy( eaopWrite.fpFEA2List->list[0].szName, pszEAName );
  memcpy( eaopWrite.fpFEA2List->list[0].szName + ulEANameLen + 1,
          &llData, sizeof(LLONG) );

  ulRC = DosSetPathInfo( pszPath, FIL_QUERYEASIZE, (PVOID)&eaopWrite,
                         sizeof(EAOP2), DSPI_WRTTHRU );

  DosFreeMem( eaopWrite.fpFEA2List );

  return ulRC;
}

extern ULONG lqlibEAQueryLLong(PSZ pszPath, PSZ pszEAName, PLLONG pllData)
{
  ULONG		ulGEA2ListSize;
  ULONG		ulFEA2ListSize;
  ULONG		ulEANameLen = strlen( pszEAName );
  EAOP2		eaopRead;
//  FILESTATUS4	sFileStatus4;
  ULONG		ulRC;

/*  ulRC = DosQueryPathInfo( pszPath, FIL_QUERYEASIZE,
                           &sFileStatus4, sizeof(FILESTATUS4) );
  if ( ulRC != NO_ERROR )
  {
    debug( "DosQueryPathInfo(), rc = %u", ulRC );
    return ulRC;
  }*/

  ulGEA2ListSize = sizeof(GEA2LIST) + ulEANameLen + 1;

//  eaopRead.fpGEA2List = alloca( ulGEA2ListSize );
  ulRC = DosAllocMem( (PVOID *)&eaopRead.fpGEA2List, ulGEA2ListSize, fALLOC );

  if ( ulRC != NO_ERROR )
  {
    debug( "DosAllocMem() #1, rc = %u", ulRC );
    return ulRC;
  }

  eaopRead.fpGEA2List->cbList = ulGEA2ListSize;
  eaopRead.fpGEA2List->list[0].oNextEntryOffset = 0;
  eaopRead.fpGEA2List->list[0].cbName = ulEANameLen;
  strcpy( eaopRead.fpGEA2List->list[0].szName, pszEAName );

//  ulFEA2ListSize = sFileStatus4.cbList;
  ulFEA2ListSize = sizeof(FEA2LIST) + ulEANameLen + 1 + sizeof(LLONG);
//  ulFEA2ListSize *= 2;

//  eaopRead.fpFEA2List = alloca( ulFEA2ListSize );
  ulRC = DosAllocMem( (PVOID *)&eaopRead.fpFEA2List, ulFEA2ListSize,
                      fPERM | PAG_COMMIT );

  if ( ulRC != NO_ERROR )
  {
    debug( "DosAllocMem() #2, rc = %u" );
    DosFreeMem( &eaopRead.fpGEA2List );
    return ulRC;
  }

  eaopRead.fpFEA2List->cbList = ulFEA2ListSize;

  ulRC = DosQueryPathInfo( pszPath, FIL_QUERYEASFROMLIST,
                           &eaopRead, sizeof(EAOP2) );

  if ( ( ulRC == NO_ERROR ) &&
       ( eaopRead.fpFEA2List->list[0].cbValue == sizeof(LLONG) ) )
  {
    *pllData = *(PLLONG)&(eaopRead.fpFEA2List->list[0].szName[ulEANameLen+1]);
  }

  DosFreeMem( eaopRead.fpGEA2List );
  DosFreeMem( eaopRead.fpFEA2List );

  return ulRC;
}
