
/*------------------------------------------------------------------*
 *                                                                  *
 *  Video Toolkit For OS/2 Version 1.0                              *
 *  Example Application No. 2.                                      *
 *  Written by Stephen Sloan.                                       *
 *  Date : 22/02/95.                                                *
 *  Copyright (c) Abbotsbury Software Ltd., United Kingdom. 1995.   *
 *                                                                  *
 *  Filename : helpfunc.c                                           *
 *                                                                  *
 *------------------------------------------------------------------*/

#define INCL_PM

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "helpfunc.h"

extern  HWND    HwndFrame;

extern  void    msg_box (UCHAR *txt, UCHAR *title, ULONG options);

HAB     hab;
char    szTitle[MESSAGELEN];

static  UCHAR   *Copyright =
  "Copyright (c) Abbotsbury Software Ltd., UK. 1994-1995. All Rights Reserved";
static HWND hwndHelpInstance;
static CHAR szLibName[HELPLIBRARYNAMELEN];
static CHAR szWindowTitle[HELPLIBRARYNAMELEN];
static BOOL fHelpEnabled = FALSE;

void HelpInit (HWND hwnd)
{
    HELPINIT    hini;

        hab = WinQueryAnchorBlock (HwndFrame);
        WinLoadString(hab, 0, IDS_TITLEBAR, sizeof (szTitle), szTitle);

        fHelpEnabled = FALSE;

        hini.cb = sizeof (HELPINIT);
        hini.ulReturnCode = 0L;

        hini.pszTutorialName = (PSZ)NULL;

        hini.phtHelpTable = (PHELPTABLE)MAKELONG (HELP_TABLE, 0xFFFF);
        hini.hmodHelpTableModule = (HMODULE)0;
        hini.hmodAccelActionBarModule = (HMODULE)0;
        hini.idAccelTable = 0;
        hini.idActionBar = 0;

        if (!WinLoadString (hab,
                            (HMODULE)0,
                            IDS_HELPWINDOWTITLE,
                            HELPLIBRARYNAMELEN,
                            (PSZ)szWindowTitle))
        {
            msg_box ("Error loading window title",
                     "Error", MB_OK | MB_ERROR);
            return;
        }

        hini.pszHelpWindowTitle = (PSZ)szWindowTitle;

        if (!WinLoadString (hab,
                            (HMODULE)0,
                            IDS_HELPLIBRARYNAME,
                            HELPLIBRARYNAMELEN,
                            (PSZ)szLibName))
        {
            msg_box ("Error loading library name",
                     "Error", MB_OK | MB_ERROR);
            return;
        }

        hini.pszHelpLibraryName = (PSZ)szLibName;

        hwndHelpInstance = WinCreateHelpInstance (hab, &hini);

        if (!hwndHelpInstance || hini.ulReturnCode)
        {
            msg_box ("Error creating help instance",
                     "Error", MB_OK | MB_ERROR);
            return;
        }

        if (!WinAssociateHelpInstance (hwndHelpInstance, hwnd))
        {
            msg_box ("Error associating help instance",
                     "Error", MB_OK | MB_ERROR);
            return;
        }

        fHelpEnabled = TRUE;
}


void HelpHelpForHelp ()
{
        if (fHelpEnabled)
        {
            if (WinSendMsg (hwndHelpInstance, HM_DISPLAY_HELP, NULL, NULL))
            {
                msg_box ("Error displaying help panel",
                         "Error", MB_OK | MB_ERROR);
            }
        }
}


void HelpExtended ()
{
        if (fHelpEnabled)
        {
            if (WinSendMsg (hwndHelpInstance, HM_EXT_HELP, NULL, NULL))
            {
                msg_box ("Error displaying extended help panel",
                         "Error", MB_OK | MB_ERROR);
            }
        }
}

void HelpKeys ()
{
        if (fHelpEnabled)
        {
            if (WinSendMsg (hwndHelpInstance, HM_KEYS_HELP, NULL, NULL))
            {
                msg_box ("Error displaying keys help panel",
                         "Error", MB_OK | MB_ERROR);
            }
        }
}

void HelpIndex ()
{
        if (fHelpEnabled)
        {
            if (WinSendMsg (hwndHelpInstance, HM_HELP_INDEX, NULL, NULL))
            {
                msg_box ("Error displaying index help panel",
                         "Error", MB_OK | MB_ERROR);
            }
        }
}

void HelpContents ()
{
        if (fHelpEnabled)
        {
            if (WinSendMsg (hwndHelpInstance, HM_HELP_CONTENTS, NULL, NULL))
            {
                msg_box ("Error displaying contents help panel",
                         "Error", MB_OK | MB_ERROR);
            }
        }
}

void HelpAbout ()
{
        WinDlgBox (HWND_DESKTOP,
                   HwndFrame,
                   (PFNWP)AboutDlgProc,
                   (HMODULE)NULLHANDLE,
                   IDD_PRODUCTINFO,
                   NULL);
        WinInvalidateRegion (HwndFrame, NULLHANDLE, FALSE);
}

void DisplayHelpPanel (SHORT idPanel)
{
        if (fHelpEnabled)
        {
            if (WinSendMsg (hwndHelpInstance, HM_DISPLAY_HELP,
                MPFROM2SHORT (idPanel, NULL), MPFROMSHORT (HM_RESOURCEID)))
            {
                msg_box ("Error displaying help panel",
                         "Error", MB_OK | MB_ERROR);
            }
        }
}

void DestroyHelpInstance ()
{
        if (hwndHelpInstance)
            WinDestroyHelpInstance (hwndHelpInstance);
}
