#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <vcadd.h>
#include    <vcai.h>
#include    "oem.h"

static unsigned char *copyright =
          "TV Diagnostic for Hauppauge Video Capture Hardware\n"
          "%s Copyright (c) Abbotsbury Software Ltd. UK 1995-99\n";
static unsigned char *vers = "Version 3.1";

static char *Drvr_name;
static USHORT Connect;
main(int argc, char *argv[], char *envp[])
{
unsigned short arr[10], version;
VCADEVINFO      dev_info;
PVCADEVINFO     info = &dev_info;
unsigned long   region, channel, freq, fine, input, colours;
ULONG           temp, temp1, temp2, temp3, model;
USHORT          x, lv, rv, lb, rb, lt, rt, m;
OEM             oem;

    if (argc > 2)
    {
        Connect = atoi (argv[2]);
        Drvr_name = argv[1];
    }
    else
    {
        printf ("This program requires 2 parameters :\n");
        printf ("  The name of the driver\n");
        printf ("  The driver connection number\n");
        printf ("   I.E. diag celeb 2\n");
        exit (1);
    }

    printf (copyright, vers);
/*
    DosGetVersion (&version);
    printf ("OS/2 Version %d.%d", (version >> 8)/10, version & 0xff);
    DosGetDateTime (&dt);
    printf (" Date %d/%d/%d\n", dt.day, dt.month, dt.year);
*/
    oem_info (&oem);
    printf ("Video Controller Oem %s\n", oem.oem_name);
    printf ("Video Controller Adaptor %s\n", oem.oem_hw);
    printf ("Video Controller RAM = 0x%lx\n", oem.oem_ram);

    if (VcaiDeviceOpen (Drvr_name, Connect) == FALSE)
    {
        printf ("Cannot open device %s %d$\n", Drvr_name, Connect);
        exit (1);
    }

    version = VcaiDllVersionQuery ();
    printf ("VCAI DLL version = %x.%x\n", version >> 8, version & 0xFF);

    info->Length = sizeof (VCADEVINFO);
    VcaiDeviceInfoGet (info);

    x = strlen (dev_info.ProdInfo);
    if (!x)
    {
            printf ("No Driver Present\n");
            exit (0);
    }
    printf ("Product Name   = %30.30s \n", dev_info.ProdInfo);
    printf ("Manufacturer   = %30.30s \n", dev_info.ManInfo);
    printf ("Version Number = %10.10s \n", dev_info.Version);

    if (strncmp (dev_info.ProdInfo, "WarpTV - WinCast VCA", 20) == 0)
    {
        (void)VcaiVarRead ("PCI_device_id",  VCA_VARIABLE_HW, &temp1);
        printf ("Hardware Chipset   =  Bt%ld\n", temp1);
        (void)VcaiVarRead ("Model_no",       VCA_VARIABLE_HW, &model);
        printf ("Hauppauge Card Id  =  %ld ", model);
        (void)VcaiVarRead ("Revision_high", VCA_VARIABLE_HW, &temp1);
        (void)VcaiVarRead ("Revision_low",  VCA_VARIABLE_HW, &temp2);
//        printf ("Revision No.       =  ");
        printf ("%c", (UCHAR)((temp1 >> 8) & 0xFF));
        printf ("%c", (UCHAR)(temp1 & 0xFF));
        printf ("%c", (UCHAR)((temp2 >> 8) & 0xFF));
        printf ("%c", (UCHAR)(temp2 & 0xFF));

        (void)VcaiVarRead ("Serial_no_high",  VCA_VARIABLE_HW, &temp1);
        (void)VcaiVarRead ("Serial_no_low",   VCA_VARIABLE_HW, &temp2);
        temp  = (temp1 << 16);
        temp |= temp2;
        printf (" (Serial No. %ld)\n", temp);


        (void)VcaiVarRead ("Tuner_manufacturer", VCA_VARIABLE_HW, &temp);
        printf ("Tuner Manufacturer =  %ld\n", temp);
        (void)VcaiVarRead ("Tuner_type", VCA_VARIABLE_HW, &temp);
        printf ("Tuner Type         =  %ld\n", temp);

        (void)VcaiVarRead ("Teletext_support", VCA_VARIABLE_HW, &temp);
        (void)VcaiVarRead ("Ext_support", VCA_VARIABLE_HW, &temp1);
        (void)VcaiVarRead ("SVHS_support", VCA_VARIABLE_HW, &temp2);
        (void)VcaiVarRead ("FM_support", VCA_VARIABLE_HW, &temp3);

        if (temp || temp1 || temp2 || temp3)
        {
            printf ("Options            =  ");
            if (temp)
                printf ("Teletext ");
            if (temp1)
                printf ("External ");
            if (temp2)
                printf ("SVHS ");
            if (temp3)
                printf ("FM tuner");
            printf ("\r\n");
        }
    }
    else
    {
        VcaiInfoGet (arr);
        printf ("Tuner Type = %d, with %s Clock, running at %s MHz\n",
             arr[0],
            (arr[1] == 0) ? "Crystal" :
            (arr[1] == 1) ? "Oscillator" : "Unknown",
            (arr[2] == 0) ? "24.5454" :
            (arr[2] == 1) ?  "27" :
            (arr[2] == 2) ?  "29" : "Unknown");
        printf ("IO address set to 0x%3.3x\n", arr[3]);
        printf ("Board memory address set to 0x%3.3x000\n", arr[4]);
    }

    if (VcaiVarRead ("NumColours", VCA_VARIABLE_GENERIC, &colours))
    {
        printf ("Colours = %ld Resolution = %d by %d Pixels\n",
                colours, arr[6], arr[7]);
    }
    printf ("Image Format = %lx\n", dev_info.ImgFormat);
    printf ("BitsPerPel = %d\n", dev_info.BitsPerPEL);
    printf ("Overlay support = %d\n", dev_info.Overlay);
    printf ("Video Brightness %lx ", dev_info.Brightness);
    printf ("Hue %lx ", dev_info.hue);
    printf ("Saturation %lx ", dev_info.saturation);
    printf ("Contrast %lx\n", dev_info.contrast);
    printf ("Colour Key currently set to %ld\n", VcaiColourkeyGet ());
    input = VcaiVideoInputQuery ();
    printf ("Video Input source %s\n", (input == 0) ? "Ext Composite 1" :
                                       (input == 1) ? "Ext Composite 2" :
                                       (input == 2) ? "TV Tuner" : "SVHS");


    VcaiAudioGet (&lv, &rv, &lb, &rb, &lt, &rt, &m);
    printf ("Sound %s Volume %x/%x Bass %x/%x Treble %x/%x\n",
            (m) ? "Muted" : "On", lv, rv, lb, rb, lt, rt);

    VcaiTunerGet (&region, &channel, &freq, &fine);
    printf ("Tuner Region %ld, Channel %ld Frequency %ld, FineTune %ld\n",
              region, channel, freq, fine);
    return 0;
}

