unit Manf_ID;

interface

// from checkip 7.0 pe jedecid.ini,jep106L.asc,.pcmcia.h..
// http://www.pcmcia.org/tupleidlist.htm

const
  known_jedecid:array[0..729] of
    record
      num               :smallword;
      str               :PChar;
    end

  = // Parity+ 7 Bit JEDEC...
  ((num:$0001;  str:'Advanced Micro Devices'            ),
   (num:$0002;  str:'American Megatrends Inc'           ),
   (num:$0083;  str:'Fairchild'                         ),
   (num:$0004;  str:'Fujitsu'                           ),
   (num:$0085;  str:'GTE'                               ),
   (num:$0086;  str:'Harris'                            ),
   (num:$0007;  str:'Hitachi'                           ),
   (num:$0008;  str:'Inmos'                             ),
   (num:$0089;  str:'Intel'                             ),
   (num:$008A;  str:'ITT Cannon'                        ),
   (num:$000B;  str:'Intersil Corporation'              ),
   (num:$008C;  str:'Monolithic Memories'               ),
   (num:$000D;  str:'Mostek'                            ),
   (num:$000E;  str:'Motorola'                          ),
   (num:$008F;  str:'National Semiconductor'            ),
   (num:$0010;  str:'NEC Technologies, Inc'             ),
   (num:$0091;  str:'RCA'                               ),
   (num:$0092;  str:'Raytheon'                          ),
   (num:$0013;  str:'Conexant (Rockwell)'               ),
   (num:$0094;  str:'Seeq'                              ),
   (num:$0015;  str:'Philips Semi. (Signetics)'         ),
   (num:$0016;  str:'Synertek'                          ),
   (num:$0097;  str:'Texas Instruments'                 ),
   (num:$0098;  str:'Toshiba'                           ),
   (num:$0019;  str:'Xicor'                             ),
   (num:$001A;  str:'Zilog Corporation'                 ),
   (num:$009B;  str:'Eurotechnique'                     ),
   (num:$001C;  str:'Mitsubishi Electronics'            ),
   (num:$009D;  str:'Lucent (AT&T)'                     ),
   (num:$009E;  str:'Exel'                              ),
   (num:$001F;  str:'General Instrument/Atmel'          ),
   (num:$0020;  str:'SGS-Thomson Microelectronics'      ),
   (num:$00A1;  str:'Lattice Semiconductor'             ),
   (num:$00A2;  str:'Symbios Logic/NCR'                 ),
   (num:$0023;  str:'Wafer Scale Integration'           ),
   (num:$00A4;  str:'IBM'                               ),
   (num:$0025;  str:'Tristar'                           ),
   (num:$0026;  str:'Visic'                             ),
   (num:$00A7;  str:'International CMOS Technology'     ),
   (num:$00A8;  str:'SSSI'                              ),
   (num:$0029;  str:'MicrochipTechnology'               ), (* "Amtel/General Instrument" *)
   (num:$002A;  str:'Ricoh Company, Ltd.'               ),
   (num:$00AB;  str:'Philips Semiconductors/VLSI'       ),
   (num:$002C;  str:'Micron Quantum Devices, Inc.'      ),
   (num:$00AD;  str:'Hyundai Electronics Industries'    ),
   (num:$00AE;  str:'OKI Semiconductor'                 ),
   (num:$002F;  str:'ACTEL'                             ),
   (num:$00B0;  str:'Sharp Corporation'                 ),
   (num:$0031;  str:'Catalyst Semiconductor, Inc.'      ),
   (num:$0032;  str:'Panasonic'                         ),
   (num:$00B3;  str:'IDT'                               ),
   (num:$0034;  str:'Cypress Semiconductor'             ),
   (num:$00B5;  str:'Digital Equipment Corporation'     ),
   (num:$00B6;  str:'LSI Logic'                         ),
   (num:$0037;  str:'Zarlink (Plessey)'                 ),
   (num:$0038;  str:'UTMC'                              ),
   (num:$00B9;  str:'Thinking Machine'                  ),
   (num:$00BA;  str:'Thomson CSF'                       ),
   (num:$003B;  str:'Integrated CMOS Systems (Vertex)'  ),
   (num:$00BC;  str:'Honeywell'                         ),
   (num:$003D;  str:'Tektronix'                         ),
   (num:$003E;  str:'Sun Microsystems, Inc.'            ),
   (num:$00BF;  str:'SST'                               ),
   (num:$0040;  str:'MOSEL'                             ),
   (num:$00C1;  str:'Infineon (Siemens Nixdorf)'        ),
   (num:$00C2;  str:'Macronix'                          ),
   (num:$0043;  str:'Xerox'                             ),
   (num:$00C4;  str:'Plus Logic'                        ),
   (num:$0045;  str:'SunDisk'                           ), (* Sandisk Corporation *)
   (num:$0046;  str:'Elan Circuit Technology'           ),
   (num:$00C7;  str:'European Silicon Str.'             ),
   (num:$0047;  str:'I3 Design Systems'                 ), (* ? C7<->47 *)
   (num:$00C8;  str:'Apple Computer'                    ),
   (num:$00C9;  str:'Xilinx, Inc.'                      ),
   (num:$004A;  str:'Compaq'                            ),
   (num:$00CB;  str:'Protocol Engines'                  ),
   (num:$004C;  str:'SCI Systems, Inc.'                 ),
   (num:$00CD;  str:'Seiko Instruments'                 ),
   (num:$00CE;  str:'Samsung'                           ),
   (num:$004F;  str:'I3 Design System'                  ),
   (num:$00D0;  str:'Klic'                              ),
   (num:$0051;  str:'Crosspoint Solutions'              ),
   (num:$0052;  str:'Alliance Semiconductor'            ),
   (num:$00D3;  str:'Tandem'                            ), (* Integrated Silicon Solutions ? *)
   (num:$0054;  str:'Hewlett-Packard'                   ),
   (num:$00D5;  str:'Integrated Silicon Solutions'      ),
   (num:$00D6;  str:'Brooktree'                         ),
   (num:$0057;  str:'New Media Corporation'             ),
   (num:$0058;  str:'MHS Electronic'                    ),
   (num:$00D9;  str:'Performance Semi.'                 ),
   (num:$00DA;  str:'Winbond Electronics Corporation'   ),
   (num:$005B;  str:'Kawasaki Steel'                    ),
   (num:$00DC;  str:'Bright Micro, Inc.'                ),
   (num:$005D;  str:'TECMAR'                            ),
   (num:$005E;  str:'Exar'                              ),
   (num:$00DF;  str:'PCMCIA European Chapter'           ),
   (num:$00E0;  str:'LG Semiconductor (Goldstar)'       ),
   (num:$0061;  str:'Northern Telecom Canada, Ltd.'     ),
   (num:$0062;  str:'Sanyo'                             ),
   (num:$00E3;  str:'Array Microsystems'                ),
   (num:$0064;  str:'Crystal Semiconductor'             ),
   (num:$00E5;  str:'Analog Devices'                    ),
   (num:$00E6;  str:'PMC-Sierra'                        ),
   (num:$0067;  str:'Asparix'                           ),
   (num:$0068;  str:'Convex Computer'                   ),
   (num:$00E9;  str:'Quality Semiconductor'             ),
   (num:$00EA;  str:'Nimbus Technology'                 ),
   (num:$006B;  str:'Transwitch'                        ),
   (num:$00EC;  str:'Micronas (ITT Intermetall)'        ),
   (num:$006D;  str:'Cannon'                            ),
   (num:$006E;  str:'Altera'                            ),
   (num:$00EF;  str:'NEXCOM'                            ),
   (num:$0070;  str:'QUALCOMM'                          ),
   (num:$00F1;  str:'Sony'                              ),
   (num:$00F2;  str:'Cray Research'                     ),
   (num:$0073;  str:'AMS(Austria Micro)'                ),
   (num:$00F4;  str:'Vitesse'                           ),
   (num:$0075;  str:'Aster Electronics'                 ),
   (num:$0076;  str:'Bay Networks(Synoptic)'            ),
   (num:$00F7;  str:'Zentrum Mikroeleckt.'              ),
   (num:$00F8;  str:'TRW'                               ),
   (num:$0079;  str:'Thesys'                            ),
   (num:$007A;  str:'Solbourne Computer'                ),
   (num:$00FB;  str:'Allied-Signal'                     ),
   (num:$007C;  str:'Dialog'                            ),
   (num:$00FD;  str:'Media Vision'                      ),
   (num:$00FE;  str:'Level One'                         ),

    // not JEDEC, all bits used
   (num:$0100;  str:'AT&T Paradyne'                     ),
   (num:$0101;  str:'3Com Corporation'                  ),
   (num:$0102;  str:'US Robotics Mobile Comm. Corporation/Megahertz'),
   (num:$0103;  str:'OmniTel Inc'                       ),
   (num:$0104;  str:'Socket Communications, Inc.'       ),
   (num:$0105;  str:'Xircom, Inc./Intel'                ),
   (num:$0106;  str:'Intgral Peripherals'              ),
   (num:$0107;  str:'PNB/US Robotics PCD'               ),
   (num:$0108;  str:'Standard Microsystems Corporation' ),
   (num:$0109;  str:'Motorola'                          ),
   (num:$010A;  str:'Hayes Microcomputer Products'      ),
   (num:$010B;  str:'National Instruments'              ),
   (num:$010C;  str:'Digicom SPA'                       ),
   (num:$010D;  str:'DataTrek'                          ),
   (num:$010E;  str:'Allen-Bradley Co.'                 ),
   (num:$0110;  str:'Pure Data'                         ),
   (num:$0111;  str:'Seagate Technology'                ),
   (num:$0112;  str:'American Megatrends, Inc.'         ),
   (num:$0113;  str:'Benchmarq Electronics'             ),
   (num:$0114;  str:'QLogic Corporation'                ),
   (num:$0115;  str:'US Robotics, Inc.'                 ),
   (num:$0116;  str:'EXP Computer, Inc.'                ),
   (num:$0117;  str:'AMT International'                 ),
   (num:$0118;  str:'Adobe Systems'                     ),
   (num:$0119;  str:'Capstone Technology'               ),
   (num:$011A;  str:'IDEAssociates'                     ),
   (num:$011B;  str:'Paace Micro'                       ),
   (num:$011C;  str:'Quanta Computer, Inc.'             ),
   (num:$011D;  str:'Cogent Data Technologies, Inc.'    ),
   (num:$011E;  str:'Secured Communications, Inc.'      ),
   (num:$011F;  str:'Chaplet Systems'                   ),
   (num:$0120;  str:'Mykotronx, Inc.'                   ),
   (num:$0121;  str:'Olicom A/S'                        ),
   (num:$0122;  str:'WIBU-Systems AG'                   ),
   (num:$0123;  str:'CIM Engineering (USA), Inc.'       ),
   (num:$0124;  str:'Nokia Corporation'                 ),
   (num:$0125;  str:'3DO Company'                       ),
   (num:$0126;  str:'Proxim'                            ),
   (num:$0127;  str:'IBP Ges.f. Messtechnik GmbH'       ),
   (num:$0128;  str:'DSP Solutions, Inc.'               ),
 //(num:$0129;  str:''                                  ),
   (num:$012A;  str:'Expertronics'                      ),
   (num:$012B;  str:'Creative Labs'                     ),
 //(num:$012C;  str:''                                  ),
   (num:$012D;  str:'Communicate Limited'               ),
   (num:$012E;  str:'Macronix America, Inc.'            ),
   (num:$012F;  str:'Adaptec, Inc.'                     ),
   (num:$0130;  str:'Future Domain Corporation'         ),
   (num:$0131;  str:'Novalink Technologies/Flat Connections, Inc./NovaWeb Technologies, Inc.'),
   (num:$0132;  str:'Smart Modular Technologies'        ),
   (num:$0133;  str:'AMP, Inc./TYCO Electronics, Inc.'  ),
   (num:$0134;  str:'Lasat Communications A/S / Eicon Networks'),
   (num:$0135;  str:'Magic Ram, Inc.'                   ),
   (num:$0136;  str:'EZ Show Systems, Inc.'             ),
   (num:$0137;  str:'Quatech, Inc.'                     ),
   (num:$0138;  str:'Compaq Computer'                   ),
   (num:$0139;  str:'Mission Peak Designs/3rd Rail Engineering'),
   (num:$013A;  str:'Eicon Technology Corporation'      ),
   (num:$013B;  str:'Bondwell Industrial'               ),
   (num:$013C;  str:'Line Switch M.B. srl'              ),
   (num:$013D;  str:'ACEEX Corporation'                 ),
   (num:$013E;  str:'Microcom'                          ),
   (num:$013F;  str:'Racore Computer Products'          ),
   (num:$0140;  str:'Ositech Communications'            ),
   (num:$0141;  str:'Madge Networks'                    ),
   (num:$0142;  str:'Wavetron Microsystems'             ),
   (num:$0143;  str:'TDK Grey Cell, Ltd.'               ), (* Grey Cell Systems, Ltd. *)
   (num:$0144;  str:'Group Technologies'                ),
   (num:$0145;  str:'Excalibur Systems, Inc.'           ),
   (num:$0146;  str:'Asant Technologies'               ),
   (num:$0147;  str:'WesTest Engineering Corporation'   ),
   (num:$0148;  str:'Keithley Metrabyte'                ),
   (num:$0149;  str:'D-Link Corporation'                ),
   (num:$014A;  str:'Accurite Technologies, Inc.'       ),
   (num:$014B;  str:'FCI Electronics'                   ),
   (num:$014C;  str:'ILC Data Device Corporation'       ),
   (num:$014D;  str:'Simple Technology, Inc.'           ),
   (num:$014E;  str:'Cirrus Logic'                      ),
   (num:$014F;  str:'Data Broadcasting Corporation'     ),
   (num:$0150;  str:'Frederick Engineering'             ),
   (num:$0151;  str:'TGA Systems'                       ),
   (num:$0152;  str:'Canopus Co., Ltd.'                 ),
   (num:$0153;  str:'Data Translation, Inc.'            ),
   (num:$0154;  str:'Development Concepts'              ),
   (num:$0155;  str:'Communication Automation Corp.'    ),
   (num:$0156;  str:'AT&T Global Information Systems'   ),
   (num:$0157;  str:'Gemplus Card International Co.'    ),
   (num:$0158;  str:'Practical Peripherals'             ),
   (num:$0159;  str:'Telequip Corporation'              ),
   (num:$015A;  str:'VLSI Vision Limited'               ),
   (num:$015B;  str:'Inventec Corporation'              ),
   (num:$015C;  str:'Corelis, Inc.'                     ),
   (num:$015D;  str:'Elan Digital Systems, Ltd.'        ),
   (num:$015E;  str:'Banksia Technology Pty Ltd'        ),
   (num:$015F;  str:'Aironet Wireless Communications/Cisco Systems, Inc.'),
   (num:$0160;  str:'Brain Boxes'                       ),
   (num:$0161;  str:'Katron Technologies'               ),
   (num:$0162;  str:'Cardwell'                          ),
   (num:$0163;  str:'3M'                                ),
   (num:$0164;  str:'Corporate Systems Center'          ),
   (num:$0165;  str:'Amber Logic, Ltd.'                 ),
   (num:$0166;  str:'Akyman Financial Services'         ),
   (num:$0167;  str:'Sealevel Systems, Inc.'            ),
   (num:$0168;  str:'Softing AG'                        ),
   (num:$0169;  str:'Fair Point Communcations'          ),
   (num:$016A;  str:'RK Data Systems'                   ),
   (num:$016B;  str:'Ericsson Mobile Communications AB' ),
   (num:$016C;  str:'Psion Dacom PLC'                   ),
   (num:$016D;  str:'ADD Industry OY'                   ),
   (num:$016E;  str:'Norand Corporation'                ),
   (num:$016F;  str:'IPS Electronics'                   ),
   (num:$0170;  str:'Trimble Navigation'                ),
   (num:$0171;  str:'SCII Telecom, Ltd.'                ),
   (num:$0173;  str:'Artic Technologies'                ),
   (num:$0174;  str:'Microspeed'                        ),
   (num:$0175;  str:'Premax Microelectronics Corp.'     ),
   (num:$0176;  str:'Digital Design GmbH'               ),
   (num:$0177;  str:'Methode Electronics'               ),
   (num:$0178;  str:'Quadrant International, Inc.'      ),
   (num:$0179;  str:'Agema Infrared Systems'            ),
   (num:$017A;  str:'Honeywell'                         ),
   (num:$017B;  str:'Applied Systems'                   ),
   (num:$017C;  str:'Measurements Group Inc'            ),
   (num:$017D;  str:'Silicon Systems'                   ),
   (num:$017E;  str:'Greystone Peripherals, Inc.'       ),
   (num:$017F;  str:'J.C. Designs Ltd'                  ),
   (num:$0180;  str:'Edge Diagnostic Systems'           ),
   (num:$0181;  str:'SAIC'                              ),
   (num:$0182;  str:'KNX Ltd'                           ),
   (num:$0183;  str:'Paralon Technologies Inc'          ),
   (num:$0184;  str:'Biopac Systems, Inc.'              ),
   (num:$0185;  str:'Eiger Labs, Inc.'                  ),
   (num:$0186;  str:'Kingston Technology Corporation'   ),
   (num:$0188;  str:'X-Net OY'                          ),
   (num:$0189;  str:'Chrysalis ITS, Inc.'               ),
   (num:$018A;  str:'Kingmax Technology, Inc.'          ),
   (num:$018B;  str:'Ballard Technology'                ),
   (num:$018D;  str:'ESD GmbH'                          ),
   (num:$018E;  str:'Turtle Beach Systems'              ),
   (num:$018F;  str:'Crypto AG'                         ),
   (num:$0190;  str:'Datakey, Inc'                      ),
   (num:$0191;  str:'Sercel'                            ),
   (num:$0192;  str:'Sierra Wireless, Inc.'             ),
   (num:$0193;  str:'Nanoteq'                           ),
   (num:$0194;  str:'Dayna Communications, Inc.'        ),
   (num:$0195;  str:'Photonics Corporation'             ),
   (num:$0196;  str:'Air Access'                        ),
   (num:$0197;  str:'Spectrix'                          ),
   (num:$0198;  str:'Verisys'                           ),
   (num:$0199;  str:'University of Dortmund'            ),
   (num:$019B;  str:'Maruda Techvision, Ltd.'           ),
   (num:$019C;  str:'Data Encryption Systems'           ),
   (num:$019D;  str:'Zentrum Mikroelectronik'           ),
   (num:$019E;  str:'Ran Data - Hawker'                 ),
   (num:$019F;  str:'Dassault A.T.'                     ),
   (num:$01A0;  str:'Datasonix Corporation'             ),
   (num:$01A1;  str:'SST'                               ),
   (num:$01A2;  str:'Ecoms'                             ),
   (num:$01A3;  str:'ATEMCO'                            ),
   (num:$01A4;  str:'Netcomm Limited'                   ),
   (num:$01A5;  str:'Winnov, L.P.'                      ),
   (num:$01A6;  str:'Raytheon Company'                  ),
   (num:$01A7;  str:'AMV GmbH'                          ),
   (num:$01A8;  str:'Symbionics/Cadence Design Systems/Tality UK Limited'),
   (num:$01A9;  str:'LogiData Tech Electronics'         ),
   (num:$01AA;  str:'Trans Digital Corporation'         ),
   (num:$01AB;  str:'Solectek Corporation'              ),
   (num:$01AC;  str:'OTW Technology'                    ),
   (num:$01AD;  str:'Racal-Datacom'                     ),
   (num:$01AE;  str:'International Microsystems'        ),
   (num:$01AF;  str:'Philips Crypto BV'                 ),
   (num:$01B0;  str:'iPower'                            ),
   (num:$01B1;  str:'Kontron Electronik GmbH'           ),
   (num:$01B2;  str:'Fujifilm Microdevices Co, Ltd.'    ),
   (num:$01B3;  str:'Introcom'                          ),
   (num:$01B4;  str:'INES, Inc'                         ),
   (num:$01B5;  str:'Pacific Avionics'                  ),
   (num:$01B6;  str:'Wandel & Goltermann GmbH'          ),
   (num:$01B7;  str:'Zytrax Communications'             ),
   (num:$01B8;  str:'Solitron Technologies, Inc.'       ),
   (num:$01B9;  str:'LXE, Inc.'                         ),
   (num:$01BA;  str:'Advanced Electronics'              ),
   (num:$01BB;  str:'Thomson-CSF'                       ),
   (num:$01BC;  str:'Pantronix Corporation'             ),
   (num:$01BD;  str:'Echelon Corporation'               ),
   (num:$01BE;  str:'CNF'                               ),
   (num:$01BF;  str:'Accton Technology Corporation'     ),
   (num:$01C0;  str:'ViaSat, Inc.'                      ),
   (num:$01C1;  str:'Pulse Engineering'                 ),
   (num:$01C2;  str:'Qualcomm, Inc.'                    ),
   (num:$01C3;  str:'Gage Talker Cim Works'             ),
   (num:$01C4;  str:'S.A.T.'                            ),
   (num:$01C5;  str:'Computer Boards, Inc.'             ),
   (num:$01C6;  str:'Intellicard Systems Pte., Ltd.'    ),
   (num:$01C7;  str:'Norris Communications'             ),
   (num:$01C8;  str:'Security Dynamics, Inc.'           ),
   (num:$01C9;  str:'Visiontek'                         ),
   (num:$01CA;  str:'Edimax Technology Co., Ltd'        ),
   (num:$01CB;  str:'Hermstedt GmbH'                    ),
   (num:$01CC;  str:'01dB'                              ),
   (num:$01CD;  str:'Digital Technology'                ),
   (num:$01CE;  str:'Miram International Inc'           ),
   (num:$01CF;  str:'Temic Telefunken Microelectronic GmbH'),
   (num:$01D0;  str:'Creative System Solutions'         ),
   (num:$01D1;  str:'Sigma Data'                        ),
   (num:$01D2;  str:'Digi International'                ),
   (num:$01D3;  str:'MSC Vertriebs GmbH'                ),
   (num:$01D4;  str:'Universal Microelectronics Co.Ltd.'),
   (num:$01D5;  str:'Chartered Electronic Industries'   ),
   (num:$01D6;  str:'Z-Com, Inc.'                       ),
   (num:$01D7;  str:'Northrop Grumman'                  ),
   (num:$01D8;  str:'Margi Systems, Inc.'               ),
   (num:$01D9;  str:'CHASE Advanced Technologies'       ),
   (num:$01DA;  str:'Silicom, Ltd.'                     ),
   (num:$01DB;  str:'Capital Equipment Corp.'           ),
   (num:$01DC;  str:'Image Data Design, Ltd.'           ),
   (num:$01DD;  str:'Centennial Technologies, Inc.'     ),
   (num:$01DE;  str:'Krautkramer GmbH & Co.'            ),
   (num:$01DF;  str:'Avatar System Corp.'               ),
   (num:$01E0;  str:'MIDAC Corp.'                       ),
   (num:$01E1;  str:'Inet, Inc.'                        ),
   (num:$01E1;  str:'Nextcell, Inc.'                    ),
   (num:$01E2;  str:'Eigner Messtechnik GmbH'           ),
   (num:$01E3;  str:'Integrated Technology of America'  ),
   (num:$01E3;  str:'Digital Privacy, Inc.'             ),
   (num:$01E4;  str:'Fair Image, Inc.'                  ),
   (num:$01E5;  str:'Viking Components, Inc.'           ),
   (num:$01E6;  str:'Micromed'                          ),
   (num:$01E7;  str:'X-Wave'                            ),
   (num:$01E8;  str:'Silicon Vision'                    ),
   (num:$01E9;  str:'Mortara Instrument'                ),
   (num:$01EA;  str:'GW Instruments'                    ),
   (num:$01EB;  str:'Nortel'                            ),
   (num:$01EC;  str:'Dolphin Oceanic'                   ),
   (num:$01ED;  str:'Meiko Electronics Co.'             ),
   (num:$01EE;  str:'Kvaser AB'                         ),
   (num:$01EF;  str:'USC'                               ),
   (num:$01F0;  str:'DSP Tools, Inc.'                   ),
   (num:$01F1;  str:'Digigram'                          ),
   (num:$01F2;  str:'Goepel Electronic GmbH'            ),
   (num:$01F3;  str:'Bear Instruments'                 ),
   (num:$01F4;  str:'GN Nettest'                        ),
   (num:$01F5;  str:'ITRI'                              ),
   (num:$01F6;  str:'White Electronic Designs Corp.'    ),
   (num:$01F7;  str:'Focus Enhancements'                ),
   (num:$01F8;  str:'Philips Professional Solutions'    ),
   (num:$01F9;  str:'Apricorn'                          ),
   (num:$01FA;  str:'Dantec Medical'                    ),
   (num:$01FB;  str:'RadioLAN'                          ),
   (num:$01FC;  str:'Enator Telub AB'                   ),
   (num:$01FD;  str:'iREZ Research Corporation'         ),
   (num:$01FE;  str:'Card Access, Inc.'                 ),
   (num:$01FF;  str:'Intermec Technologies Corporation' ),
   (num:$0200;  str:'Ingenieurburo Anhaus GmbH'         ),
   (num:$0201;  str:'Phototelesis'                      ),
   (num:$0202;  str:'Diamond Multimedia'                ),
   (num:$0203;  str:'Research In Motion Limited'        ),
   (num:$0204;  str:'Dosch & Amand'                     ),
   (num:$0205;  str:'Willnet, Inc.'                     ),
   (num:$0206;  str:'No Wires Needed BV'                ),
   (num:$0207;  str:'PC Card International AB'          ),
   (num:$0208;  str:'American Biometric Company'        ),
   (num:$0209;  str:'WiNRADiO Communications'           ),
   (num:$020A;  str:'BreezeCom'                         ),
   (num:$020B;  str:'Mediane Systems'                   ),
   (num:$020C;  str:'HST High Soft Tech GmbH'           ),
   (num:$020D;  str:'Tinwald Networking Technologies, Inc.'),
   (num:$020E;  str:'Sedlbauer AG'                      ),
   (num:$020F;  str:'Proxima'                           ),
   (num:$0210;  str:'Fraunhofer Institute for Integrated Circuits'),
   (num:$0211;  str:'Not Limited, Inc.'                 ),
   (num:$0212;  str:'Lucent Technologies'               ),
   (num:$0213;  str:'RELIA Technologies Corporation'    ),
   (num:$0214;  str:'ADS Technologies'                  ),
   (num:$0215;  str:'Momentum Data Systems'             ),
   (num:$0216;  str:'Sycard Technology'                 ),
   (num:$0217;  str:'GPP mbH'                           ),
   (num:$0218;  str:'CPath'                             ),
   (num:$0219;  str:'ReSound Corporation'               ),
   (num:$021A;  str:'Farallon Computing, Inc.'          ),
   (num:$021B;  str:'Billionton Systems, Inc.'          ),
   (num:$021C;  str:'Lightwell Co. Ltd.'                ),
   (num:$021D;  str:'Tellus Technology Inc.'            ),
   (num:$021E;  str:'Franklin Electronic Publishers'    ),
   (num:$021F;  str:'IOtech Inc.'                       ),
   (num:$0220;  str:'SkyTune Corporation/Auravision Corporation'),
   (num:$0221;  str:'Mobilink Telecom'                  ),
   (num:$0222;  str:'Mils Elektronik GmbH'              ),
   (num:$0223;  str:'Utimaco'                           ),
   (num:$0224;  str:'Friesian Engineering Ltd.'         ),
   (num:$0225;  str:'Cue Network Corporation'           ),
   (num:$0226;  str:'dSPACE GmbH'                       ),
   (num:$0227;  str:'Calluna Technology, Ltd.'          ),
   (num:$0228;  str:'Butterfly Group'                   ),
   (num:$0229;  str:'Digianswer A/S'                    ),
   (num:$022A;  str:'TNO-TPD'                           ),
   (num:$022B;  str:'Quickflex, Inc.'                   ),
   (num:$022C;  str:'Annapolis Micro Systems, Inc.'     ),
   (num:$022D;  str:'AmbiCom, Inc.'                     ),
   (num:$022E;  str:'Condor Engineering Inc.'           ),
   (num:$022F;  str:'Micro Solutions, Inc.'             ),
   (num:$0230;  str:'High Content GmbH'                 ),
   (num:$0231;  str:'Shelcad Communications Ltd./Way2Call Communications, Ltd.'),
   (num:$0232;  str:'INESC'                             ),
   (num:$0233;  str:'UTEL AS'                           ),
   (num:$0234;  str:'Memory Limited'                    ),
   (num:$0235;  str:'XLTEK'                             ),
   (num:$0236;  str:'Penn State University'             ),
   (num:$0237;  str:'Scientific Atlanta'                ),
   (num:$0238;  str:'Advanced Medical Electronics'      ),
   (num:$0239;  str:'Janz Computer AG'                  ),
   (num:$023A;  str:'Ambient Technologies, Inc.'        ),
   (num:$023B;  str:'Perle Systems Ltd.'                ),
   (num:$023C;  str:'Orbital Sciences Corporation/Smith Aerospace'),
   (num:$023D;  str:'Nokia Wireless Business Comm.'     ),
   (num:$023E;  str:'Sectra Communications AB'          ),
   (num:$023F;  str:'DSA Daten und Systemtechnik GmbH'  ),
   (num:$0240;  str:'Signalteknik AB'                   ),
   (num:$0241;  str:'Lasergraphics'                     ),
   (num:$0242;  str:'TMS International BV'              ),
   (num:$0243;  str:'Baumer Ident GmbH'                 ),
   (num:$0244;  str:'Spyrus'                            ),
   (num:$0245;  str:'Intec GmbH'                        ),
   (num:$0246;  str:'Delta Networks Inc.'               ),
   (num:$0247;  str:'SystemBase Co, Ltd.'               ),
   (num:$0248;  str:'Wave Science, Inc.'                ),
   (num:$0249;  str:'IHG Technologies'                  ),
   (num:$024A;  str:'Bomedia Inc.'                      ),
   (num:$024B;  str:'Sinus Messtechnik GmbH'            ),
   (num:$024C;  str:'Realtek Semi-Conductor Co., Ltd.'  ),
   (num:$024D;  str:'MADS Inc.'                         ),
   (num:$024E;  str:'Silicon Film Technologies'         ),
   (num:$024F;  str:'Toyotamacs, Inc.'                  ),
   (num:$0250;  str:'Samsung Electro-Mechanics Co. Ltd.'),
   (num:$0251;  str:'Lifestyle Software GmbH'           ),
   (num:$0252;  str:'Anritsu Corporation'               ),
   (num:$0253;  str:'Ifak System GmbH'                  ),
   (num:$0254;  str:'ShareWave, Inc.'                   ),
   (num:$0255;  str:'Halo Data Devices'                 ),
   (num:$0256;  str:'Scitex Corporation Ltd.'           ),
   (num:$0257;  str:'Quicknet Technologies'             ),
   (num:$0258;  str:'Netherlands Forensic Institute'    ),
   (num:$0259;  str:'Roche Diagnostics Corporation'     ),
   (num:$025A;  str:'Ubinetics, Ltd.'                   ),
   (num:$025B;  str:'MMC Technology Inc.'               ),
   (num:$025C;  str:'Omnipoint Technologies, Inc.'      ),
   (num:$025D;  str:'WPI Husky Technology, Ltd.'        ),
   (num:$025E;  str:'Sphinx Elektronik GmbH'            ),
   (num:$025F;  str:'Identicator Technology'            ),
   (num:$0260;  str:'Argosy Research, Inc.'             ),
   (num:$0261;  str:'Home Wireless Networks, Inc.'      ),
   (num:$0262;  str:'Logix Communications Ltd.'         ),
   (num:$0263;  str:'Stollmann Produkt GmbH'            ),
   (num:$0264;  str:'Wireless Solutions Sweden AB/National Semiconductor Sweden AB'),
   (num:$0265;  str:'SBS Technologies, Inc.'            ),
   (num:$0266;  str:'Digimedia'                         ),
   (num:$0267;  str:'Optoelectronics Co., Ltd.'         ),
   (num:$0268;  str:'ARtem GmbH'                        ),
   (num:$0269;  str:'Port Denshi Co., Ltd.'             ),
   (num:$026A;  str:'Feiya Technology Corporation'      ),
   (num:$026B;  str:'Vetronix Research Corporation'     ),
   (num:$026C;  str:'Symbol Technologies'               ),
   (num:$026D;  str:'Yisotelecom'                       ),
   (num:$026E;  str:'Freecom Technologies GmbH'         ),
   (num:$026F;  str:'Buffalo, Inc. (MELCO, Inc.)'       ),
   (num:$0270;  str:'Manufacturing Laboratories, Inc.'  ),
   (num:$0271;  str:'Atheros Communications, Inc.'      ),
   (num:$0272;  str:'Ethentica, Inc.'                   ),
   (num:$0273;  str:'IXXAT Automation GmbH'             ),
   (num:$0274;  str:'Bromax Communications, Inc.'       ),
   (num:$0275;  str:'Buffer-Tek Corporation/Topson Technology Co., Ltd.'),
   (num:$0276;  str:'Telson Information and Communications Co., Ltd.'),
   (num:$0277;  str:'Abomem Technology Corporation'     ),
   (num:$0278;  str:'Air Prime, Inc.'                   ),
   (num:$0279;  str:'Oxford Semiconductor, Ltd.'        ),
   (num:$027A;  str:'Mobilian'                          ),
   (num:$027B;  str:'NTT Multimedia Laboratories, Inc.' ),
   (num:$027C;  str:'Verbatim Corporation'              ),
   (num:$027D;  str:'Cubic Transportation Systems'      ),
   (num:$027E;  str:'Itronix Corporation'               ),
   (num:$027F;  str:'Absolute Value Systems'            ),
   (num:$0280;  str:'Hanmacstone Co., Ltd.'             ),
   (num:$0281;  str:'Silicon Magic Co., Ltd.'           ),
   (num:$0282;  str:'Westell, Inc.'                     ),
   (num:$0283;  str:'Chia Tse Terminal Industry Co., Ltd.'),
   (num:$0284;  str:'Business Security AB'              ),
   (num:$0285;  str:'SysOnChip Company'                 ),
   (num:$0286;  str:'Berton Information Co., Ltd.'      ),
   (num:$0287;  str:'Silicon Motion, Inc.'              ),
   (num:$0288;  str:'Nitsuko Corporation'               ),
   (num:$0289;  str:'Neopraxis'                         ),
   (num:$028A;  str:'GemTek Technology Co., Ltd.'       ),
   (num:$028B;  str:'GTran, Inc.'                       ),
   (num:$028C;  str:'M. C. Miller Company'              ),
   (num:$028D;  str:'Lead Data Inc.'                    ),
   (num:$028E;  str:'Meshnetworks, Inc.'                ),
   (num:$028F;  str:'Identec Solutions'                 ),
   (num:$0290;  str:'Infineer, Inc./Mako Technologies, LLC'),
   (num:$0291;  str:'Polycom'                           ),
   (num:$0292;  str:'Hand Held Products'                ),
   (num:$0293;  str:'Primax Electronics, Ltd.'          ),
   (num:$0294;  str:'Constellation Technology Corporation'),
   (num:$0295;  str:'Cyberlane Inc.'                    ),
   (num:$0296;  str:'Palm, Inc.'                        ),
   (num:$0297;  str:'Siemens Hearing Instruments'       ),
   (num:$0298;  str:'Xtreme Spectrum, Inc.'             ),
   (num:$0299;  str:'Dane-Elec'                         ),
   (num:$029A;  str:'Zydas Technology Corporation'      ),
   (num:$029B;  str:'ENE Technology, Inc.'              ),
   (num:$029C;  str:'Micro Linear'                      ),
   (num:$029D;  str:'Meltron Communications Corporation'),
   (num:$029E;  str:'Telsy S.P.A'                       ),
   (num:$029F;  str:'Nippon Systems Development Co. Ltd.'),
   (num:$02A0;  str:'NorthStar Systems, Inc.'           ),
   (num:$02A1;  str:'Kobil Systems GmbH'                ),
   (num:$02A2;  str:'HaSoTec GmbH'                      ),
   (num:$02A3;  str:'New Logic Technologies'            ),
   (num:$02A4;  str:'Flex-P Industries Sdn. Bhd'        ),
   (num:$02A5;  str:'C-One Technology Corporation'      ),
   (num:$02A6;  str:'Leoco Corporation'                 ),
   (num:$02A7;  str:'Point Star A/S'                    ),
   (num:$02A8;  str:'Be Interactive Co., Ltd.'          ),
   (num:$02A9;  str:'Cryptographic Appliances Inc.'     ),
   (num:$02AA;  str:'ASUSTek Computer Inc.'             ),
   (num:$02AB;  str:'Philips Components'                ),
   (num:$02AC;  str:'Efficient Networks, Inc.'          ),
   (num:$02AD;  str:'RF Code, Inc.'                     ),
   (num:$02AE;  str:'Ritek, Inc.'                       ),
   (num:$02AF;  str:'Teletronics Technology Corporation'),
   (num:$02B0;  str:'Integrated Telecom Express Inc.'   ),
   (num:$02B1;  str:'Rainbow China Company'             ),
   (num:$02B2;  str:'PalmMicro Communications'          ),
   (num:$02B3;  str:'Advanced Analogic Technologies, Inc.'),
   (num:$02B4;  str:'Agere Systems'                     ),
   (num:$02B5;  str:'Envara'                            ),
   (num:$02B6;  str:'Onspec Electronics, Inc'           ),
   (num:$02B7;  str:'Farsite Communications Ltd.'       ),
   (num:$02B8;  str:'Kouwell Electronics Corp.'         ),
   (num:$02B9;  str:'Interworks, A Sanmina Company'     ),
   (num:$02BA;  str:'Indigita Corporation'              ),
   (num:$02BB;  str:'Systemonic AG'                     ),
   (num:$02BC;  str:'KG Goransson AB'                   ),
   (num:$02BD;  str:'CryptoCard Corporation'            ),
   (num:$02BE;  str:'Latschbacher GmbH'                 ),
   (num:$02BF;  str:'Caveo Technologies'                ),
   (num:$02C0;  str:'Philips Electronics/Animated Prosthetics Inc.'), (* Ungermann-Bass ? *)
   (num:$02C1;  str:'Prolink Microsystems Corporation'  ),
   (num:$02C2;  str:'CopyTele Inc.'                     ),
   (num:$02C3;  str:'Navicom Co. Ltd.'                  ),
   (num:$02C5;  str:'Microgate'                         ),
   (num:$02C6;  str:'NextComm Inc.'                     ),
   (num:$02C7;  str:'Cameo Communications, Inc.'        ),
   (num:$02C8;  str:'SIIG, Inc.'                        ),
   (num:$02C9;  str:'Dream-Multimedia-Tv GmbH'          ),
   (num:$02CA;  str:'SIDSA'                             ),
   (num:$02CB;  str:'Logicmeca Co. Ltd.'                ),
   (num:$02CC;  str:'Flarion Technologies'              ),
   (num:$02CD;  str:'Speeddragon Multimedia Limited'    ),
   (num:$02CE;  str:'Ericsson Mobile Communications (UK) Ltd.'),
   (num:$02CF;  str:'Wing-Span Enterprise Co. Ltd.'     ),
   (num:$02D0;  str:'Broadcom Corporation'              ),
   (num:$02D1;  str:'Fodus Communications Inc.'         ),
   (num:$02D2;  str:'Microsoft Corporation'             ),
   (num:$02D3;  str:'Indus Teqsite Private Limited'     ),
   (num:$02D4;  str:'Sun Corporation'                   ),
   (num:$02D5;  str:'Simple Technology Co. Ltd.'        ),
   (num:$02D6;  str:'CATC'                              ),
   (num:$02D7;  str:'Think Innovation Korea Inc.'       ),
   (num:$02D8;  str:'Wave Plus Tech. Co., LTD.'         ),
   (num:$02D9;  str:'DCrypt Private Ltd.'              ), (* D(a)Crypt D("o)Crypt? *)
   (num:$02DA;  str:'CET Technologies Pte. Ltd.'        ),
   (num:$02DB;  str:'SyChip, Inc.'                      ),
   (num:$02DC;  str:'Root, Inc.'                        ),
   (num:$02DD;  str:'Alps Electric Co., Ltd.'           ),
   (num:$02DE;  str:'Transmeta Corporation'             ),
   (num:$02DF;  str:'Marvell Semiconductor Inc.'        ),
   (num:$02E0;  str:'Giga-Byte Technology Co. Ltd.'     ),
   (num:$02E1;  str:'Bermai, Inc.'                      ),
   (num:$02E2;  str:'General Meters Corporation'        ),
   (num:$02E3;  str:'ArrayComm, Inc.'                   ),
   (num:$02E4;  str:'Eil Company'                       ),
   (num:$02E5;  str:'System Create Corporation'         ),
   (num:$02E6;  str:'Vector Informatik GmbH'            ),
   (num:$02E7;  str:'SiliconMobius, Inc.'               ),
   (num:$02E8;  str:'Resonext Communications, Inc.'     ),
   (num:$02E9;  str:'PacketDNA Technologies, Inc.'      ),
   (num:$02EA;  str:'Infineon Technologies'             ),
   (num:$02EB;  str:'Archtek Telecom Co.'               ),
   (num:$02EC;  str:'Concraft Industrial Co., Ltd.'     ),
   (num:$02ED;  str:'Spectec Computer'                  ),
   (num:$02EE;  str:'Delphi Connection Systems'         ),
   (num:$02EF;  str:'Oasis Silicon Systems'             ),
   (num:$02F0;  str:'Netgear, Inc.'                     ),
   (num:$02F1;  str:'L3 Communications'                 ),
   (num:$02F2;  str:'IP Wireless, Inc.'                 ),
   (num:$02F3;  str:'Howtel Co., Ltd.'                  ),
   (num:$02F4;  str:'GE Interlogix'                     ),
   (num:$02F5;  str:'Allied Telesyn Incorporated'       ),
   (num:$02F6;  str:'Nexus Electronics, Ltd.'           ),
   (num:$02F7;  str:'Aplux Communications Ltd.'         ),
   (num:$02F8;  str:'Vista Imaging Inc.'                ),
   (num:$02F9;  str:'Silicon Integrated Systems Corporation'),
   (num:$02FA;  str:'Siemens AG'                        ),
   (num:$02FB;  str:'Brooks Automation GmbH'            ),
   (num:$02FC;  str:'Field Technology Co., Ltd.'        ),
   (num:$02FD;  str:'Rochester Microsystems, Inc.'      ),
   (num:$02FE;  str:'Inprocomm, Inc.'                   ),
   (num:$0300;  str:'ATI Technologies'                  ),
   (num:$0301;  str:'Garmin International'              ),
   (num:$0302;  str:'Interactive Imaging Systems'       ),
   (num:$0303;  str:'Matsushita Electric Works, Ltd.'   ),
   (num:$0304;  str:'Boeing'                            ),
   (num:$0305;  str:'AboCom Systems, Inc.'              ),
   (num:$0306;  str:'Rikaline Marketing Corporation'    ),
   (num:$0307;  str:'Innovative Strategic Advanced Systems'),
   (num:$0308;  str:'Zyxel Communications Corporation'  ),
   (num:$0309;  str:'Planning Systems, Inc.'            ),
   (num:$030A;  str:'Smiths Aerospace'                  ),
   (num:$030B;  str:'Messring System Bau GmbH'          ),
   (num:$030C;  str:'System Innovation AB'              ),
   (num:$030D;  str:'VEO'                               ),
   (num:$030E;  str:'Brecis Communications'             ),
   (num:$030F;  str:'JAE Electronics, Inc.'             ),
   (num:$0310;  str:'Daisen Electronic Industrial Co., Ltd.'),
   (num:$0311;  str:'Netchip Technology'                ),
   (num:$0312;  str:'Twin Mos Technologies Inc.'        ),
   (num:$0313;  str:'3E Technologies International'     ),
   (num:$0314;  str:'Option N.V.'                       ),
   (num:$0315;  str:'Commtech, Inc.'                    ),
   (num:$0316;  str:'NVidia Corporation'                ),
   (num:$0317;  str:'TDK Semiconductors Corporation'    ),
   (num:$0318;  str:'Sony Ericsson Mobile Communication AB'),
   (num:$0319;  str:'Hitachi Global Storage Technologies, Inc.'),
   (num:$031A;  str:'cap-XX Pty Ltd'                    ),
   (num:$031B;  str:'Simcom Ltd.'                       ),
   (num:$031C;  str:'Longwell Company'                  ),
   (num:$031D;  str:'Amphenol East Asia Ltd.'           ),
   (num:$031E;  str:'Taisol Electronics'                ),
   (num:$031F;  str:'Systemtechnik GmbH'                ),
   (num:$0320;  str:'Askey Computer Corporation'        ),
   (num:$0321;  str:'M-Systems'                         ),
   (num:$0322;  str:'DataLogic Spa'                     ),
   (num:$0323;  str:'Tateno-Dennou, Inc.'               ),
   (num:$0324;  str:'Actron Manufacturing'              ),
   (num:$0325;  str:'AboveCable, Inc.'                  ),
   (num:$0326;  str:'Andor Design'                      ),
   (num:$0327;  str:'Microlink Communcations Inc.'      ),
   (num:$0328;  str:'California Micro Devices'          ),
   (num:$0329;  str:'Fujikura/DDK'                      ),
   (num:$032A;  str:'Cambridge Silicon Radio Ltd.'      ),
   (num:$032B;  str:'NSW Roads & Traffic Authority, Information & Ref. Centre' ),
   (num:$032C;  str:'ROHM Company, Ltd.'                ),
   (num:$032D;  str:'Atmel Hellas S.A.'                 ),
   (num:$032E;  str:'Super Link Electronics Co., Ltd.'  ),
   (num:$032F;  str:'Seclarity, Inc.'                   ),
   (num:$0330;  str:'Comax Technology, Inc.'            ),
   (num:$0331;  str:'Sony Corporation'                  ),
   (num:$0332;  str:'Synaptics, Inc.'                   ),
   (num:$0333;  str:'Third Millennium Systems'          ),
   (num:$0334;  str:'Kionix, Inc.'                      ),
   (num:$0335;  str:'Tatung Co.'                        ),
   (num:$0336;  str:'L&K Precision Technology Co., Ltd.'),
   (num:$0337;  str:'Advanced Connectek'                ),
   (num:$0338;  str:'Palm One'                          ),
   (num:$0339;  str:'Wistron Neweb Corporation'         ),
   (num:$033A;  str:'Cmotech Co., Ltd.'                 ),
   (num:$033B;  str:'Plastron Precision Co., Ltd.'      ),
   (num:$033C;  str:'Sony'                              ),
   (num:$033D;  str:'Technisat Digital GmbH'            ),
   (num:$033E;  str:'Jess-Link Products Co. LTD.'       ),
   (num:$033F;  str:'Animation Technologies Inc.'       ),
   (num:$0340;  str:'Allion Computer Inc.'              ),
   (num:$0341;  str:'Pacific Telecom Research Inc.'     ),
   (num:$0342;  str:'SCM Microsystems'                  ),
   (num:$0343;  str:'DATAFAB Systems, Inc.'             ),
   (num:$0344;  str:'Formac Elektronik GmbH'            ),
   (num:$0345;  str:'Wise Power Tech. Co., Ltd.'        ),
   (num:$0345;  str:'China IWNCOMM Co. Ltd.'            ),
   (num:$0346;  str:'AIM GmbH'                          ),
   (num:$0347;  str:'VIA Technologies, Inc.'            ),
   (num:$0348;  str:'Hagiwara Sys-Com U.S.'             ),
   (num:$0349;  str:'Barron McCann Ltd.'                ),
   (num:$034A;  str:'Tactel AB'                         ),
   (num:$034B;  str:'Ubiquam Co., Ltd.'                 ),
   (num:$034C;  str:'Anzus Inc.'                        ),
   (num:$034D;  str:'Creatix GmbH'                      ),
   (num:$034E;  str:'Western Digital'                   ),
   (num:$034F;  str:'AVerMedia Technologies, Inc.'      ),
   (num:$0350;  str:'XCrypt, Inc.'                      ),
   (num:$0351;  str:'Intellibus'                        ),
   (num:$0352;  str:'Hosiden Corporation'               ),
   (num:$0353;  str:'Zhong-Yue Technologic Co., Ltd.'   ),
   (num:$0354;  str:'Red River Engineering'             ),
   (num:$0355;  str:'Motorola Israel, Ltd.'             ),
   (num:$0356;  str:'DiBcom'                            ),
   (num:$0357;  str:'TTTech Computertechnik AG'         ),
   (num:$0358;  str:'AVX Corporation'                   ),
   (num:$0359;  str:'U-Media Communications, Inc.'      ),
   (num:$035A;  str:'WJ Communications, Inc.'           ),

   (num:$0D37;  str:'Bad? Noname NEC USB 2.0 vendor?'   ), (* cscinfo *)
   (num:$4E01;  str:'Lexar?'                            ), (* D. E. 20030127 *)
   (num:$5241;  str:'Archos'                            ), (* D. E. 20030127 *)
   (num:$C001;  str:'Contec'                            ), (* ciscode.h *)
   (num:$C00B;  str:'Macnica'                           ), (* ciscode.h *)
   (num:$C00F;  str:'Allied Telesis'                    )  (* LA-PCM.cis *)
    );

implementation

end.
