Title   constant+record definitions from pc95smpl.h

VOLTAGE_33V             equ 33
VOLTAGE_50V             equ 50

MAXTUPLEDATALEN         equ 080h

;-------------------------------------------------------------------
;   Card Services version definitions.
;-------------------------------------------------------------------

CS_LEVEL_200            equ 0200h
CS_LEVEL_210            equ 0210h
CS_LEVEL_500            equ 0500h

;-------------------------------------------------------------------

; from ftl2.h

; Attribute for Register Client argument

MEMORY_CLIENT_DD                equ 00001h
MEMORY_TECHNOLOGY_DRV           equ 00002h
IO_CLIENT_DD                    equ 00004h
INSERTION_EVENTS_SHARED         equ 00008h
INSERTION_EVENTS_EXCLUSIVE      equ 00010h
INSERTION_EVENTS_ALL            equ INSERTION_EVENTS_SHARED+INSERTION_EVENTS_EXCLUSIVE

; Event Mask for Register Client argument

EVENTMASK_WRITE_PROTECT_CHANGE  equ 00001h
EVENTMASK_CARD_LOCK_CHANGE      equ 00002h
EVENTMASK_EJECTION_REQUEST      equ 00004h
EVENTMASK_INSERTION_REQUEST     equ 00008h
EVENTMASK_BATTERY_DEAD          equ 00010h
EVENTMASK_BATTERY_LOW           equ 00020h
EVENTMASK_READY_CHANGE          equ 00040h
EVENTMASK_CARD_DETECT_CHANGE    equ 00080h
EVENTMASK_POWER_MGMT_CHANGE     equ 00100h
EVENTMASK_RESET                 equ 00200h
EVENTMASK_SS_UPDATED            equ 00400h


; from common.inc

;*--------------------------------------------------------------------------*
;*  CS,SS Return codes                                                      *
;*--------------------------------------------------------------------------*

SUCCESS                     equ     000h
BAD_ADAPTER                 equ     001h
BAD_ATTRIBUTE               equ     002h
BAD_BASE                    equ     003h
BAD_EDC                     equ     004h
BAD_IRQ                     equ     006h
BAD_OFFSET                  equ     007h
BAD_PAGE                    equ     008h
READ_FAILURE                equ     009h
BAD_SIZE                    equ     00Ah
BAD_SOCKET                  equ     00Bh
BAD_TYPE                    equ     00Dh
BAD_VCC                     equ     00Eh
BAD_VPP                     equ     00Fh
BAD_WINDOW                  equ     011h
WRITE_FAILURE               equ     012h
NO_CARD                     equ     014h
UNSUPPORTED_FUNCTION        equ     015h
UNSUPPORTED_MODE            equ     016h
BAD_SPEED                   equ     017h
BUSY                        equ     018h
GENERAL_FAILURE             equ     019h
WRITE_PROTECTED             equ     01Ah
BAD_ARG_LENGTH              equ     01Bh
BAD_ARGS                    equ     01Ch
CONFIGURATION_LOCKED        equ     01Dh
IN_USE                      equ     01Eh
NO_MORE_ITEMS               equ     01Fh
OUT_OF_RESOURCE             equ     020h
BAD_HANDLE                  equ     021h

;-------------------------------------------------------------------
;   OS2 IDC interface argument packet structure.
;-------------------------------------------------------------------

IDC_Packet              Struc
  function              db ?
  handle                dw ?
  pointer               dd ?
  arglen                dw ?
  argumentpointer       dd ?
IDC_Packet              EndS

;-------------------------------------------------------------------
;   The Argument structure for Card Services Function (API) Call.
;-------------------------------------------------------------------

GetCardServicesInfoStructure Struc
  InfoLen               dw ?
  Signature             dw ?
  Count                 dw ?
  Revision              dw ?
  CSLevel               dw ?
  VStrOff               dw ?
  VStrLen               dw ?
  VendorString          db ?
GetCardServicesInfoStructure EndS

RegisterClientStructure Struc
  Attribute_RCS         dw ?
  EventMask             dw ?
  ClientData            db 8 dup (?)
  Version_RCS           dw ?
RegisterClientStructure EndS

RequestWindowStructure  Struc
  Socket                dw ?
  Attribute_RWS         dw ?
  Base                  dd ?
  Size_RWS              dd ?
  AccessSpeed           db ?
RequestWindowStructure  EndS

RequestIRQStructure     Struc
  Socket                dw ?
  Attribute_RIS         dw ?
  AssignedIRQ           db ?
  IRQInfo1              db ?
  IRQInfo2              dw ?
RequestIRQStructure     EndS

ReleaseIRQStructure     Struc
  Socket                dw ?
  Attributes_LIS        dw ?
  AssignedIRQ           db ?
ReleaseIRQStructure     EndS

RequestConfigurationStructure Struc
  Socket_CFG            dw ?                    ; logical socket
  Attribute_CFG         dw ?                    ; bit mask for attributes
  Vcc                   db ?                    ; vcc setting
  Vpp1                  db ?                    ; vpp1 setting
  Vpp2                  db ?                    ; vpp2 setting
  IntType               db ?                    ; interrupt type
  ConfigBase            dd ?                    ; base address of registers
  Status_CFG            db ?                    ; status register setting
  Pin_CFG               db ?                    ; card pin register setting
  Copy_CFG              db ?                    ; copy register setting
  Option_CFG            db ?                    ; option register setting
  Present_CFG           db ?                    ; config registers present
  ExtendedStatus        db ?
RequestConfigurationStructure EndS

ReleaseConfigurationStructure Struc
  Socket                dw ?                    ; logical socket
ReleaseConfigurationStructure EndS

GetConfigurationInfoStructure Struc
  Socket                dw ?                    ; logical socket
  Attribute_INFO        dw ?                    ; bit mask for attributes
  Vcc                   db ?                    ; vcc setting
  Vpp1                  db ?                    ; vpp1 setting
  Vpp2                  db ?                    ; vpp2 setting
  IntType               db ?                    ; interrupt type
  ConfigBase            dd ?                    ; base address of registers
  Status_INFO           db ?                    ; status register setting
  Pin_INFO              db ?                    ; card pin register setting
  Copy_INFO             db ?                    ; copy register setting
  Option_INFO           db ?                    ; option register setting
  Present_INFO          db ?                    ; config registers present
  FirstDevType          db ?
  FuncCode              db ?
  SysInitMask           db ?
  ManuCode              dw ?
  ManuInfo              dw ?
  CardValues            db ?
  AssignedIRQ_INFO      db ?
  IRQAttributes         dw ?
  BasePort1             dw ?
  NumPorts1             db ?
  Attributes1           db ?
  BasePort2             dw ?
  NumPorts2             db ?
  Attributes2           db ?
  IOAddrLines           db ?
  unknown_level_800     db 40 dup (?)
GetConfigurationInfoStructure EndS

GetTupleDataStructure   Struc
  Socket                dw ?                    ; logical socket
  Attribute_TUPLEDATA   dw ?                    ; bit-mapped attributes
  DesiredTuple          db ?                    ; desired tuple code value
  TupleOffset           db ?                    ; offset into tuple
  Flags                 dw ?                    ; cs tuple flags data
  LinkOffset            dd ?                    ; cs link state info
  CISOffset             dd ?                    ; cs cis state information
  TupleDataMax          dw ?                    ; max size of tuple data area
  TupleDataLen          dw ?                    ; num of bytes in tuple body
  TupleData             db (MAXTUPLEDATALEN+2) dup (?) ; tuple data
GetTupleDataStructure   EndS

GetFirstTupleStructure  Struc
  Socket                dw ?                    ; Logical Socket
  Attribute_TUPLESTR    dw ?                    ; Bit-mapped attributes
  DesiredTuple          db ?                    ; Desired Tuple Code value
  Reserved_TUPLESTR     db ?
  Flags                 dw ?                    ; CS Tuple Flags data
  LinkOffset            dd ?                    ; CS Link state info
  CISOffset             dd ?                    ; CS CIS state information
  TupleCode             dw ?                    ; Tuple found
  TupleLink             dw ?                    ; Link value for tuple found
GetFirstTupleStructure  EndS


RequestExclusiveStructure Struc
  wRQXSocket            dw ?                    ; Socket
  wRQXAttributes        dw ?                    ; Attributes
RequestExclusiveStructure EndS


; from cs2mcequ.inc

;*--------------------------------------------------------------------------*
;*  CS Function codes                                                       *
;*--------------------------------------------------------------------------*

CS_GetCardServicesInfo      equ     00Bh
CS_RegisterClient           equ     010h
CS_DeregisterClient         equ     002h
CS_GetStatus                equ     00Ch
CS_ResetCard                equ     011h
CS_SetEventMask             equ     031h
CS_GetEventMask             equ     02Eh

CS_RequestIO                equ     01Fh
CS_ReleaseIO                equ     01Bh
CS_RequestIRQ               equ     020h
CS_ReleaseIRQ               equ     01Ch
CS_RequestWindow            equ     021h
CS_ReleaseWindow            equ     01Dh
CS_ModifyWindow             equ     017h
CS_MapMemPage               equ     014h
CS_RequestSocketMask        equ     022h
CS_ReleaseSocketMask        equ     02Fh
CS_RequestConfiguration     equ     030h
CS_GetConfigurationInfo     equ     004h
CS_ModifyConfiguration      equ     027h
CS_ReleaseConfiguration     equ     01Eh
CS_GetFirstWindow           equ     037h
CS_GetNextWindow            equ     038h
CS_GetMemPage               equ     039h

CS_OpenMemory               equ     018h
CS_ReadMemory               equ     019h
CS_WriteMemory              equ     024h
CS_CopyMemory               equ     001h
CS_RegisterEraseQueue       equ     00Fh
CS_CheckEraseQueue          equ     026h
CS_DeregisterEraseQueue     equ     025h
CS_CloseMemory              equ     000h

CS_GetFirstTuple            equ     007h
CS_GetNextTuple             equ     00Ah
CS_GetTupleData             equ     00Dh
CS_GetFirstRegion           equ     006h
CS_GetNextRegion            equ     009h
CS_GetFirstPartition        equ     005h
CS_GetNextPartition         equ     008h

CS_ReturnSSEntry            equ     023h
CS_MapLogSocket             equ     012h
CS_MapPhySocket             equ     015h
CS_MapLogWindow             equ     013h
CS_MapPhyWindow             equ     016h
CS_RegisterMTD              equ     01Ah
CS_RegisterTimer            equ     028h
CS_SetRegion                equ     029h
CS_ValidateCIS              equ     02Bh
CS_RequestExclusive         equ     02Ch
CS_ReleaseExclusive         equ     02Dh
CS_GetFirstClient           equ     00Eh
CS_GetNextClient            equ     02Ah
CS_GetClientInfo            equ     003h
CS_AddSocketServices        equ     032h
CS_ReplaceSocketServices    equ     033h
CS_VendorSpecific           equ     034h
CS_AdjustResourceInfo       equ     035h
CS_AccessConfigRegister     equ     036h

;*--------------------------------------------------------------------------*
;*  CS Event codes                                                          *
;*--------------------------------------------------------------------------*

PM_RESUME_EVENT                   equ     00Bh
PM_SUSPEND_EVENT                  equ     00Ch
BATTERY_DEAD_EVENT                equ     001h
BATTERY_LOW_EVENT                 equ     002h
CARD_INSERTION_EVENT              equ     040h
CARD_LOCK_EVENT                   equ     003h
CARD_READY_EVENT                  equ     004h
CARD_REMOVAL_EVENT                equ     005h
CARD_RESET_EVENT                  equ     011h
CARD_UNLOCK_EVENT                 equ     006h
EJECTION_COMPLETE_EVENT           equ     007h
EJECTION_REQUEST_EVENT            equ     008h
ERASE_COMPLETE_EVENT              equ     081h
EXCLUSIVE_COMPLETE_EVENT          equ     00Dh
EXCLUSIVE_REQUEST_EVENT           equ     00Eh
INSERTION_COMPLETE_EVENT          equ     009h
INSERTION_REQUEST_EVENT           equ     00Ah
REGISTRATION_COMPLETE_EVENT       equ     082h
RESET_COMPLETE_EVENT              equ     080h
RESET_PHYSICAL_EVENT              equ     00Fh
RESET_REQUEST_EVENT               equ     010h
MTD_REQUEST_EVENT                 equ     012h
CLIENT_INFO_EVENT                 equ     014h
TIMER_EXPIRED_EVENT               equ     015h
SS_UPDATED_EVENT                  equ     016h
WRITE_PROTECT_EVENT               equ     017h
REQUEST_ATTENTION_EVENT           equ     018h


