/* install.cmd */
/* Author: Peter Brown */
/* Purpose: Install USBcfg.exe and support files; setup USB program object in System Setup folder */
/* Modified for beta5 to distinguish between eCS and OS/2 */
/* Modified for beta7 to install the USBfaq.inf file */
/* Modified for beta0.7.1 to install the USBfaq.inf file as usbmsdFAQ.inf */
/* Modified for beta0.7.1 to install the usbacpiFAQ.inf file */
/* Modified for beta0.7.5 to install the GETDESC.DLL file */

call rxFuncAdd "SysLoadFuncs" , "RexxUtil" , "SysLoadFuncs"
call SysLoadFuncs

  boot_drive = ''
  boot_drive = SysBootDrive()

name = "USB"
dir = directory()

/* Check for existing USBcfg - should have been created as USB not USBcfg originally */
objectExist = ObjectExist(USBcfg)
If  objectExist = 1 then
/* USBcfg exists so Delete Desktop Object USBcfg */
Do
   Say 'USBcfg object exists'
   If SysDestroyObject('<USBCFG>') Then
   Do 
    Say "USBcfg object destroyed."
   End
   Else
   Do 
    Say "USBcfg object NOT destroyed."
   End
End


/* addin code to check for and remove any directory backslash */
IF Right(Strip(dir),1)<>'\' THEN 
  dir=dir||'\'

/*  eCS or OS/2? */
call SysFileTree boot_drive||'\ecs\bin', 'file', 'D'
If file.0=1 Then
Do
/* eCS */
  '@Copy ' ||dir||"USBCFG.EXE" boot_drive||"\ecs\bin\USBCFG.EXE"
  '@Copy ' ||dir||"USBCFG.HLP" boot_drive||"\ecs\help\USBCFG.HLP"
  '@Copy ' ||dir||"GETDESC.DLL" boot_drive||"\ecs\DLL\GETDESC.DLL"
  '@Copy ' ||dir||"USBMSDFAQ.INF" boot_drive||"\ecs\book\USBMSDFAQ.INF"
  '@Copy ' ||dir||"USBACPIFAQ.INF" boot_drive||"\ecs\book\USBACPIFAQ.INF"
  PRGOPTION="EXENAME="||boot_drive||"\ecs\bin\USBCFG.EXE;OBJECTID=<USBCFG_EXE>"
/* just in case the app was previously installed in [BootDrive]:\os2 */
  call SysFileTree boot_drive||'\OS2\USBCFG.EXE', 'thefile', 'F'
     If thefile.0=1 Then
       Do
           '@Del' boot_drive||'\OS2\USBCFG.EXE'
           '@Del' boot_drive||'\OS2\USBCFG.HLP'
           '@Del' boot_drive||'\OS2\USBCFG.INI'
      End
/* just in case the help file, usbcfg.hlp, was previously installed in [BootDrive]:\ecs\bin */
  call SysFileTree boot_drive||'\ecs\bin\USBCFG.HLP', 'helpfile', 'F'
     If helpfile.0=1 Then
       Do
           '@Del' boot_drive||'\ecs\bin\USBCFG.HLP'
      End
End 
Else
Do
/* OS/2 */
/* the below fails on 1 system to date because an extra leading slash is inserted */
/* resolved by the addin code to check for and remove any directory backslash above */
  '@Copy ' ||dir||"USBCFG.EXE" boot_drive||"\OS2\USBCFG.EXE"
  '@Copy ' ||dir||"USBCFG.HLP" boot_drive||"\OS2\help\USBCFG.HLP"
  '@Copy ' ||dir||"GETDESC.DLL" boot_drive||"\OS2\DLL\GETDESC.DLL"
  '@Copy ' ||dir||"USBMSDFAQ.INF" boot_drive||"\OS2\book\USBMSDFAQ.INF"
  '@Copy ' ||dir||"USBACPIFAQ.INF" boot_drive||"\OS2\book\USBACPIFAQ.INF"
  PRGOPTION="EXENAME="||boot_drive||"\OS2\USBCFG.EXE;OBJECTID=<USBCFG_EXE>"
/* just in case the help file, usbcfg.hlp, was previously installed in [BootDrive]:\OS2 */
  call SysFileTree boot_drive||'\OS2\USBCFG.HLP', 'helpfile', 'F'
     If helpfile.0=1 Then
       Do
           '@Del' boot_drive||'\OS2\USBCFG.HLP'
      End
End
/* Create program object */
rc=SysCreateObject("WPProgram",name,"<WP_CONFIG>",PRGOPTION,"REPLACE")

Exit 0

/* Following code is "borrowed" from Rexx Tips and Tricks and checks for the existence of an object */

/* ------------------------------------------------------------------ */
/* function: Check if an object with a given object ID exists         */
/*                                                                    */
/* Usage:    ObjectExist objectID                                     */
/*                                                                    */
/* where:    objectID = object ID of the object to test               */
/*                                                                    */
/* returns:  1 - the object exist                                     */
/*           0 - the object does not exist                            */
/*           else                                                     */
/*             error code of the SysCreateObject function             */
/*                                                                    */
ObjectExist: PROCEDURE
  parse arg objectID

                        /* init the return code                       */
  rc = 43               /* error code 43 = routine not found          */

                        /* install a local error handler              */
  SIGNAL ON SYNTAX NAME ObjectExistError

                        /* check the parameter                        */
  if substr( objectID, 2, 1 ) <> ":" then
    if left( objectID,1 ) <> "<" & right( objectID,1 ) <> ">" then
      objectID = "<" || objectID || ">"

                        /* try to create an object with this ID       */
  tempRC = SysCreateObject( "WPFolder"                     ,,
                            "TestObject"                   ,,
                            "<WP_NOWHERE>"                 ,,
                            "OBJECTID=" || objectID || ";" ,,
                            "FAIL" )

  if tempRC = 1 then
  do
                        /* object created, delete it                  */
    call SysDestroyObject objectID
    rc = 0              /* set return code to "Object does not exist" */
  end /* if tempRC = 1 then */
  else
    rc = 1              /* set return code to "Object does exist"     */

ObjectExistError:

RETURN rc

