/* 16 May 2002. THUMINDX ver 1.30

  SRE-http addon and generic CGI-BIN script:
  Create a thumbnail index of graphic files in a directory
  Also can be run in standalone mode.


This program will work as:
 1) a SRE-http add-on,
 2) a cgi-bin script
 3) a standalone program
 
...it will automatically detect how it's being called.

Notes:
  * YOU MUST SET the thumbnail_dir and thumbnail_dir_sel parameters (below)!
  * To run in standalone mode, you MUST SET the WWW_DIR parameter (below)!

    Exception: if running in standalone mode, and generating links to 
               "local files", you can use the NOT_HTTP
               and IMGDIR parameters instead of THUMBNAIL_DIR and WWW_DIR

*/

/* ********   BEGIN user changable options         **********   */
/* ********   BEGIN user changable options       ***********    */

/*     ------  You Must Set the THUMBNAIL_DIR parameter !         ----   */

/*BEGIN --- */


    /* Enter fully-qualfied directory in which thumbnail files should be stored. */

THUMBNAIL_DIR='F:\WWW\THUMCASH'

/* If you are running SRE-http with multiple hosts, you can also define
"host specific" versions of THUMBNAIL_DIR. For example, if you have
a  BOATS host, then you could define:
  THUMBNAIL_DIR.BOATS='f:\photos\boats\thumcash'
*/


  /* SRE-http users only:
     Enter the "selector" corresponding to thumbnail_dir.
     SRE-http users can leave this blank, in which case thumindx.cmd
     will determine it */
THUMBNAIL_DIR_SEL=''

/* Used in standalone mode only.
   This is the "root directory of your web"
   For example, 
     if WWW_DIR=E:\WWW
     then a http request for /hello.htm would refer to E:\WWW\hello.htm
*/
WWW_DIR='F:\WWW'

/* colors to use in rows of certain tables (1 3 5 ... and 2 4 6 ...   */
bgs.0='#bbccbb'
bgs.1="#ccdddd"

/* default "command file" (used in standalone mode */
default_cmdfile='thumindx.in'

 /* Enter name of directory that contain the GBM programs. 
   Note: GBM programs are used to create thumbnails directly from 
   a variety of graphics types. Leave blank to use the GoServe 
   working directory (this is where INSTALL.CMD will place them). */
gbm_dir=''

 /* alignment of images when using VIEW THUMBNAILS. Should be one of
     TOP MIDDLE or BOTTOM */
IMGALIGN='TOP'

 /* sentence to use in "link to list" (it can be added to imagemap-style indices
    Leave blank to use a default message. This placed between <a ..>  and </a> */
link_to_list=''

 /* sentence to use in "link to map" (it can be added to list-style indices
    Leave blank to use a default message. This placed between <a ..>  and </a> */
link_to_map=''

 /* sentence to use in "link to simple map" (it can be added to list-style indices
    Leave blank to use a default message. This is placed between <a ..>  and </a> */
link_to_map_simple=''

/* colors to use in top and work frames */
workcolor="#33bdbb"
topcolor="#cc88fa"

/* program string for displaying html output. Also used to display THUMINDX.TXT  */
vu_prog='NETSCAPE -l en '



/* default verbosity (standalone mode only). 0=not verbose...3=too verbose */
isverbose=0

/*END --- */

/* ********   END   user changable options         **********   */
/* ********   END   user changable options         **********   */


parse arg  ddir, tempfile, reqstrg,list,verb ,uri,user, ,
          basedir ,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname,homedir,aparam,semqueue,prog_file 

standalone=0
if verb="" then  standalone=1


call load_dlls

if standalone=1 then do /* get "batch" file */
  call get_batch
  isverbose=cmds.!verbose ; verbose=isverbose
  if CMDS.!LOCAL_TDIR<>'' then thumbnail_dir=cmds.!LOCAL_TDIR
end 
else do     /* got privs for this ? */
  if wordpos('SUPERUSER',translate(privset))+wordpos('THUMBNAIL',translate(privset))=0 then do
    'header add WWW-Authenticate: Basic Realm=<THUMB_INDEX>'  /* challenge */
    return sref_response('unauth', "You do not have ThumbIndex rights ",tempfile,servername)
  end 
  isverbose=verbose
end

if host_nickname<>'' then do
   if symbol('THUMBNAIL_DIR.'||host_nickname)='VAR' then do
        thumbnail_dir=thumbnail_dir.host_nickname
   end 
   if symbol('THUMBNAIL_DIR_SEL.'||host_nickname)='VAR' then do
        thumbnail_dir_sel=thumbnail_dir_sel.host_nickname
   end 
end 

if pos(':',thumbnail_dir)=0 then do            /* add drive letter? */
    foo=directory()
    thumbnail_dir=left(foo,2)||thumbnail_dir
end /* do */

/* IF standalone mode, go to standalone procedures */
if standalone=1 then do
   call do_standalone
   exit
end

/* IF here, called as srehttp addon */
if thumbnail_dir_sel='' then do
  oof=substr(thumbnail_dir,length(ddir))
  thumbnail_dir_sel=translate(oof,'/','\')
end /* do */


hophere:        /* jump here on next step, if in standalone mode */

if standalone=0 then do
  action=uri
  method=verb
  if  method="GET" then    parse var uri action '?' list   /* if srehttp addon, get purer version of request string */
end

opts.=''
crlf='0d0a'x

/* read the arguments from the client */
LIST1=LIST
do until list=""
   parse var list a1 '&' list
   parse var a1 avar '=' aval
   avar=strip(translate(avar)) 
   select
      when abbrev(avar,'LISTN')=1 then avar='LISTNAME'
      when abbrev(avar,'MAPN')=1 then avar='MAPNAME'
      when abbrev(avar,'SMAPN')=1 then avar='SMAPNAME'
      when abbrev(avar,'TOLIST')=1 then avar='TOLIST'
      when abbrev(avar,'TOMAP')=1 then avar='TOMAP'
      when abbrev(avar,'STEP')=1 then avar='STEP'
      when abbrev(avar,'BIGH')=1 then avar='BIGHEADER'
      when abbrev(avar,'BIGF')=1 then avar='BIGFOOTER'
      when abbrev(avar,'HEADERF')=1 then avar='HEADERFILE'
      when abbrev(avar,'OVERW')=1 then avar='OVERWRITE'
      when abbrev(avar,'DOSUB')=1 then avar='DOSUB'
      when abbrev(avar,'THUMBT')=1 then avar='THUMBTEXT'

      when abbrev(avar,'AUTOGIF')=1 then avar='AUTOGIF'
      when abbrev(avar,'INC')=1 then avar='INCLUSION'
      when abbrev(avar,'TSIZE')=1 then avar='TSIZE'
      when abbrev(avar,'DESC')=1 then avar='DESCRIP'
      when abbrev(avar,'SEL')=1 then avar='SEL'
      when abbrev(avar,'INC')=1 then avar='INDEX'
      when abbrev(avar,'VUDIR')=1 then avar='VUDIR'
      when abbrev(avar,'COMM')=1 then avar='COMMENT'
      when abbrev(avar,'FRAM')=1 then avar='FRAME'
      when abbrev(avar,'PREV')=1 then avar='PREVIEW'
      otherwise nop
   end
   avar='!'||avar
   select 
      when avar='!COMMENT' then do /* dont transform index comment */
       opts.avar=strip(aval)
      end
      when avar='!DESCRIP' | avar='!BIGHEADER' | avar='!BIGFOOTER'then do
        opts.avar=strip(decodekeyval(translate(aval,' ','+')))
      end
      when avar='!INCLUSION' then do
        aval=translate(strip(decodekeyval(translate(aval,' ','+'))))
        select
           when aval='JPG' then   opts.avar=opts.avar||' *.JPG *.JPEG '
           when aval='TIF' then   opts.avar=opts.avar||' *.TIF *.TIFF '
           when aval='BMP' then   opts.avar=opts.avar||' *.BMP '
           when aval='PNG' then   opts.avar=opts.avar||' *.PNG '
           when aval='GIF' then   opts.avar=opts.avar||' *.GIF '
           otherwise nop
        end
      end
      otherwise do
        opts.avar=translate(strip(decodekeyval(translate(aval,' ','+'))))
      end
   end
end 


/*  do as instructed ... */
select 
  when opts.!VUDIR=1 then do   /* create a popup window listing web directories */
     call make_dirlist
     f0=call writ_end()
     return f0
  end /* do */

  when opts.!preview=1 then do  /* simple listing of thumbnails & images */
       aa=writ_hdr('Previewing thumbnails',workcolor)
       theind=strip(translate(strip(opts.!index),'\','/'),,'\')
       cachedir=strip(strip(thumbnail_dir),,'\')
       theind=strip(translate(cachedir||'\'||theind))
       if right(theind,4)<>'.IND' then theind=theind||'.IND'
       aa=show_list_index(theind,,,,,2)       
       f0=call writ_end()
       return f0
  end 

  when  opts.!STEP=1 then  do  /* display thumbnail creation form */
    if opts.!frame="TOP" then do
       aa=writ_hdr('Step 1 -- Select a WWW directory',topcolor)
        call outit '  ...<a href="" onClick=" '
        call outit '  parent.WORK_FRAME.document.HERE1.HERE2.focus(); '
        call outit '   return false ;">or use an existing ThumbIndex database?</a>'
        f0=call writ_end()
       return f0
    end 

    if opts.!frame="WORK" then do 
       aa=writ_hdr('Step 1 -- Select a WWW directory',workcolor)  
       aa=step1_main()       
       f0=call writ_end()
       return f0
    end
    aa=writ_hdr('ERROR: no such Frame= 'opts.!frame)
    f0=call writ_end()
    return f0
  end

/* step 1.b -- create the thumbnails (given dir, etc. info */

  when  opts.!STEP='1B' then  do
    call do_step1b     /* call as subroutine, since lots of globals */
  end

  when  opts.!STEP='1A' then  do
       aa=writ_hdr('Step 1a -- Choose a ThumbIndex Database',workcolor)  
      call do_step1a     /* call as subroutine, since lots of globals */
    f0=call writ_end()
    return f0
  end

  when  opts.!STEP='1ANU' then  do
       aa=writ_hdr('Select a ThumbIndex Database',workcolor)  
      call do_step1anu    /* call as subroutine, since lots of globals */
    f0=call writ_end()
    return f0
  end

  when  opts.!STEP='1A2' then  do
      aa=writ_hdr('Step 1a2 -- ThumbIndex Database Chosen',workcolor)  
     call do_step1a2    /* call as subroutine, since lots of globals */
     f0=call writ_end()
     return f0
  end


  when  opts.!STEP=2 then  do
    if opts.!frame="TOP" then do
       aa=writ_hdr('Step 2 -- Add comments',topcolor)
       f0=call writ_end()
       return f0
    end 
    if opts.!frame="WORK" then do 
       aa=writ_hdr('Step 2 -- Add comments',workcolor)
       call outit '<script language="javascript">'
       call outit 'function open_viewers() {'

       call outit 'daVIEW1=window.open("","THUMB_VIEWER",',
                     '"location=NO,MENUBAR=NO,RESIZABLE,DEPENDENT,SCROLLBARS=YES,STATUS=NO,TITLEBAR,TOOLBAR=NO,SCREENX=12,SCREENY=30,height=74,width=74");'
       call outit 'daVIEW1.document.writeln("<head><title>Thumbnail viewer for Index Editor </title></head>");'
       call outit 'daVIEW1.document.writeln("<body>Thumbnails will <br>be displayed here</body>");'

       call outit 'daVIEW2=window.open("","FILE_VIEWER",',
                      '"location=NO,MENUBAR=NO,RESIZABLE,DEPENDENT,SCROLLBARS=YES,STATUS=NO,TITLEBAR,TOOLBAR=NO,SCREENX=212,SCREENY=30,height=274,width=274");'
       call outit 'daVIEW2.document.writeln("<head><title>File viewer for Index Editor </title></head>");'
       call outit 'daVIEW2.document.writeln("<body>Files will be displayed here</body>");'

       call outit 'foo2=window.moveTo(140,140);'
       call outit 'foo2=window.focus();'
       call outit '}'
       call outit 'function saywhat(ii,aa){'
       call outit 'var da1=aa.pathname.split(''/'');'
       call outit 'var da1a=da1[da1.length-1];'
       call outit 'if (ii==1) '
       call outit '{parent.TOP_FRAME.document.WHICHS.BIG.value=da1a}'
       call outit 'else '
       call outit '{parent.TOP_FRAME.document.WHICHS.LITTLE.value=da1a}'
       call outit 'return true}'

       call outit '</script>'
       call outit '<a href="" '
       call outit ' onClick="open_viewers() ; return false ">'
       call outit '<em>Open viewer windows?</em></a>'

       aa=step2_main()       
       f0=call writ_end()
       return f0
    end
    aa=writ_hdr('ERROR: no such Frame= 'opts.!frame)
    f0=call writ_end()
    return f0
  end

  when  opts.!STEP='2B' then  do
       aa=writ_hdr('Step 2B -- Descriptions were changed/added',workcolor)
       call step2_2
    f0=call writ_end()
    return f0
  end  

  when  opts.!STEP=3 then  do           /* write the indices */
    if opts.!frame="TOP" then do
       aa=writ_hdr('Step 3: Create HTML thumbnail-indices',topcolor)
       f0=call writ_end()
       return f0
    end 

    if opts.!frame="WORK" then do 
       aa=writ_hdr('Create HTML thumbnail-indices',workcolor)
       aa=step3_main()       
       f0=call writ_end()
       return f0
    end
    aa=writ_hdr('ERROR: no such Frame= 'opts.!frame)
    f0=call writ_end()
    return f0
  end

  when  opts.!STEP='3B' then  do        /*write the indices */
       aa=writ_hdr('Step 3B -- Indices were written',workcolor)
       theind=step3_2()
       if theind<>0 & (opts.!mapname<>'0' & opts.!mapname<>'')then do 
          foo=stream(theind,'c','close')
          foo=step3_2b(theind)
       end
       if theind<>0 & (opts.!Smapname<>'0' & opts.!Smapname<>'')then do 
          foo=stream(theind,'c','close')
          foo=step3_2b(theind,1)
       end

       call outit '<script language="javascript">'
       CALL outit '    parent.TOP_FRAME.document.open(''text/html'');'
       call outit '    parent.TOP_FRAME.document.writeln(',
              ' ''<body bgcolor='||topcolor||'> '');'
       call outit '    parent.TOP_FRAME.document.writeln(',
         ' ''<h3 align='center'>Indices successfully created!</h3>'');'
       call outit '    parent.TOP_FRAME.document.writeln( ', 
         '  ''You can now create another set of indices (just hit the '');'
       call outit '    parent.TOP_FRAME.document.writeln(',
     ' ''<a href="" onClick="parent.SIDE_FRAME.document.THUM_ACTION.T2.focus() ',
                ';return false " '');'
       call outit '    parent.TOP_FRAME.document.writeln( ',
              '  ''>Create Thumbnails</a> button)'');'
       call outit "    parent.TOP_FRAME.document.writeln('",
                  '<form name="INFO" method="GET" action=""> '') ;'
       call outit "   parent.TOP_FRAME.document.writeln('",
        '<input type="hidden" name="INDEX" value="'||opts.!Index||'" >'' ); '

       call outit '    parent.TOP_FRAME.document.writeln( ',
              '  '' </body></html> '');'
       call outit '    parent.TOP_FRAME.document.close() ;'
       call outit '</script>'

       call outit '<script language="javascript">'
       CALL outit '    parent.SIDE_FRAME.document.THUM_ACTION.STATUS.value=',
                  '"Indices created!" ;'
       call outit '</script>'

       f0=call writ_end()
       return f0
  end  

  otherwise
   say "no such step "opts.!step
end
return 0


/*******/
/* write an html document header info */
writ_hdr:procedure expose tempfile gls. cmds. standalone 
parse arg ahdr,acolor
call lineout tempfile,'<!DOCTYPE HTML PUBLIC "-//W3 Organization//DTD W3 HTML 3.2//EN">'
call lineout tempfile,'<HTML>'
call lineout tempfile,'<HEAD>'
call lineout tempfile,'<TITLE>ThumbIndex. 'ahdr'</TITLE>'
call lineout tempfile,'</HEAD>'
call lineout tempfile,'<BODY bgcolor="'||acolor||'">'
call lineout tempfile,'<H3>'ahdr'</H3>'
return 1

/********/
/* finalize html document, and send to client */
writ_end:procedure expose tempfile gls.  standalone 
call lineout tempfile,'</body>'
call lineout tempfile,'</html>'
call lineout tempfile
aa=stream(tempfile,'c','query size')
call gofile 'FILE ERASE type text/html name '||tempfile 
aa=stream(tempfile,'c','query size')
return 200' '||aa

/***********/
/* step 3 for main frame */
step3_main:procedure expose opts. thumbnail_dir tempfile thumbnail_dir_sel gls. ddir ,
     imgalign uri is_cgi tdcs. dasel topcolor crlf bgs. cmds.  standalone  enmadd homedir host_nickname

cachename=cvt_cachename(opts.!index)

theind=strip(translate(strip(cachename),'\','/'),,'\')
cachedir=strip(strip(thumbnail_dir),,'\')
theind=cachedir||'\'||theind
foo=stream(theind,'c','query exists')

if foo='' then do
 call outit '<P><B>ERROR</B>: No such ThumbIndex database: 'opts.!index 
 return 0
end 

afoo=linein(theind) 
if afoo="" then do
    call outit 'Unable to read index file (1): 'opts.!index'(try again later) '
    return 0
end 
parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .

/* is there a SNPS subdirectory (with snapshots in it? */
fsel=strip(dasel,,'/')||'/foo.1'
dadir=sref_do_virtual(ddir,fsel,enmadd,0,transaction,homedir,host_nickname)

arf=strip(filespec('d',dadir)||filespec('p',dadir),,'\')||'\SNPS'
arf2=dosisdir(arf)


call outit '<form name="FORM3" action="/THUMINDX.CMD" method="GET">'

/* call outit '<form name="BOO" >' */
call outit '<input type="CHECKBOX" name="GETPRIOR"'
call outit 'onClick=" '
call outit 'self.document.FORM3.MAPNAME.value=parent.SIDE_FRAME.document.BINFO.MAPNAME.value;'
call outit 'self.document.FORM3.SMAPNAME.value=parent.SIDE_FRAME.document.BINFO.SMAPNAME.value;'
call outit 'self.document.FORM3.LISTNAME.value=parent.SIDE_FRAME.document.BINFO.LISTNAME.value;'
call outit 'self.document.FORM3.BIGHEADER.value=parent.SIDE_FRAME.document.BINFO.BIGHEADER.value;'
call outit 'self.document.FORM3.BIGFOOTER.value=parent.SIDE_FRAME.document.BINFO.BIGFOOTER.value;'
call outit 'iarf=parent.SIDE_FRAME.document.BINFO.THUMBTEXT.value ;'
call outit 'self.document.FORM3.THUMBTEXT.options[iarf].selected=true;'

call outit 'self.document.FORM3.GETPRIOR.checked=false ; return true"><font size=-1>Retrieve prior values</font>'

call outit '<input type="SUBMIT" value="Make the indices"'
call outit 'onClick=" '
call outit 'parent.SIDE_FRAME.document.BINFO.MAPNAME.value=self.document.FORM3.MAPNAME.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.SMAPNAME.value=self.document.FORM3.SMAPNAME.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.LISTNAME.value=self.document.FORM3.LISTNAME.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.BIGHEADER.value=self.document.FORM3.BIGHEADER.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.BIGFOOTER.value=self.document.FORM3.BIGFOOTER.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.THUMBTEXT.value=self.document.FORM3.THUMBTEXT.selectedIndex;"'
call outit '<input type="RESET" value="Reset to defaults">'


call outit '<input type="hidden" name="INDEX" value="'||opts.!index||'">'
call outit '<input type="hidden" name="STEP" value="3B">'

call outit '<table>'
call outit '<tr bgcolor="'||bgs.0||'">'
call outit '<td>Name of file to use for <em>javascript enhanced client-side imagemap</em> thumbnail index </td>'
call outit '<td><input type="text" size=20 name="MAPNAME" value="index.htm"> </td>'

call outit '<tr bgcolor="'||bgs.0||'">'
call outit '<td>Name of file to use for <em>simple client-side imagemap</em> thumbnail index </td>'
call outit '<td><input type="text" size=20 name="SMAPNAME" value="index1.htm"> </td>'

call outit '<tr bgcolor="'||bgs.1||'">'
call outit '<td>Name of file to use for <em>linear list</em> thumbnail index </td>'
call outit '<td><input type="text" name="LISTNAME" size=20 value="index2.htm"> </td>'

call outit '<tr><td> Select the text to put under each thumbnail '
call outit '<td><select name="THUMBTEXT"  size=2>'
call outit '<option selected value="!NONE">None'
call outit '<option value="!DATE">Date'
call outit '<option value="!SIZE">Width x Height'
call outit '<option value="!NAME">Image name'
call outit '</select>'

if arf2=1 then
  call outit '<tr> <td colspan=2><INPUT TYPE="CHECKBOX" NAME="makesnap" VALUE="1"  CHECKED> Enable display of <em>VGA</em> snapshots</td>'
else
  call outit '<tr><td colspan=2><em>Note: vga snapshot directory not detected</em></td>'
call outit '</table>'

call outit '<table border=1>'

call outit '<tr><td><font size=-1>'
call outit '<br><b>*</b> leave blank to use default </td>'
call outit '<td>Enter header info <tt>(you can use several '
call outit '<a href="#codes"> '
call outit '$code</a> substitutions) '
call outit ' </tt> </em><br>'
call outit ' <textarea name="BIGHEADER" cols=50 rows=4> </textarea>'

call outit '<tr><td><font size=-1>'
call outit '<br><b>*</b> leave blank to use default </td>'
call outit '<td>Enter footer info <tt>(you can use several '
call outit '<a href="#codes"> '
call outit '$code</a> substitutions) '
call outit ' </tt> </em><br>'
call outit ' <textarea name="BIGFOOTER" cols=50 rows=4> </textarea>'
call outit '</table>'
call outit '<input type="SUBMIT" value="Make the indices"'
call outit 'onClick=" '
call outit 'parent.SIDE_FRAME.document.BINFO.MAPNAME.value=self.document.FORM3.MAPNAME.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.SMAPNAME.value=self.document.FORM3.SMAPNAME.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.LISTNAME.value=self.document.FORM3.LISTNAME.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.BIGHEADER.value=self.document.FORM3.BIGHEADER.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.BIGFOOTER.value=self.document.FORM3.BIGFOOTER.value;'
call outit 'parent.SIDE_FRAME.document.BINFO.THUMBTEXT.value=self.document.FORM3.THUMBTEXT.selectedIndex;"'
call outit '<input type="RESET" value="Reset to defaults">'
call outit '</form>'

call outit '  <hr><a name="codes"><h4>$CODE substitutions</h4></a>  '
call outit ' In both headers and footers, the following codes are replaced'
call outit ' (codes start with a $ sign, and must NOT contain spaces).'

cdir=translate(cachedir,'/','\')
call outit '<menu> '
call outit '<li> <b>$BOTTOM</b> : jump to bottom of screen   '
tt=dosfileinfo(theind,'W')
call outit '<li> <b>$CREATION</b> : the database creation date <tt>('tt')</tt>  '
dd=left(adesc,min(length(adesc),30))
if length(dd)<>length(adesc) then dd=dd||' ...'
call outit '<li> <b>$DESC</b> : the "database" description   <tt>('dd')</tt>'    
call outit '<li> <b>$DATE</b> : today''s date <tt>('||date('n')||')</tt>   '
call outit '<li> <b>$DIR</b> :  the WWW directory the database contains thumbnails for <tt>('dasel')</tt>    '

call outit '<li> <b>$FILE=filename</b> : insert a file<br><font size=-1>(filename is relative to 'cdir '</font> '
call outit '<br> The inserted contents will ALSO be subject to $CODE replacement (but only one <TT>$FILE=</TT> replacement per footer or per header)'
call outit ' <li><b>$LINK_OTHER</b> : a link to the "other" indices '
call outit '<em>(for example, in index.sht, include a link to both index1.sht and index2.sht)</em>'
call outit '<li> <b>$NUM</b> :  the number of thumbnails contained in this database <tt>('numrec')</tt>'   
call outit '<li> <b>$RESIZE</b> : include a <em>resize images</em> option (used only in the regunar imagemap index; it is NOT used in the simple imagemap index) '   
call outit '<li> <b>$TIME</b> : current time <tt>('||time('n')||')</tt>   '
call outit '<li> <b>$TOP</b> : jump to top of screen   '

call outit '<script language="javascript">'
CALL outit '    parent.TOP_FRAME.document.open(''text/html'');'
call outit '    parent.TOP_FRAME.document.writeln(''<body bgcolor='||topcolor||'> '');'
call outit '    parent.TOP_FRAME.document.writeln(''<h3 align='center'>Specify index files...</h3>'');'
call outit '    parent.TOP_FRAME.document.writeln('' <p>The index files will be written to <tt>'dasel'.</tt> '' );'
call outit '    parent.TOP_FRAME.document.writeln('' To suppress creation of one of the index files, leave it`s field blank '');'
adesc0=translate(adesc,'`',"'")
call outit '    parent.TOP_FRAME.document.writeln('' <p><b>Notes:</b><menu compact><li><em> # of thumbnails</em> ='numrec'<li><em> Description=</em><tt>'adesc0' </tt>   '');'
call outit '    parent.TOP_FRAME.document.writeln('' <li><em>Reminder:</em><tt><b> index files are HTML documents that use thumbnails to link to your images</tt></b>.  '' );'
call outit '    parent.TOP_FRAME.document.writeln('' </menu> '');'
call outit '    parent.TOP_FRAME.document.writeln(''<form name="INFO" method="GET" action=""> '') ;'||crlf
call outit '    parent.TOP_FRAME.document.writeln(''<input type="hidden" name="INDEX" value="'||opts.!Index||'" >'' ); '||crlf
call outit '    parent.TOP_FRAME.document.writeln(''</form>'' );'
call outit '    parent.TOP_FRAME.document.writeln('' </body></html> '');'
call outit '    parent.TOP_FRAME.document.close() ;'

call outit '</script>'

return 1

/*************************************/
/* write list index */
step3_2:procedure expose opts. thumbnail_dir tempfile thumbnail_dir_sel gls. cmds. ,
     imgalign uri is_cgi tdcs. dasel list1 bgs. servername  crlf bold normal  standalone  ,
     link_to_list link_to_map_simple link_to_map  enmadd ddir transaction homedir host_nickname 

if gls.!standalone=1 then do
  indxfile=gls.!indxfile
  theind=gls.!thumind
  afoo=gls.!line1
  parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .
  gls.!dasel=dasel
  cachedir=gls.!thumcash
  resize_thing=''
  opts.!bigheader=cmds.!header
  opts.!bigfooter=cmds.!footer
  opts.!mapname=cmds.!mapname
  opts.!smapname=cmds.!smapname
  signal stand1
end

cachename=cvt_cachename(opts.!index)

theind=strip(translate(strip(cachename),'\','/'),,'\')
cachedir=strip(strip(thumbnail_dir),,'\')
theind=cachedir||'\'||theind
foo=stream(theind,'c','query exists')

if foo='' then do
 call outit '<P><B>ERROR</B>: no such ThumbIndex database: 'opts.!index
 return 0
end 

resize_thing=''         /* no "resize" option in list index */
                        /* since this is NOT exposed, setting = '' does NOT
                           zap the global value ! */
afoo=linein(theind) 
if afoo="" then do
    call outit 'Unable to read index file (2): 'opts.!index'(try again later) '
    return 0
end 
parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .

/* if no linear index, then return (retaining values of theind and other globals
   that were set above */
if opts.!listname=0 | opts.!listname='' then return theind

sel_1=strip(translate(opts.!listname,'/','\'))
if  abbrev(sel_1,'/')=0 then 
   sel_1=strip(dasel,,'/')||'/'||sel_1
indxfile=sref_do_virtual(ddir,sel_1,enmadd,0,transaction,homedir,host_nickname)

if stream(indxfile,'c','query exists')<>'' then do       /* rename preexisting */
  parse var indxfile ttfile '.' .
  ttfile=dostempname(ttfile||'.???')
  foo=dosrename(indxfile,ttfile)
  if foo=0 then do
     call outit '<P><B>ERROR</B>:  Unable to rename old index file 'indxfile
     return 0
  end
end

stand1: nop        /* ------------- jump here if standalone mode */

tempfile_temp=tempfile           /* start writing to index file */
tempfile=indxfile

/* fix client supplied  header, or use a default */
bigh=opts.!bigheader
if link_to_map='' then link_to_map='Compressed view (as java script enhanced imagemap)?'
if link_to_map_simple='' then link_to_map_simple='Compressed view (as a simple imagemap)?'

if bigh=0 | bigh=' ' then do
   bigh='<hr width=40%> <a name="top"><h2>Thumbnails of files in 'dasel '</h2></a>'
   bigh=bigh||crlf||'<blockquote>'adesc'</blockquote>'
end
else do
   bigh=fix_header(bigh,adesc,dasel,numrec,theind,opts.!mapname,link_to_map,opts.!smapname,link_to_map_simple)
end

/* check for <HTML> in header. If not there, add one to beginning */
if pos('<HTML',translate(bigh))=0 then do
    bigh='<html><head><title>Index of 'dasel'</title></head><body><a name="top">&nbsp;</a>'||bigh
end 
else do         /* add top name */
   if pos('"TOP"',translate(bigh))=0 then bigh=bigh||'<a name="top">&nbsp;</a>'
end 

/* fix client supplied footer */
bigf=opts.!bigfooter
if bigf=0 then
   bigf=' '
else
   bigf=fix_header(opts.!bigfooter,adesc,dasel,numrec,theind,opts.!mapname,link_to_map,opts.!smapname,link_to_map_simple)

aa=show_list_index(theind,bigh,bigf,afoo,0)       /*** MAKE IT!!! */

call outit '<a name="bottom">&nbsp;</a></body></html>'
call lineout tempfile           /* close index file */
foo=stream(tempfile,'c','query size')
if gls.!standalone=1 then do
  say bold||foo ' bytes written to 'normal||tempfile
end
else do
  tempfile=tempfile_Temp
  call outit '<dl>'
  call outit '<dt>'foo ' bytes written to 'sel_1
  call outit '<dd>Would you like to <a href="'sel_1'" target="viewer">view this index</a>?'
  call outit '</dl>'
end

return theind


/*************************************/
/* write clientside imagemap */
step3_2b:procedure expose opts. cmds. thumbnail_dir tempfile thumbnail_dir_sel gls. ,
     imgalign uri is_cgi tdcs. dasel list1 bgs. servername  crlf bold normal ,
     link_to_list link_to_map_simple link_to_map  enmadd ddir transaction homedir host_nickname ,
     resize_thing  standalone 

parse arg theind,simplemap

if gls.!standalone=1 then do
  indxfile=gls.!indxfile
  theind=gls.!thumind
  afoo=gls.!line1
  parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .
  gls.!dasel=dasel
  cachedir=gls.!thumcash
  opts.!bigheader=cmds.!header
  opts.!bigfooter=cmds.!footer
  opts.!mapname=cmds.!mapname
  opts.!smapname=cmds.!smapname
  opts.!listname=cmds.!listname
  signal stand2
end


amapname=opts.!mapname
if simplemap=1 then amapname=opts.!smapname

afoo=linein(theind) 
cachedir=strip(strip(thumbnail_dir),,'\')

if afoo="" then do
    call outit 'Unable to read index file (3): 'opts.!index'(try again later) '
    return 0
end 
parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .

sel_1=strip(translate(amapname,'/','\'))
if  abbrev(sel_1,'/')=0 then 
   sel_1=strip(dasel,,'/')||'/'||sel_1
indxfile=sref_do_virtual(ddir,sel_1,enmadd,0,transaction,homedir,host_nickname)
if stream(indxfile,'c','query exists')<>'' then do       /* rename preexisting */
  parse var indxfile ttfile '.' .
  ttfile=dostempname(ttfile||'.???')
  foo=dosrename(indxfile,ttfile)
  if foo=0 then do
     call outit '<P><B>ERROR</B>:  Unable to rename old index file 'indxfile
     return 0
  end
end

stand2: nop        /* ------------- jump here if standalone mode */

tempfile_temp=tempfile           /* start writiing to index file */
tempfile=indxfile

/* fix client supplied  header, or use a default */
bigh=opts.!bigheader
if link_to_list='' then link_to_list='Expanded view (as a list)?'

if simplemap=1 then do
   othermap=opts.!mapname
   othermap_text=link_to_map
   if othermap_text='' then othermap_text='Compressed view (as java script enhanced imagemap)?'
end
else do
   othermap=opts.!smapname
   othermap_text=link_to_map_simple
   if othermap_text='' then othermap_text='Compressed view (as a simple imagemap)?'
end

if bigh=0 | bigh=' ' then do
   bigh='<hr width=40%> <a name="top"><h2>Thumbnails of files in 'dasel '</h2></a>'
   bigh=bigh||crlf||'<blockquote>'adesc'</blockquote>'
end
else do
   bigh=fix_header(bigh,adesc,dasel,numrec,theind,opts.!listname,link_to_list,othermap,othermap_text)
end

/* check for <HTML> in header. If not there, add one to beginning */
if pos('<HTML',translate(bigh))=0 then do
    bigh='<html><head><title>Imagemap of images in 'dasel'</title></head><body><a name="top">&nbsp;</a>'||bigh
end 
else do
   if pos('"TOP"',translate(bigh))=0 then bigh=bigh||'<a name="top">&nbsp;</a>'
end 

/* fix client supplied footer */

if simplemap=1 then resize_thing=' '   /* simple bigfooter */

bigf=opts.!bigfooter
if bigf=0 then 
  bigf='<a name="bottom">&nbsp;</a> '
else
  bigf=fix_header(opts.!bigfooter,adesc,dasel,numrec,theind,opts.!listname,link_to_list,othermap,othermap_text)

if simplemap=1 then
  aa=show_list_index(theind,bigh,bigf,afoo,2)       /*** MAKE IT!!! */
else
  aa=show_list_index(theind,bigh,bigf,afoo,1)       /*** MAKE IT!!! */

call outit '<a name="bottom">&nbsp;</a></body></html>'

call lineout tempfile           /* close index file */
foo=stream(tempfile,'c','query size')

if gls.!standalone=1 then do
   say bold||foo ' bytes written to 'normal||tempfile
   foo=stream(theind,'c','close')
   return 1
end

tempfile=tempfile_Temp
call outit '<dl><dt>'foo ' bytes written to 'sel_1
if simplemap=1 then
  call outit '<dd>Would you like to <a href="'sel_1'" target="viewer">view this imagemap index</a>?'
else
  call outit '<dd>Would you like to <a href="'sel_1'" target="viewer">view this javascript enhanced imagemap index</a>?'

call outit '</dl>'


foo=stream(theind,'c','close')
return 1



/************/
/* fix a header or footer (do $code replacement ) */
fix_header:procedure expose servername cachedir crlf resize_thing gls.  standalone 
parse arg bigh,adesc,dasel,nrec,ifile,other,othertext,other2,othertext2
tbigh=translate(bigh)
bigh=translate(bigh,' ','0d0a0900'x)
if pos('$FILE=',tbigh)>0 then do         /* replace with contents of $FILE=filename */
   i=1
   newbigh=''
   do forever
      tbigh=translate(bigh)
      ii=pos('$FILE=',tbigh)
      if ii=0 then do
         bigh=newbigh||bigh
         leave
      end 
/* if here, found a $FILE */
      if ii>1 then newbigh=newbigh||left(bigh,ii-i)
      bigh=substr(bigh,ii+6)
      parse var bigh filename bigh         /* next word is filename */
      afile=cachedir'\'||strip(translate(strip(filename),'\','/'),,'\')
      zz=stream(afile,'c','query size')
      if zz='' then do
         newbigh=newbigh||' <!-- Error: `header` file does not exist: 'afile ' --> '
      end 
      else do
         goo=stream(afile,'c','open read')   
         if abbrev(translate(strip(goo)),'READY')<>1 then do
            newbigh=newbigh||' <!-- Error: `header` file not readable: 'filename ' --> '        
         end
         else do
            aa=charin(afile,1,zz)
            newbigh=newbigh||aa
            goo=stream(afile,'c','close')
        end
     end                        /* 0 size */
   end                  /* parsing */
end                     /* $file found */
/* now substitute dynamic stuff */
if bigh<>'' & bigh<>0 then  do
   bigh=replacestrg(bigh,'$DESC',adesc,'ALL')
   bigh=replacestrg(bigh,'$TOP','<a href="#top">Top</a>','ALL')
   bigh=replacestrg(bigh,'$BOTTOM','<a href="#bottom">Bottom</a>','ALL')

   bigh=replacestrg(bigh,'$DESC',adesc,'ALL')

   bigh=replacestrg(bigh,'$DIR',dasel,'ALL')
   bigh=replacestrg(bigh,'$NUM',nrec,'ALL')
   bigh=replacestrg(bigh,'$RESIZE',resize_thing,'ALL')
   bigh=replacestrg(bigh,'$DATE',date('n'),'ALL')
   bigh=replacestrg(bigh,'$TIME',time('n'),'ALL')
   bigh=replacestrg(bigh,'$SERVER',servername,'ALL')
   if pos('$CREATION',translate(bigh))>0 then do
     tt=dosfileinfo(ifile,'W')
     bigh=replacestrg(bigh,'$CREATION',tt,'ALL')
   end
   if pos('$LINK_OTHER',translate(bigh))>0 & (other2<>'' | other<>'') then do
       tt=''
       if other<>"" then
          tt=tt||' <a href="'||other||'">'||othertext||'</a><br>'
       if other2<>'' then
          tt=tt||' <a href="'||other2||'">'||othertext2||'</a>'
       bigh=replacestrg(bigh,'$LINK_OTHER',tt,'ALL')
   end
end                    /* bigh exists */
return bigh

/***********/
/* step 2 for main frame */
step2_main:procedure expose opts. thumbnail_dir tempfile thumbnail_dir_sel gls. ,
     imgalign uri is_cgi tdcs. dasel topcolor crlf cmds. ,
     enmadd ddir transaction homedir host_nickname bgs. standalone 

cachedir=strip(strip(thumbnail_dir),,'\')
a0=strip(translate(strip(thumbnail_dir_sel),'/','\'),,'/')
if pos(':',opts.!Index)=0 then do  /*it's a selector */
  selind=opts.!Index
  theind=cachedir||'\'||strip(translate(selind,'\','/'),,'\')
  indexb=substr(selind,2)
end 
else do
  theind=translate(strip(opts.!index),'\','/')
  nnc=length(strip(strip(thumbnail_dir),'t','\'))
  selind=substr(opts.!index,nnc+1)
  indexb=substr(opts.!index,nnc+2)
end
afoo=linein(theind) 
if afoo="" then do
    call outit 'Unable to read index file (4): 'theind '(try again later) '
    return 0
end 

parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .
call outit ' '

call outit '<!-- ========== ' dasel' ============= -->'
call outit '<hr width=40%> <h3>Thumbnails of files in 'dasel '</h3>'

call outit  '<Form method='POST' action="/THUMINDX.CMD" name="DO_DESC">'
call outit '<input type="hidden" name="STEP" value="2B">'
call outit '<input type="hidden" name="INDEX" value="'INDEXb'">'

call outit '<table bgcolor="#bbccbb" ><tr><td><em>Index Description<em>:</td>'
call outit '<td><input type="text" name="DESC" value="'adesc'" size=40></td></table>'
call outit '<!--  Total of 'numrec ' thumbnails -->'
call outit '<!-- using the 'theind 'thumbnail-index -->'


call outit '<Ol> '
ifnd=0
do mm=1 to numrec
     aa=linein(theind)
     parse var aa filename cachename . amess ; filename=strip(filename)

     cachename=cvt_cachename(cachename)
     parse value cvt_filename(filename,dasel,cshlen) with filename selname

     if stream(filename,'c','query exists')='' then iterate

     ifnd=ifnd+1
     a1=a0||'/'||strip(cachename,,'/')
     alink7='<a href="'selname'" target="FILE_VIEWER" onClick="saywhat(1,this);return true">'selname'</a>'
     alink8=' (<a href="'a1'" target="THUMB_VIEWER" onClick="saywhat(0,this);return true">thumbnail</a>)'

     cmess=strip(subword(amess,2))
     call outit '<li> 'alink7 ||alink8'<br> <em>First description:</em><tt> '||word(amess,1)||'</tt>'
     call outit '<br><table><tr><td><em>2nd description:</em></td> '

     adesc2=replacestrg(cmess,'&','&amp;','ALL')
     adesc2=replacestrg(adesc2,'<','&lt;','ALL')
     adesc2=replacestrg(adesc2,'>','&gt;','ALL')
     adesc2=replacestrg(adesc2,'"','&quot;','ALL')
     call outit '<td><textarea cols=50 rows=2 name="LINEDESC.'||mm||'">'||adesc2||'</textarea></td></table>'

end          /* get next entry in index_list */

call outit '</ol>'

call outit ' <input type="submit" name="CHANGE1" '
call outit '          value="Change descriptions"'
call outit '      onClick="daVIEW1.close() ; daVIEW2.close(); return true "'
call outit '>'
call outit '<input type="reset" value="Reset"></form>'

call outit '<script language="javascript">'
CALL outit '    parent.TOP_FRAME.document.open(''text/html'');'
call outit '    parent.TOP_FRAME.document.writeln(''<body bgcolor='||topcolor||'> '');'
call outit '    parent.TOP_FRAME.document.writeln(''<center><b>Change/add descriptions ..</b></center>'');'
call outit '    parent.TOP_FRAME.document.writeln('' <form NAME="WHICHS"> '');'
call outit '    parent.TOP_FRAME.document.writeln('' <table> '');'

call outit '    parent.TOP_FRAME.document.writeln(''<tr valign="TOP"><td bgcolor='bgs.0'> Little <br>viewer:<td bgcolor='bgs.0'><input type="text" NAME="LITTLE" value="none chosen"> '');'
call outit '    parent.TOP_FRAME.document.writeln('' <td bgcolor='bgs.1'>Big<br>viewer:<td bgcolor='bgs.1'><input type="text" NAME="BIG" value="none chosen"> '');'
call outit '    parent.TOP_FRAME.document.writeln('' </form> '');'

call outit '    parent.TOP_FRAME.document.writeln(''<td> <a href="" onClick=" '');'
call outit '    parent.TOP_FRAME.document.writeln(''  parent.WORK_FRAME.document.DO_DESC.CHANGE1.focus(); '');'
call outit '    parent.TOP_FRAME.document.writeln('' return false ;">Ready to change descriptions?</a><br> '');'
call outit '    parent.TOP_FRAME.document.writeln('' </table> '');'

call outit '    parent.TOP_FRAME.document.writeln(''<br> Note: descriptions are in ThumbIndex database <tt>'||selind||'</tt> '' );'
call outit '    parent.TOP_FRAME.document.writeln(''<form name="INFO" method="GET" action=""> '') ;'||crlf
call outit '    parent.TOP_FRAME.document.writeln(''<input type="hidden" name="INDEX" value="'||opts.!Index||'" >'' ); '||crlf
call outit '    parent.TOP_FRAME.document.writeln(''</form>'' );'

call outit '    parent.TOP_FRAME.document.writeln('' </body></html> '');'
call outit '    parent.TOP_FRAME.document.close() ;'
 call outit '</script>'
   return 1


/*************************************/
/* save new comments to a thumbnail index */
step2_2:procedure expose opts. thumbnail_dir tempfile thumbnail_dir_sel gls. ,
     imgalign uri is_cgi tdcs. dasel list1 bgs. cmds.  ,
     enmadd ddir transaction homedir host_nickname  standalone 

theind=''
linedesc.=''
/* parse out the linedesc. arguments */
DO UNTIL LIST1=''
   parse var list1 a1 '&' list1
   PARSE VAR a1 avar '=' aval
   Avar=translate(STRIP(Avar))
   Aval=strip(decodekeyval(translate(aval,' ','+')))
   if abbrev(avar,'LINEDESC.')=1 & aval<>'' then do
      parse var avar . '.' nth
      linedesc.nth=aval
   end 
end  

cachedir=strip(strip(thumbnail_dir),,'\')
theind=translate(cachedir||'\'||strip(opts.!index),'\','/')

afoo=linein(theind) 
if afoo="" then do
    call outit '<tt>Unable to read index file (5)</tt>: 'theind '(try again later) '
    return 0
end 
crlf='0d0a'x
parse  var afoo reclen numrec idlen cshlen dasel awid aht woogie '/#/' adesc '/#/' gooba
bigstring=''
ichanged=0
if opts.!descrip='' | strip(opts.!descrip)=strip(adesc) then do
   bigstring=afoo||crlf
end 
else do
   bigstring=reclen' 'numrec' 'idlen' 'cshlen' 'dasel' 'awid' 'aht' 'woogie' /#/'||opts.!descrip||'/#/ '||gooba||crlf
   call outit '<b>New general description</b>:<tt>'opts.!descrip'</tt><p>' 
   ichanged=1
end 

call outit '# Items in 'opts.!index' = <tt>'numrec'</tt>'
call outit '<table>'
ifnd=0
do ii=1 to numrec
    aa=linein(theind)

   if linedesc.ii='' then do
       bigstring=bigstring||aa||crlf
       iterate
   end 
   parse var aa filename cachename dw mess1 amess ; filename=strip(filename)
   cachename=cvt_cachename(cachename)
   parse value cvt_filename(filename,dasel,cshlen) with filename selname

   if stream(filename,'c','query exists')='' then do
        call outit '<tr><td><tt>Warning. No such file</td><td>:</tt>'filename'</td>'
        bigstring=bigstring||aa||crlf
        iterate
   end 
   linedesc.ii=strip(translate(linedesc.ii,' ','0d0a0009'x))

   if linedesc.ii=strip(amess) then do
       bigstring=bigstring||aa||crlf
       iterate
   end
   ichanged=ichanged+1
   ifnd=1-ifnd

   call outit '<tr bgcolor="'bgs.ifnd'"><td>#'ii': <tt>'selname'</tt></td> '
   call outit '<td>: <em>'amess'</em><hr width="20%"> 'linedesc.ii'</td>'
   bigstring=bigstring||selname' 'cachename' 'dw' 'mess1' '||linedesc.ii||crlf

end 
call outit '</table>'

/* if ichanged=0 then do
        call outit '<p><B>No changes to</b><tt> 'opts.!index'</tt>'
        call outit '<p><a href="javascript:history.go(-1)">Back.. </a>'
        return 1
end */ 

parse var theind ttfile '.' .
ttfile=dostempname(ttfile||'.???')
foo=stream(theind,'c','close')
foo=dosrename(theind,ttfile)
if foo=0 then do
   call outit '<p><b>ERROR:</b> unable to rename old index file 'theind
   call outit '       to 'ttfile
   return 0
end
/* call outit '<p>Old index file renamed to <tt>'ttfile'</tt>' */

foo=stream(theind,'c','open write')
if abbrev(translate(foo),'READY')<>1 then do
  call outit '<p><b>Error</b>: Unable to write new contents of index file 'theind
  return
end
foo=charout(theind,bigstring,1)
if foo<>0 then do
   call outit '<p><b>Warning:</b> 'foo' bytes not written to 'theind
end 
else do
    if ichanged=0 then do
        call outit '<br>No changes were made to the ThumbIndex database'
    end 
    else do
       call outit '<p>Success changing ThumbIndex database' 
    end
end 
foo=stream(theind,'c','close')


call outit '<p><a href="javascript:history.go(-1)">Back.. </a>'

call outit '<script language="javascript">'
CALL outit '    parent.TOP_FRAME.document.open(''text/html'');'
call outit '    parent.TOP_FRAME.document.writeln(''<body bgcolor='||topcolor||'> '');'
call outit '    parent.TOP_FRAME.document.writeln(''<h3 align='center'>Descriptions have been changed</h3>'');'
call outit '    parent.TOP_FRAME.document.writeln(''<b>Step 2 completed succesfully.</b>'');'||crlf
call outit '    parent.TOP_FRAME.document.writeln(''You can now proceed to Step 3 (Write indices)</b><p>'');'||crlf

call outit '    parent.TOP_FRAME.document.writeln('' '||ichanged||' changes in ThumbIndex database <tt>'||opts.!Index||'</tt> '' );'
call outit '    parent.TOP_FRAME.document.writeln(''<form name="INFO" method="GET" action=""> '') ;'||crlf
call outit '    parent.TOP_FRAME.document.writeln(''<input type="hidden" name="INDEX" value="'||opts.!Index||'" >'' ); '||crlf
call outit '    parent.TOP_FRAME.document.writeln(''</form>'' );'

call outit '    parent.TOP_FRAME.document.writeln(''  '');'
call outit '    parent.TOP_FRAME.document.writeln(''  '');'
call outit '    parent.TOP_FRAME.document.writeln('' </body></html> '');'

call outit '    parent.TOP_FRAME.document.close() ;'
call outit '</script>'

return 1


/***********/
/* step 1 for main frame */
step1_main:procedure expose tempfile topcolor workcolor gls. cmds.
call outit '<script language="javascript">'
call outit ' '
call outit 'var DIR_LISTED=0;'
call outit 'function Open_viewtree(isblur)'
call outit '{eek=escape(window.document.CALL_THUMB.SEL.value) ;'
call outit 'daVIEWTREE=window.open("/thumindx.cmd?VUDIR=1&sel="+eek,"VIEWTREE", "location=NO,MENUBAR=NO,RESIZABLE,DEPENDENT,SCROLLBARS=YES,STATUS=YES,TITLEBAR,TOOLBAR=NO,SCREENX=12,SCREENY=30,height=440,width=200");'

call outit ' var openVIEWTREE=1;  '
call outit 'if (isblur==1) ; {daVIEWTREE.blur() }'
call outit ' }'
call outit ' '
call outit ' </script>'

call outit ' '
call outit ' <FORM ACTION="/thumindx" METHOD="GET" name="CALL_THUMB" >'
call outit ' <input type="hidden" name="STEP" value="1B">'
call outit '<table bgcolor="#eedd22" cols=2>'
call outit '<tr><td>Select a <b>web directory:</b></td>'
call outit ' <td>'
call outit ' <a href=""'
call outit '  onCLick="Open_viewtree(); DIR_LISTED=1; daVIEWTREE.focus() ;  return false " '
call outit '  onMouseOut="window.status=''ThumIndx'' ; return true "  '
call outit '  onMouseOver="window.status=''Display directory list in separate window'' ;return true">'
call outit '  ... display a <em>directory list</em></a>'
call outit ' <br><InPUT TYPE="text" NAME="SEL"  VALUE="/"  SIZE=30 MAXLENGTH=60>'


call outit ' '
call outit ' <br> <INPUT TYPE="CHECKBOX" NAME="DOSUB" VALUE="1">  Search subdirectories also?  '
call outit ' <br> <INPUT TYPE="CHECKBOX" NAME="OVERWRITE" VALUE="1"> Overwrite prior thumbnails &amp; database?  </td>'

call outit ' '
call outit '<tr> <td colspan=2><INPUT TYPE="CHECKBOX" NAME="autogif" VALUE="1"  CHECKED> If no ThumbNail'
call outit ' <tt>(in the file''s EAs)</tt> try to create one <em> </em></td>'

call outit '<tr> <td colspan=2><INPUT TYPE="CHECKBOX" NAME="makesnap" VALUE="1"  CHECKED> Create <em>VGA</em> snapshots'
call outit ' <tt>(write to subdirectory of chosen <b>web directory</b>)</td>'


call outit ' '
call outit ' <tr>'
call outit ' '
call outit ' <br>'
call outit ' <td >Include which files: </td>'
call outit ' <td><select size=2 multiple name="INCLUSION">'
call outit ' <option value="*" selected>All files '
call outit  '<option value="JPG"> JPEG (or JPG) files '
call outit  '<option value="GIF"> GIF files'
call outit  '<option vlaue="BMP"> BMP files '
call outit  '<option value="TIF"> TIFF (or TIF) files'
call outit  '<option value="PNG"> PNG files'
call outit '</select></td>'
call outit ' <tr>'
call outit ' <td>Thumbnail size: </td>'
call outit '<td><select size=2 name="TSIZE">'
call outit '<option value=16>Small (16x16) '
call outit '<option value=32>Medium (32x32) '
call outit '<option value=64 selected>Large (64x64) '
call outit '<option value=96>Very Large (96x96) '
call outit '</select></td>'
call outit ' <tr>'
call outit ' <tr bgcolor="#998899"><td>Description:</td><td><input type="text" name="descrip" size=50>'
call outit ' </table>'
call outit ' <INPUT TYPE="submit" NAME="MAKE0" value="Make the thumbnails" name="DIDIT" '
call outit ' >'
call outit ' '
call outit ' </form>'
call outit '<form name="HERE1"><menu>'
call outit '<li><input type="checkbox" onClick=window.location=''/thumindx?Step=1A''; '
call outit 'return true" name="HERE2">'
call outit ' Instead, would you like to use an existing <u>ThumbIndex database</u>'
call outit '<br>'
call outit '  ... or, list these databases '
call outit '<a href="" onClick="'
call outit 'daVIEW2=window.open(''/thumindx?Step=1ANU'',''FILE_VIEWER'',',
      '''location=NO,MENUBAR=NO,RESIZABLE,DEPENDENT,SCROLLBARS=YES,STATUS=NO,TITLEBAR,TOOLBAR=NO,SCREENX=212,SCREENY=30,height=374,width=190'');'
call outit 'return false;">'
call outit 'in a new window</a>'
call outit '</menu>'
call outit '</form>'

return 1

/********************/
/* step 1.a -- allow client to select an existing thumbindex database */
do_step1A:

cachedir=strip(strip(thumbnail_dir),,'\')
ILOOK=CACHEDIR||'\THUMINDX.IND'
AA=SYSFILETREE(ILOOK,'INDS','S')
klen=length(cachedir)+2
call outit 'Choose a ThumbIndex database. You will then be able to change comments,'
call outit 'and (re)generate thumbnail indices.'
call outit '<form name="CHOOSE_TDATA" action="/THUMINDX.CMD" method="GET">'
call outit '<table><tr><th>WWW directory </th><th>Creation date of <br>ThumbNail Database</th>'
DO MM=1 TO INDS.0
   parse var inds.mm date time size attrib fname
   fname2=translate(substr(fname,klen),'/','\')

   fname0=filespec('d',fname)||filespec('p',fname)
   fname2a=translate(substr(fname0,klen),'/','\')
  
   call outit '<tr><td>'
   call outit '<input type="RADIO" name="INDEX" value="'||fname2'"'
   call outit '>'
   call outit '<b>'fname2a'</b></td><td>'date' 'time'</td>'

end
call outit '</table>'
call outit '<input type="hidden" name="STEP" value="1A2">'
call outit '<input type="SUBMIT" name="CHOOSE1" value="Choose a ThumbIndex Database ">'
call outit '</form>'


call outit '<script language="javascript">'
CALL outit '    parent.TOP_FRAME.document.open(''text/html'');'
call outit '    parent.TOP_FRAME.document.writeln(''<body bgcolor='||topcolor||'> '');'
call outit '    parent.TOP_FRAME.document.writeln(''<h3 align='center'>Choose a ThumbIndex database...</h3>'');'
call outit '    parent.TOP_FRAME.document.writeln('' <a href="" onClick=" '');'
call outit '    parent.TOP_FRAME.document.writeln(''  parent.WORK_FRAME.document.CHOOSE_TDATA.CHOOSE1.focus(); '');'
call outit '    parent.TOP_FRAME.document.writeln('' return false ;">Ready to choose a thumbindex database?</a><br> '');'
call outit '    parent.TOP_FRAME.document.writeln('' <p>Select one of the 'inds.0' ThumbIndex databases.'');'
call outit '    parent.TOP_FRAME.document.writeln('' Or, hit the <u>Create Thumbnails</u> button (in the left hand frame) to create a new set of thumbnails '');'
call outit '    parent.TOP_FRAME.document.writeln('' </body></html> '');'
call outit '    parent.TOP_FRAME.document.close() ;'
call outit '</script>'

RETURN 1

/********************/
/* step 1.a nu -- display list of thumbnail indices, allow selection */
do_step1ANu:

cachedir=strip(strip(thumbnail_dir),,'\')
ILOOK=CACHEDIR||'\THUMINDX.IND'
AA=SYSFILETREE(ILOOK,'INDS','S')
klen=length(cachedir)+2
call outit '<form name="TDATANU" >'
call outit '<table><tr><th>Index ID</th>'
DO MM=1 TO INDS.0
   parse var inds.mm date time size attrib fname
   fname2=translate(substr(fname,klen),'/','\')

   fname0=filespec('d',fname)||filespec('p',fname)
   fname2a=translate(substr(fname0,klen),'/','\')
  
   call outit '<tr><td><font size=-1>'
   call outit '<input type="RADIO" name="INDEX" value="'||fname2||'"'
   call outit 'onClick="do2(this);return true;"'
   call outit '>'
   call outit fname2a'</font></td>'

end
call outit '</table>'

call outit '</form>'


call outit '<script language="javascript">'
call outit 'var callwin=self.opener; '
call outit ' function do2(a){'
CALL outit '    callwin.parent.TOP_FRAME.document.open(''text/html'');'
call outit '    callwin.parent.TOP_FRAME.document.writeln(''<body bgcolor='||topcolor||'> '');'
call outit '    callwin.parent.TOP_FRAME.document.writeln(''<h3 align='center'>An Index Chosen</h3>'');'
call outit '    callwin.parent.TOP_FRAME.document.writeln(''You chose:<tt>''+a.value+''</tt> '');'
call outit '    callwin.parent.TOP_FRAME.document.writeln(''<br>You can now proceed to Step 2 (Add Comments) or to Step 3 (Write Indices)<p>'');'
call outit '    callwin.parent.TOP_FRAME.document.writeln(''<form name="INFO" method="GET" action=""> '') ;'
call outit '    callwin.parent.TOP_FRAME.document.writeln(''<input type="hidden" name="INDEX" value="''+a.value+''" >'' ); '
call outit '    callwin.parent.TOP_FRAME.document.writeln(''</form>'' );'

call outit '    callwin.parent.TOP_FRAME.document.writeln(''  '');'
call outit '    callwin.parent.TOP_FRAME.document.writeln(''  '');'
call outit '    callwin.parent.TOP_FRAME.document.writeln('' </body></html> '');'

call outit '    callwin.parent.TOP_FRAME.document.close() ;'

CALL outit '    callwin.parent.WORK_FRAME.document.open(''text/html'');'
call outit '    callwin.parent.WORK_FRAME.document.writeln(''<body bgcolor='||workcolor||'> '');'
call outit '    callwin.parent.WORK_FRAME.document.writeln(''<h3 align='center'>An Index Chosen</h3>'');'
call outit '    callwin.parent.WORK_FRAME.document.writeln(''You chose:<tt>''+a.value+''</tt> '');'
call outit '    callwin.parent.WORK_FRAME.document.writeln(''<br>You can now proceed to Step 2 (Add Comments) or to Step 3 (Write Indices)<p>'');'
call outit '    callwin.parent.WORK_FRAME.document.writeln(''<form name="INFO" method="GET" action=""> '') ;'
call outit '    callwin.parent.WORK_FRAME.document.writeln(''<input type="hidden" name="INDEX" value="''+a.value+''" >'' ); '
call outit '    callwin.parent.WORK_FRAME.document.writeln(''</form>'' );'

call outit '    callwin.parent.WORK_FRAME.document.writeln(''  '');'
call outit '    callwin.parent.WORK_FRAME.document.writeln(''  '');'
call outit '    callwin.parent.WORK_FRAME.document.writeln('' </body></html> '');'

call outit '    callwin.parent.WORK_FRAME.document.close() ;'


call outit '}'
call outit '</script>'


RETURN 1


/********************/
/* step 1.a2 -- thumdindex database has been selected */
do_step1A2:

call outit '<script language="javascript">'
CALL outit '    parent.TOP_FRAME.document.open(''text/html'');'
call outit '    parent.TOP_FRAME.document.writeln(''<body bgcolor='||topcolor||'> '');'
call outit '    parent.TOP_FRAME.document.writeln(''<h3 align='center'>Index Chosen</h3>'');'
call outit '    parent.TOP_FRAME.document.writeln(''You chose:<tt> 'opts.!index'</tt> '');'||crlf
call outit '    parent.TOP_FRAME.document.writeln(''<br>You can now proceed to Step 2 (Add Comments) or to Step 3 (Write Indices)<p>'');'||crlf
call outit '    parent.TOP_FRAME.document.writeln(''<form name="INFO" method="GET" action=""> '') ;'||crlf
call outit '    parent.TOP_FRAME.document.writeln(''<input type="hidden" name="INDEX" value="'||opts.!Index||'" >'' ); '||crlf
call outit '    parent.TOP_FRAME.document.writeln(''</form>'' );'

call outit '    parent.TOP_FRAME.document.writeln(''  '');'
call outit '    parent.TOP_FRAME.document.writeln(''  '');'
call outit '    parent.TOP_FRAME.document.writeln('' </body></html> '');'

call outit '    parent.TOP_FRAME.document.close() ;'
call outit '</script>'

call outit 'Information on the ThumbIndex database: 'opts.!index

cachedir=translate(strip(thumbnail_dir,'t','\'))
theind=strip(translate(strip(opts.!index),'\','/'),,'\')
theind=cachedir||'\'||theind

foo=stream(theind,'c','query exists')
if foo='' then do
   call outit '<BR>Warning: could not find database index <tt> 'opts.!Index'</tt>'
   return 0
end 

crea=dosfileinfo(theind,'W')
call outit ' <em>created 'crea '</em>'

afoo=linein(theind) 
foo=stream(theind,'c','close')
parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .
call outit '<ul>'
call outit '<li>Thumbnails of files in WWW directory:<tt> 'dasel'</tt>'
call outit '<li># of thumbnails: <tt>'numrec '</tt>'
call outit '<li>Description: <tt> 'adesc '</tt>' 
call outit '</ul>'
call outit '<hr> <a href="/thumindx.cmd?index='opts.!index'&preview=1" target="viewer">Preview these thumbnails</a>'

return 1

/********************/
/* step 1.b -- create the thumbnails */
do_step1b:

'set netbuffer off'
aa='<!DOCTYPE HTML PUBLIC "-//W3 Organization//DTD W3 HTML 3.2//EN">'
foo=sref_multi_send(aa,,'1S')

call govar '<HTML><HEAD><TITLE>Step 1b: creating the thumbnails </TITLE></head>'||crlf

call govar '<BODY bgcolor="'||workcolor||'">'||crlf

call govar '<script language="javascript">'||crlf
CALL GOVAR '    parent.TOP_FRAME.document.open(''text/html'');'||crlf
call govar '    parent.TOP_FRAME.document.writeln(''<body bgcolor='||topcolor||'> '');'||crlf
call govar '    parent.TOP_FRAME.document.writeln(''<h3 align='center'>Thumbnails being created ..</h3>'');'||crlf
call govar '    parent.TOP_FRAME.document.writeln('' Creating thumbnails of files in <tt>'||opts.!sel||'</tt> '');'||crlf
call govar '    parent.TOP_FRAME.document.writeln('' </body></html> '');'||crlf

call govar '    parent.TOP_FRAME.document.close() ;'
call govar '</script>'||crlf

call  do2_step1b


/* update THUMINDX.DAT */
alist=cachedir'\THUMINDX.DAT'
goo=date('O') ;a2=left(goo,2)
if dsel<>'/' then dsel='/'||strip(dsel,,'/')
select
      when a2=19 | a2=20 then nop
      when a2>80 then goo='19'||goo
      otherwise goo='20'||goo
end
goo=goo||'.'||time('s')
tfile3=translate(tfile2'.IND','/','\')
putit=translate(dsel' 'tfile3)

if stream(alist,'c','query exists')='' then do
   aa.1=';List of ThumbIndex databases  '
   goo=date('O') ;a2=left(goo,2)
   select
      when a2=19 | a2=20 then nop
      when a2>80 then goo='19'||goo
      otherwise goo='20'||goo
  end
  lins.1='; ThumbIndex databases: 'date('n')||' '||time('n')
  aa.2=isucc' 'putit' 'goo
  aa.0=2
  foo=sref_filewrite(alist,'aa.')
  if foo<0 then 
       call sref_multi_send('<p>Warning 'foo': unable to update (write) 'alist'<br>')
end 
else do
   foo=sref_fileread(alist,'lins.')
   if foo=0 then do
       call sref_multi_send('<p>Warning 'foo': unable to update (read) 'alist'<br>')
   end
   else do
     lins.1='; ThumbIndex databases created by ThumbNail Index: 'date('n')||' '||time('n')
     ii=0
     if opts.!overwrite=1 then do
        ii=find_inlist(putit)
     end
     if ii=0 then do  /* not overwrite, or no match */
       ii=lins.0+1
       lins.0=ii
     end
     lins.ii=isucc' 'putit' 'goo
     foo=sref_filewrite(alist,'lins.')
     if foo<0 then 
       call sref_multi_send('<p>Warning 'foo': unable to update (write) 'alist'<br>')
   end
end 

aa='</BODY></HTML>'
foo=sref_multi_send(aa,,'1E')

return 200' '||extract('bytessent')

/**********/
/* search lins for entry that contains same web-directory and thumbnail-directory*/
find_inlist:procedure expose lins. gls.
parse arg lookfor
do mm=1 to lins.0
   if pos(lookfor,lins.mm)>0 then return mm
end 
return 0

/*************************************/
/* create thumbnails and thumbnail index */
do2_step1b:

cachedir=translate(strip(thumbnail_dir,'t','\'))
if dir_exists(cachedir)<>1 then do
    aa= crlf"<b>ERROR</b>: no root directory for caching: "thumbnail_dir
    call govar  aa 
    return 0
end 
if words(opts.!sel)>1 then do
    aa= crlf'<b>ERROR</b>: too many directories requested: 'opts.!sel
    call govar  aa 
    return 0
end

if datatype(opts.!tsize)<>'NUM' then do
    aa= crlf'<b>ERROR</b>: bad thumnbnail size (must be an integer>0): 'opts.!tsize
    call govar  aa 
    return 0
end

x32=opts.!tsize ;y32=x32

if opts.!dosub=1 then  /* process subdirectories ? */
  ts='TS'
else 
 ts='T'

/* process directory */
eek1=strip(opts.!sel)
dsel=eek1                     /* used in index */
eek1=eek1||'/' 
if eek1='//' then eek1='/'
thedir=sref_do_virtual(ddir,eek1,enmadd,0,transaction,homedir,host_nickname)
thedir=strip(thedir,'t','\')
if dir_exists(thedir)<>1 then do
   aa=crlf||'<B> No such directory </b>: ' eek1
   call govar  aa
   return 1
end 

/* astem=left(thedir,1+length(thedir)-length(eek1)) */

aa='0d0a'x||'<h3 align="center">Creating thumbnails</h3> Examining files in 'eek1'<br>'
call govar  aa
call do3_step1b 

return 1

/********/
/* working portion of from_request */
do3_step1b:          
parse arg isstand

actualnum=sysfiletree2(strip(thedir,,'\')||'\*.*',ts,opts.!inclusion,length(thedir))

nosnap=0
nosnap_message=''
arf=filespec('d',thedir)
arf2=dosfilesys(arf)
if arf2='FAT' then do
   nosnap=1
   nosnap_message='Creation of SnapShots requires non-FAT drives'
end
if nosnap=0 & (cmds.!make_snap=1 | opts.!MakeSNAP=1 ) then do
   snapdir=strip(thedir,,'\')||'\SNPS'
   if dosisdir(snapdir)=0 then do  /* create it and use it*/
       oy=sysmkdir(snapdir)
       if oy<>0 then do
          nosnap=1
          nosnap_message='Could not create directory: 'snapdir
       end
   end
end

call govar '<hr width="50%">'crlf
isucc=0 ;nautos=0;nconvert=0
isucc_snap=0
if standalone=1 then 
  inactive=10000000
else
   inactive=extract('limittimeinactive')/2

if actualnum<>flist.0 then do
  aa='<b>Note:</b> 'actualnum ' files before use of inclusion list of:'
  call govar  aa
  aa='       <tt>'opts.!inclusion'</tt>'||crlf
  call govar aa
end

autogif=opts.!autogif

foo=time('r')

if cmds.!LOCAL_TDIR='' | standalone<>1 then
   cachedir_use=mk_index_dir(cachedir,dsel,opts.!overwrite)   /* make a subdir under cachedir for these thumbnails & index */
else
   cachedir_use=cmds.!LOCAL_TDIR

if cachedir_use=0 then do
     call govar '<p>ERROR: unable to create thumbnail directory for 'dsel
     return 0
end 
if cachedir_use=-1 then do
     call govar '<p>ERROR: unable to create a thumbnail directory for 'dsel
     return 0
end 
parse var cachedir_use  cachedir_use isover
tfile=cachedir_use||'\THUMINDX.IND'

tfile2=substr(tfile,length(cachedir)+2)
gls.!thumindx=translate(tfile2,'/','\')

cshlen=length(thedir)
iwasx=0
if standalone=0 then do
  call govar '<p><em>Current status.... </em><p><ul>'crlf
  call govar "<li><font size=-1>Examining <tt>" flist.0 "</tt> files from <tt>" thedir '</tt></font><p>'
end

if standalone=1 then do

   say bold"Examining:" flist.0 " files from " thedir ||normal
   say "   hit any ESC to exit, any other key to continue ... "
   anans=translate(sysgetkey('echo'))
   if anans='1b'x then do
        say "bye "
        exit
   end /* do */
   say
   say '     '|| cY_ye||'Creating thumbnails 'normal
   say

   if cmds.!verbose=1 then isverbose=1
end 

a10=10
do m=1 to flist.0
   aw=flist.m
   if standalone=1 & isverbose>0 then say " Checking ... " word(aw,4)
   parse upper var aw adate asize . dafile ; dafile=strip(dafile)

   if (m//a10=1 & m<>1) | time('e')>inactive then  do
        aa=crlf'<li> '  isucc " thumbnails written from   " (m-1) ' files '||crlf
        if nosnap=0 & (cmds.!make_snap=1 | opts.!MakeSNAP=1 ) then do
            aa=aa||'<br>          Snapshots made= 'isucc_snap||crlf
        end
        call govar  aa
        foo=time('r')
        a10=20
   end
   if stream(dafile,'c','query exists')='' then iterate
   rr=make_dathumb(cachedir_use,dafile,adate,,' ',verbose)

   if rr<>'' then do
      parse var rr dafile' 'tfile2' 'adate' 'ooze' '
      parse value cvt_filename(dafile,dsel,cshlen) with dafile selname
      rr=selname' 'tfile2' 'adate' 'ooze
      isucc=isucc+1
      suclist.isucc=rr
   end 

/* make snapshots? */

   if nosnap=0 & (cmds.!MAKE_SNAP=1 | opts.!MakeSNAP=1 ) then do
       oof=make_snapshot(dafile,snapdir)
       if oof='' then isucc_snap=isucc_snap+1
   end
   

end /* check all files do */
call govar '</ul><b>Done!</b><br>'||crlf
if isucc=0 then do
   aa=crlf'<b>No thumbnails created </b>'||crlf
   call govar  aa
    return 0
end /* do */
aa=crlf'<p><B>' isucc ' thumbnails  created </B>('nautos '.GIF generated, 'nconvert ' resized) from  ' flist.0 " files"
call govar aa


if nosnap_message<>'' then do
  aa=crlf||'<p><b>Note regarding snapshot creation:</b>'||nosnap_message
  call govar aa
end

suclist.0=isucc

oo=arraysort2(suclist)
mxlenv1=0 ; mxlenv2=0
do mm=1 to suclist.0
   parse var suclist.mm v1 v2
   mxlenv1=max(mxlenv1,length(v1))
   mxlenv2=max(mxlenv2,length(v2))
end
do mm=1 to suclist.0
   parse var suclist.mm v1 v2
   suclist.mm=left(v1,mxlenv1)' 'left(v2,mxlenv2)
end /* do */
mxlen=mxlenv1+mxlenv2+1
desc1=opts.!descrip
if desc1=0 then desc1=' '
suclist2.1=mxlen' 'suclist.0' 'mxlenv1' 'cshlen' ' dsel' 'x32' 'y32' /#/ 'desc1 ' /#/  ; DO NOT modify '
if length(suclist2.1)>mxlen then mxlen=length(suclist2.1)
suclist2.1=left(suclist2.1,mxlen)
do mm=1 to suclist.0
    mm1=mm+1
    suclist2.mm1=suclist.mm
end 
suclist2.0=suclist.0+1
aa=sref_filewrite(tfile,suclist2)
if aa=0 then do
   aa='<p><B>ERROR. </b> Unable to write index to 'tfile
   call govar aa
   return 0
end /* do */
if isstand=1 then return 1

tfile2=substr(tfile,length(cachedir)+2)
parse var tfile2 tfile2 '.' .

aa='<hr> <a href="/thumindx.cmd?index='tfile2'&preview=1">Preview thumbnails</a>'||crlf
call govar aa

call govar '<p><a href="javascript:history.go(-1)">Back.. </a>'crlf

call govar '<script language="javascript">'||crlf
CALL GOVAR '    parent.TOP_FRAME.document.open(''text/html'');'||crlf
call GOVAR '    parent.TOP_FRAME.document.writeln(''<body bgcolor='||topcolor||'> '');'||crlf
call GOVAR '    parent.TOP_FRAME.document.writeln(''<h3 align='center'>Thumbnails created</h3>'');'||crlf
call GOVAR '    parent.TOP_FRAME.document.writeln(''<b>Step 1 completed succesfully.</b>'');'||crlf
call GOVAR '    parent.TOP_FRAME.document.writeln(''You can now proceed to Step 2 (Add Comments)</b><p>'');'||crlf

call GOVAR '    parent.TOP_FRAME.document.writeln('' A total of '||isucc||' thumbnails were created for files in '||dsel||' '');'||crlf
tt=translate(tfile,'/','\')
if isover=1 then
   call GOVAR '    parent.TOP_FRAME.document.writeln('' <br><font size=-1>The  (overwritten) ThumbIndex database is:  '||tt||' </font> '');'||crlf
else
   call GOVAR '    parent.TOP_FRAME.document.writeln('' <br><font size=-1>The ThumbIndex database is:  '||tt||' </font> '');'||crlf
call GOVAR '    parent.TOP_FRAME.document.writeln(''<form name="INFO" method="GET" action=""> '') ;'||crlf
call GOVAR '    parent.TOP_FRAME.document.writeln(''<input type="hidden" name="INDEX" value="'||tt||'" >'' ); '||crlf
call GOVAR '    parent.TOP_FRAME.document.writeln(''</form>'' );'
call govar '    parent.TOP_FRAME.document.writeln('' </body></html> '');'||crlf

call GOVAR '    parent.TOP_FRAME.document.close() ;'||crlf
call govar '</script>'||crlf


return 1




/**********************/
/* make a directory listing of all directories under /
  (display as relative to / */
make_dirlist:
try1=opts.!sel
if opts.!sel='' then try1='/'
try1=translate(try1,'/','\')
try1b=strip(try1,,'/')
adir=sref_do_virtual(ddir,try1'/',enmadd,0,transaction,homedir,host_nickname)
rdir=strip(adir,,'\')
if dosisdir(rdir)=0 then do
    call outit '<B>ERROR</b>: Could not find directory= 'rdir
    return 1
end 
oof=rdir||'\*.*'

oof2=sysfiletree(oof,'dirs.','DOS')
 call outit '<html><HEAD><TITLE>Directory listing</title></head>'
  call outit '<script language="javascript">'
  call outit '<!--'
  call outit 'var vstore="'||try1b||'" ;'   
  call outit 'var totdir='dirs.0 ' ;'
  call outit 'var nowdir=0  ;'
  call outit 'var callwin=self.opener; '
  call outit ' '
  call outit 'function do_chosen(thedir,dirnum) {'
  call outit 'window.document.TT.CHOSEN.value="'||try1b||'"+thedir ;'
  call outit " vstore='"||try1b||"'+thedir ; nowdir=dirnum ;"
  call outit 'if (callwin.document.forms.length>0){'
  call outit ' callwin.document.CALL_THUMB.SEL.value=vstore;}' 
  call outit ' return true }'
  call outit ' '
  call outit 'function next_dir() {'
  call outit 'idir=nowdir+1;'
  call outit 'if (idir>totdir) {idir=0}'
  call outit ' '
  call outit 'window.document.TT.CHOSEN.value="'||try1b||'/"+dirarray[idir] ;'
  call outit " vstore='"||try1b||"/'+ dirarray[idir] ; nowdir=idir ;"
  call outit 'if (callwin.document.forms.length>0){'
  call outit ' callwin.document.CALL_THUMB.SEL.value=vstore;}' 

  call outit ' return true }'

  call outit '// end of hiding -->'
call outit '</script>'

call outit 
call outit "<nobr><b>Directories</b><br>"
call outit '<form name="TT" onSubmit="return false;">'
call outit '<table bgcolor="#aabbaa"><tr ><td><font size=-1>Chosen Dir:</font></td>'
call outit '<td><input type="TEXT" '
call outit '  value="'||try1b||'" size=30 '
call outit '  onChange="if (callwin.document.forms.length>0){'
call outit '     vstore=this.value ;'
call outit '     callwin.document.CALL_THUMB.SEL.value=vstore};' 
call outit '     return false; }"'
call outit ' name="CHOSEN">'
call outit '</td>'
call outit '<tr> '
call outit ' <td colspan=2><Input type="checkbox" value=1 name="WHAT_DIRAT"'
call outit ' onClick="next_dir() ; window.document.TT.WHAT_DIRAT.checked=false; return true"'
call outit '   Get the <b>next</b> directory.'
call outit '</table></form>'
call outit '<ul compact type="CIRCLE">'
ddlist.=''

ndirs=dirs.0
dirs.0=rdir

nddir=length(rdir)
extlist='JJGMTTP'
extlist2='JPG JPEG GIF BMP TIF TIFF PNG'
do mm=0 to ndirs
  acdir=dirs.mm
  if abbrev(translate(acdir),thumbnail_dir)=1 then  iterate /* skip thumbnail cache dir */

  founds=''
  thissel=substr(translate(acdir,'/','\'),nddir+1)
  thissel=strip(thissel,,'/') ; thissel2=translate(thissel)
  if thissel='' then thissel='/'
  thisselr='/'||try1b||'/'||thissel2||'/'
  if left(thisselr,2)='//' then thisselr=substr(thisselr,2)
  if left(thisselr,2)='//' then thisselr=substr(thisselr,2) /* might have been /// */
 

  npics=0
  do ac=1 to length(extlist)
     ac2=substr(extlist,ac,1)  
     atype2=word(extlist2,ac)
     howsh=acdir'\*.'||atype2
     oo=sysfiletree(howsh,'ff.','FO')
     if ff.0=0 then iterate
     if pos(ac2,founds)=0 then founds=founds||ac2
     npics=npics+ff.0
  end
  if founds<>'' then founds='  <font size=-1><em>('||founds||' = '||npics||')</em></font>'
  call outit '<li> <a href="'||thissel||'" '

   call outit 'onClick="do_chosen(this.pathname,'mm');return false">'
  call outit thissel||'</a>'||founds

  ddlist.mm=thissel
  ddlist.!all=mm

end 
call outit ' </ul><p><font size=-1><em>(BJGTP)</em> signify BMP, JPG, GIF, TIFF,<br> or PNG files detected in a directory.</font>'
call outit '</nobr>'
call outit ' '
call outit '<script language="javascript">'
call outit '<!-- '
call outit 'dirarray=new Array('||ddlist.!all||') ;'
do jjj=0 to ddlist.!all
  call outit ' dirarray['||jjj||']="'||ddlist.jjj||'";'
end
call outit ' // end of hiding -->'
call outit' </script>'


return 0

/*************************************/
/* create an html document that views thumbnails. Uses stuff stored
   in the thumbindex database */

show_list_index:procedure expose opts. thumbnail_dir tempfile thumbnail_dir_sel gls. ,
     imgalign uri is_cgi tdcs. dasel crlf ,
     enmadd ddir transaction homedir host_nickname cmds.  standalone 

parse arg theind,bigheader,bigfooter,afoo,bigpicture,multiplier

/* bigpicture  =  ' ' : linear index
                  1   : javascript enhanced imagemap
                  2  : regular imagmap
*/

cachedir=strip(translate(strip(thumbnail_dir,'t','\')))
ncdir=length(cachedir)
if index_list='' | index_list='*' then do
  call outit ' <b>Sorry</b>. No such index: <u>'opts.!index'</u>'
  return 1
end 

if multiplier='' then multiplier=1

bgs.1='#bbccbb'
bgs.2="#ddeedd"
foo=stream(theind,'c','close')
afoo=linein(theind) 
if afoo="" then do
       call outit 'Unable to read index file (6): 'theind '(try again later) '
       numrec=0
       return 0
end 

parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .
x32=awid ; y32=aht

call outit ' '
if bigheader<>'' then do
   call outit bigheader
end 

/* make big pictures of the thumbnails, or make an index */
if bigpicture>0 then do
    cdd=strip(filespec('d',theind)||filespec('p',theind),,'\')
    if bigpicture=1 then   call make_bigpic0 
    call make_bigpicture cdd
end
else do
    call make_list_index multiplier
end

if bigfooter<>'' & bigfooter<>0 then do
   call outit bigfooter
end 

return 1


/***************/
/* write an ol of thumbnailized links */
make_list_index:
parse arg amult
if amult='' then amult=1

call outit '<Ol> '
vuin=' TARGET="VIEWIN" '
ifnd=0

/* make link to thumbnail and actual file-- all entries in theind */
awidx=trunc(awid*amult); ahtx=trunc(aht*amult)
do mm=1 to numrec
     aa=linein(theind)
     parse var aa filename cachename . amess ; filename=strip(filename)
     cachename=cvt_cachename(cachename)
     parse value cvt_filename(filename,dasel,cshlen) with filename selname
     if standalone=1 then do
       if cmds.!NOT_HTTP=1 | cmds.!NOT_HTTP=2  then selname=strip(selname,,'/')
     end
     if stream(filename,'c','query exists')='' then iterate

     ifnd=ifnd+1
     aa=strip(thumbnail_dir_sel,,'/')
     if cmds.!NOT_HTTP=2  & standalone=1 then do
       aa='thumindx/'||strip(cachename,,'/')
     end
     else do
       aa='/'aa'/'||strip(cachename,,'/')
     end
     alink7='<img  align="'||imgalign||'"  width='||awidx||' height='||ahtx||' src="'||aa||'"'
     parse value filespec('n',filename) with isalt '.' .
     alink7=alink7||' alt="'||isalt||'">'
     alink8='<a href="'selname||'"'||vuin||'>'alink7'</a> '
     cmess=strip(subword(amess,2))
     call outit '<li> 'alink8 || '<font size=-1><em>'||word(amess,1)||'</em></font> &nbsp; &nbsp; '||cmess
     call outit '<p>'       
end             

call outit '</ol>'
call outit ' '
return 1


/**************/
/* create a directory for some new thumbnails */
mk_index_dir:procedure  expose gls.
parse arg cachedir,thesel,overwrite,nameonly
/* index file (to create -- based on subdir name listed in sel */
foo=strip(translate(thesel,' ','\/'))
if foo='' then do               /* might be root */
    use1=cachedir||'\THUMINDX'
end 
else do
    use1=cachedir||'\'||strip(word(foo,words(foo)))
end 

/* does this dir exist? */
call mkind_2 use1
afoo=result
if afoo<>0 then return afoo     /* -1 failure, or dir name */

/* else, exists, try looking in subdirectories V1 .. V1000) */
use0=use1
do dd=1 to 1000
  use1b=use0||'\V'||dd
  call mkind_2 use1b
  afoo=result
  if afoo<>0 then return afoo     /* -1 failure, or dir name */
end
return -1               /* unable to create a directory */


/*******/
/* see if overwrite is okay (or if empty */
mkind_2:
parse arg use1a

if dosisdir(use1a)=0 then do  /* nope, so create it and use it*/
  oy=sysmkdir(use1a)
  if oy=0 then return use1a            
  return -1
end

/* perhaps it's empty? */
foo=sysfiletree(use1a'\*.*','goo.','FT')
if goo.0=0 then return use1a             /* it's empty */

/* not empty, perhaps it's for the same "selector" (and overwite=1 )*/
if overwrite=1 then do
  aind=use1a'\thumindx.ind'
  foo=stream(aind,'c','query exists')
  if foo='' then return use1a   /* no .ind file, so use this dir */

  afoo=linein(aind) 
  foo=stream(aind,'c','close')
  if afoo="" then  return use1a   /* .ind file is flawed, so overwrite */

  parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .

  if translate(dasel)=translate(thesel) then do /* match -- clean up and use */
     aa=linein(aind)            /* skip header info */
     do vv=1 to numrec
        aa=linein(aind)
        parse var aa a1 a2 .
        goo=1+lastpos('/',a2)
        aff=substr(a2,goo)
        foo=sysfiledelete(use1a'\'aff)
     end 
     foo=stream(aind,'c','close')
     foo=sysfiledelete(aind)
     return use1a' 1'
  end
end             /* overwrite? */
return 0            /* can not overwrite */


/*******/
/* cvt from old style (full file) to new style (selector
   or vice versa. Uses virtual directory stuff  */
cvt_filename:procedure expose enmadd ddir transaction homedir host_nickname gls. cmds.   standalone 
parse arg filename,dasel,cshlen


if pos(':',filename)=0 then do
   aselname=filename
   if abbrev(aselname,'/')=0 then  aselname='/'aselname
   if gls.!standalone=1 then do
      if gls.!imgdir='' then do
         afilename=strip(gls.!wwwdir,,'\')||'\'||strip(translate(filename,'\','/'),,'\')       
      end
      else do
        filename=substr(filename,length(dasel)+1)
        afilename=gls.!imgdir||'\'||strip(translate(filename,'\','/'),,'\')
      end /* do */
   end 
   else do 
      afilename=sref_do_virtual(ddir,filename,enmadd,0,transaction,homedir,host_nickname)
   end
   
end
else do
  afilename=filename
  aselname=strip(translate(substr(filename,cshlen+1),'/','\'),,'/')
  dasel=strip(strip(dasel),,'/')
  if dasel='' then
     aselname='/'aselname
  else
     aselname='/'dasel'/'aselname
end
return afilename' 'aselname


/*******/
/* cvt from old style (full file) to new style (selector */
cvt_cachename:procedure expose thumbnail_dir gls.
parse arg cachename

if pos(':',cachename)>0 then
    cachename=strip(translate(substr(cachename,length(thumbnail_dir)+2),'/','\'),,'/')
else
    cachename=translate(cachename,'/','\')

return cachename

/*************************************/
/* output to tempfile, or stdout (depending on whether it's called as cgi or srehttp addon*/
outit:
parse arg damess
call lineout tempfile,damess
return 1


/* ----------------------------------------------------------------------- */
/* MOVED: Return a 'moved' response  -- it calls a macrospace routine      */
/* ----------------------------------------------------------------------- */
/* Argument is new URL or partial URI          */

moved:procedure expose stempfile   verbose   servername  gls.

  parse arg uri,daind
  port=extract('port')
  if left(translate(uri),5)=='HTTP:' then do /* got full URI */ 
         url=uri
   end
   else  do
      if port=80 then pp=''; else pp=':'port
      url='http://'servername||pp'/'uri        /* relocation */
  end
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'
  call lineout tempfile, "<html><head><title>Moved</title></head>"

  /* Now set the response and build the response file */
    'RESPONSE HTTP/1.0 302 Moved Temporarily'  /* Set HTTP response line */
    'HEADER ADD Location:' url
    call lineout tempfile, "<body><h2>Thumbnail is at...</h2>"
    call lineout tempfile, "<p>The thumbnail is <a href="""url""">here</a>"
    parse value filespec('n',daind) with  daind '.' .
    call lineout tempfile,'<em>(from thumbnail index: 'daind')</em><br>'
    call lineout tempfile, "</body></html>"
  
  call lineout tempfile  /* close */
 call gofile  'FILE ERASE TYPE text/html NAME '||tempfile
return 1



/************/
/* to a "VAR xx or sref_multi_send */
govar:
parse arg aa2
if standalone=1 then do
 taa=''
 a1=translate(aa2,' ','0d0a'x)
 do forever
    if a1='' then leave
    parse var a1 t1 '<' t2 '>' a1
    taa=taa||t1
    if translate(t2)='LI' then taa=taa' * '
    if translate(t2)='P' | translate(t2)='BR' then taa=taa||'0d0a'x
    if abbrev(strip(translate(t2)),'A')=1 then taa=taa' >> '
 end
 taaa=''
 do forever
   if taa=' ' then leave
   parse var taa a1 '&nbsp;' taa
   taaa=taaa' 'a1
 end 
 taaaa=''
 do forever
   if taaa=' ' then leave
   parse var taaa a1 '&amp;' taaa
   if taaa='' then
      taaaa=taaaa||a1
   else
      taaaa=taaaa||a1||'&'
  end

  if length(taaaa)>80 then do
     bline=''
     do igoo=1 to words(taaaa)
        aword=word(taaaa,igoo)
        if length(bline||aword)>75 then do
           say bline
           bline=aword
        end
        else do
           bline=bline||' 'aword
        end
     end
     if bline<>'' then say bline
   end 
   else do
      say taaaa
   end

  return 1
end


/* not standalone */
if is13='' then DO
   'VAR NAME aa2'
END
else DO
   foo=sref_multi_send(aa2)
   IF FOO<0 THEN EXIT      /* CLIENT CLOSED CONNECTION */
return 0


/*******************/
/* sysfiletree, with check against inclusion list  -- return in flist. */
sysfiletree2:procedure expose flist. gls.
parse upper arg lookat,ts,inclu,lenlookat
inclu=strip(inclu)
aa=sysfiletree(lookat,'flist.',ts)


if ts.0=0 | inclu='' | inclu=0 | inclu='*'  then return flist.0

ini=words(inclu)                /* put inclusion entries into a stem var */
do ll=1 to ini
   inclus.ll=strip(word(inclu,ll))
end /* do */
inclus.0=ini

mm2=0
do mm=1 to flist.0              /* check each file agains inclusion list */
   aw=flist.mm
   parse upper var aw . . . dafile ; dafile=substr(strip(dafile),lenlookat+2)
   do ip=1 to inclus.0

      arf=wild_match(dafile,inclus.ip)

      if arf<>0 then do
         mm2=mm2+1 ; flist.mm2=flist.mm
      end /* do */
   end /* do */
end
flist.0=mm2
return mm


/*********************************/
/* make a thumbnail gif
   This is either from extented attributes, in which case the thumbnail
   starts with THM. If it's created on the fly (from a gif file),
   the thumbnail starts with THU. TMPM* files are temporary gif files,
   formed by taking  one image from an animated gif
*/
make_dathumb:procedure expose r_text b_text g_text nconvert nautos gif_exts gls. ,
                        autogif  gbm_dir cmds. is_verbose ,
                        doconvert h10 wtxt x32 y32 cachedir iwasx how_scale   standalone 


parse arg cachedir_use,dafile,adate,tfile,padding,isverbose
      signal on syntax name ayikes 
      signal on error name ayikes 
      signal on halt name ayikes 
      signal on failure name ayikes 

   if cachedir_use=0 | cachedir_use='' then cachedir_use=cachedir
   nth_image_frac=0   /* image to use in animated gif = #images * nth_image_frac */

   parse value filespec('n',dafile) with dafile_name '.' .

   orx='' ; ory='' ; foo2=0
   yowb=sysgetea(dafile,'.ICON',goticon)
   if yowb<>0 then foo2=1
/* no .icon ea found */
   if length(goticon)=0 then do      /* perhaps create one? */
      if isverbose>0 then say "   ! no .ICON ea " dafile
      if autogif=0 then return ''

/* is this non .gif file? */
      if pos('.GIF',dafile)=0 then do
          if tfile="" then tfile=mk_filename(cachedir_use'\'dafile_name,'.GIF')
          astat=gbm_thumbnail(dafile,tfile,x32,y32,160)
          if astat<>1  then do
             if isverbose>0 then say astat
             return ' '
          end
      end
      else do             /* convert a gif file */
          dafile_use=dafile
          dims=gif_info(dafile,'S2')
          parse var dims orx ory kimgs
          if orx <= 0 then do
             if pos('.GIF',dafile)>0 & isverbose>0 then say "  ... bad GIF file " dims
             return ''
          end
          call make_thumb_gif
      end
   end                  /* no .ICON ea */
   else do             /* found a .ICON ea */
       if isverbose>1 then say  "   ... .ICON ea found "
       if tfile="" then tfile=mk_filename(cachedir_use'\'dafile_name,'.GIF')
       if isverbose>1 then    say "   .. about to get .ICON ea "
       afoo=do_ea2gif(dafile,tfile,isverbose)

       if afoo<>1 then do
          if isverbose>0  then say "    ... Problem with EA2GIF "
          return ''
       end
/* convert sizes */
          if isverbose>1 then say "  ... converting size"
/* use rxgdutil to create thumbnail */
          im1=rxgdimagecreatefromgif(strip(tfile))

          if im1>1 then do
            im2=rxgdimagecreate(x32,y32)        /* write thumbnail to this buffer*/  
            orx1=rxgdimagesx(im1) ;ory1=rxgdimagesy(im1)
            foo=rxgdimagecopyresized(im2,im1,0,0,0,0,x32,y32,orx1,ory1)
            wow=rxgdimagegif(im2,tfile)    /* resave to tfile */
            nconvert=nconvert+1
            yow=rxgdimagedestroy(im1); yow=rxgdimagedestroy(im2)
          end
    end         /* .ICON ea processing */

/* if here, success. */

/* record the size, if possible */
  uui=' '                /* assume got orx and ory */
  if orx='' then  uui=get_image_dimensions(dafile)
  if uui<>' ' then do   
      parse var uui orx ory ; orx=strip(orx); ory=strip(ory)
   end       /* found a size (PNG BMP PCX GIF JPG  */

   if orx<>' ' then 
      ooze=orx'x'ory
    else
      ooze=''

   tfile2=translate(substr(tfile,length(cachedir)+1),'/','\')

   return dafile' 'tfile2' 'adate' 'ooze' '


ayikes:
if foo=0 then 
   call pmprintf(' Thumbnail error at line: ' sigl', 'rc)
else
  say "BAD ERROR " sigl
exit



/************/
/* make a thumbnail form a gif file */
make_thumb_gif:

if kimgs>1 then do
         dafile_use=mk_filename(cachedir'\TMPM','.GIF')
         if datatype(nth_image_frac)<>'NUM' then nth_image_frac=0
         trk=min(max(1,trunc(kimgs*nth_image_frac)),kimgs)
         goo=gif_info(dafile,trk,dafile_use)  
         if isverbose>0 & goo=0 then do
            say "   ... RXGDUTIL can not read multiple image gif: " dafile
            return ''            /* couldn't do it */
         end
         if isverbose>0 then say "   ... Extracted image # " trk " from animated gif."
end

/* use rxgdutil to create thumbnail */
  fooo=stream(dafile_use,'c','close')
  im1=rxgdimagecreatefromgif(dafile_use)
  if im1<=1 then do
         if isverbose>0 then say "   ... RXGDUTIL could not read .gif file "
         if dafile_use<>dafile then foo=sysfiledelete(dafile_use)
         return ''            /* couldn't do it */
 end
 if orx>2000 | ory>2000 then do
          if isverbose>0 then say "    ... gif too big "
          yow=rxgdimagedestroy(im1)
          if dafile_use<>dafile then foo=sysfiledelete(dafile_use)
          return ''
 end /* do */
 im2=rxgdimagecreate(x32,y32)        /* write thumbnail to this buffer*/  

 select                            /* scale image .... */
   when how_scale=0 then do         /* just fit */
             tx32=x32 ; ty32=y32
   end 
   when how_scale=1  then do         /* fit to min of image size and thumbnail size */
          TX32=MIN(ORX,X32)
          TY32=MIN(ORY,Y32)
   end
   otherwise do                    /* proportionally scale */
           if x32>orx & y32>ory then do /* image is smaller then thumbnail */
              TX32=MIN(ORX,X32)
              TY32=MIN(ORY,Y32)
           end
           else do
              vvx=orx/x32 ;  vvy=ory/y32 
              vvxy=max(vvx,vvy)
              tx32=min(orx/vvxy,x32); ty32=min(ory/vvxy,y32)
           end
   end
 end
 tx32=max(2,trunc(tx32)) ; ty32=max(trunc(ty32),2)
 foo=rxgdimagecopyresized(im2,im1,0,0,0,0,Tx32,Ty32,orx,ory) /* save using presetsize */
 if tfile="" then tfile=mk_filename(cachedir_use'\'dafile_name,'.GIF',iwasx)
 if tfile<>'' then parse var tfile tfile iwasx
 wow=rxgdimagegif(im2,tfile) 
 nautos=nautos+1
 yow=rxgdimagedestroy(im1); yow=rxgdimagedestroy(im2)
 if isverbose>0  then say "   ... Thumbnail Created from .GIF : " dafile
 if dafile_use<>dafile then foo=sysfiledelete(dafile_use)
 return 1


/**********************/
/* do ea2gif, watch for errors */
do_ea2gif:procedure expose standalone gls. cmds. isverbose
parse arg dafile,tfile,isverbose
signal on syntax name boogz
signal on error name boogz
foo=stream(dafile,'c','close')
if isverbose>1 then do
         address cmd '   EA2GIF 'dafile  ' ' tfile  '  Q '
end
else do
         address cmd '@EA2GIF 'dafile  ' ' tfile ' Q >> nul ' 
end

if isverbose>0 then    say "   .. got .ICON ea "

signal on syntax name ayikes
signal on error name ayikes

return 1

boogz:          /* here if problem, usually in ea2gif */
signal on syntax name ayikes
signal on error name ayikes
return 0




/******/
/* return 1 if .GIF file */
is_a_gif:procedure expose isverbose gls.
parse upper arg afile,gexts
      fii=lastpos('.' ,afile);daext=strip(substr(afile,fii+1))
      if wordpos(daext,gexts)=0 then return 0
/* check that the size is not insane (which might signal unreadable by rxgdutil */

      asize=get_image_dimensions(afile)
      if isverbose>0 then say '   .. 'afile "    Size of .GIF=" asize
      if asize='' then return 0
      parse var asize aw ah
      if aw>1400 | ah > 1400 then return 0      /* too big */
      return  1

/***********/
/* check filestamp of dafile against dastamp 
return
0=ok
1=no such dafile
2=mismatch in timestamp */
date_match:procedure expose gls. 
parse arg dafile,dastamp
dastamp=strip(dastamp)
  aa=sysfiletree(dafile,yowk,'TF')
  if yowk.0=0 then return '1'
  parse var yowk.1 datestamp .  ; datestamp=strip(datestamp)
  if dastamp<>datestamp then return '2'
  return 0


/**************************/
/* create unused file name, numbered from 1....*/
mk_filename:procedure expose gls.
parse arg aname,aext,mm0

/* exact match? */
if stream(aname||aext,'c','query exists')="" then  return aname||aext

domm0=0
if mm0<>'' then domm0=1

if mm0='' | datatype(MM0)<>'NUM' then mm0=0
f1=aname||'9999'||aext

do mm=mm0+1 to 9999
    f1=aname||mm||aext
    if stream(f1,'c','query exists')="" then do
      if domm0=0 then  
            return f1       
      else 
          return f1' 'mm
    end
end /* do */

if domm0=0 then 
  return f1       /* use name9999.ext in a pinch */
else 
  return f1' 'mm


/* See if directory exists , 0=no 1=yes*/
dir_exists:procedure expose gls.

parse upper arg lookfor
lookfor=strip(lookfor,'t','\')

adrive=filespec('d',lookfor)       /* does drive exist? */
if adrive<>"" then do
  oo2=sysdrivemap(,'used')
  if pos(translate(adrive),translate(oo2))=0 then return 0   /* no such drive */
end
eek=lastpos('\',lookfor)
if eek>0 then do
  lookfor1=substr(lookfor,eek+1)
  foo=delstr(lookfor,eek)
end
else do
   return 1       /* it's a root dir */
end /* do */
foo=foo'\*.*'
aa=sysfiletree(foo,'eek','DO')
do mm=1 to eek.0
   if translate(filespec('n',eek.mm))=lookfor1 then do 
       return 1
   end /* do */
end /* do */
return 0


/************************/
/* Do a multi wild card match -- return stats on match
   Stats are list of letter positions (in needle) that are matched
   Or, -1 for "exact match"
   OR, 0 for "no match"
Example: Needle="THIS/IS/VERY/SILLY"
        haystack="THIS*VERY*"
        would yield: 1 2 3 4 9 10 11 12
 One can then compare this result list to other result lists (to ascertain
 best match */


wild_match:procedure 
parse upper arg needle, haystack ; haystack=strip(haystack)
needle=strip(needle)

if needle=haystack then return -1        /* -1 signals exact match */
ast1=pos('*',haystack)
if ast1=0 then return 0                 /* 0 means no match */
if haystack='*' then  do
   if length(needle)=0 then 
       return 100000
    else 
        return length(needle)
end
ff=haystack
ii=0
do until ff=""
  ii=ii+1
  parse var ff hw.ii '*'  ff
  hw.ii=strip(hw.ii)
end
if hw.ii='' then ii=ii-1
hw.0=ii


/* check each component of haystackw against needle -- all components
must be there */

resu=' '
istart=1 ; ido=2
if ast1>1 then do       /* first check abbrev */
  if abbrev(needle,hw.1)=0 then return 0
  aresu=length(hw.1)
  if hw.0=1 then do
     do nm=1 to aresu
        resu=resu||' '||nm
     end /* do */
     return resu         /* if haystacy of form abc*, we have a match */
  end
  ido=2 ; istart=aresu+1
  do mm=1 to aresu
        resu=resu||' '||mm
  end /* do */
end
/* if here, then first part (a non wildcard) of haystack matches first
part of needle
Now check sequentially that each remaining part also exists
*/
do mm=ido to hw.0
  igoo=pos(hw.mm,needle,istart)
  if igoo=0 then return 0
  tres=length(hw.mm)
  istart=igoo+tres
  do nn=igoo to (istart-1)
     resu=resu||' '||nn
  end /* do */
end
if istart >= length(needle) | right(haystack,1)='*' then
   return resu
return 0



/**********************/
/* load dlls and other stuff */
load_dlls:
signal on syntax name ayikes ;     signal on error name ayikes 
signal on halt name ayikes ;  signal on failure name ayikes 


gls.=''

crlf='0d0a'x
foo=rxfuncquery('rxgdloadfuncs')
if foo=1 then do
  Call RxFuncAdd 'RxgdLoadFuncs', 'RXGDUTIL', 'RxgdLoadFuncs'
  Call RxgdLoadFuncs
end
foo=rxfuncquery('rxgdloadfuncs')
if foo=1 then do
    say " Could not find RXGDUTIL "
    exit
end /* do */

/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end

foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
    say " Could not find REXXLIB "
    exit
end /* do */

if rxfuncquery('sref_filewrite')<>0 then do
  ik=rxfuncadd('sref_filewrite','rexxlib','LIB_FILEWRITE')
  if ik<>0 then call pmprintf('!! SRE-http Monitor WARNING: unable to register SREF_FILEWRITE')
end

resize_thing='<form name="DIMS">'
resize_thing=resize_thing||crlf||'<table>'
resize_thing=resize_thing||crlf||'<tr>'

resize_thing=resize_thing||crlf||'<Td><nobr>'
resize_thing=resize_thing||crlf||'<a name="checksnap"><input type="checkbox" name="do_snap" '
resize_thing=resize_thing||crlf||'  onClick="dosnap=1-dosnap; return true">'
resize_thing=resize_thing||crlf||' Display</a></nobr> <b>snapshot</b> <em>(VGA quality)</em>'
resize_thing=resize_thing||crlf||' version of selected photos </td>'

resize_thing=resize_thing||crlf||'<td><em>Resize images? </em><br>'
resize_thing=resize_thing||crlf||'<select name="RESIZE" size=2>'
resize_thing=resize_thing||crlf||'<option value=1.0 selected>Do not resize (100%)'
resize_thing=resize_thing||crlf||'<option value=0.20>20%'
resize_thing=resize_thing||crlf||'<option value=0.33>33%'
resize_thing=resize_thing||crlf||'<option value=0.50>50%'
resize_thing=resize_thing||crlf||'<option value=0.66>66%'
resize_thing=resize_thing||crlf||'<option value=1.00>100%'
resize_thing=resize_thing||crlf||'<option value=1.33>133%'
resize_thing=resize_thing||crlf||'<option value=1.66>166%'
resize_thing=resize_thing||crlf||'<option value=2.0>200%'
resize_thing=resize_thing||crlf||'<option value=2.5>250%'
resize_thing=resize_thing||crlf||'</select>'
resize_thing=resize_thing||crlf||'<td>'


resize_thing=resize_thing||crlf||'<a href="javascript:redisp()">(Re)display image # </a>'
resize_thing=resize_thing||crlf||'<input type="text" name="CIMAGE" value="1"><br>'
resize_thing=resize_thing||crlf||'<a href="javascript:do1(''NEXT'')">Next image</a> ||'
resize_thing=resize_thing||crlf||'<a href="javascript:do1(''PRIOR'')">Prior image</a>'

resize_thing=resize_thing||crlf||'</table><table>'

resize_thing=resize_thing||crlf||'<tr bgcolor='bgs.1'><td><input type="checkbox" name="SLIDESHOW"'
resize_thing=resize_thing||crlf||'  onClick=" '
resize_thing=resize_thing||crlf||'    do1b(parseInt(this.form.SLIDE1.value),parseInt(this.form.SLIDE2.value));'
resize_thing=resize_thing||crlf||' return true">  '
resize_thing=resize_thing||crlf||'  '
resize_thing=resize_thing||crlf||'Display images as a slideshow<br><em>Check to start, uncheck to stop</em>'
resize_thing=resize_thing||crlf||'<td>First image: <input size=5 type="text" name="SLIDE1" value=1> '
resize_thing=resize_thing||crlf||'<br>Last image: <input size=5 type="text" name="SLIDE2" value=10> '
resize_thing=resize_thing||crlf||'<td>Pause (in seconds) between slides: <input size=5 type="text" name="SLIDED" value=5> '

resize_thing=resize_thing||crlf||'  '
resize_thing=resize_thing||crlf||'  '
resize_thing=resize_thing||crlf||'  '

resize_thing=resize_thing||crlf||'</table>'
resize_thing=resize_thing||crlf||'</form>'
resize_thing=resize_thing||crlf||'<script> document.DIMS.SLIDE2.value=totimgs</script>  '

if basedir='' then basedir=directory()

if gbm_dir='' then gbm_dir=basedir
gbm_dir=strip(strip(gbm_dir),,'\')
if right(gbm_dir,1)=':' then gbm_dir=gbm_dir||'\'
if dosisdir(gbm_dir)=0 then do
   say "Error: bad GBM directory= "gbm_Dir
   exit
end 


/* look for GBM programs */
gbm_hdr=strip(gbm_dir,'t','\')||'\'||'GBMHDR'
gbm_hdr=doscommandfind(GBM_HDR)
if gbm_hdr='' then do
  gbm_hdr=doscommandfind('GBMHDR')
  if gbm_hdr='' then do            /* check gbmdir */
      say "WARNING: could not find GBMHDR (graphics conversion) programs."
      say  'You may wish to change the GBM_DIR ('gbm_dir
   end
end 
gls.!gbm_hdr=gbm_hdr

gbm_bpp=strip(gbm_dir,'t','\')||'\GBMBPP'
gbm_bpp=doscommandfind(GBM_BPP)
if gbm_bpp='' then do
  gbm_bpp=doscommandfind('GBMBPP')
  if gbm_bpp='' then do            /* check gbmdir */
      say "WARNING: could not find GBMBPP (graphics conversion) programs."
      say  'You may wish to change the GBM_DIR ('gbm_dir
   end
end 
gls.!gbm_bpp=gbm_bpp

gbm_size=strip(gbm_dir,'t','\')||'\GBMsize'
gbm_size=doscommandfind(GBM_size)
if gbm_size='' then do
  gbm_size=doscommandfind('GBMsize')
  if gbm_size='' then do            /* check gbmdir */
      say "WARNING: could not find GBMsize (graphics conversion) programs."
      say  'You may wish to change the GBM_DIR ('gbm_dir
   end
end 
foo=lastpos('.',gbm_size)
if foo>0 then
  gls.!gbm_size=left(gbm_size,foo-1)
else
  gls.!gbm_size=gbm_size


 aesc='1B'x
 cy_ye=aesc||'[37;46;m'
 normal=aesc||'[0;m'
 bold=aesc||'[1;m'
 re_wh=aesc||'[31;47;m'
 reverse=aesc||'[7;m'


return 1



/*********************/
/* sort suclist array. Use arraysort if available, otherwise indx_sort */
arraysort2:procedure expose suclist. 
parse arg tfile,tfile1,tfile2

if rxfuncquery('arraysort')=0 then do
   foo=arraysort(suclist)
   return foo
end /* do */

/* no arraysort -- use the SORT program */
do mm=1 to suclist.0
   call lineout tfile1,suclist.mm
end /* do */
call lineout tfile1

address cmd '@SORT < 'tfile1 '> ' tfile2
if rc<>0 then do
   say " Error in SORT routine (probably the index is too big) "
   say " Try making few thumbnails; or, get REXXLIB (it has a better sorter)"
   exit
end /* do */
do mm=1 to suclist.0
   suclist.mm=linein(tfile2)
end /* do */
foo=sysfiledelete(tfile1)
foo=sysfiledelete(tfile2)
return 1


/***************************/
/* read image dimensions; for gif, bmp, jpeg, png, and pcx files */
get_image_dimensions:procedure expose gls.
parse upper arg filename

foo=lastpos('.',filename)
if foo=0 then return ' '
anext=substr(filename,foo+1)
signal on error name nosuch ; signal on syntax name nosuch
select
   when abbrev(anext,'GIF')=1 then eek=gif_info(filename,'S') 
   when anext='JPG' | anext='JPEG' then eek=litjpg(filename)
   when anext='BMP'  then eek=litbmp(filename)
   when anext='PNG' then eek=litpng(filename)
   when anext='PCX' then eek=litpcx(filename)
   otherwise eek=''
end  /* select */
signal off error ; signal off syntax 
return eek

nosuch:
signal off error ; signal off syntax 
return ''

/*********************************************************************
Adapted from the GRFXREXX package
 (available at http://hobbes.nmsu.edu ); they were written by Raphal Vanney, 09/95

 The purpose of this REXX program is to get information from a BMP file.
 There's of course no waranty of any kind associated to it. Use freely.
**********************************************************************/

litbmp:procedure
Parse Arg FName
Drop BMP.

If FName="" Then Return " "

/* read file header */

aa=CharIn(FName, 1, 2)
Hdr=C2D(Reverse(aa))             /* type */
BMP.fsize=C2D(Reverse(CharIn(FName, , 4)))        /* which size ? */
BMP.rsv=C2D(Reverse(CharIn(FName, , 4)))          /* should be 0 */

If (Hdr<>19778) | (BMP.rsv<>0) Then return ' '

BMP.offbits=C2D(Reverse(CharIn(FName, , 4)))
BMP.isize=C2D(Reverse(CharIn(FName, , 4)))
BMP.width=C2D(Reverse(CharIn(FName, , 4)))        /* bitmap width */
BMP.height=C2D(Reverse(CharIn(FName, , 4)))       /* bitmap height */

Return BMP.width||"  "||BMP.height



/*********************************************************************
 LitJPEG - Raphal Vanney, 09/95

 The purpose of this REXX program is to get information from a JPEG
 file. There's of course no waranty of any kind associated to it. Use
 freely.
**********************************************************************/

litjpg:procedure
Parse Arg FName
Drop JPEG.

If FName="" Then Return " "

/* read file header */

Hdr=C2X(CharIn(FName, 1, 2))

If Hdr<>"FFD8" Then Return " "

NxtSeg=3
Do While (Seg.Type<>"D9") & (NxtSeg<>-1) & (JPEG.height="JPEG.HEIGHT")
     NxtSeg=LitSegment(NxtSeg)
End

Drop Hdr NxtSeg Seg. Res FName

If JPEG.height<>"JPEG.HEIGHT" then 
  Return JPEG.width||"  "||JPEG.height
Else
  Return " "

LitSegment:         /* reads a JPEG segment's header from the input file */
Arg SegPos

Seg.marker=C2X(CharIn(FName, SegPos))
If Seg.marker<>"FF" Then
Do
     Return -1
End
Seg.Type=C2X(CharIn(FName))
Res=SegPos+2                  /* position of next segment */
If (Seg.Type="01") | ((Seg.Type>="D0") & (Seg.Type<="D9")) Then
Do   /* these segments contain no data nor length info */
     Seg.Len=0
End
Else
Do
     Seg.Len=C2D(CharIn(FName, , 2))
End
Res=Res+Seg.Len

If (Seg.Type="C0") | (Seg.Type="C2") Then
Do
     /* start of frame 0 */
     JPEG.bps=C2D(CharIn(FName))             /* bits per sample */
     JPEG.height=C2D(CharIn(FName, , 2))
     JPEG.width=C2D(CharIn(FName, , 2))
End

Return Res

/*********************************************************************
 LitPCX - Raphal Vanney, 09/95

 The purpose of this REXX program is to get information from a PCX file.
 There's of course no waranty of any kind associated to it. Use freely.
**********************************************************************/
litpcx:procedure
Parse Arg FName
Drop PCX.

If FName="" Then Return " "

/* read file header */

Hdr=C2D(CharIn(FName, 1))                    /* manufacturer */
PCX.version=C2D(CharIn(FName))               /* PaintBrush version */
PCX.comp=C2D(CharIn(FName))                  /* encoding (1=RLL) */
PCX.bits=C2D(CharIn(FName))                  /* bits per pixel */
PCX.xmin=C2D(Reverse(CharIn(FName, , 2)))
PCX.ymin=C2D(Reverse(CharIn(FName, , 2)))
PCX.xmax=C2D(Reverse(CharIn(FName, , 2)))
PCX.ymax=C2D(Reverse(CharIn(FName, , 2)))
PCX.width=PCX.xmax-PCX.xmin+1
PCX.height=PCX.ymax-PCX.ymin+1

Return PCX.width||"   "||PCX.height

/*********************************************************************
 LitPNG - Raphal Vanney, 09/95

 The purpose of this REXX program is to get information from a PNG file.
 There's of course no waranty of any kind associated to it. Use freely.
**********************************************************************/
litPng:procedure
Parse Arg FName
Drop PNG.

If FName="" Then Return " "

/* read file header */

Hdr=CharIn(FName, 1, 8)
If Hdr<>(D2C(137)||"PNG"||D2C(13)||D2C(10)||D2C(26)||D2C(10)) Then
     Return " "

NxtSeg=9
Do While (Seg.Type<>"IEND") & (NxtSeg<>-1) & (PNG.height="PNG.HEIGHT")
     NxtSeg=LitSegment(NxtSeg)
End

Drop Hdr NxtSeg Seg. Res FName
          
If PNG.height<>"PNG.HEIGHT" Then 
  Return PNG.width||"  "||PNG.height
Else
  Return " "

LitSegment:         /* reads a PNG chunk's header from the input file */
Arg SegPos

Seg.len=C2D(CharIn(FName, SegPos, 4))   /* length of chunk's DATA */
Seg.type=CharIn(FName, , 4)             /* chunk type */
Res=SegPos+12+Seg.len                   /* position of next chunk */

If Seg.type="IHDR" Then
Do
     /* header chunk */
     PNG.width=C2D(CharIn(FName, , 4))
     PNG.height=C2D(CharIn(FName, , 4))

Return Res


/************************************************/
/* procedure from TEST-CGI.CMD by  Frankie Fan <kfan@netcom.com>  7/11/94 */
DecodeKeyVal: procedure
  parse arg Code
  Text=''
  Code=translate(Code, ' ', '+')
  rest='%'
  do while (rest\='')
     Parse var Code T '%' rest
     Text=Text || T
     if (rest\='' ) then
      do
        ch = left( rest,2)
        if verify(ch,'01234567890ABCDEF')=0 then
           c=X2C(ch)
        else
           c=ch
        Text=Text || c
        Code=substr( rest, 3)
      end
  end
  return Text


/**********/
/* script into bigpicture/imagemap index */
make_bigpic0:
call outit '<script language="javascript">'
call outit 'var da1=0 ; var oldia=-1 ; var oldwid=0 ; '
call outit ' var oldhei=0 ; var oldidate=0 ; var oldtxt=0 ;'
call outit 'var curimg=''none chosen'' ;'
call outit ' dosnap=0 ; '
call outit ' lastshown=0;'
if  opts.!MAKESNAP=1 then
  call outit 'no_snaps=0 ;'
else
  call outit 'no_snaps=1 ;'

call outit ' '

call outit '// recursive function for slideshows '
call outit 'function do1b(todo,endat) {'
call outit 'if (todo>endat || document.DIMS.SLIDESHOW.checked==false)'
call outit '    { status=''SlideShow is over.'';return true}'
call outit ' status=''Displaying image #''+todo+'' of ''+endat;'
call outit ' do1(todo-1); // images indexed from 0 to N-1 '
call outit ' ipause=1000*parseInt(document.DIMS.SLIDED.value);'
call outit ' todo=todo+1 ; if (todo>endat) {ipause=1}'
call outit ' setTimeout(''do1b(''+todo+'',''+endat+'')'',ipause)'
call outit '}'

call outit '// this function opens a window for image display '
call outit 'function do1(ia) {'

call outit 'if (ia=="NEXT") {ia=lastshown+1} ;'
call outit 'if (ia=="PRIOR") {ia=lastshown-1} ;'
call outit 'ia=Math.min(ia,totimgs-1) ;'
call outit 'ia=Math.max(0,ia);'
call outit 'lastshown=ia;'

call outit 'var atmp=apics[ia].split('' '')' ;
call outit '  var a=atmp[0] ; var wid=atmp[1] ; var hei=atmp[2]; var idate=atmp[3];'
call outit '  var txt='' ''; '

call outit 'for (var coo=4 ; coo < atmp.length ; coo++) '
call outit '   { txt=txt+atmp[coo]+'' ''} '

call outit '// check for SNP (snapshot)'

call outit 'dosnapuse=dosnap ;'
call outit 'if (dosnap==1 & no_snaps==1 )'
call outit ' { window.alert(''Sorry, snapshots for these images are not currently available''); dosnapuse=0;}'

call outit ' '
call outit 'if (dosnapuse==1)'
call outit '{'
call outit 'aparts=a.split(''/'');'
call outit 'aparts[aparts.length-1]=''SNPS/SNP_''+aparts[aparts.length-1] ;'
call outit 'newp=aparts[1] ;'
call outit 'for (var igoo=2 ; igoo<aparts.length ; igoo++)'
call outit '  {newp=newp+''/''+aparts[igoo] }'
call outit 'a=newp;'
call outit '}'

if wordpos(cmds.!NOT_HTTP,'1 2')=0 | standalone=0 then
  call outit 'var aurl=''http://''+location.hostname+''/''+a'
else
  call outit 'var aurl=a'
call outit 'var vda1=a.split(''/'');'
call outit 'var vda1a=vda1[vda1.length-1];' 
call outit 'if (txt==0) {txt=a};'
call outit 'oldia=ia ;'

call outit 'if (da1==1) {'
call outit '  if (daVIEW2.closed) {da1=0} ;'
call outit '};'
call outit 'if (da1==0) {'
call outit ' daVIEW2=window.open("","FILE_VIEWER","location=no,menubar=no,status=yes,resizable,dependent,scrollbars=yes,titlebar,toolbar=no,screenx=262,screeny=30,height=322,width=442");'
call outit ' da1=1'
call outit '};'                                   
call outit 'daVIEW2.document.open("text/html");'
call outit 'daVIEW2.document.writeln("<html><head><title>"+txt+"<\/title>");'
call outit 'daVIEW2.document.writeln("<\/head>");'

call outit 'daVIEW2.document.writeln(''<body onLoad="self.status=\'' ''+txt+'' \''";>'');'

call outit 'afact=1;v=300;'
call outit 'if (self.document.forms.length>0){' 
call outit '  ii=self.document.DIMS.RESIZE.options.selectedIndex;'
call outit '  afact=self.document.DIMS.RESIZE.options[ii].value ;'
call outit '  vv=afact*hei;'
call outit '  v=Math.ceil(vv);}'
call outit 'if (v>255){'
call outit 'daVIEW2.document.writeln(''<a href="javascript:self.scrollTo(0,2300)'');'
call outit 'daVIEW2.document.writeln(''" onMouseOver="self.status=\''Image info, and more options\'' ; return true">?<\/a>'') ;'
call outit 'daVIEW2.document.writeln('' &nbsp; &nbsp; <a href="javascript:history.go(-1)" onMouseOver="self.status=\''Prior image\''; return true">&laquo;</a> '');'
call outit 'daVIEW2.document.writeln('' &nbsp; &nbsp; <a href="javascript:history.go(+1)" onMouseOver="self.status=\''Next image \''; return true">&raquo;</a><br> '');'
call outit '}'

call outit 'daVIEW2.document.writeln(''<a href="recenter..." onMouseover="status=\''Click to scroll image... \''; return true" onMouseOut="status=\'' ''+txt+'' \'' ; return true;"'');'
call outit 'daVIEW2.document.writeln(''onClick="sx=event.pageX-self.pageXOffset ;sy=event.pageY-self.pageYOffset;'');'
call outit 'daVIEW2.document.writeln('' if (sx<5 && sy<5) { '');'
call outit 'daVIEW2.document.writeln('' self.scrollTo(1,1)} '');'

call outit 'daVIEW2.document.writeln('' else{   dx=sx-(self.innerWidth/2) ; dy=sy-(self.innerHeight/2);'');'
call outit 'daVIEW2.document.writeln(''    self.scrollBy(dx,dy)}'');'
call outit 'daVIEW2.document.writeln(''    return false;"'');'
call outit 'daVIEW2.document.writeln(''>'');'

call outit 'daVIEW2.document.writeln(''<img src="''+aurl+''"'');'

call outit 'if (dosnapuse==1)'
call outit ' {daVIEW2.document.writeln(''alt=''+''"''+''(Low res snapshot of ''+txt+''"'')}'
call outit 'else '
call outit '  {daVIEW2.document.writeln(''alt="''+txt+''"'') };'

call outit 'if (self.document.forms.length>0){'
call outit 'ii=self.document.DIMS.RESIZE.options.selectedIndex;'

call outit 'if (dosnapuse==1)'
call outit '  {wid0=640}'
call outit 'else'
call outit '  {wid0=wid}'

call outit 'vv=self.document.DIMS.RESIZE.options[ii].value*wid0 ;'
call outit 'v=Math.ceil(vv);'
call outit 'daVIEW2.document.writeln(''width=''+v);'
call outit '}'

call outit 'if (self.document.forms.length>0){'
call outit 'ii=self.document.DIMS.RESIZE.options.selectedIndex;'

call outit 'vv=self.document.DIMS.RESIZE.options[ii].value*hei ;'
call outit 'v=Math.ceil(vv);'
call outit 'if (dosnapuse!=1)'
call outit ' {daVIEW2.document.writeln(''height=''+v)}'
call outit '}'

call outit 'daVIEW2.document.writeln(''>'');'
call outit 'daVIEW2.document.writeln(''</a>'');'

call outit 'daVIEW2.document.writeln(''<hr><a name="bot">'');'

call outit 'v=100;if (self.document.forms.length>0){'
call outit 'vv=self.document.DIMS.RESIZE.options[ii].value*10000 ;'
call outit 'v=Math.ceil(vv)/100 };'

call outit 'if (dosnapuse==1)'
call outit '   {daVIEW2.document.write(''<nobr>(Low-res snapshot of) image size=<tt>''+wid+''x''+hei+''h'');}'
call outit 'else '
call outit '   {daVIEW2.document.write(''<nobr>Image size=<tt>''+wid+''x''+hei+''h'');}'

call outit 'if (v!=100){daVIEW2.document.write('' <em> ''+v+''% </em> '')}'
call outit 'daVIEW2.document.writeln('', date=<tt>''+idate+''</tt> </nobr>'');'
call outit 'daVIEW2.document.writeln(''</a>'');'
call outit 'daVIEW2.document.writeln(''<font size=-1><br> &nbsp;<a href="javascript:history.go(-1)">Back</a> '');'
call outit 'daVIEW2.document.writeln('' &nbsp; &nbsp; <a href="javascript:history.go(+1)">Forward</a> '');'
call outit 'daVIEW2.document.writeln('' &nbsp; &nbsp; <a href="javascript:self.opener.parent.document.DIMS.RESIZE.focus()">ReSize</a> '');'
call outit 'daVIEW2.document.writeln('' &nbsp; &nbsp; <a href="javascript:close()">Close</a> </font>'');'


call outit 'daVIEW2.document.writeln("</body></html>")'
call outit 'daVIEW2.document.close() ;'
call outit 'self.document.DIMS.CIMAGE.value=vda1a;'
call outit 'self.document.DIMS.CIMAGE.value= (1+ia) +'' (''+ vda1a+ '')''; '
call outit 'daVIEW2.focus();'
call outit '}'
call outit ' '
call outit '// redisplay most recently displayed image'
call outit 'function redisp() {'
call outit 'gob2=parseInt(self.document.DIMS.CIMAGE.value);'
call outit 'if (isNaN(gob2)==false) {'
call outit '    if (oldia<0) '
call outit '        {alert(''Please select an image! '')}'
call outit '    else '
call outit '        {do1(gob2-1)}'
call outit '}'
call outit 'else'
call outit '  {do1(oldia)}'
call outit '} // end of redisp'
call outit ' '
call outit '</script>'
return 0


/*****************/
/* make big pictures out of thumbnails*/
make_bigpicture:
parse arg cdir2
text_bcolor='888888'
r_back=x2d(substr(text_bcolor,1,2))
G_back=x2d(substr(text_bcolor,3,2))
b_back=x2d(substr(text_bcolor,5,2))

ifnd=0

/* find & store all valid entries in the thumbnail index */
 call get_good_entries         /* find and store, in gotlist, good entries */

/* now, create the big picture(s) */
/* max width is 555 pixels. Use 12 x 12 if possible. If not (due
   to 12 * (x32+5) >  555, use small # of pictures per row.
*/
  newwid=x32+3
  if datatype(opts.!big_col)='NUM' & opts.!big_col<>0 & opts.!big_col<>'' then do /* explicit takes priority */
       docols=opts.!big_col
  end
  else do                       /* try 10 columns */
      if newwid>trunc(555/10) then 
        docols=trunc(555/newwid)
      else
        docols=10
  end

immes=rxgdimagecreate(120,11)  /* filename buffer */
jcc0=rxgdimagecolorallocate(immes,r_back,g_back,b_back)

ff=rxgdimagefilledrectangle(immes,0,0,119,10,jcc0)
jcc1=rxgdimagecolorallocate(immes,r_text,g_text,b_text)

/* now figure max rows -- pixels of 550 */
newht=y32+12
if datatype(opts.!big_row)='NUM' & opts.!big_row<>0 & opts.!big_row<>'' then do /* explicit takes priority */
       dorows=opts.!big_row
end
else do
   if newht>42 then
      dorows=trunc(420/newht)
   else
     dorows=10
end

/* place docols x dorows  images into imbuf */
  idid=0 ; ng1=1 ; maxaname=1
  do kk=1 to gotlist.0
      if idid=0 then do
           call make_empty_image    /* for filling with thumbnails */
      end 
      idid=idid+1
      im1=rxgdimagecreatefromgif(gotlist.kk.2)
      isx=rxgdimagesx(im1); isy=rxgdimagesy(im1)
      aname=filespec('n',gotlist.kk.1)
      maxaname=max(length(aname),maxaname)

      irow=trunc((idid-0.01)/docols) ; icol=idid-(irow*docols) 
      yat=irow*(y32+12)  ; xat=(icol-1)*newwid
      yow=rxgdimagecopyresized(imbuf,im1,xat,yat,0,0,x32,y32,isx,isy)
      gotlist.kk.!l=xat ; gotlist.kk.!u=yat
      gotlist.kk.!r=xat+x32 ; gotlist.kk.!b=yat+newht-1

     foo=rxgdimagedestroy(im1)  


     select
        when opts.!thumbtext='!NONE' then  damess=''
        when opts.!thumbtext='!DATE' then damess=left(gotlist.kk.!date,8)
        when opts.!thumbtext='!SIZE' then damess=gotlist.kk.!mess
        when opts.!thumbtext='!NAME' then damess=aname
        otherwise damess=opts.!thumbtext
     end  /* select */

     if damess<>'' then do
       ff=rxgdimagefilledrectangle(immes,0,0,119,11,jcc0)  /* clear it */
       foo=rxgdimagestring(immes,'T',1,1,damess,jcc1)  /* name into temp buffer */
       messwid=trunc(maxaname*5.7) ; mw1=messwid; mw2=messwid
       if messwid>x32 then do
           mw1=x32 ; mw2=x32
       end /* do */
       yow=rxgdimagecopyresized(imbuf,immes,xat,yat+y32,0,0,mw1,11,mw2,11)
     end
    if kk=gotlist.0 | idid=docols*dorows then do /* done, or filled up */
         bigit=mk_filename(cdir2||'\BIG','.GIF')
         foo=rxgdimagegif(imbuf,bigit)
         foo=rxgdimagedestroy(imbuf)  
         call outit ' '
         call outit ' <!-- Thumbnails ' ng1 ' to ' kk ' (stored in  ' bigit ' -->'

         aa=strip(thumbnail_dir_sel,,'/')   /* display the bigit image */
         if cmds.!NOT_HTTP=2 & standalone=1 then
            aa=translate(substr(bigit,length(cachedir)+2),'/','\')
          else
            aa='/'aa'/'||translate(substr(bigit,length(cachedir)+2),'/','\')
         imgmapname=filespec('N',bigit) ; a1=lastpos('.',imgmapname)
         imgmapname=delstr(imgmapname,a1)
         if cmds.!NOT_HTTP=2 & standalone=1 then
           call outit '<img src="thumindx/'aa'" usemap="#'imgmapname'"> <p>'
         else
           call outit '<img src="'aa'" usemap="#'imgmapname'"> <p>'
         call make_clientmap 
         idid=0 ; ng1=kk+1 ; maxaname=1
    end         

   end          /* the gotlist */

 foo=rxgdimagedestroy(immes)

if bigpicture<>1 then return 1

/* else, create array with image info in it */
call outit ' <script language="javascript">'
call outit' apics = new Array() '

do mm=1 to gotlist.0
   iarf=mm-1

   parse var gotlist.mm.!mess wid 'x' hei 'h' .
   if datatype(wid)<>'NUM' then wid=640
   if datatype(hei)<>'NUM' then hei=480   /* assume vga */
   ddate=gotlist.mm.!date

   if gotlist.mm.!Imess.1=0 then
        txt='0'
   else
       txt=gotlist.mm.!imess
   call outit 'apics['||iarf||']="'||gotlist.mm.3||' 'wid' 'hei' 'ddate' 'txt||'"'
end 
call outit 'var totimgs='gotlist.0 
call outit '</script>'

return 1


/* make a clientmap, using info in gotlist */
make_clientmap:
call outit ' '
call outit '<map name="'imgmapname'">'

/* either use fancy javascript, or simple target
   depending value of bigpicture */


do tm=ng1 to kk
   clist=gotlist.tm.!l','gotlist.tm.!u','gotlist.tm.!r','gotlist.tm.!b
   isalt=gotlist.tm.!imess
   parse var gotlist.tm.!mess wid 'x' hei 'h' .
   if datatype(wid)<>'NUM' then wid=640
   if datatype(hei)<>'NUM' then hei=480   /* assume vga */
   ddate=gotlist.tm.!date

   ddate=overlay(' ',ddate,9,1)
   ddate=overlay(':',ddate,12,1)
   select
     when left(ddate,2)<80 then  ddate='20'||ddate
     when left(ddate,2)<100 then ddate='19'||ddate
     otherwise ddate=ddate
  end

   qdate="'"||ddate||"'"

   qalt="'"||isalt||"'"

   if bigpicture=1 then do
     ahref=' '
     tm0=tm-1
     vuin='0d0a'x||'onclick="do1('||tm0||') ; return false ;" '
   end
   if bigpicture=2 then do
        vuin=' target="VIEWER" '
        ahref=gotlist.tm.3
   end 

   call outit '<area shape="rect" coords="'clist'" href="'||ahref||'" '||vuin||' ALT="'||isalt||'" >'
end /* do */
call outit '<area shape="default" nohref>    '
call outit '</map> '

return 1


/* make an image buffer */
make_empty_image:

/* if gotlist.0-kk > dorows*docols, then make full height box
   else, make non-full height */
  isfoo=1+gotlist.0-kk 
  if isfoo>=(docols*dorows) then do
      foorows=dorows
  end /* do */
  else do
      foorows=trunc(0.999+(isfoo/docols))
  end /* do */

  wbufsize=newwid*docols
  hbufsize=newht*foorows
  imbuf=rxgdimagecreate(wbufsize,hbufsize)
  icc0=rxgdimagecolorallocate(imbuf,r_back,g_back,b_back)
  ff=rxgdimagefilledrectangle(imbuf,0,0,wbufsize-1,hbufsize-1,icc0)
  icc1=rxgdimagecolorallocate(imbuf,r_text,g_text,b_text)
  return 1
end

/***************/
/*find and store, in gotlist, good entries of those listed in theind index*/
get_good_entries:
  xdasel=strip(dasel,,'/')
  do mm=1 to numrec
     aa=linein(theind)
     parse var aa filename cachename datestamp  amess imess  

     thumbsel=cvt_cachename(cachename)
     thumbsel=strip(translate(space(thumbsel,0),'\','/'),,'\')
     thumbfile=cachedir||'\'||thumbsel

     parse value cvt_filename(filename,dasel,cshlen) with filename selname

     if stream(filename,'c','query exists')='' then iterate
     if stream(thumbfile,'c','query exists')='' then iterate

     ifnd=ifnd+1
     gotlist.ifnd.1=filename ; gotlist.ifnd.2=thumbfile

     selname=strip(translate(substr(filename,cshlen+1),'/','\'),,'/')
     if cmds.!NOT_HTTP=2 & standalone=1 then
        gotlist.ifnd.3=selname
     else
        gotlist.ifnd.3='/'xdasel'/'selname
     if imess=''  then do
        parse value filespec('n',filename) with imess '.' .
        gotlist.ifnd.!imess.1=0
     end      
     gotlist.ifnd.!imess=imess  /* a descripiton */
     
     gotlist.ifnd.!date=datestamp
     gotlist.ifnd.!mess=amess  /* almost always, the size */

  end
  gotlist.0=ifnd

  return 1

dasel
/**********************/
/* GIF_INFO is called as:
     stuff=GIF_INFO(gif_file,infotype)

*/

gif_info:procedure 
parse  arg afile,atype,afilenew
atype=translate(atype)

atype=strip(atype)
dodisp=0
delay=-1

if datatype(atype)='NUM' then do
   getnth=atype ; atype='E'
end /* do */


fqn=stream(afile,'c','query exists')
  if fqn='' then do
    return ''
  end
  fooo=stream(afile,'c','close')
  gifver=charin(fqn,1,6)
  if abbrev(translate(gifver),'GIF8')=0 then  do
     oo=stream(afile,'c','close')
     return -1
  end
  oo=stream(afile,'c','close')
  filesize=chars(fqn)
  ain=charin(fqn,1,filesize)
  oo=stream(afile,'c','close')

gifver=left(ain,6)
if abbrev(translate(gifver),'GIF8')=0 then   return   -1

l1=substr(ain,7,2)
g_width=c2d(reverse(l1))
l2=substr(ain,9,2)
g_height=c2d(reverse(l2))

l3=substr(ain,11,1)
ctable0=x2b(c2x(l3))

global_color_flag=left(ctable0,1)

ct1=right(ctable0,3)
ct1=right(ct1,8,0)
ct1=x2d(b2x(ct1))
numcolors=2**(ct1+1)

iat=13          /* 11 bytes used for intro info */

iat=iat+(3*numcolors)  /* iat is the Last byte used */

section_gc=''
section_image=''
termx='3b'x

if atype='E' then do 
   sect1=substr(ain,1,iat)
end /* do */


desc.1='2c'x ; desc.1.!val='image'
desc.2='21'x ; desc.2.!val='extension'
desc.3='3b'x ; desc.3.!val='trailer'

ext.1='f9'x ; ext.1.!val='graphic control'
ext.2='fe'x ; ext.2.!val='comment'
ext.3='01'x ; ext.3.!val='plain text'
ext.4='ff'x ; ext.4.!val='application'

nimgs=0 ; ngcs=0 ; ncmts=0 ; napps=0 ; nptxts=0

do forever              /* scan the gif file */

if atype='E' & nimgs=getnth then do    /* got nth image -- write and leave */
   goom=sect1||section_gc||section_image||termx
   ff=charout(afilenew,goom,1)
   oo=stream(afilenew,'c','close')
   if ff<>0 then return 0
   return 1
end

/* continue processing */
iat=iat+1       
blockid=substr(ain,iat,1)       /* get next block type */

select

   when blockid='00'x then  ares=0
   when blockid=desc.1 then do  /* it's an image */
      nimgs=nimgs+1
      call do_image
      ares=result
   end /* do */

   when blockid=desc.2 then  do      /* extension */
       iat=iat+1                /* get extention type */
       extype=substr(ain,iat,1)
       select                  
          when extype=ext.1 then do     /*graphics control */
            ngcs=ngcs+1
            call graphics_control
            ares=result
          end
          when extype=ext.3  then do    /*plain text */
              nptxts=nptxts+1
              call plain_text  
              ares=result
          end /* do */
          when extype=ext.2 then do     /*comment */
             ncmts=ncmts+1
             call is_comment
             ares=result
          end
          when extype=ext.4 then do     /* application */
             napps=napps+1
             call application_block
             ares=result
          end /* do */

          otherwise  do
             RETURN  -1
          end
       end      /* extype select */
   end          /* extention descriptor */

   when blockid=desc.3 then do
      leave      /* terminator */
   end
   otherwise do
        return -2
   end
end  /* select */

if ares<0 then return ares

end     /* forever */

/* -------------  package output for return */
select
  
/* basic image-file info */
   when atype='S' then return g_width' 'g_height
   when atype='S2' then return g_width' 'g_height' 'nimgs
   otherwise return 0
end

return ''



/************/
do_image:
iat0=iat
      l1=substr(ain,iat+1,2)
      lcl_left=c2d(reverse(l1))
      l2=substr(ain,iat+3,2)
      lcl_top=c2d(reverse(l2))

      l1=substr(ain,iat+5,2)
      lcl_width=c2d(reverse(l1))
      l2=substr(ain,iat+7,2)
      lcl_height=c2d(reverse(l2))
    
      l3=substr(ain,iat+9,1)
      ctable0=x2b(c2x(l3))
      lcl_ct_flag=left(ctable0,1)
      lcl_interlace=substr(ctable0,2,1)
      t1=right(ctable0,3) ; t1=right(t1,8,0)
      lcl_ct_size=x2d(b2x(t1)) ; lcl_ct_size=2**(lcl_ct_size+1)

       skip=lcl_ct_flag*lcl_ct_size*3

       iat=iat+9+skip    /* iat is now just before the table based image */

/* chew up the data block */
       iat=iat+1        /* skip the lzw bits variable */
       imgsize=chew_data()
       if imgsize<0 then return -6

       if atype='E' then section_image=substr(ain,iat0,(iat-iat0)+1)

       return 1 


/*********/
graphics_control:
iat0=iat-1
       iat=iat+2
       pk=substr(ain,iat,1) ; pk=x2b(c2x(pk))
       tc_flag=right(pk,1)
       iat=iat+1
       tmp=reverse(substr(ain,iat,2)) 
       delay=x2d(c2x(tmp))
       iat=iat+2
       tc_index=x2d(c2x(substr(ain,iat,1)))
       iat=iat+1
       term=x2d(c2x(substr(ain,iat,1)))
       if term<>0 then return -8
       if atype='E' then section_gc=substr(ain,iat0,(iat-iat0)+1)
return 1

/*********/
application_block:
iat=iat+1
app_blocksize=x2d(c2x(substr(ain,iat,1)))
if app_blocksize<>11 then   return -3

iat=iat+1

app_id=substr(ain,iat,8)
iat=iat+8
app_auth=substr(ain,iat,3)
iat=iat+2
appsize=chew_data()
if appsize<0 then return -33

return 1

/***********/
plain_text:
iat=iat+1
app_blocksize=x2d(c2x(substr(ain,iat,1)))
if ptextblocksize<>12 then  return -4

  l1=substr(ain,iat+1,2)
pt_left=c2d(reverse(l1))
  l2=substr(ain,iat+3,2)
pt_top=c2d(reverse(l2))

   l1=substr(ain,iat+5,2)
pt_width=c2d(reverse(l1))
   l2=substr(ain,iat+7,2)
pt_height=c2d(reverse(l2))
iat=iat+4
pt_size=chew_data(1)
if pt_size<0 then return -44
return 1

/*********/
is_comment:
csize=chew_data(1)
if csize<0 then return -7
return 1

/*********/
chew_data:procedure expose iat ain amess filesize
parse arg keep
       totsize=0
       amess=''
       do forever       /* data blocks */
         if iat>filesize then do
             return -5
         end /* do */
         iat=iat+1      /* size of block */
         ii=substr(ain,iat,1) ; ii=c2d(ii)
         if ii=0 then do 
             leave
         end /* do */
         iat=iat+1
         if keep<>0 then amess=amess||substr(ain,iat,ii)
         totsize=totsize+ii
         iat=iat+ii-1
       end /* do */
   return totsize

/* 'FILE or SREF_GOS */
gofile:procedure
parse arg afile

aa=value('SREF_PREFIX',,'os2environment')
if aa='' then 
  afile
else
  foo=sref_gos(afile)

return 0

/***************/
/* use GBM programs to make thumbnails of a variety of graphics types
 3 steps:
1) make sure the file is a graphics file (GBMHDR)
2) convert to gif (GBMBPP) 
3) shrink to thumbnail size (GBMSIZE) 
Arguments are:
   infile,thumbfile,wid,hei,colors

infile: fully qualified name of file to make thumbnail of 
thumbfile: fully qualified name of thumbnail file (to create)
wid,hei: Optional -- the width and height of the thumbnail. If not
                 specified, 64x64 is used
colors: Optional -- color depth of the thumbnail. If not specified, 164 is used.

Return 1 if success,  error message if failure
orx and ory are original image width and height
*/

gbm_thumbnail:procedure expose gbm_dir orx ory gls.


parse arg infile,thumbfile,wid,hei,colors

/* does infile exists */
if stream(infile,'c','query exists')='' then return 'no such file 'infile

/* get type of file */
  oldq=rxqueue('g')
  useq=rxqueue('c')
  foo=rxqueue('s',useq)
if queued()>0 then do then
  do until queued()=0
     pull goo
  end
end
dd='@'||gls.!gbm_hdr||' -s '||infile||'  | rxqueue  'useq      
foo=stream(infile,'c','close')

address cmd dd                          

if queued()>0 then do                   
  pull rres
end                                     
else do         /* no response means "error */                            
  dd='@'||gls.!gbm_hdr||' '||infile ||' rxqueue 'useq 

  address cmd dd                          

  if queued()>0 then do                   
    pull foo 
    foo=rxqueue('d',useq)
    foo=rxqueue('s',oldq)
    return foo
  end                                     
  return 'unable to determine graphics type of 'infile
end 

afoo=rxqueue('d',useq)
afoo=rxqueue('s',oldq)
if colors='' then colors=160
if datatype(colors)<>"NUM" then return 'bad spec for number of colors: 'colors

if stream(thumbfile,'c','query exists')<>'' then do
  oo=sysfiledelete(thumbfile)
  if oo<>0 then return 'error 'oo' deleting old thumbnail file 'thumbfile
end

if colors>255 then colors=255
if colors<2 then colors=2
parse upper var rres orx 'X' ory bbp asize compression atype .
atype=strip(atype) ; orx=strip(orx) ; ory=strip(ory)
if atype<>'GIF' then do         /* convert color table first */

  dd='@'||gls.!gbm_bpp||' -m mcut'||colors||' '||infile||' '||thumbfile     
  address cmd dd                          

end   

if stream(thumbfile,'c','query exists')='' then do
  return 'failure converting color table of 'infile
end

/* now make the thumbnail */
dd='@'||gls.!gbm_size||' -w '||wid||' -h '||hei||' '||thumbfile

address cmd dd                          

if stream(thumbfile,'c','query exists')='' then 
  return 'failure converting size of 'thumbfile
return 1

/*******************************/
/* get a batch file for standalone processing 
Batch files have the following structure:
actions=xxxx
var = val ;
var = val ;
...
; comment lines begin with ;
- continuation lines begin with  - (you may need these with HEADER and FOOTER)

The VAR and VAL values are:


> These are used to specify what image files you wish to "process".
   IMGDIR = optional: a fully qualified directory
        The directory that contains the images you want to process.
        If NOT specified, then the SEL subdirectory of the WWW_DIR 
        (a user configurable parameter) is where the images are assumed to be.

        Example: 
           E:\MYFILES\PHOTOS\AUGUST
        
   SEL = selector 
       The URI to use to point to the images you wish to make thumbnails of.
       If IMGDIR is NOT specified, then this subddirectory of the WWW_DIR 
       contains the images.
       If IMGDIR is specified, then your server must map SEL to IMGDIR.
       
       Example:
         /PHOTOS/AUGUST

       The default is /

   NOT_HTTP = 2, 1 or 0

       If 1, then the index files will be built using local disk addresses,
       rather then URLs. For example, you can use this to create indices for 
       set of photos to be distributed on a CD (the indices point to
       whatever drive the index file resides on). Note that thumbnails will
       be stored in the THUMBNAIL_DIR (set in the user configurable parameters
       section at the top of this file)

       2 is similar to 1, but it over rides THUMBNAIL_DIR -- thumbnails are 
       stored in the THUMINDX subdirectory of the IMGDIR (THUMINDX will be
       created if necessary).  If IMGDIR is not specified, using 2 causes
       an error.

      If 0, NOT_HTTP is ignored.
       

> This is used when creating thumbnails.
   CREATE=1 or 0
        If 1, then create (or recreate) thumbnails and  a database (of images 
        specified by IMGDIR or by SEL).
        Otherwise, use an existing set of thumbnails and database (of images 
        specified by IMGDIR or SEL).

> These are used when CREATE=1
   DOSUB =0  or 1
      If DOSUB=1 is specified, then also examine all subdirectories of SEL
      Default is 0
   OVERWRITE=0 or 1
      If OVERWRITE=1 is specified, then old thumbnails (and databases) will be overwritten
      Default is 1
   AUTOGIF=1 or 0
      If AUTOGIF=1, then if a thumbnail can not be found in the extended attributes, try to
      create one. Default is 1
  INCLUSION=EXT
      EXT can be one of * JPG GIF BMP TIF PNG        
      You can include several instances of INCLUSION=EXT
      Default is *.
   TSIZE=nn
      nn is the pixel height (and width) of the thumbnails to be created
      Examples include 16, 32,  64, or 96
      Default is 64
  DESC= a description
      Description of this directory of images
      Default is "Thumbnails"

 
This is used to add comments 
  COMMENT= sel  a commment
      You can have many comment statements -- one for each entry in the database
      The "sel" is the relative URI that points to the image
         if you want to include  a comment for E:\WWW\ANIMALS\HORSES.JPG, 
         and WWW_DIR=E:\WWW
         and SEL='/ANIMALS'
         then you could use
            COMMENT= /animals/horses.jpg These fine horses are ready to run
        

These are used to write the html "index" files.
  LISTNAME= name for "linear list index". If not specified, INDEX2.HTM (in
               the SEL directory) is used. 
                 To suppress use LINEAR_LIST=0.
                 Do NOT include directory (filename only)
                 Default is INDEX2.HTM.
  MAPNAME = name for "imagemap index". If not specified, INDEX.HTM (in
               the SEL directory) is used. To suppress use IMAGEMAP_LIST=0.
               Do NOT include directory (filename only)
      
  SMAPNAME = name for "simple imagemap index". If not specified, 
               INDEX1.HTM (in the SEL directory) is used. To suppress use 
               IMAGEMAP_LIST=0. Do NOT include directory (filename only)

  THUMBTEXT = xxx
       What sort of info to write on bottom of thumbnail (in the imagemap).
       xxx can be DATE, SIZE, or NAME. If not specified, then no info is written.

  HEADER= header stuff
        A header, which may include $Codes. This is added to the beginning of each
        html "index" file.

  FOOTER= footer stuff
        Footer info, which may include $codes. This is added to the end of each
        html "index" file.

*/

GET_BATCH:

/* check for help request */
ddir=translate(strip(ddir))
if wordpos(ddir,'? -? /?')>0 then do
 call help_thumindx
 exit
end 

do forever
   call getin ddir
   if result=1 then leave
end

/* Set the default values */
cmds.=''
cmds.!local_tdir=''
foo=directory()
adrive=filespec('d',foo)
cmds.!SEL='/'


cmds.!CREATE=1
cmds.!DOSUB=0 ; cmds.!OVERWRITE=1 ; cmds.!AUTOGIF=1 ; cmds.!INCLUSION=''
cmds.!TSIZE=64  ; cmds.!DESC="Thumbnails"

cmds.!verbose=0
cmds.!make_snap=0
cmds.!LISTNAME='INDEX2.HTM'
cmds.!MAPNAME='INDEX.HTM'
cmds.!SMAPNAME='INDEX1.HTM'

cmds.!FOOTER=''  ; cmds.!HEADER='' ; cmds.!THUMBTEXT=' '

cmds.!COMMENT.0=0

cmds.!verbose=isverbose

crlf='0d0a'x
/* remove comments, append continuation lines */
cmdlist='IMGDIR SEL CREATE DOSUB OVERWRITE AUTOGIF INCLUSION TSIZE DESC MAKE_SNAP VERBOSE  ',
        'COMMENT LISTNAME MAPNAME SMAPNAME  THUMBTEXT HEADER FOOTER VERBOSE NOT_HTTP'

altlist= 'ISVERBOSE SMAPFILE MAPFILE LISTFILE INC   OVER DESCRIP'
altlist0='  VERBOSE SMAPNAME MAPNAME LISTNAME INCLUSION OVERWRITE DESC '



lins.=''
jat=0
do until stuff=''
   parse var stuff aline (crlf) stuff
   
   tline=strip(translate(aline))
   if abbrev(tline,';')=1 then iterate
   if abbrev(tline,'-')=1 then do
      parse var aline . '-' aline
      if jat=0 then jat=1
      lins.jat=lins.jat||' '||aline
      iterate
   end
   jat=jat+1
   lins.jat=strip(aline)
end

do mm=1 to jat
   aline=lins.mm
   if aline='' then iterate
   parse var aline avar '=' aval ; avar=strip(Translate(avar))

   iww=wordpos(avar,altlist)>0          /* do some synonym replacements */
   if iww>0 then do
       avar=strip(word(altlist0,iww))
   end

   if wordpos(avar,cmdlist)=0 then do
       say "WARNING: bad keyword ("avar ") in " strip(aline)
       exit
   end 
   select
     when avar='COMMENT' then do /* may be multiple comments */
        nj=cmds.!COMMENT.0+1
        cmds.!COMMENT.nj=aval
        cmds.!COMMENT.0=nj
     end
     when avar='INCLUSION' then do
         cmds.!INCLUSION=cmds.!INCLUSION' 'aval
     end
     when abbrev(avar,'DESC')=1 then do
         cmds.!descrip=aval
     end
     when abbrev(avar,'MAKE_S')=1 then do
         cmds.!MAKE_SNAP=strip(aval)
     end /* do */
     when avar="IMGDIR" then do
        dd=translate(strip(aval),'\','/')
        if length(dd)>3 then dd=strip(dd,,'\')
        if dosisdir(dd)=0 then do
           say "Error. No such Image DIR: "dd
           exit
         end
         vv='!'||avar
         cmds.!IMGDIR=dd
     end

     otherwise do
        vv='!'||avar
        cmds.vv=aval
     end
  end
end

if cmds.!inclusion=' ' then cmds.!inclusion='*.GIF *.JPG *.JPEG *.BMP *.PNG *.TIF *.TIFF'

if  cmds.!NOT_HTTP=2 then do
   if cmds.!IMGDIR='' then do
       say "ERROR: NOT_HTTP specified, but IMGDIR was not specified "
       exit
   end 
   local_tdir=strip(cmds.!IMGDIR,,'\')||'\THUMINDX'
   if dosisdir(local_tdir)=0 then do 
      oy=sysmkdir(local_tdir)
      if oy<>0 then do
         say "Error "oy " creating " local_tdir
         exit
      end 

   end
   say "Writing thumbnails to local directory: "local_tdir
   CMDS.!LOCAL_TDIR=local_tdir
end

dsel=cmds.!SEL
adsel=translate(dsel,'\','/')
basedir=gls.!wwwdir||'\'||strip(adsel,,'\')
if cmds.!imgdir='' then do
  if dosisdir(basedir)=0 then do
     say "Error. No such SEL directory: "basedir
     exit
  end
  cmds.!basedir=basedir
end

return 1



/**************/
/* ask and read an input file */
getin:
parse arg infile
say normal "                  " cy_ye "    ThumbIndex ver 1.30   " normal
if infile='' then do
  call lineout,bold " Enter ThumbIndex command file (?=help, ?DIR=directory, EXIT=quit) "normal
  call charout,"  "reverse " :" normal
  parse pull infile ; infile=strip(infile)
end

if infile='' then infile=default_cmdfile

if strip(translate(infile))='EXIT' then do
   say "bye "
   exit
end

if abbrev(translate(infile),'?DIR')=1 then do
    parse var infile . thisdir

    if thisdir="" then do
       thisdir=strip(directory(),'t','\')||'\*.*'
    end
    say
    say reverse ' List of files in: ' normal bold thisdir normal
    do while queued()>0
            pull .
    end 
    toget=thisdir
   '@DIR /b  '||toget||' | rxqueue'

    foo=show_dir_queue('*')
    say
    infile=''
    signal getin
end

if infile=' ' | strip(infile)='?' then do
   call sayhelp
   say
   say "Note: the default ThumbIndex command file is: "default_cmdfile
   infile=''
   signal getin
end /* do */

if abbrev(translate(strip(infile)),'/DIR')=1 then do
    infile=substr(strip(infile),2)
    address cmd infile
    infile=''
    signal getin
end /* do */


if abbrev(translate(strip(infile)),'/VAR')=1 then do
  call change_params infile
  infile=''
  signal getin
end

/* maybe it's actually a file name */

infile=strip(infile)
infile0=infile
if pos('.',infile)=0 then infile=infile||'.in'
cmdfile=stream(infile,'c','query exists')      
if cmdfile='' & pos('.',infile0)=0 then cmdfile=stream(infile0,'c','query exists')
if cmdfile='' then cmdfile=stream(infile0||'.html','c','query exists')


if cmdfile='' then do
    Say "Sorry. could not find: " infile
   return 0
end 

htmllen=stream(cmdfile,'c','query size')
if htmllen=0 then do
   say " Sorry -- " cmdfile " is empty "
   infile=''
   signal getin
end 
stuff=charin(cmdfile,1,htmllen)
Say "Reading " HTMLlen " characters from " cmdfile
foo=stream(cmdfile,'c','close')
return 1

/**********************************/
sayhelp:
say
say cy_ye' Welcome to THUMBINDEX'normal
say 
say bold'ThumbIndex'normal' makes it easy to create a thumbnail index of your images '
say '(by image, we mean any graphic, including art work and photos). '
say 'The idea is simple: '
say '     if you have images on a WWW accessible computer (that is, on '
say '     an http server), and you want to make them available to the world'
say '      ... then all you have to do is point "the world" to a thumbnail index. '
say bold'ThumbIndex'normal' makes this process easy! '
say 
say 'To use ThumbIndex (in standalone mode), you must provide a 'bold'ThumbIndex command'normal
say 'file. You use this file to select what images to create thumbnails of; and to '
say 'specify a number of options, such as thumbnail size and thumbnail comments.'
say 'For the details, see 'reverse'THUMINDX.TXT'normal
say
aa=yesno("Would you like to view THUMNINDX.TXT",,'N')
if aa=1 then do
      foo=stream('thumindx.txt','c','query exists')
      if foo='' then do
         say "Sorry, THUMINDX.TXT is not available"
      end 
      else do
        foo=vu_prog' file:///'||foo
        '@start /f 'foo
        say " >>> view THUMINDX.TXT  with " vu_prog
        say"       (it might take a few seconds)"
        say ' '
      end
end
 
return 1

/*********/
/* show stuff in queue as a list */
show_dir_queue:procedure expose qlist. gls.
parse arg lookfor
    ibs=0 ;mxlen=0
    if lookfor<>1 then
       nq=queued()
     else
        nq=qlist.0
    do ii=1 to nq
       if lookfor=1 then do
          aa=qlist.ii
          ii2=lastpos('\',aa) ; anam=substr(aa,ii2+1)
       end /* do */
       else do
          parse pull aa
          if pos(lookfor,aa)=0 & lookfor<>'*' then iterate
          parse var aa anam (lookfor) .
          if strip(anam)='.' | strip(anam)='..' then iterate
       end
       ibs=ibs+1
       blist.ibs=anam
       mxlen=max(length(anam),mxlen)
    end /* do */
arf=""
do il=1 to ibs
   anam=blist.il
   arf=arf||left(anam,mxlen+2)
   if length(arf)+mxlen+2>75  then do
        say arf
        arf=""
   end /* do */
end /* do */
if length(arf)>1 then say arf
say
return 1


/* -------------------- */
/* choose between multiple alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2,... for chosen altenative ) */

yesno:procedure
parse arg amessage , altans,def,arrowok
ahdr=''
if pos('|',amessage)>0 then parse var amessage ahdr '|' amessage
aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

aynn=' '
if def='' then
 defans=''
else
 defans=translate(left(strip(def),1))
if altans='' then altans='No Yes'

w.0=words(altans)
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     if iw0<w.0 then aynn=aynn'|'
end
if arrowok=1 then aynn=aynn||' [UP]'
do forever
 foo1=normal||ahdr||reverse||amessage||normal||aynn||' 'normal
 if length(amessage)+length(altans)<70 then
    foo1=normal||ahdr||reverse||amessage||normal||aynn||' 'normal
 else
    foo1=normal||ahdr||reverse||amessage||normal||'0d0a'x||'    '||aynn||' 'normal
 call charout, foo1
 anans=translate(sysgetkey('echo'))
 ianans=c2d(anans)
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0 then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end



/* -------------------- */
/* -------------------- */
/* Standalone mode! */
do_standalone:

if www_dir='' then
   gls.!WWWDIR=adrive||'\WWW'     /* default WWW_DIR */
else
   gls.!WWWDIR=www_dir
if pos(':',gls.!wwwdir)=0 then gls.!wwwdir=adrive||gls.!wwwdir
if dir_exists(gls.!WWWDIR)<>1 then do
    say "ERROR: no such WWW directory: "gls.!wwwdir  
    exit
end 

gls.!imgdir=cmds.!Imgdir

/* 1) create thumbnails */
if cmds.!create=1 then call do_create           
if cmds.!comment.0>0 then call do_comments

if cmds.!smapname=0 & cmds.!smapname='' & ,
    cmds.!mapname=0 & cmds.!mapname=''  & ,
   cmds.!listname=0 & cmds.!listname=''    then do
       nop
end
else do
   call do_indices
end 
return 1


/********************************/
/* create the various indices */
do_indices:

say
say cY_ye||'Writing index files 'normal
say

cachedir=translate(strip(thumbnail_dir,'t','\'))
if dir_exists(cachedir)<>1 then do
    say "ERROR: no root directory for caching: "thumbnail_dir
    exit
end 
if words(cmds.!sel)>1 then do
    say 'ERROR: too many directories requested: 'cmds.!sel
    exit
end

/* look it up in THUMINDX.DAT */
alist=cachedir'\THUMINDX.DAT'
if stream(alist,'c','query exists')='' then do
 say "ERROR. List of databases is missing: "alist
 exit
end
iii=stream(alist,'c','open read')
if abbrev(translate(iii),'READY')=0 then do
   say "ERROR. Unable to open database list "alist
   exit
end 

iii=stream(alist,'c','query size')
if iii=0 | iii=' ' then do
   say "ERROR. Empty or missing database list "alist
   exit
end 
tsel='/'||strip(translate(strip(cmds.!sel)),,'/')
goo=charin(alist,1,iii)
foo=stream(alist,'c','close')
thumbind='' ; found_line=''
do until goo=''
   parse var goo aline '0d0a'x goo
   aline=strip(aline)
   if aline='' | abbrev(aline,';')=1 then iterate
   parse var aline npics imgdir thumbind .
   imgdir='/'||strip(translate(strip(imgdir)),,'/')
   if imgdir=tsel then do
      thumbind=strip(translate(strip(thumbind)),,'/')
      thumbind=translate(cachedir||'\'|| thumbind,'\','/')

      thumbind=stream(thumbind,'c','query exists')
      if thumbind='' then do
         say "Warning: missing database in "alist
         say "      "||left(aline,50)
         iterate
      end 
      found_line=aline
      leave
   end
end 
if thumbind='' then do
   say "Could not find ThumbIndex Database for "tsel
   exit
end 

afoo=linein(thumbind)
if afoo="" then do
    call outit 'Unable to read index file: 'tsel
    exit      
end 

gls.!thumcache=filespec('d',thumbind)||filespec('p',thumbind)
gls.!thumind=thumbind
gls.!line1=afoo
gls.!standalone=1  
gls.!imgdir=cmds.!imgdir

parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .

d1='/'||strip(translate(strip(dasel)),,'/')

if d1<>tsel then do
   say
   say bold"ERROR: "normal" selector mismatch!"
   say "    Requested: "tsel
   say "  In database: "d1
   say "    (the database is: "thumbind ')'
  say
   say " You should edit the list of databases, "
   say "     "alist
   say " and remove (or place a ; at the beginning): "
   say "     "found_line
   exit
end 


say "Using ThumbIndex database: "thumbind
say "   which contains references to "numrec" images"
say "   these images are in "dasel

eek1=strip(translate(tsel,'\','/'),,'\')
if gls.!imgdir='' then 
   thedir=strip(gls.!wwwdir,,'\')||'\'||eek1||'\'
else
  thedir=strip(gls.!Imgdir,,'\')||'\'

gls.!thedir=thedir

/* write list index  */
if  cmds.!listname<>0 & cmds.!listname<>''   then 
  call do_indices_list

if  cmds.!mapname<>0 & cmds.!mapname<>''   then 
  call do_indices_map

if  cmds.!smapname<>0 & cmds.!smapname<>''   then 
  call do_indices_map 1


exit

/*****************/
/* standalone list index creation */
do_indices_list:
say
  sel_1=strip(translate(cmds.!listname,'/','\'))
  indxfile=thedir||strip(translate(sel_1,'\','/'),,'\')
  if stream(indxfile,'c','query exists')<>'' then do       /* rename preexisting */
     parse var indxfile ttfile '.' .
     ttfile=dostempname(ttfile||'.???')
     foo=dosrename(indxfile,ttfile)
     if foo=0 then do
        say    'Unable to rename old  file: 'indxfile
        say    '(this is the HTML-list thumbnail index  file'
        exit
     end
     else do
        say "Old list index file renamed to "ttfile
     end 
  end
  else do
     say "Creating list index file "indxfile
  end 
  gls.!indxfile=indxfile
  foo=step3_2()
  
return 1



/*****************/
/* standalone imagemap index creation */
do_indices_map:
parse arg issimp
say
  if issimp=1 then
    sel_1=strip(translate(cmds.!smapname,'/','\'))
  else
    sel_1=strip(translate(cmds.!mapname,'/','\'))

  indxfile=thedir||strip(translate(sel_1,'\','/'),,'\')
  if stream(indxfile,'c','query exists')<>'' then do       /* rename preexisting */
     parse var indxfile ttfile '.' .
     ttfile=dostempname(ttfile||'.???')
     foo=dosrename(indxfile,ttfile)
     if foo=0 then do
        say    'Unable to rename old  file: 'indxfile
        if issimp=1 then
          say    '(this is the HTML-clientside-simple-imagemap thumbnail index  file'
        else
           say    '(this is the HTML-clientside-imagemap thumbnail index  file'
        exit
     end
     else do
        if issimp=1 then
          say "Old simple imagemap index file renamed to "ttfile
        else
          say "Old imagemap index file renamed to "ttfile
     end 
  end
  else do
     if issimp=1 then
        say "Creating simple imagemap index file "||indxfile
     else
        say "Creating imagemap index file "||indxfile
  end 
  gls.!indxfile=indxfile
  foo=step3_2b(gls.!thumind,issimp)
  
return 1


/********************************/
/* add comments to a database */
do_comments:

say
say cY_ye||'Adding comments'normal
say


cachedir=translate(strip(thumbnail_dir,'t','\'))
if dir_exists(cachedir)<>1 then do
    say "ERROR: no root directory for caching: "thumbnail_dir
    exit
end 
if words(cmds.!sel)>1 then do
    say 'ERROR: too many directories requested: 'cmds.!sel
    exit
end

/* look it up in THUMINDX.DAT */
alist=cachedir'\THUMINDX.DAT'
if stream(alist,'c','query exists')='' then do
 say "ERROR. List of databases is missing: "alist
 exit
end
iii=stream(alist,'c','open read')
if abbrev(translate(iii),'READY')=0 then do
   say "ERROR. Unable to open database list "alist
   exit
end 

iii=stream(alist,'c','query size')
if iii=0 | iii=' ' then do
   say "ERROR. Empty or missing database list "alist
   exit
end 
tsel='/'||strip(translate(strip(cmds.!sel)),,'/')
goo=charin(alist,1,iii)
foo=stream(alist,'c','close')
thumbind=''
found_line=''
do until goo=''
   parse var goo aline '0d0a'x goo
   aline=strip(aline)
   if aline='' | abbrev(aline,';')=1 then iterate
   parse var aline npics imgdir thumbind .
   imgdir='/'||strip(translate(strip(imgdir)),,'/')
   if imgdir=tsel then do
      thumbind=strip(translate(strip(thumbind)),,'/')
      thumbind=translate(cachedir||'\'||thumbind,'\','/')
      thumbind=stream(thumbind,'c','query exists')
      if thumbind='' then do
         say "Warning: missing database in  "alist
         say "      "||left(aline,50)
         iterate
      end 
      found_line=aline
      leave
   end
end 
if thumbind='' then do
   say "Could not find ThumbIndex Database for "tsel
   exit
end 

afoo=linein(thumbind)
if afoo="" then do
    call outit 'Unable to read index file): 'thumbind
    exit      
end 
say " Adding comments to database: " thumbind
/* convert cmds.!comments */
drop cmts2.
cmts2.=''
ido=0
do mm=1 to cmds.!comment.0
   parse var cmds.!comment.mm filename acomm 
   filename=translate(strip(translate(filename)),'/','\')
   if abbrev(filename,'/')=0 then do
      filename=tsel||'/'||filename
   end 
   aff='!'||filename
   cmts2.aff=mm
   cmts2.mm.!file=filename
   cmts2.mm.!cmt=strip(acomm)
end 
say ' # comments specified: ' cmds.!comment.0

parse  var afoo reclen numrec idlen cshlen dasel awid aht . '/#/' adesc '/#/' .
gls.!dasel=dasel

d1='/'||strip(translate(strip(dasel)),,'/')


if d1<>tsel then do
    say
   say bold"ERROR: "normal" selector mismatch!"
   say "    Requested: "tsel
   say "  In database: "d1
   say "    (the database is: "thumbind ')'
  say
   say " You shoule edit the list of databases, "
   say "     "alist
   say " and remove (or place a ; at the beginning): "
   say "     "found_line
   exit
end 

say numrec " records in database at "thumbind

iouts=1
outs.iouts=afoo

ifnd=0
do mm=1 to numrec
     aline=linein(thumbind)
     aa=strip(aline)
     if aa='' | abbrev(aa,';')=1 then do
        iouts=iouts+1; outs.iouts=aline
        iterate
     end
     parse var aa filename .
     filename=strip(translate(filename))
     aff='!'||filename
     if cmts2.aff='' then do
        iouts=iouts+1; outs.iouts=aline
        iterate
     end
/* else, got a match -- add comment */
    parse var aline a1 a2 a3 a4 a5
    i1=cmts2.aff
    amess=cmts2.i1.!cmt
    cmds.!comment.i1.!did=1
    aline=a1' 'a2' 'a3' 'a4' 'amess
    iouts=iouts+1; outs.iouts=aline
    iterate
end
goo=stream(thumbind,'c','close')

parse var thumbind ttfile '.' .
ttfile=dostempname(ttfile||'.???')
foo=stream(theind,'c','close')
foo=dosrename(thumbind,ttfile)
if foo=0 then do
   say 'ERROR: unable to rename old index file to 'ttfile
   exit
end
else do
   say "Old ThumbIndex database renamed to: "ttfile
end 
do mm=1 to iouts
   call lineout thumbind,outs.mm
end 
call lineout thumbind

newcmt=0 ; notdone=0
do mm=1 to cmds.!comment.0
  if cmds.!comment.mm.!did=1 then do
    newcmt=newcmt+1
  end
  else do
     say bold"   Warning. no match for: "normal||left(cmds.!comment.mm,55)
  end 
end

say newcmt " new comments written to " thumbind
return 1

/********************************/
/* create thumbnails & database */
do_create:

say

cachedir=translate(strip(thumbnail_dir,'t','\'))
if dir_exists(cachedir)<>1 then do
    say "ERROR: no root directory for caching: "thumbnail_dir
    exit
end 
if words(cmds.!sel)>1 then do
    say 'ERROR: too many directories requested: 'cmds.!sel
    exit
end

if datatype(cmds.!tsize)<>'NUM' then do
    say     'ERROR: bad thumnbnail size (must be an integer>0): 'cmds.!tsize
    exit
end


x32=cmds.!tsize ;y32=x32

if cmds.!dosub=1 then  /* process subdirectories ? */
  ts='TS'
else 
 ts='T'

/* process directory */
eek1=strip(translate(cmds.!sel,'\','/'))
if gls.!imgdir='' then 
   thedir=strip(gls.!wwwdir,,'\')||'\'||strip(eek1,,'\')||'\'
else
  thedir=strip(gls.!Imgdir,,'\')||'\'

if dir_exists(thedir)<>1 then do
   say ' No such directory: ' thedir
   exit
end 

/* astem=left(thedir,1+length(thedir)-length(eek1)) */


opts.!autogif=cmds.!autogif; opts.!overwrite=cmds.!overwrite
opts.!inclusion=cmds.!inclusion
opts.!descrip=cmds.!descrip
opts.!thumbtext=cmds.!thumbtext

call do3_step1b 1                       /* THIS DOES THE WORK */

say bold"Thumbnails and thumbnail-database created in "normal' 'cachedir_use
say     "       "||bold||"w/relative URI= "normal||cmds.!sel

/* update THUMINDX.DAT */
alist=cachedir'\THUMINDX.DAT'
goo=date('O') ;a2=left(goo,2)
if dsel<>'/' then dsel='/'||strip(dsel,,'/')
select
      when a2=19 | a2=20 then nop
      when a2>80 then goo='19'||goo
      otherwise goo='20'||goo
end
goo=goo||'.'||time('s')
tfile3=translate(tfile2'.IND','/','\')

tfile3=gls.!thumindx
putit=translate(dsel' 'tfile3)

if stream(alist,'c','query exists')='' then do
   aa.1=';List of ThumbIndex databases  '
   goo=date('O') ;a2=left(goo,2)
   select
      when a2=19 | a2=20 then nop
      when a2>80 then goo='19'||goo
      otherwise goo='20'||goo
  end
  lins.1='; ThumbIndex databases: 'date('n')||' '||time('n')
  aa.2=isucc' 'putit' 'goo
  aa.0=2
  foo=filewrite(alist,'aa.')
  if foo<0 then say 'Warning 'foo': unable to update (write) 'alist'<br>'
end 
else do
   foo=fileread(alist,'lins.')
   if foo=0 then do
       say 'Warning 'foo': unable to update (read) 'alist'<br>'
   end
   else do
     lins.1='; ThumbIndex databases created by ThumbNail Index: 'date('n')||' '||time('n')
     ii=0
     if cmds.!overwrite=1 then do
        ii=find_inlist(putit)
     end
     if ii=0 then do  /* not overwrite, or no match */
       ii=lins.0+1
       lins.0=ii
     end
     lins.ii=isucc' 'putit' 'goo
     foo=filewrite(alist,'lins.')
     if foo<0 then  say 'Warning 'foo': unable to update (write) 'alist'<br>'
   end
end 


return 1

/*********************/
/* description of thumindx */
help_thumindx:
call sayhelp
say
say "You can provide one parameter on the command line: the name of a "
say "'ThumbIndex command file'. If you provide no parameters, then you "
say "will be asked for the name of a ThumbIndex command file."
say
say "Example: "
say "  x:\ThumIndx>thumindx thum1.in"
say
say "Hint: to save status messags to an output file, use "
say "     x:\ThumIndx>thumindx thum1.in > results.out "
say
exit

/*********************/
/* ----------------------------------------------------------------------- */
/* REPLACESTRG:
  Arguments:
                astring : the "haystack" to look in
                target: the "needle" to look for
                putme: the "new needle" to replace the "needle" with
                type : The direction/type of search
                        FORWARD, BACKWARD, ALL
                exact: YES-- then cases in needle and haystack must match

      Note taht regardless of value of exact, cases are retained in both
      astring and putme.

   Returns the modified astring, or the unmodified astring if target could
   not be found.
*/
/* ----------------------------------------------------------------------- */

replacestrg:procedure

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch

type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end
 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring


/*********************/
/* create a "snapshot" version (640w, 60% compression) of all
.JPGs in a directory. write to a SNPS subdirectory */

make_snapshot:procedure expose gls.

parse arg aphoto,todir
foo=stream(aphoto,'c','close')
phname='SNP_'||filespec('n',aphoto)
io1=lastpos('.',phname)
if io1>0 then 
  phname=left(phname,io1)||'JPG'
else
  phname=phname||'.JPG'

tosnap=todir||'\'||phname

oof='@'||gls.!gbm_size||' -a -w 640 '||aphoto||' '||tosnap||',quality=60 '

address cmd oof

return ' '


