/* DOCALC: front end to calcwww
 Used Arguments are:
  LIST0 : list of arguments (the equations to calculate in packed form)
  Tempfile  : temporary work file (write results to )
  workdir: WHere to write temporary "work" files to
           (need NOT be under datadirectory, but doesn't hurt if it is)
 */

   parse  arg ddir,tempfile,sel,list0,verb,uri,user,basedir,workdir

/* generic list is flawed: regenerate from uri */
  parse var uri  eek '=' l2   /* get out every thing after the = sign */
  l2=translate(l2, ' ', '+')  /* convert +  to blanks. */

 l2=packur(l2)    /* and now convert %xx syntax to other stuff (such as + and / */
  list=translate(l2, ' ', '090a0d'x)  /* convert tab, etc to blanks. */


 call lineout tempfile,"<html> <head> <title> CALC-WWW results </title> </head> <body> "

/* note that calc requires some preprocesing in getpost -- specifically, + characters
 mean +, and space means space */

 /*  get stuff needed to make tempfiles */
 parse var tempfile basename '.' .

workdir=strip(workdir,'t','\')||'\'
infile=dostempname(workdir||'CALC????.IN')
outfile=dostempname(workdir||'CALC????.OUT')

/***
The 2 work files for CALC \:
1) An input file 
2) An output file file
CALCWWW is called as CALCWWW /IN=INFILE
and an /OUT OUTFILE entry is the first thin in infile
also we need
3)  .. the post-execution, status report/wanna get results? .htm file (use tempfile for this)
***/


/****** Now start processing the stuff *****/
/* Case: no list sent */
  if list='' then do
      call lineout tempfile,' <h2> CALC-WWW </h2>'
      call lineout tempfile,'  No equation recieved.'
      signal donenow
   end

list0=list

/* Case: got equatoins, break off each line and write to infile */
    call lineout tempfile,'<h2> CALC-WWW </h2>  <hr width=200>'
    call lineout tempfile,' <h3> Analyzing  ... </h3>'
    call lineout tempfile,'<pre> '

/* but first write /out line */
    outfil2=translate(outfile,'\','/')
    call lineout infile,'/OUT ' outfil2
    ieqs=0
    do while list0<>''
         parse var list0 eqa  ';' list0   /* break off an equation */
         if eqa<>' ' then do
                eqa=strip(eqa,'L')
                ieq=ieqs+1
               call lineout infile,eqa
               call lineout tempfile,eqa  /* tell user */
         end
      end
call lineout infile,'EXIT'  /* not needed, but a good idea */
call lineout infile
call lineout tempfile,'</pre> '

poo=basedir'\CALCWWW /IN='||infile
address cmd
poo
address
/* say " RC on CALC call =  "  rc */
if rc<>0 then do
 call lineout tempfile,' <h2> Error in CALC-WWW </h2>'
        call lineout tempfile,'  Problem running CALC-WWW ('rc
        signal donenow
end

/* now copy all stuff from outfile to tempfile */
call lineout tempfile,' <hr width=100> <h3> ... results: </h3> '
call lineout tempfile,'  <pre> '
foo=stream(outfile,'c','close')

do until lines(outfile) = 0
   a=linein(outfile)
   call lineout tempfile,a
end

call lineout tempfile,'</pre> <hr width=200> '


donenow:
  call lineout tempfile, "<hr> "
  call lineout tempfile,"</body></html>"
  call lineout tempfile  

 foo=stream(outfile,'c','close')
 foo=stream(infile,'c','close')
 
  call sysfiledelete(infile) 
  call sysfiledelete(outfile)

  oof=dosdir(tempfile,'s')
 
  return 'FILE TYPE text/html NAME' tempfile


