/* This is the STATUS addon for srehttp/2
     Use /status? to invoke this addon.
     Note: by default, this is one of the "preloaded" addons
*/

status:

parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,client_ip,privset,,
          uri,host_nickname,id_info,aiter,attribs,seluse2

if verb=" " then do
   say "This SREhttp/2 procedure is not meant to be run in standalone mode "
   exit
end  

pr1=dospriority()

if aiter='' then return 'PRIVS_LOOK '  /* get readily available privileges */

parse var prog_file prog_file ','  mproc

list0=list
list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc. */

parse var privset norm_privset ',' secret_privset


/* first "parse" the parameter list, and store in a simple stem variable */
m=0
optname.=0
list0=list
do until list=""
    parse var list opt1 '&' list
    m=m+1
    parse var opt1 avar '=' aval ; avar=strip(translate(avar)) ; aval=strip(aval)
    if aval='' then aval=1
    avar='!'avar
    optname.avar=aval
end


if optname.!PARAMS<>0  then do
   stuff=sreh2_get_userinfo(,host_nickname,id_info)  /* lookup in users.in database */
   if stuff<>'' then do          /* pull out privs */
     parse var stuff username pwd  privset1
     privset=privset' 'privset1' USER'         /* users in userfile always give a USER privilege */
   end

  if sreh2_check_privs('SUPERUSER',privset)=0 then do
      rcode=sre_auth_response('View Status',servername,, ,
        'You need SuperUser privilieges to view parameter settings', ,
         id_info)
     return rcode
   end
end 



/* Information will be returned in a temporary file, whose name
   is provided in the tempfile variable.
   Note that it's a good idea to start your HTML documents with a dtd doctype statement
*/

call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'
nowtime=sre_datestamp()
call lineout tempfile, "<html><head><title>The SREhttp/2 STATUS addon</title>"
call lineout tempfile, "</head><body>"

call lineout tempfile,'<font size=-1>'
call lineout tempfile,'<a href="#headers">Headers</a> || <a href="#UserInfo">User/Server Info</a> || '
call lineout tempfile,'<a href="#superuser">SuperUser Options </a>'
call lineout tempfile,'</font>'
call lineout tempfile,'<br><table align="center" bgcolor="lightblue"><tr><td>'
call lineout tempfile,' <h2 >SREhttp/2 Status: Client, Server, and other information </h2>'
call lineout tempfile,'</table>'

call lineout tempfile,' <h3>The arguments recieved by the status addon </h3> '

call lineout tempfile,' <dl> '

  call lineout tempfile,' <dt>  LIST  <dd><code>' list0 ' </code> '

  call lineout tempfile,' <br> LIST is read from:</b>: '
     call lineout tempfile, '<br> ... if POST method, from the <code>body</code> of the request '
     call lineout tempfile,' <br> ... if GET method ,  from after the "?" in the request string.  '

   call lineout tempfile,' <dt>  SERVERNAME <dd> <code>' servername '</code> '

   call lineout tempfile,' <dt>  VERB <dd> <code>' VERB ' </code> '

   call lineout tempfile,' <dt>  TEMPFILE <em> The "temporary file" (used to build this response)</em> ',
                         '<DD> <code>' tempfile ' </code> '

   call lineout tempfile,' <dt> PROGFILE <em> The file containing this addon </em><DD> <code> ' prog_file '</code>'
    if mproc<>'' then call lineout tempfile,  '<em> (using preloaded addon in 'mproc ')</em>'

   call lineout tempfile,'<dt>REQNUM '
      call lineout tempfile,'<Em>The transaction and request within transaction </em>'
     call lineout tempfile,'<dd><code> 'reqnum '</code>'
 
   call lineout tempfile,'<dt>VERBOSE <dd> <code>'verbose'</code>'

   call lineout tempfile,' <dt> CLIENT_IP <em> Client''s ip address </em>'
     call lineout tempfile,'<dd> <code>' client_ip ' </code> '

   call lineout tempfile,' <Dt> PRIVSET <em> Your username specific privileges </em> '
        call lineout tempfile,'<dd> <code> ' norm_privset ' </code> '
   if words(secret_privset)>0 then do
        if wordpos('SUPERUSER',privset)>0 then do 
              call lineout tempfile,' <em>(secret privileges: '||secret_privset||' )</em>'
        end /* do */
        else do
              call lineout tempfile,' <em>(#secret privileges: '||words(secret_privset)||' )</em>'
        end 
   end /* do */


   call lineout tempfile,' <dt>  URI <em> The full <b>request string</b></em> '

   call lineout tempfile,'<dd> <code>' URI ' </code> '
 
   call lineout tempfile,' <Dt> HOST_NICKNAME '
            call lineout tempfile,' <DD> <code> ' host_nickname ' </code> '

   call lineout tempfile,' <Dt> ID_INFO '
            call lineout tempfile,' <DD> <code> ' id_info ' </code> '
        call lineout tempfile,'<bR><em>ID_INFO can be passed to SRE2003 procedures to '
        call lineout tempfile, ' speed up processing a bit. </em>'
    

   call lineout tempfile,' <Dt> AITER'
            call lineout tempfile,' <DD> <code> 'aiter ' </code>  '
        call lineout tempfile,' <em>( 1 means that this is a second call. This typically '
        call lineout tempfile, 'occurs if the addon returned with "please lookup privileges" flag)</em> '


   call lineout tempfile,' <Dt> ATTRIBS'
         call lineout tempfile,' <DD> <ul>'
         parse var attribs ,
            realm   '01'x   ,     
            rule    '01'x   ,     
            redirect '01'x  ,     
            options '01'x    ,    
            failure_file '01'x ,   
            permissions  '01'x ,  
             requires 

          options=translate(options,'||','0d0a'x)

          call lineout tempfile,'<li><b>realm: </b><tt>'||realm||'</tt>'
          call lineout tempfile,'<li><b>rule: </b><tt>'||rule||'</tt>'
          call lineout tempfile,'<li><b>redirect:</b><tt>'||redirect||'</tt>'
          call lineout tempfile,'<li><b>options: </b><tt>'||options||'</tt>'
          call lineout tempfile,'<li><b>failure_file: </b><tt>'||failure_file||'</tt>'
          call lineout tempfile,'<li><b>permissions: </b><tt>'||permissions||'</tt>'
          call lineout tempfile,'<li><b>requires: </b><tt>'||requires||'</tt>'
     call lineout tempfile,'</ul>'

   call lineout tempfile,' <Dt> SELUSE2'
            call lineout tempfile,' <DD> <code> 'seluse2 ' </code>  '
        call lineout tempfile,' <em>the request selector, after internal redirection</em>'


call lineout tempfile,' </dl> '


call lineout tempfile,' <h3>Other useful parameters </h3> '
ddir=sre_datadir()
workdir=sre_value('H2_TEMP_DIR',,'SRE')
addon_dir=sreh2_value('ADDON_DIR',,host_nickname)
if addon_dir=''  | addon_dir=0 then addon_dir=sre_value('H2_ADDON_DIR_DEFAULT',,'SRE')

homedir=sreh2_value('HOME_DIR',,host_nickname)
srvdir=sre_value('SRV_DIR',,'SRESYS')
filterdir=sre_value('FILTER_DIR',,'SRESYS')

call lineout tempfile,' <dl> '

   call lineout tempfile,' <dt>  DATADIR = <code>' ddir '</code> '
     call lineout tempfile,' <dd>  The (host-specific) "data directory" (where your HTML documents should be) '

   call lineout tempfile,' <dt>  SRV_DIR = <code>' srvdir ' </code> '
      call lineout tempfile,' <dd> The "working directory" (where SRE2003 lives) '

   call lineout tempfile,' <dt>  FILTER_DIR = <code>' filterdir ' </code> '
      call lineout tempfile,' <dd> The "filter directory" (where SREhttp/2 lives) '

   call lineout tempfile,' <dt>  H2_TEMP_DIR = <code>' workdir ' </code> '
      call lineout tempfile,' <dd>  Temporary area, for working files '

   call lineout tempfile, '<dt> HOME_DIR=<code> ' homedir  ' </code>'
     call lineout tempfile,' <Dd> The (host-specific) ~ (home directory) string '


   call lineout tempfile, '<dt> ADDON_DIR=<code> ' addon_dir  ' </code>'
     call lineout tempfile,' <Dd> The (host-specific) addon directory '

call lineout tempfile,'</dl>'

/* Read the "header" -- and display the results */
foo=sre_command('READ HEADER',,id_info)
foo0=sre_extract('REQUEST_LINE',id_info)
call lineout tempfile,'<a name="headers"> <h3> The Request Line and Request Headers </h3> </a><br>'
call lineout tempfile,' <blockquote> <pre>'||foo0||'0d0a'x||'0d0a'x||foo||'</pre> </blockquote>'

call lineout tempfile,'<a name="UserInfo"> <h3> Some User &amp; Server Info </h3></a> '
caddr=sre_extract('CLIENTADDR',id_info)
cname=sre_clientname()
ssoft=sre_server('NF')
ssoft_num=sre_value('H2_VERSION',,'SRE')
saddr=sre_extract('SERVERADDR',id_info)
sport=sre_extract('SERVERPORT',id_info)

call lineout tempfile,' <ul> '
   call lineout tempfile,' <li> Client ip address:  <code>' caddr '</code>'
   call lineout tempfile,' <li> Client name:  <code>' cname '</code>'
   call lineout tempfile,' <li> Server ip address: <code>' saddr '</code>'
   call lineout tempfile,' <li> Server port:  <code>' sport '</code>'
   call lineout tempfile, ' <li> Server software:  <code>' ssoft '</code> <em>('||ssoft_num')</em>'
call lineout tempfile,' </ul> '


getuse: nop
/* get some "intensity of use " statistics */
 reptime=sre_extract('RESPONSETIME')
 numtrans=sre_extract('TRANSACTIONS')
 whenstart=sre_extract('LASTSTART')
 nclients=sre_extract('CLIENTS')

 call lineout tempfile,' <h3> Use Statistics </h3> '

 call lineout tempfile,' SRE2003 started: ' whenstart
 call lineout tempfile,'<BR> # of transactions ' numtrans  ', avg. reponsetime = 'reptime ' sec. '
 call lineout tempfile,'<BR> Current # of clients = ' nclients


/* Special features (such as the HOST function) -- demonstrates the use of external calls */
 

/* if we found a GETIP, and got it's value, then lookit up */
  if optname.!GETIP<>0  then do
/* Note use of the address cmd xxx to call a OS/2 level command  */
    A=RXQUEUE('S','SESSION')    /* SINCE QUEUE MIGHT BE A THREAD'S QUEUE */
    do queued(); pull .; end                   /* flush */
    chkip=optname.!GETIP
    address cmd '@host' chkip '| rxqueue'     /* execute the command */
    parse pull hostresult                      /* get result */
    call lineout tempfile,' <h3> Look up address </h3> '
    call lineout tempfile,' <pre> ' hostresult ' </pre>'
  end

  call lineout tempfile,'<hr><a name="superuser"><h3>SuperUser options:</h3></a>'
  call lineout tempfile,'<b>SuperUsers</b> can (for this host-nickname):<menu>'
  call lineout tempfile,'<li> <a href="/!RESET">reset SREhttp/2 parameters</a>'
  call lineout tempfile,' <li> View  <A href="/status?params=11">general parameter settings</a>'

  call lineout tempfile,' <li> View  <A href="/status?params=1">host-specific parameter settings</a>'
  call lineout tempfile,' <li> View  <A href="/status?params=2">host-specific SSI vars</a>'
  call lineout tempfile,' <li> View  <A href="/status?params=3">other host-nicknames</a>'

  call lineout tempfile,'</menu>'

if optname.!PARAMS<>0  then do           /* if this is true, must be  superuser */
    call show_params
end 


/* all done, write final end-of-html elements */
  call lineout tempfile,'<hr><em>Current time is 'nowtime'</em><br>'
  call lineout tempfile,'<body> </html>'
  call lineout tempfile
  rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF ERASE TYPE text/html NAME 'tempfile,,id_info)
  return rcode


/********/
/* show SREhttp/2 parameters  (maybe add "change parameters" option later)

*/
show_params:
if optname.!PARAMS=1 then do
   call lineout tempfile,' <hr><h3>Current parameter settings </h3> '
   call lineout tempfile,'<em>for host-nickname 'host_nickname'</em>'
   foo=sreh2_value('!LIST',,host_nickname)
   call lineout tempfile,'<table><tr><th>Variable<th>Value'
   do jj=1 to words(foo)
        afoo=strip(translate(word(foo,jj)))
        if abbrev(afoo,'SSIVAR_')=1 then iterate
        awow=sreh2_value(afoo,,host_nickname)
        call lineout tempfile,'<tr><th>'||afoo||'<td>'||awow
   end 

   if host_nickname<>'DEFAULT'  then do
          if sreh2_value('SUPERCEDING',,host_nickname)<>2 then do      /* get DEFAULT values */
            foo=sreh2_value('!LIST',,'DEFAULT')
            call lineout tempfile,'<tr><td colspan=2><br> <em>DEFAULT variables </em><br>'
            do jj=1 to words(foo)
                afoo=strip(translate(word(foo,jj)))
                if abbrev(afoo,'SSIVAR_')=1 then iterate
                awow=sreh2_value(afoo,,host_nickname)
                call lineout tempfile,'<tr><th>'||afoo||'<td>'||awow
            end 
         end
    end
     call lineout tempfile,'</table>'
    return 1
end

if optname.!PARAMS=11 then do
   call lineout tempfile,' <hr><h3>Current  general parameter settings </h3> '
   foo=sre_value('!LIST',,'SRE')
   call lineout tempfile,'<table><tr><th>Variable<th>Value'
   do jj=1 to words(foo)
        afoo=strip(translate(word(foo,jj)))
        if abbrev(afoo,'H2_')<>1 then iterate
        awow=sre_value(afoo,,'SREBEST')
        call lineout tempfile,'<tr><th>'||afoo||'<td>'||awow
   end 

   if host_nickname<>'DEFAULT'  then do
          if sreh2_value('SUPERCEDING',,host_nickname)<>2 then do      /* get DEFAULT values */
            foo=sreh2_value('!LIST',,'DEFAULT')
            call lineout tempfile,'<tr><td colspan=2><br> <em>DEFAULT variables </em><br>'
            do jj=1 to words(foo)
                afoo=strip(translate(word(foo,jj)))
                if abbrev(afoo,'SSIVAR_')=1 then iterate
                awow=sreh2_value(afoo,,host_nickname)
                call lineout tempfile,'<tr><th>'||afoo||'<td>'||awow
            end 
         end
    end
     call lineout tempfile,'</table>'
    return 1
end



if optname.!PARAMS=2 then do
   call lineout tempfile,' <hr><h3>Current SSI_VARS </h3> '
   call lineout tempfile,'<em>for host-nickname 'host_nickname'</em>'
   foo=sreh2_value('!LIST',,host_nickname)
   call lineout tempfile,'<table border=1><tr><th>SSI Variable<th>Value'
   do jj=1 to words(foo)
        afoo=strip(translate(word(foo,jj)))
        if abbrev(afoo,'SSIVAR_')<>1 then iterate
        awow=sreh2_value(afoo,,host_nickname)
        parse var afoo . '_' afoo2
        call lineout tempfile,'<tr><th>'||afoo2||'<td><pre>'||strip(sre_html_encode(awow))||'</pre>'
   end 

   if host_nickname<>'DEFAULT'  then do
      if sreh2_value('SUPERCEDING',,host_nickname)<>2 then do      /* get DEFAULT values */
          foo=sreh2_value('!LIST',,'DEFAULT')
          call lineout tempfile,'<tr><td colspan=2><br> <em>DEFAULT variables </em><br>'
          do jj=1 to words(foo)
                afoo=strip(translate(word(foo,jj)))
                if abbrev(afoo,'SSIVAR_')=1 then iterate
                awow=sreh2_value(afoo,,host_nickname)
                call lineout tempfile,'<tr><th>'||afoo||'<td>'||awow
          end 
      end
   end
   call lineout tempfile,'</table>'
   return 1
end


if optname.!PARAMS=3 then do  /* STATUS? links to other hosts */
ff=sre_servername('default')
   call lineout tempfile,' <hr><h3>Other hosts served by this site</h3> '
   call lineout tempfile,'<a href="http://'||ff||'/status?">The default </a><p>'
   hinfo_list=sre_hostinfo('!LIST')
   parse var hinfo_list nh '0d0a'x hinfo_list
   call lineout tempfile,'<table border=1><th>IP address<br>or domain name <th>Host-nickname <th>Root html-document directory'
   do until hinfo_list=''
     parse var hinfo_list ah '0d0a'x  hinfo_list
     goo=sre_hostinfo(ah)
    parse var goo aip ',' anick adatadir
    call lineout tempfile,'<tr><td><a href="http://'||ah||'/status?">'||aip||'<td>'anick'<td>'adatadir
   end /* do */
   call lineout tempfile,'</table>'
   return 1
end

return 1


/********************************************************/
/********************************************************/
/********************************************************/

